.include output, hexbin, rechnen, mem, strings

jmp BEGIN

Frei  DB '  frei', 0
Dos   DB '  DOS', 0
IoSys DB '  IO.SYS', 0
Env   DB '  Umgebung', 0
Temp  DB  13 dup (0)
   
OBJECT Arena:
  Signatur DB ?
  Owner    DW ?
  Size     DW ?
  Reserved DB 3 Dup (0)
  Name     DB 8 Dup (0)
  ZeroByte DW 0        ; Stringeende, falls Name 8 Zeichen lang

  PROC Copy:           ; Segment in AX bergeben
    push ax, cx, si, di, ds, es, cs / pop es
    mov  ds, ax
    xor  si, si
    lea  di, Arena
    mov  cx, 8
    cld
    rep  movsw
    pop  es, ds, di, si, cx, ax
    ret
  ENDP
OBJECT END
 

PROC GoRight:
  push ax, bx, cx, dx, cx
  mov  ah, 3
  xor  bh, bh
  int  10h
  pop  cx
  sub  cl, dl
  xor  ch, ch
  jcxz @raus
  mov  al, 32
  @nochmal:
    #DosChar (ax)
  loop @nochmal
  @raus:
  pop  dx, cx, bx, ax
  ret
ENDP


PROC WriteSegment:
  push si, ax, cx
  #Wordhex (ax, Temp^)
  #DosStr  (Temp^)
  mov  cx, 13
  #GoRight
  pop  cx, ax, si
  ret
ENDP


PROC WriteSize:
  Temp1 LOC 4
  Temp2 LOC 13
BEGP
  push ax, cx, si, di
  lea  di, temp1
  push di
  mov  ax, Arena.Size
  inc  ax
  stosw
  xor  ax, ax
  stosw
  pop di
  #LongSHL (di, 4, di)
  lea si, temp2
  #LongStr (di, si)
  mov  cx, 30
  #GoRight
  #TausPkt (si, Temp^)
  #Length (Temp^)
  mov cx, 15
  sub cx, ax
  jcxz @wech
  @loop:
    #DosChar (32)
  loop @loop
  @wech:
  #DosLn (Temp^)
  pop  di, si, cx, ax
  ret
ENDP


PROC WriteName:
  lea si, Frei
  mov bx, arena.owner   ; PSP-Adresse des Besitzers
  or  bx, bx
  jz  @weiter           ; Wenn = 0, dann freier Block
    push bx
    mov  bx, arena.name
    cmp  bx, 'SD'       ; System Data
    pop  bx
    jne  @w
      lea si, IOSys
      jmp short @weiter
    @w:
    push bx, es
    mov  es, ax
    mov  bx, es:[16]
    cmp  bx, 'CO'       ; 'COMSPEC' ?
    pop  es, bx
    jne  @v
      lea si, Env
      jmp short @weiter
    @v:
    lea  si, Dos
    push es
    mov  es, bx
    mov  bx, es:[0]
    cmp  bx, $20CD      ; Sprungbefehl im PSP-Beginn (int 20h)
    pop  es
    jne  @weiter
  @out:
  lea si, arena.name
  @weiter:
  #WriteSegment
  #DosStr (si)
  #WriteSize
  @raus:
  ret
ENDP
   

BEGIN:
  #FreeOwnMem
  #DosLn (&Header^)
  
  mov ah, 52h
  int 21h
  mov ax, es:[bx-2]    ; Segment des ersten MCB/ArenaRecs in ax

  @nochmal:
    #arena.copy
    mov bl, arena.signatur
    cmp bl, 'M'
    je  @los
    cmp bl, 'Z'
    je  @los
    jmp @ende
    @los:
    #WriteName
    add ax, arena.size
    inc ax
  jmp @nochmal

@ende:
.HALT

&Header DB 13,10
> 'Segm         Name             Gre',13,10
> '-------------------------------------',0
