
; Demonstriert das Komprimieren/Entkomprimieren einer Text-Datei
; Syntax: SPACE [Quelldatei] [Zieldatei] [/P | /E]
; /P packt (komprimiert) die Quelldatei
; /E entpackt (entkomprimiert) die Zieldatei
; Die gepackte Datei sollte die Endung .SPC bekommen (Standard in New-DOS)
; Gepackt werden knnen nur ASCII-Textdateien!
 
jmp @BEGIN

.include fileop, param, space

Modus DB 0, 0, 0

OBJECT ReadRec
  Handle  DW ?                   ; Datei-Handle
  CharNum DW ?                   ; Zahl der gelesenen/geschriebenen Bytes
  Private DB ?                   ; fr Programmierer fr eigene Zwecke
OBJECT END

.even

OBJECT WriteRec
  Handle  DW ?                   ; Datei-Handle
  CharNum DW ?                   ; Zahl der gelesenen/geschriebenen Bytes
  Private DB ?                   ; fr Programmierer fr eigene Zwecke
OBJECT END

ReadName  DB 80 DUP (?)
WriteName DB 80 DUP (?)
 
BufSize  EQU ($-ReadName)        ; die beiden Dateinamen werden als 
QBuffer   DB absolute (ReadName) ; Lesepuffer "mibraucht"
ZBuffer   DB (Bufsize*2) DUP (?) ; Zielpuffer, doppelt so gro wie "QBuffer"
 
@BEGIN:
  #ParamStr (1, ReadName^)  / cmp Byte ReadName,  0 / jne @1 / jmp @ende / @1:
  #ParamStr (2, WriteName^) / cmp Byte WriteName, 0 / jne @2 / jmp @ende / @2:
  #ParamStr (3, Modus^)     / cmp Byte Modus,     0 / jne @3 / jmp @ende / @3: 

  mov al, [(Modus+1)]
  and al, 11011111b                 ; UpCase ('p' --> 'P')
  cmp al, 'P' / je @los             ; Parameter checken
  cmp al, 'E' / je @los / jmp @ende
 
@los:
  mov Modus, al

  #Reset    (ReadRec^,  ReadName^)  / jc @ende
  #Rewrite  (WriteRec^, WriteName^) / jc @ende
 
  @next:
    #BlockRead (ReadRec^, QBuffer^, BufSize)
    jc  @close
    cmp Word ReadRec.CharNum, 0   ; Dateiende erreicht?
    je  @close

    cmp byteptr Modus, 'P'  ; 'P'=packen, 'E'=entpacken
    jne @entpacken
      #PackText   (QBuffer^, ZBuffer^, ReadRec.Charnum)
      jmp short @weiter
    @entpacken:
      #UnPackText (QBuffer^, ZBuffer^, ReadRec.Charnum)
    @weiter:

    #BlockWrite (WriteRec^, ZBuffer^, ax)  ; AX= Zahl der Zeichen in ZBuffer
    jc @close
  jmp short @next

@close:
  #Close (WriteRec^)
  #Close (ReadRec^)

@ende:
.halt

