
; -------------------------- Textviewer -------------------------------
; zeigt die ersten 400 Zeilen einer Textdatei. Eine Zeile kann bis zu
; 127 Zeichen lang sein - das Seitwrtsscrollen ist mglich.
; Die anzuzeigende Datei wird als Kommandozeilen-Parameter bergeben.


jmp BEGIN

BufSize EQU 128

.include CRT, Param, Strings, FileOp

OBJECT TextRec
  Handle  DW ?                   ; Datei-Handle
  BufPtr  DW ?                   ; Schreib/Leseposition im Puffer
  BufEnd  DW ?                   ; Zahl der Zeichen im Puffer
  EoF     DB ?                   ; 1, wenn Dateiende erreicht, sonst 0
  Private DB ?                   ; fr Programmierer fr eigene Zwecke
  Buffer  DB BufSize dup ('x')   ; Schreib/Lesepuffer
OBJECT END
 
OutString:     ; benutzt die nachfolgenden Strings als Puffer, 
               ; da die nicht mehr gebraucht werden

FileName   DB 80 dup ('y')
 
StatusText DB ' Scrollen: ',24,25,26,27,', BILD-Tasten, Pos1, End       '
>             'Beenden: Esc         Zeile: 1',0


StrLen    EQU  128     ; Maximale Stringlnge
MaxLines  EQU  400     ; Maximale Zahl der einzulesenden Zeilen der Datei
LastLine   DW    0     ; Anzahl der tatschlich eingelesenen Zeilen
FirstLine  DW    0     ; Nummer der ersten auf dem Moni angezeigten Zeile
FirstChar  DW    1     ; Erstes anzuzeigendes Zeichen der jeweiligen Zeile

; ---------------------  Unter-Prozeduren --------------------------------

 
PROC ErrorMsg: / Text PAR 2       ; Gibt die in "Text" bergebene
BEGP                              ; Zeichenkette als Fehlermeldung aus
  push ax, dx
  mov  dx, Text
  mov  ah, 9
  int  21h
  lea  dx, &KeyMsg
  mov  ah, 9
  int  21h
  mov  ah, 7
  int  21h
  pop  dx, ax
  RET
  &KeyMsg DB  13,10,13,10, 'Weiter mit beliebiger Taste',13,10,'$'
ENDP


PROC IncLine: / Num PAR 2
BEGP
  push ax, cx
  mov  cx, Num
  jcxz @wech
  mov  ax, FirstLine
  @rep:
    cmp ax, LastLine
    ja  @wech
    inc ax
  loop @rep
  @wech:
  mov  FirstLine, ax
  pop  cx, ax
  ret
ENDP


PROC DecLine: / Num PAR 2
BEGP
  push ax, cx
  mov  cx, Num
  jcxz @wech
  mov  ax, FirstLine
  @rep:
    or  ax, ax
    jz  @wech
    dec ax
  loop @rep
  @wech:
  mov  FirstLine, ax
  pop  cx, ax
  ret
ENDP


PROC WriteLineNum:
  LineNumStr LOC 6         ; Lokaler String fr die Ausgabe der Zeilennummer
BEGP
  push bx, si
  mov  bx, FirstLine
  lea  si, LineNumStr
  inc  bx
  #StrWord (bx, si)
  #TextBackGround (1)      ; blau
  #TextColor (14)          ; gelb
  #Window  (1, 1, 80, 25)
  #GotoXY  (75, 25)
  #Write   (si)
  #ClrEol
  #Window  (1, 2, 80, 24)
  #TextBackGround (7)      ; grau
  #TextColor (0)           ; Schwarz
  pop  si, bx
  ret
ENDP
 
; ---------------------------- Haupt-Programm ------------------------------

BEGIN:
  #ParamStr (1, FileName^)
  cmp Byte FileName, 0           ; Lnge = 0 ?
  jne @IsParam 
    #ErrorMsg ('Parameter Dateiname fehlt$'^) / jmp @Exit
  @IsParam:

  #InitCrt
  #ResetText (TextRec^, FileName^)
  jnc @los
    #ErrorMsg ('Datei konnte nicht geffnet werden$'^) / jmp @Exit
  @los:

  lea dx, &EndOfProgram
  xor bx, bx
  mov cx, MaxLines
 
  @next:
    #PopStr (TextRec^, dx, StrLen)
    jnc  @los1
      #ErrorMsg ('Lesefehler in Datei$'^) / jmp short @Close 
    @los1:
    add dx, StrLen
    inc bx
    cmp Byte TextRec.EoF, 1
  loopne @next

  @Close:
  #Close (TextRec^)
  jnc  @los2
    #ErrorMsg ('Fehler beim Schlieen der Datei$'^) / jmp @Ende
  @los2:

  mov LastLine, bx
 
; ----------------------- Text anzeigen ------------------------------------

  #TextBackGround (1)      ; blau
  #TextColor (14)          ; gelb

  #GotoXY (1, 1)
  #ClrEoL
  #GotoXY (2, 1)
  #UpCaseStr (FileName^, FileName^)
  #Write (FileName^)

  #GotoXY (1, 25)
  #Write (StatusText^)
  #ClrEoL
 
  #Window (1, 2, 80, 24)
  #TextBackGround (7)     ; grau
  #TextColor (0)          ; schwarz
  #ClrScr
  #CursorOff
 
  @scroll:
    #GotoXY (1, 1)
    lea si, &EndOfProgram
    mov ax, FirstLine / push ax
    mov cl, 7
    shl ax, cl
    add si, ax
    mov cx, 23
    pop ax
    @nochmal:
      cmp  ax, LastLine
      jae  @weiter
      #WriteChr (' ')
      #Copy (si, OutString^, FirstChar, 78)
      #Write (OutString^)
      @weiter:
      #ClrEol
      cmp  cx, 1 / je @weiter1 / #LineFeed / @weiter1:
      inc  ax
      add  si, StrLen
    loop @nochmal

    @9:
    mov ah, 7
    int 21h
    cmp al, 27   / je  @Ende
    or  al, al   / jz  @9                        ; ScanCode holen

    cmp al, 80   / jne @1 / #IncLine (1)         / @1:     ; Pfeil-Nach-Unten
    cmp al, 72   / jne @2 / #DecLine (1)         / @2:     ; Pfeil-Nach-Oben
    cmp al, 79   / jne @3 / #IncLine (LastLine)  / @3:     ; Ende
    cmp al, 71   / jne @4 / #DecLine (FirstLine) / @4:     ; Pos1
    cmp al, 81   / jne @5 / #IncLine (22)        / @5:     ; BILD-Ab
    cmp al, 73   / jne @6 / #DecLine (22)        / @6:     ; BILD-Auf
    cmp al, 77   / jne @7 / inc Word FirstChar   / @7:     ; Rechts
    cmp al, 75   / jne @8 / cmp Word FirstChar, 1/ jbe @8
                            dec Word FirstChar   / @8:     ; Links
    #WriteLineNum
  jmp short @scroll

  @Ende:
  #TextBackGround (0)
  #TextColor (7)
  #Window (1, 1, 80, 25)
  #ClrScr
  #CursorOn

  @exit:
.HALT

