
;          Beispielprogramm zur Umwandlung von Zeichenketten in 
;                   32-Bit-Binrzahlen und umgekehrt
; -------------------------------------------------------------------------

.include output, rechnen, strings

jmp short BEGIN

String  DB  '-12345678', 0   ; erlaubt sind Ziffern und Vorzeichen + bzw. -
Zahl    DD  ?                ; "LongInt"


BEGIN:

  #LongVal (String^, Zahl^)  ; Zeichenkette -> Binrzahl
  jc  @Error                 ; Wenn Carry-Flag gesetzt, dann enthielt die
                             ; Zeichenkette unerlaubte Zeichen

  #LongStr (Zahl^, String^)  ; Binrzahl    -> Zeichenkette

  #DosLn (String^)           ; Ergebnisstring ausgeben

.HALT

  @Error:
  #DosLn (&Error^)           ; Fehlermeldung ausgeben
.HALT

  &Error   DB  'Zeichenkette enthlt unerlaubte Zeichen', 0
 
; -------------------------------------------------------------------------
; Anmerkung: Eine Binrzahl kann mit den Prozeduren DosNum, DosNumLn,
; OutNum oder OutNumLn (LIB-Datei OUTPUT.LIB) auch direkt als Zeichenkette 
; auf dem Bildschirm ausgegeben werden.

