.include output
jmp BEGIN
 
; Als nchstes soll eine ganze Zeichenkette von der Tastatur entgegengenommen
; und anschlieend auf dem Monitor ausgegeben werden. DOS stellt dazu einen 
; einfachen Zeilen-Editor zur Verfgung. Hier knnen Sie Zeichen schreiben
; und mit der Rcktaste wieder entfernen. Mit Enter schlieen Sie eine 
; Eingabe ab.

; Die Programmierung des DOS-Zeilen-Editors ist nicht ganz einfach. Hier ist
; angeraten, was Sie auch fr die Zukunft beherzigen sollten: Sie sollten
; Code bersichtlich strukturieren, soda er sich mglichst selbst erklrt.

; Fr die folgende Texteinlese-Funktion ist der von ASM zur Verfgung
; gestellte Datentyp "Object" geradezu wie geschaffen. Ein Objekt ist 
; soetwas wie eine Kapsel. In der Kapsel befindet sich wohlverwahrt alles,
; was zum Einlesen der Zeichenkette und deren Verwaltung ntig ist.

; Das im folgenden deklarierte Objekt "Line" enthlt 4 Felder

OBJECT Line:
  MaxLen DB ?                 ; 1. Feld "MaxLen"  (ein Byte gro)
  Length DB ?                 ; 2. Feld "Length"  (ein Byte gro)
  Puffer DB 255 dup (0)       ; 3. Feld "Puffer"  (255 Byte gro)

  PROC   Read:                ; 4. Feld "Read"    (Prozedur)
    push ax,  dx, di
    lea  di,  Line.MaxLen
    mov  Word [di], 254
    mov  dx,  di
    mov  ah,  0Ah             ; DOS-Funktion 0Ah "Zeichenkette einlesen"
    int  21h
    mov  al,  Line.Length
    xor  ah,  ah
    lea  di,  Line.Puffer
    add  di,  ax
    mov  Byte [di], 0
    pop  di,  dx, ax
    ret
  ENDP
OBJECT END

; Um spter im Programm auf eines der Felder zugreifen zu knnen, mssen
; Sie es zusammen mit dem Namen des Objektes (Schema: Objekt.Feld) aufrufen. 
; Die vier Felder haben folgende Funktion:

; Line.MaxLen = hier wird DOS mitgeteilt, wie lang die eingelesene
;               Zeichenkette maximal werden darf
;
; Line.Length = hier speichert DOS, wieviele Zeichen es eingelesen hat,
;               also wie lang die Zeichenkette ist
;
; Line.Puffer = Der Puffer, der die eingelesenen Zeichen enthlt. Das Ende
;               der Zeichenkette ist mit einem Null-Byte gekennzeichnet.
;
; Line.Read   = die Prozedur, die DOS auffordert, eine Zeichenkette
;               einzulesen und die dazu alle Daten aufbereitet

; Wenn Sie das heil berstanden haben, dann knnen Sie nun aufatmen. Der
; Rest ist ein Kinderspiel:

BEGIN:
  #Line.Read             ; Zeichenkette von Tastatur einlesen
  #DosLineFeed           ; Zeilenvorschub einfgen
  #DosLn (Line.Puffer^)  ; eingelesene Zeichenkette auf Bildschirm ausgeben
.halt

; Das war es wirklich schon!

