
; Ersatz fr ANSI.SYS

jmp BEGIN 
DB                  1   ; VersionsNummer des Treibers 
DB                  2   ; Treiber-Nummer zur berprfung d. UnAnsi
DB                  1,0 ; interne Nummer (vom Programmierer frei whlbar) 
DB                  29h ; Nummer eines der umgeleiteten Interrupts 
DB                  0   ; Zahl der erwarteten Start-Parameter
 
Flag            DB  0
TextAttr        DB  7
VideoAddr       DW  $B000 
SaveCurPos      DW  0
Escape          DB  0 
AnsiLen         DB  0, 0                   ; Length (AnsiStr)
ColorTab        DB  0, 4, 2, 6, 1, 5, 3, 7 ; Farbtabelle

;----------------------- Unterfunktionen ---------------------------------

PROC GetCursorPos:
  mov dx, 0040h
  mov es, dx
  mov dx, es:[50h]
  RET 
ENDP


PROC MoveCursor:
  mov ah, 2 
  xor bh, bh 
  int 10h 
  RET
ENDP


PROC CharAdd
  mov bx, AnsiLen               ; Lade LngenByte
  cmp bx, 255                   ; Maximale Lnge des AnsiStr
  ja  @ZuLang 
  lea di, &AnsiString
  mov [di+bx], al               ; hnge CodeByte an AnsiString an
  inc bx
  mov AnsiLen, bx               ; neue StringLnge
  clc
  jmp @exit                     ; und dann raus
  @ZuLang:
  stc
  @exit:
  RET
ENDP



PROC SetColors: 
  or  al, al / jnz @Farben

; Die Codes in ah verstehen sich als ah+1
        cmp ah, 1  / jne @xa
        mov Byte TextAttr, 7                    ; Normalschrift
        jmp short @xx
  @xa:/ cmp ah, 2  / jne @xb
        or  Byte Textattr, 00001000b            ; Highvideo
        jmp short @xx
  @xb:/ cmp ah, 5  / jne @xc 
        mov Byte TextAttr, 1                    ; unterstrichen (nur sw-Moni)
        jmp short @xx
  @xc:/ cmp ah, 6  / jne @xd 
        or  Byte Textattr, 128                  ; Blink
        jmp short @xx
  @xd:/ cmp ah, 8  / jne @xe                    ; invers
        mov al, TextAttr
        and al, 11110111b         ;LowVideo
        rol al, 1
        rol al, 1
        rol al, 1
        rol al, 1
        mov TextAttr, al
        jmp short @xx
  @xe:/ cmp ah, 9  / jne @xx 
        and Byte Textattr, 11110111b            ; LowVideo
  @xx:
  RET

@Farben:
  lea si, ColorTab
  mov bx, ax / dec bl / xor bh, bh  ; Zeiger auf Farbe-> [si+bx]

;@TextColor:
  cmp ah, 4  / jne @BackGround      ; Textfarben ndern ?
  mov al, TextAttr
  and al, 11110000B                 ; Highvideobit evtl. stehenlassen ??
  add al, [si+bx]
  mov TextAttr, al
  RET

@BackGround:
  cmp ah, 5 / jne @fert1            ; Hintergrund ndern ?
  mov ah, [si+bx]
  shl ah, 1
  shl ah, 1
  shl ah, 1
  shl ah, 1
  mov al, TextAttr
  and al, 10001111B                 ; Blinkbit stehenlassen
  add al, ah
  mov TextAttr, al
@fert1:
RET 
ENDP


PROC Val:
  xchg al, ah
  dec  al 
  or   ah, ah / jz @DasWars 
  dec  ah
  mov  bl, ah
  xor  ah, ah
  mov  bh, 10
  mul  bh
  add  al, bl
  @DasWars:
  RET
ENDP


PROC GotoXY:
  #VAL
  or  dh, dh / jnz @Zeile1
  mov dh, al
  jmp short @Zeile2
  @Zeile1:
  mov dl, al
  dec dh / cmp dh, 24 / jbe @s1 / mov dh, 24 / @s1:
  dec dl / cmp dh, 79 / jbe @s2 / mov dh, 79 / @s2: 
  #MoveCursor
  @Zeile2:
  RET
ENDP

 
PROC CheckAnsiCode:
  mov  cx, AnsiLen               ; Lade LngenByte
  jcxz @ex
  lea  di, &AnsiString
  xor  ax, ax
  @start1:
    mov bl, [di]
    inc di
    cmp bl, 59                  ; Suche nach Zeichen ';'
    je  @Trenner
    mov al, bl
    sub al, 47                  ; aus '0' wird 1 usw.
    or  ah, ah
    jnz @weit
    mov ah, al
    xor al, al
    jmp short @weit
    @Trenner:
           cmp dl, 'm' / jne @y1
           #SetColors  / jmp short @Fert
    @y1: / cmp dl, 'H' / je  @x2 / cmp dl, 'f' / jne @y2
    @x2: / #GotoXY     / jmp short @Fert

    @y2: / #val / mov bl, dl / #GetCursorPos

           cmp bl, 'A' / jne @y3 
           cmp dh, al  / ja  @r1/mov al, dh /@r1:/ sub dh, al / jmp short @mov 
    @y3: / cmp bl, 'B' / jne @y4 
           add dh, al  / cmp dh, 24 /jbe @r2 /mov dh, 24/@r2: / jmp short @mov 
    @y4: / cmp bl, 'C' / jne @y5 
           add dl, al  / cmp dl, 79 /jbe @r3 /mov dl, 79/@r3: / jmp short @mov 
    @y5: / cmp bl, 'D' / jne @fert 
           cmp dl, al  / ja  @r4/mov al, dl /@r4:/ sub dl, al  

    @mov:/ #moveCursor
    
    @fert:
      xor ax, ax
    @weit:
  loop @Start1
  @ex:
  RET
ENDP

;------------------------ Hauptprozedur ----------------------------------


Output:                    

  cmp Byte Flag, 2              ; Flag wird vom Unloader auf 2 gesetzt, 
  jne @Okay                     ; wenn nur alte Routine ausgefhrt
                                ; werden soll. Sonst Flag = 0
  DB 0EAh                       ; Jmp Far Ptr = alte Int-29h-Routine
  OBJECT Old29:
    Ofs DW '6.'                ; hier setzt der Loader die alte Adresse
    Seg DW '24'                ; der alten Int-29h-Routine ein.
  OBJECT END
;------------------------------ Escape auswerten-----------------------------

@Okay:
  push ax, bx, cx, dx, ds, es, si, di, cs / pop ds

  cmp Byte Escape, 27  / je @1  ; Prfe Escape-Flag
  cmp Byte Escape, 91  / je @2  ; Escape-Flag = '['

  cmp al, 27                    ; Escape-Zeichen ?
  jne @KeinFlag1
  mov Escape, al                ; wenn Ja, setze Escape-Flag
  mov Word AnsiLen, 0           ; AnsiLen auf 0
  jmp @ende                     ; und dann raus

@1:
  mov Byte Escape, 0             
  cmp al, 91                    ; Esc-Klammer ?
  jne @KeinFlag1
  mov Escape, al                ; wenn Ja, setze Klammer-Flag
  jmp @ende                     ; und dann raus

@KeinFlag1:
  jmp @KeinFlag

@2: 
  cmp al,  59 / je @AddChar     ; al= ';'
  cmp al, '0' / jb @Buchstabe
  cmp al, '9' / ja @Buchstabe

@AddChar: 
  #CharAdd / jc @KeinFlag
  jmp @ende
 
@Buchstabe:
  mov ah, al / mov al, 59 / #CharAdd / mov al, ah / jc @KeinFlag1 
 
      cmp al, 's' / jne @a                                    ; SaveCursor
      #GetCursorPos / mov SaveCurPos, dx 
      jmp short @Fertig

  @a:/cmp al, 'u' / jne @b                                    ; Restor3Cursor
      mov dx, SaveCurPos / #MoveCursor
      jmp short @Fertig 

  @b:/cmp al, 'K' / jne @c                                    ; ClrEol
      #GetCursorPos / mov cx, dx / mov dl, 80 
      mov bh, TextAttr / mov ax, 0700h / int 10h
      jmp short @Fertig 

  @c:/cmp al, 'J' / jne @d                                    ; ClrScr
      xor cx, cx / mov dx, 6223
      mov bh, TextAttr / mov ax, 0700h / int 10h
      jmp short @Fertig  

  @d:/mov dl, al / xor dh, dh   ; Code in DL, Zhler in DH=0
      #CheckAnsiCode

@Fertig:
  mov Byte Escape,  0           ; Escape-Flag lschen  
  mov Word AnsiLen, 0           ; AnsiLen auf 0 (mu berhaupt ?)
  jmp short @ende               ; und dann raus
 
@KeinFlag:
;------------------------------ Zeichen auf Bildschirm ---------------------

  #GetCursorPos

  mov  ah, 0Eh                  ; BIOS-AusgabeRoutine
  int  10h

  cmp  al, 10                   ; Farbunterlegung nicht bei den
  je   @Ende                    ; beiden Zeilenumbruch-Zeichen
  cmp  al, 13
  je   @Ende
 
  mov  es, VideoAddr            ; Farbunterlegung
  xor  ax, ax
  mov  al, dh
  xor  dh, dh
  mov  di, dx
  mov  bh, 80
  mul  bh
  add  di, ax
  add  di, di
  inc  di

  mov  al, TextAttr             ; Schreibe Farbe in VideoRAM
  stosb

@Ende:
;---------------------------- FlagCheck ------------------------------------

  cmp  Byte Flag, 1        ; Flag wird vom Unloader auf 1 gesetzt, 
  jne  @GanzRaus           ; wenn ANSI.COM aus dem Speicher entfernt
                           ; werden soll. Sonst Flag = 0
  lds  dx, Old29           ; Alte Adressen laden 
  mov  ax, 2529h           ; SetIntVec 29h
  int  21h                 ; Alte INT 29-Routine wieder einsetzen
 
  push cs 
  pop  es
  mov  ah, 49h             ; Speicher von ANSI.COM wieder freigeben
  int  21h                 ; ES=CS=Segment des freizugebenden Blocks 

@GanzRaus: 
  pop  di, si, es, ds, dx, cx, bx, ax
IRET                                     


&AnsiString DB 0           ; speichert die eintreffenden Zeichen
                           ; Loader gibt hier noch 256 Bytes dazu

;------------------------------- Loader ------------------------------------

BEGIN:
  lea dx, &ProgName
  #OutPut1

  cld
  mov  ax, 6200h              ; Adresse des PSP ermitteln
  int  21h                   
  mov  es, bx                 ; Segment des PSP in ES
  mov  di, 81h                ; Anfang Kommandozeile in SI
  xor  cx, cx
  mov  cl, es:[80h]           ; Lade LngenByte der Kommandozeile in CL
  mov  al, ' '
  repe scasb                  ; Leerzeichen berspringen
  je   @laden                 ; nur Leerzeichen? dann raus
  mov  al, es:[di]            ; Zeichen nach '/' laden
  and  al, 11011111b          ; UpCase
 
         cmp al, 'X' / jne @xs / mov bl, 1                     / jmp short @entladen
  @xs: / cmp al, 'S' / jne @xr / mov bl, 2  / lea dx, &Deactiv / jmp short @entladen
  @xr: / cmp al, 'R' / jne @xh / xor bl, bl / lea dx, &Activ   / jmp short @entladen 
  @xh:                                      / lea dx, &Hilfe   / jmp short @out 
 
@entladen:
  push dx, bx
  mov  ax, 3529h
  int  21h
  pop  bx, dx
  mov  di, 100h                       ; es:di = Driver-Header
  mov  si, di                         ; ds:si = COM-Header
  mov  cx, 9                          ; Lnge Header
  repe cmpsb                          ; Header vergleichen
  jcxz @ausfhren
    lea dx, &NotFound
    jmp short @out
  @ausfhren:
  es:
  mov  Flag, bl
  cmp  bl, 1
  jne  @out

  mov  al, 13 / int  29h              ; Unload anschubsen
  lea  dx, &Unload

@out:
 #OutPut1
.HALT


@Laden:
  -EnvironMemFree
  -GetVideoAddr

  lea  dx, &Load
  #OutPut1                    ; Gebe Text aus                  

  mov  ax, 3529h       ; GetIntVec 29h
  int  21h                                
  mov  Old29.Ofs, bx   ; Schreibe alten Vektor in den Call-Befehl
  mov  Old29.Seg, es   ; 
  mov  ax, 2529h       ; SetIntVec 29h
  lea  dx, OutPut      ; = mov dx, Offset OutPut, DS bereits Segment-Addr.
  int  21h

  lea  dx, BEGIN       ; = Zahl der resident zu haltenden 
                       ; Bytes - CS-Register = Segment des PSP
  add  dx,  256        ; Max. Lnge AnsiString dazu addieren
  int  27h             ; Rest des Programmes resident machen

PROC OutPut1:
  mov ah, 9
  int 21h
  lea dx, &LineFeed
  mov ah, 9
  int 21h
  RET
ENDP

.insert copyrigh

  &Progname  DB  'ANSI  ', Copyright, '$'
  &LineFeed  DB   13,10,'$'
  &Load      DB  'geladen$'
  &Deactiv   DB  'stillgelegt$'
  &Activ     DB  'reaktiviert$'
  &Unload    DB  'entfernt$'
  &NotFound  DB  'nicht gefunden$'
  &Hilfe     DB  'ermglicht Grafik- und Cursorsteuerung mit Escape-Sequenzen'
  >               13,10,13,10
  >              'Laden  : ANSI',13,10
  >              'Steuern: ANSI [/x|/s|/r]',13,10,13,10
  >              '/x  aus dem Speicher entfernen',13,10
  >              '/s  stillegen',13,10
  >              '/r  reaktivieren$' 
