
; ========================  CLOCK 1 =======================================
; Einfaches Beispielprogramm zur TSR-Programmierung. Das Programm zeigt am
; oberen rechten Bildschirmrand eine mitlaufende Uhr an.


jmp BEGIN                 ; Sprung zum Lade-Programm (Loader)


; ------------------------  Variablen -------------------------------------

VideoAddr DW  $B000       ; Segment-Adresse des Video-RAM - dieser liegt bei
                          ; Mono-Monitoren an $B000 und bei VGA-Monitoren
                          ; an $B800. Die Ermittlung der tatschlichen
                          ; Adresse findet im Lade-Programm (Loader) statt.
OBJECT Old1C:
  Ofs DW ?                ; hier setzt der Loader die Adresse
  Seg DW ?                ; der alten Int-1Ch-Routine ein.
OBJECT END                ; (Offset und Segment)
 

;-------------------------- Unterfunktion ---------------------------------
; Die folgende Prozedur wandelt die vom BIOS im BCD-Format zurckgelieferte
; Uhrzeit in lesbaren ASCII-Code um und gibt diesen am oberen rechten 
; Bildschirmrand aus.
;
; Die Funktionsweise von "OutTime" ist fr das Verstndnis des TSR
; nicht wesentlich.

PROC OutTime:
  mov ch, al              ; al sichern
  mov al, ah
  stosb                   ; direktes Schreiben in den Bildschirmspeicher
  inc di                  ; (Video-RAM)
  mov al, ch
  shr al, 1               ; High-Nibble von al
  shr al, 1               ; in Low-Nibble schieben
  shr al, 1
  shr al, 1
  add al, 30h             ; in ASCII-Zeichen umwandeln
  stosb                   ; Anzeigen 
  inc di
  mov al, ch              ; al restaurieren
  and al, 0Fh             ; nur Low-Nibble auswerten 
  add al, 30h             ; in ASCII-Zeichen umwandeln
  stosb                   ; Anzeigen 
  inc di
  RET
ENDP

; ------------------------  neuer Interrupt-Handler -------------------------

NewInt1C:  
  pushf                   ; Flag-Register mssen zuvor gepusht werden...
  call far cs:[Old1C]     ; ... dann alten Interrupt-Handler aufrufen
                          ; Wichtig: Ein TSR mu den alten Handler aufrufen,
                          ; wenn es andere TSR, die ebenfalls am Int 1Ch
                          ; hngen, nicht totlegen will.

  push ax, cx, dx, es, di ; Diese Register werden von CLOCK verndert und 
                          ; mssen daher unbedingt zwischengespeichert werden.

  mov  ah, 2              ; BIOS-Funktion 2h (System-Zeit lesen)
  int  1Ah                ; BIOS Interrupt 1Ah aufrufen
                          ; Verwenden Sie hier nie den hnlichen DOS-Interrupt!

  cs:                     ; Segment-Vorgabe CS. Wichtig in TSR, da das 
                          ; DS-Register NICHT auf das Datensegment zeigt!
                          ; Damit der folgende Befehl die Variable "VideoAddr"
                          ; korrekt auslesen kann, bentigt der "mov"-Befehl
                          ; die Angabe des Segmentes, wenn es NICHT DS ist!

  mov  es, VideoAddr      ; Segment Video-RAM in ES.

  mov  di, 142            ; Offset im Videospeicher
  cld                     ; vorwrts schreiben

  mov  ah, 32             ; fhrendes Leerzeichen
  mov  al, ch             ; Stunden in al
  call OutTime            ; umwandeln und anzeigen
  mov  ah, ':'            ; Doppelpunkt dazwischen
  mov  al, cl             ; Minuten in al
  call OutTime            ; umwandeln und anzeigen
  mov  ah, ':'            ; Doppelpunkt dazwischen
  mov  al, dh             ; Sekunden in al
  call OutTime            ; umwandeln und anzeigen

  pop  di, es, dx, cx, ax ; Alle Register wieder herstellen
                          ; Ganz wichtig, da ansonsten meist ein kompletter
                          ; Systemstillstand/Absturz eintritt.

IRET                      ; Rcksprung, Ausfhrung ist beendet


; ------------------------------ Loader --------------------------------------
; Dieser Teil des Programmes ldt den gesamten Code zwischen dem ersten
; Befehl (jmp BEGIN) und dem IRET in den Speicher und wird beim resident 
; machen abgeschnitten (siehe die letzten beiden Code-Zeilen)

BEGIN:

 -EnvironMemFree       ; Macro: Umgebungsspeicher freigeben
 -GetVideoAddr         ; Macro: Farb- oder Mono-Monitor ?

  mov  ax, 351Ch       ; DOS-Funktion 35h des Int 21h: Ermittle...
  int  21h             ; ...momentanen Interrupt-Vektor des Int 1Ch                  
  mov  Old1C.Ofs, bx   ; Speichere alten Vektor des Int 1Ch
  mov  Old1C.Seg, es   ; in der Variablen Old1Ch

  mov  ax, 251Ch       ; DOS-Funktion 25h: Setze neuen 1Ch-Vector
  lea  dx, NewInt1C    ; = Adresse von NewInt1C: Offset in DX, Segment 
  int  21h             ; in DS (bereits dort enthalten - dies macht DOS
                       ; beim Starten eines Programmes automatisch)

  lea  dx, BEGIN       ; = Zahl der resident zu haltenden Bytes in DX

  int  27h             ; Rest des Programmes resident machen


