
; ========================  CLOCK_2.ASM ====================================
; Beispielprogramm zur TSR-Programmierung: Entladbares TSR.
; Das Programm baut auf CLOCK_1.ASM auf.

jmp BEGIN 

DB                  1     ; VersionsNummer des Treibers 
DB                  4     ; Treiber-Nummer zur berprfung d. UnLoader
DB                  1,0   ; interne Nummer (vom Programmierer frei whlbar) 
DB                  1Ch   ; Nummer eines der umgeleiteten Interrupts 
DB                  0     ; Zahl der erwarteten Start-Parameter
 
Flag            DB  0
VideoAddr       DW  $B000 

OBJECT Old1C:
  Ofs DW ?                ; hier setzt der Loader die Adresse
  Seg DW ?                ; der alten Int-1Ch-Routine ein.
OBJECT END                ; (Offset und Segment)
 

;-------------------------- Unterfunktion ---------------------------------
 

PROC OutTime:
  mov ch, al              ; al sichern
  mov al, ah
  stosb  
  inc di
  mov al, ch
  shr al, 1               ; High-Nibble von al
  shr al, 1               ; in Low-Nibble schieben
  shr al, 1
  shr al, 1
  add al, 30h             ; in ASCII-Zeichen umwandeln
  stosb
  inc di                  ; Anzeigen
  mov al, ch              ; al restaurieren
  and al, 0Fh             ; nur Low-Nibble auswerten 
  add al, 30h             ; in ASCII-Zeichen umwandeln
  stosb
  inc di                  ; Anzeigen
  RET
ENDP

; ------------------------  neuer Interrupt-Handler -------------------------

NewInt1C:  
  pushf                   ; Flag-Register mssen zuvor gepusht werden...
  call far cs:[Old1C]     ; ... dann alten Interrupt-Handler aufrufen

  push ax, dx, es, ds, cs
  pop  ds                 ; cs jetzt auch in ds

  mov  al, Flag
  shr  al, 1
  jc   @Unload
  jnz  @Raus
 
  push di, cx

  mov  ah, 2              ; Funktion 2 (RTC-Zeit lesen)
  int  1Ah                ; BIOS Interrupt 1Ah aufrufen

  mov  es, VideoAddr      ; Segment Video-RAM
  mov  di, 142            ; Offset im Videospeicher
  cld                     ; vorwrts schreiben

  mov  ah, 32             ; fhrendes Leerzeichen
  mov  al, ch             ; Stunden in al
  call OutTime            ; umwandeln und anzeigen
  mov  ah, ':'            ; Doppelpunkt dazwischen
  mov  al, cl             ; Minuten in al
  call OutTime            ; umwandeln und anzeigen
  mov  ah, ':'            ; Doppelpunkt dazwischen
  mov  al, dh             ; Sekunden in al
  call OutTime            ; umwandeln und anzeigen

  pop  cx, di
  jmp  short @Raus
 
@Unload:
  lds  dx, Old1C          ; Alte Adressen laden 
  mov  ax, 251Ch          ; SetIntVec 1Ch
  int  21h                ; Alte INT 1Ch-Routine wieder einsetzen

  push cs 
  pop  es
  mov  ah, 49h            ; Speicher von CLOCK.COM wieder freigeben
  int  21h                ; ES=CS=Segment des freizugebenden Blocks 

@Raus:
  pop  ds, es, dx, ax
IRET


; ------------------------------ Loader --------------------------------------

BEGIN:
  lea  dx, &Progname
  #OutPut

  cld
  mov  ax, 6200h              ; Adresse des PSP ermitteln
  int  21h                   
  mov  es, bx                 ; Segment des PSP in ES
  mov  di, 81h                ; Anfang Kommandozeile in SI
  xor  cx, cx
  mov  cl, es:[80h]           ; Lade LngenByte der Kommandozeile in CL
  mov  al, ' '
  repe scasb                  ; Leerzeichen berspringen
  je   @laden                 ; nur Leerzeichen? dann raus
  mov  al, es:[di]            ; Zeichen nach '/' laden
  and  al, 11011111b          ; UpCase

         cmp al, 'X' / jne @xs / mov bl, 1                     / jmp short @entladen
  @xs: / cmp al, 'S' / jne @xr / mov bl, 2  / lea dx, &Deactiv / jmp short @entladen
  @xr: / cmp al, 'R' / jne @xh / xor bl, bl / lea dx, &Activ   / jmp short @entladen 
  @xh:                                      / lea dx, &Hilfe   / jmp short @out 
 
@entladen:
  push dx, bx
  mov  ax, 351Ch
  int  21h
  pop  bx, dx
  mov  di, 100h                       ; es:di = Driver-Header
  mov  si, di                         ; ds:si = COM-Header
  mov  cx, 9                          ; Lnge Header
  repe cmpsb                          ; Header vergleichen
  jcxz @ausfhren
    lea dx, &NotFound
    jmp short @out
  @ausfhren:
  es:
  mov  Flag, bl
  cmp  bl, 1
  jne  @out

  int  1Ch                            ; Unload anschubsen
  lea  dx, &Unload

@out:
 #OutPut
.HALT


@Laden:
  -EnvironMemFree      ; Macro: Umgebungsspeicher freigeben
  -GetVideoAddr        ; macro: Farb- oder Mono-Monitor ?

  lea  dx, &Load
  #output              ; Gebe Text aus                  

  mov  ax, 351Ch       ; GetIntVec 1Ch
  int  21h                                
  mov  Old1C.Ofs, bx   ; Schreibe alten Vektor in den Call-Befehl
  mov  Old1C.Seg, es 

  mov  ax, 251Ch       ; SetIntVec 1Ch
  lea  dx, NewInt1C    ; = mov dx, Offset NewInt1C, DS bereits Segment-Addr.
  int  21h

  lea  dx, BEGIN       ; = Zahl der resident zu haltenden 
                       ; Bytes - CS-Register = Segment des PSP
  int  27h             ; Rest des Programmes resident machen

PROC OutPut:
  mov ah, 9
  int 21h
  lea dx, &LineFeed
  mov ah, 9
  int 21h
  RET
ENDP


&ProgName  DB  'CLOCK  Copyright (c) ...$'
&LineFeed  DB   13,10,'$'
&Load      DB  'geladen$'
&Deactiv   DB  'stillgelegt$'
&Activ     DB  'reaktiviert$'
&Unload    DB  'entfernt$'
&NotFound  DB  'nicht gefunden$'
&Hilfe     DB  'blendet eine laufende Uhr ein',13,10,13,10
>              'Laden  : CLOCK',13,10
>              'Steuern: CLOCK [/x|/s|/r]',13,10,13,10
>              '/x  aus dem Speicher entfernen',13,10
>              '/s  stillegen',13,10
>              '/r  reaktivieren$' 


