
; ========================= DATE2000 =======================================
; Beispielprogramm fr das Umleiten eines DOS-Interrupts und das Sparen von 
; Speicher durch kopieren des TSR in das PSP.

jmp short BEGIN 

NEWDATE:
  cmp ah, 2Bh             ; Wurde die DOS-Funktion "Datum setzen" aufgerufen ?
  je  @CheckDate          ; wenn ja, dann Datum checken
  @Old:                   ; wenn nicht, Weitersprung zu DOS
  DB 0EAh                 ; = JMP Far [Old21]
  OBJECT Old21:
    Ofs DW 'DO'           ; hier setzt der Loader die Adresse
    Seg DW 'S7'           ; der alten Int-21h-Routine ein.
  OBJECT END

  @CheckDate:
    cmp cx, 1980          ; Datum >= 1980 ?
    jae @Old  
    add cx, 100           ; wenn nicht, dann ist es ein Datum >= 2000
  jmp short @Old          ; Korrigieren und ab zu DOS


CodeSize EQU ($-NewDate)  ; Berechnet die Gre der Prozedur "NewDate",
                          ; damit der Loader wei, wieviele Bytes er
                          ; in das PSP kopieren mu. 

HeapEnd  EQU ((CodeSize+80h+16) shr 4)
                          ; Berechnet die von DATE2000 bentigte Speicher-
                          ; gre in Paragraphen (!)
 
; ------------------------------ Loader --------------------------------------

BEGIN:
  -EnvironMemFree
 
  mov  ax, 3521h          ; GetIntVec 21h
  int  21h                                
  mov  Old21.Ofs, bx      ; Schreibe alten Vektor in den Jmp-Befehl
  mov  Old21.Seg, es 

  mov  ax, 6200h          ; Adresse des PSP ermitteln
  int  21h                   
  mov  es, bx             ; Segment des PSP in ES
  lea  si, NewDate        ; Code in das PSP verschieben, um Speicher zu sparen
  mov  di, 80h
  mov  cx, CodeSize
  cld
  rep  movsb              ; hier passierts

  mov  ax, 2521h          ; SetIntVec 21h
  mov  dx, 80h            ; Offset von "NewDate" befindet sich nun an 80h
  int  21h

  mov  dx, HeapEnd        ; = Zahl der resident zu haltenden Paragraphen
  mov  ax, 3100h          ; AH=31h, Fehlercode in AL=00h=Kein Fehler
  int  21h                ; Rest des Programmes resident machen


