
; ========================  LEER_1.ASM ====================================
; Leere TSR-Hlle eines DDD. Hier wird der alte Int-Vektor NACH der
; Ausfhrung des neuen aufgerufen

IntNumber EQU 1Ch         ; Anstelle 1Ch mssen Sie den Interrupt einsetzen, 
                          ; den das TSR auf sich selbst umlenken soll

jmp BEGIN 

DB                    1   ; VersionsNummer des Treibers 
DB                  128   ; Treiber-Nummer zur berprfung d. UnLoader
DB                  1,0   ; interne Nummer (vom Programmierer frei whlbar) 
DB            IntNumber   ; Nummer des umgeleiteten Interrupts 
DB                    0   ; Zahl der erwarteten Start-Parameter
 
Flag              DB  0

; ---------------------------------------------------------------------------

; hier knnen Sie Unterprozeduren und Variablen von "NewInt" unterbringen

; ------------------------  neuer Interrupt-Handler -------------------------

NewInt:  
  push ds, cs             ; DS wird mit CS gleichgeschaltet, damit alle
  pop  ds                 ; Variablenzugriffe funktionieren

  cmp  Byte Flag, 1       ; Flag prfen
  je   @Unload
  cmp  Byte Flag, 2
  je   @raus

  push ax, bx, cx, dx     ; Nach der Testphase sollten Sie hier alle Register
  push es, si, di, bp     ; herausnehmen, die Sie nicht verndern bzw., die
                          ; Sie ndern WOLLEN. 
 ;------------------------
                          ;
                          ; hier setzen Sie den Code ein, den das TSR
                          ; ausfhren soll.
                          ;
 ;------------------------
 
  pop  bp, di, si, es     ; alle Register poppen. Nach der Testphase
  pop  dx, cx, bx, ax     ; an Push-Befehle anpassen (s.o.)

  jmp  short @Raus
 
@Unload:
  push es, dx, ax
  cs:
  lds  dx, &OldInt                ; Alte Adressen laden 
  mov  ax, (25h shl 8+IntNumber)
  int  21h                        ; Alte INT-Routine wieder einsetzen

  push cs 
  pop  es
  mov  ah, 49h                    ; Speicher des TSR wieder freigeben
  int  21h                        ; ES=CS=Segment des freizugebenden Blocks 
  pop  ax, dx, es

@Raus:
  pop ds

  DB 0EAh                         ; JMP Far Ptr = alte Int-Routine aufrufen
  OBJECT &OldInt:
    Ofs DW ?                      ; hier setzt der Loader die Adresse
    Seg DW ?                      ; der alten Int-Routine ein.
  OBJECT END                      ; (Offset und Segment)
 
; ---------------------------------------------------------------------------

; hier knnen Sie Unterprozeduren und Variablen von "NewInt" unterbringen

; ------------------------------ Loader --------------------------------------

BEGIN:
  lea  dx, &Progname
  #OutPut

  cld
  mov  ax, 6200h              ; Adresse des PSP ermitteln
  int  21h                   
  mov  es, bx                 ; Segment des PSP in ES
  mov  di, 81h                ; Anfang Kommandozeile in SI
  xor  cx, cx
  mov  cl, es:[80h]           ; Lade LngenByte der Kommandozeile in CL
  mov  al, ' '
  repe scasb                  ; Leerzeichen berspringen
  je   @laden                 ; nur Leerzeichen? dann raus
  mov  al, es:[di]            ; Zeichen nach '/' laden
  and  al, 11011111b          ; UpCase ('a' --> 'A')

         cmp al, 'X' / jne @xs / mov bl, 1                     / jmp short @entladen
  @xs: / cmp al, 'S' / jne @xr / mov bl, 2  / lea dx, &Deactiv / jmp short @entladen
  @xr: / cmp al, 'R' / jne @xh / xor bl, bl / lea dx, &Activ   / jmp short @entladen 
  @xh:                                      / lea dx, &Hilfe   / jmp short @out 
 
@entladen:
  push dx, bx
  mov  ax, (35h shl 8 + IntNumber)
  int  21h
  pop  bx, dx
  mov  di, 100h                       ; es:di = Driver-Header
  mov  si, di                         ; ds:si = COM-Header
  mov  cx, 9                          ; Lnge Header
  repe cmpsb                          ; Header vergleichen
  jcxz @ausfhren
    lea dx, &NotFound
    jmp short @out
  @ausfhren:
  es:
  mov  Flag, bl
  cmp  bl, 1
  jne  @out

  int  IntNumber               ; Unload anschubsen. Je nach Interrupt mssen
                               ; Sie ggf. das AH-Register mit der Nummer einer
                               ; Funktion belegen, die keinen "Schaden"
  lea  dx, &Unload             ; anrichtet.

@out:
 #OutPut
.HALT


@Laden:
  -EnvironMemFree             ; Macro: Umgebungsspeicher freigeben

  lea  dx, &Load
  #output                     ; Gebe Programm-Name aus                  

  mov  ax, (35h shl 8 + IntNumber)
  int  21h                    ; GetIntVec                   
  mov  &OldInt.Ofs, bx        ; Schreibe alten Vektor in den Call-Befehl
  mov  &OldInt.Seg, es 

  mov  ax, (25h shl 8 + IntNumber)
  lea  dx, NewInt             ; SetIntVec
  int  21h

  lea  dx, (BEGIN shr 4 + 1)  ; = Zahl der resident zu haltenden Paragraphen
  mov  ax, 3100h              ; AH=31h, Fehlercode in AL=00h=Kein Fehler
  int  21h                    ; Rest des Programmes resident machen

; --------------------- Programm-Ende ---------------------------------

PROC OutPut:
  mov ah, 9
  int 21h
  lea dx, &LineFeed
  mov ah, 9
  int 21h
  RET
ENDP


&ProgName  DB  'LEER  Copyright (c) ...$'
&LineFeed  DB   13,10,'$'
&Load      DB  'geladen$'
&Deactiv   DB  'stillgelegt$'
&Activ     DB  'reaktiviert$'
&Unload    DB  'entfernt$'
&NotFound  DB  'nicht gefunden$'
&Hilfe     DB  'ist ein leeres TSR und tut nichts',13,10,13,10
>              'Laden  : LEER',13,10
>              'Steuern: LEER [/x|/s|/r]',13,10,13,10
>              '/x  aus dem Speicher entfernen',13,10
>              '/s  stillegen',13,10
>              '/r  reaktivieren$' 


