; A small tool to eject, close_track, lock, unlock or reset
; any CD-ROM, selected by the drive letter. Public domain,
; do with this file what you want. Written by Eric Auer (2003).
; To compile (http://nasm.sf.net/): nasm -o cdrom.com cdrom.asm
; Usage syntax examples:
; CDROM LOCK X:
; CDROM EJECT Y:
; ... you get it. Keywords: LOCK UNLOCK EJECT CLOSE RESET

; int 2f ax=150c bx=0 -> returns major version BH, minor BL.
; int 2f ax=1510 cx=driveletter (0 based) es:bx->request header
; int 2f ax=1500 bx=0 -> returns number of CD-ROM drive
;   letters in BX, first drive number in CX (0 based).
; int 2f ax=150d es:bx=pointer to array -> returns array of
;   drive numbers (0 based, 1 byte for each drive letter).
;   (CD-ROM 2.0+, older support pretty different ax=1501)
;
; Request header: byte length, byte subunit (filled in by *CDEX)
;   byte command (0x0c for IOCTL write), word returned status
;   (filled in by driver), 8 bytes reserved, byte 0xf8
;   (media descriptor, offset 0x0d), dword pointer to DATA
;   word size of DATA. DATA = 1 or 2 bytes (function, option)
;
; IOCTL: 0 = eject 5 = close 2 = reset 1.0 = unlock 1.1 = lock.

	org 0x100	; it is a com file

; -----------------------------

start:  mov al,0x0d	; a 0x0d byte: 4DOS fails to terminate
	cld		; the command line string if > 126 char
	mov al,-1
	mov di,drives	; the "possible drive letter list"
	mov cx,32
	rep stosb	; zap the list (init BSS)

	mov si,0x81	; command line arguments
cparse:	mov al,[si]	; get a char
	cmp al,0x0d	; end of line? then we are done.
	jz cdone
	cmp al,':'	; after a drive letter? then read it.
	jz knodrv
uknown: and al,0xdf	; a-z -> A-Z
	mov [si],al	; store upcased version
known:	inc si		; continue parsing
	jmp short cparse

knodrv:	mov al,[si-1]
	and al,0xdf	; a-z -> A-Z
	sub al,'A'	; A: -> 0 etc.
	cmp al,26	; drive number in 0..25 range?
	jae uknown	; else ignore
	mov [seldrv],al	; store selected drive number!
	jmp short known

cdone:	mov al,[ds:seldrv]	; which drive selected?
	cmp al,-1	; if none at all, complain
	jnz gowork	; else continue processing
	mov dx,helpmsg
	jmp short failed

; -----------------------------

failed:	mov ah,9	; show string
	int 0x21	; DOS API
	mov ax,0x4c01	; return with errorlevel 1
	int 0x21	; DOS API

; -----------------------------

gowork:	mov ax,0x1500	; CD-ROM install check
	mov bx,0	; if no driver at all
	int 0x2f	; multiplex interrupt
	mov dx,nocdrom	; error message: no drives!
	mov [mindrv],cl	; store first CD-ROM drive number
	mov [ndrives],bl	; number of drives
	or bx,bx	; any drives at all?
	jz failed

anycd:	mov ax,0x150c	; CD-ROM version check
	mov bx,0	; if no 2.0+ version
	int 0x2f	; MUX
	cmp bh,2
	jae newcd

oldcd:	mov al,[ds:ndrives]
	dec al
	add [cdx1end],al	; last is X after first
	mov al,[ds:mindrv]
	add [cdx1beg],al	; first is X after A:
	add [cdx1end],al	; last is X+... after A:
	mov dx,cdx1msg	; warning: old *CDEX version
	mov ah,9
	int 0x21	; DOS API
	or byte [ndrives],0x80	; flag for "old *CDEX"
	jmp short old2

newcd:  mov ax,0x150d	; get array of drive letters
	mov bx,drives	; destination array (in ES)
	int 0x2f	; MUX

old2:	mov al,[ds:seldrv]	; drive to be IOCTLed
	cmp al,[ds:mindrv]	; first valid drive
	jb invdrv	; invalid drive selected
	xor cx,cx
	mov cl,[ds:ndrives]	; drive letter count
	or cl,cl	; any drives?
	jz exdrv	; if not, no drives to be checked.
	js exdrv1	; flag set, *CDEX < 2.0, no check
	mov bx,drives	; drive letter array
chkdrv:	cmp al,[bx]
	jz exdrv
	inc bx
	loop chkdrv	; repeat until found

invdrv:	mov al,[ds:seldrv]	; the user-selected drive letter
	add [nocddrv],al	; add it to the error message
	mov dx,nocddrv	; error message: no CD-ROM letter
	mov ah,9	; NEW: show list of existing drives!
	int 0x21	; DOS API
	mov bx,drives	; drive letter array
	xor cx,cx
	mov cl,[ds:ndrives]
shdrv:	mov al,[bx]
	cmp al,25	; in A..Z range?
	ja shdrv2	; else do not display
	mov ah,2	; write char to STDOUT (CON)
	mov dl,'A'	; the char to be written
	add dl,al	; translate drive number to char
	int 0x21	; DOS API
	mov ah,9	; string output
	mov dx,colon	; add ": "
	int 0x21	; DOS API
shdrv2:	inc bx		; next list entry
	loop shdrv	; loop over array
	mov dx,nocdONE	; message end for "1" case
	mov al,[ds:ndrives]
	cmp al,1
	jz shdrv3
	mov dx,nocdN	; message end for ">1" case
shdrv3:	jmp failed	; leave with message and errorlevel 1

; -----------------------------

exdrv1:
exdrv:			; parse: which command is requested?
	mov si,cmds	; command list
wordlp:	mov bx,[si]	; pointer to the command name
	or bx,bx	; end of list?
	jz done		; no command requested at all (okay!)
	mov cx,[bx]	; first 2 chars of the name
	mov di,0x81	; command line
wordl2:	mov ax,[di]	; is it THERE ?
	cmp ax,cx
	jz dothat
	cmp al,0x0d	; end of line?
	jz wordl3	; then try again with next command
	inc di		; parse on
	jmp short wordl2

wordl3:	add si,4	; next command table entry
	jmp short wordlp	; search that one next

; -----------------------------

dothat:	add si,2	; -> command FUNCTION pointer
	mov si,[si]	; fetch that pointer
	mov ah,9	; string output
	mov dx,cmdmsg	; confirmation message
	int 0x21	; DOS API
	mov dx,bx	; command name
	mov ah,9	; string output
	int 0x21	; DOS API
	mov dx,crlfmsg	; line break
	mov ah,9	; string output
	int 0x21	; DOS API

	mov ax,ds	; segment of IOCTL data
	mov [datS],ax	; fill in in reqest header

	call si		; *** call that FUNCTION ***

	jnc done	; everything okay?
	mov dx,failmsg	; error message: function failed
	jmp failed

done:	mov ah,9	; string output
	mov dx,donemsg	; message: done
	int 0x21	; DOS API
	mov ax,0x4c00	; return errorlevel 0
	int 0x21	; DOS API

; -----------------------------

ejectC:	mov ax,0	; 0: eject
	jmp short xIOCTL

closeC:	mov ax,5	; 5: close tray
	jmp short xIOCTL

lockC:	mov byte [dsize],2	; command plus argument
	mov ax,0x0101	; 1.1: lock CD-ROM in drive
	jmp short xIOCTL
	
ulockC:	mov byte [dsize],2	; command plus argument
	mov ax,0x0001	; 1.0 (sic!): unlock CD-ROM in drive
	jmp short xIOCTL

resetC:	mov ax,2	; 2: reset
	jmp short xIOCTL

; -----------------------------

	; do CD-ROM IOCTL command AL and return to caller

xIOCTL:	mov [thedata],ax	; command AL, argument AH

IOCTL: 	mov ax,0x1510	; CD-ROM device call through *CDEX
	xor cx,cx
	mov cl,[ds:seldrv]	; selected drive (0 = A:...)
	mov bx,rheader	; request header (in segment ES)
	int 0x2f	; MUX
	jc cdxerr	; any *CDEX error?
	mov ax,[ds:rstatus]	; status of the request
	test ax,0x8000	; error? (... 0x0200 busy 0x0100 okay)
	jz cdxok	; else we are done
	nop		; *** error code is in AL, insert int3
			; *** here if you want to debug things
	mov dx,cdderr	; CD-ROM sys driver returned an error
	jmp short cdxe2

cdxok:	clc		; return without error
	ret

cdxerr: mov dx,cdxerri	; error message: no IOCTL possible
	cmp al,1	; invalid function?
	jz cdxe2
	mov dx,cdxerrd	; error message: no such CD-ROM drive
	cmp al,0x0f	; invalid drive?
	jz cdxe2
	mov dx,cdxerrx	; error message: unknown error
cdxe2:	mov ah,9	; string output
	int 0x21	; DOS API
	stc		; return with error
	ret

; -----------------------------

rheader	db 20	; length
	db 0	; subunit, filled in by *CDEX
	db 0x0c	; command: IOCTL write
rstatus	dw 0	; status, filled in by CD-ROM sys driver
	dd 0,0	; (reserved)
	db 0xf8	; media descriptor
	dw thedata	; pointer to IOCTL data, offset
datS	dw 0	; pointer to IOCTL data, segment
dsize	dw 1	; size of IOCTL data (normally 1 for us)

	; RBIL calls the next structure "C?-ROM control block"
thedata	db 0	; the command
	db 0	; the argument (lock/unlock only)

; -----------------------------

seldrv	db -1		; drive selected by the user

mindrv	db 0		; first CD-ROM drive number
ndrives	db 0		; number of CD-ROM drives

; -----------------------------

helpmsg	db 13,10,"Usage: CDROM [EJECT|CLOSE|LOCK|UNLOCK|RESET] X:"
	db 13,10,"Example: CDROM EJECT N:",13,10
	db 13,10,"Ask *CDEX 2.0+ if a CD-ROM exists: CDROM N:",13,10
	db 13,10,"Errorlevels: 0 okay, 1 failed / no such drive."
	db 13,10,"Not all drives do all commands.",13,10,"$"

cdxerrx	db "Unknown *CDEX error.",13,10,"$"
cdxerrd	db "CD-ROM drive not known to *CDEX.",13,10,"$"
cdxerri db "Drive IOCTL not supported!?",13,10,"$"
cdderr	db "CD-ROM sys driver reports failure.",13,10,"$"

; -----------------------------

	; command table: pointers to strings and functions
	; "unlock" is before "lock", as both contain "lock"!
cmds	dw ejectW,  ejectC,  closeW,  closeC,  ulockW,  ulockC,
	dw lockW,   lockC,   resetW,  resetC,  0,      0

	; command names: only first 2 chars are checked now ;-)
ejectW	db "EJECT$"	; EJ
closeW	db "CLOSE$"	; CL
ulockW	db "UNLOCK$"	; UN
lockW	db "LOCK$"	; LO <-
resetW	db "RESET$"	; RE

; -----------------------------

donemsg	db "Done.",13,10,"$"
failmsg	db "Failed.",13,10,"$"
cmdmsg	db "Command: $"

cdx1msg	db "Using old *CDEX 1.x: CD-ROM range is "
cdx1beg	db "A: - "
cdx1end	db "A: !?"	; continued in crlfmsg to save space!
crlfmsg	db 13,10,"$"

nocddrv db "A: is no CD-ROM drive, but < $"
colon	db ": $"
nocdONE	db "> is.$",13,10,"$"
nocdN	db "> are.$",13,10,"$"

nocdrom	db "No *CDEX (SHSUCDX...) found, no CD-ROM access."
	db 13,10,"$"

drives	db -1		; array with drive numbers
	;         times 32 db -1	; now in BSS, done at runtime
