; Wrapper to modify the keyboard buffer on the fly,
; warping qwerty to qwertz - 30.11.2001 by EA.

; %define CLICK 1
; for a beep for every non-dead key

        org  0  ; SYS file

next    dw -1,-1
attrib  dw 1000000000000100b    ; very nully NUL device
stra    dw strat	; *offset* prepare, store ES:BX (far call)
inr     dw intr  	; *offset* do the real work (far call)
nam     db 'EAKBDGR$'   ; driver name will become a special filename,
			; so better not use a too normal name...
pb      dd 12345678h
oldi9	dd 12345678h	; old int 9h vector
used    db 0		; if 1, init done

strat:  mov word [cs:pb+2],es
        mov word [cs:pb],bx	; we could copy the contents of the
        RETF			; referenced data structure here, too

intr:   pushf
	push ax
        push bx
        push es
        les bx,[cs:pb]
        mov byte [es:bx+17h],0		; no error
        and word [es:bx+3],7FFDh	; not busy / no error
        or word [es:bx+3],1		; ack state
        cmp byte [es:bx+2],0		; INIT ?
	jnz nix
	cmp byte [cs:used],0		; already done?
	jnz nix
        jmp inst
nix:    pop es
        pop bx
	pop ax
        popf
        RETF

I9:	push es
	push ax
	push di

	mov ax,40h	; BIOS DATA
	mov es,ax
	mov di,[es:1ch]	; next char will be stored here
	mov al,[es:96h]	; 76543210 flags, e.g. 3=altgr 1=e0 (numpad)
	mov ah,[es:17h]	; shifts... e.g. x1xxxx11 do shift

useold:	pushf
	call far [cs:oldi9]	; call real int 9
	push bx
	push si

	cmp di,[es:1ch]		; any char at all?
	jnz anychr
	jmp idone		; else ignore

anychr:	

%ifdef CLICK
	push ax
	push bx
	mov ax,0e07h
	mov bx,7
	int 10h
	pop bx
	pop ax
%endif

	mov bx,[es:di]		; LO: ascii  HI: scan

	cmp bx,1519h		; US ^Y (right of T), German ^Z
	jnz noty
ctrly:	mov ax,2c1ah		; translate to "US" ^Z (qwertz key Z)
	jmp allnew
noty:	cmp bx,2c1ah		; US ^Z (left of X), German ^Y
	jnz notz
	mov ax,1519h		; translate to "US" ^Y (qwertz key Y)
	jmp allnew

notz:	test al,8		; AltGr ?
	jz noaltgr

; *	cmp bl,0		; scan only?
; *	jnz noaltgr
; *     <- this would guarantee to leave already handled altgr as is,
; *     <- but would also make the AltGr key ignored for keys that
; *     <- ignore the AltGr key now. Doh.

altgr1:	
	and byte [es:17h], 0f7h	; NEW 12/2002: AltGr is NO Alt !

	cmp bh,78h
	jb naltgr1		; 78h... = AltGr+1 etc!
	cmp bh,82h
	ja naltgr1		; only 1..0 checked

altgr2:	mov ah,bh		; scan code
	sub ah,78h-2		; correct scan code
	mov bl,bh		; scan code bx
	mov bh,0
	sub bl,78h		; map 78h... to 0...
alt2c:	mov al,[cs:altgrnum+bx]	; xlat
	cmp al,0		; if none found, ignore
	jz idone
	jmp short allnew	; replace scan code and ascii
	
alt2b:	mov ah,bh		; scan code was ok
	sub bh,2		; map 2... to 0...
	mov bl,bh
	mov bh,0		; index in bx
	jmp short alt2c		; altgrnum translation
	

naltgr1:
	cmp bh,0eh		; real scancodes for num area?
	jbe alt2b			; AltGr+A..Z in this case
	mov ah,bh		; scan code
	mov bx,altgrchr-2

repl:	inc bx
	inc bx
	cmp byte [cs:bx],0	; end?
	jz idone
	cmp ah,[cs:bx]		; found?
	jnz repl
	mov al,[cs:bx+1]	; German ASCII for this scan code
	jmp ascnew		; replace ASCII

noaltgr:			; BX is still buffer content,
	test ah,43h		; AH the shift status (BH scan BL asc)
	mov ah,bh		; scan for repl later
	jnz shifted

notshifted:
	mov bx,lowchr-2
	jmp repl		; replace by list: unshifted

idone:	pop si
	pop bx
	pop di
	pop ax
	pop es
	IRET

shifted:
	cmp bh,0eh		; top row?
	ja listshift
	mov bl,bh
	mov bh,0
	mov al,[cs:numshift+bx]	; translate
	jmp ascnew		; replace ascii
listshift:
	mov bx,shiftchr-2
	jmp repl		; replace by list: shifted


allnew:	mov [es:di],ax		; overwrite keyboard buffer
	jmp short idone
ascnew: mov [es:di],al		; overwrite, only ASCII part
	jmp short idone

	; the num keys are handled as a group for AltGr and Shift
	; and left as is for unShift. All other replacements are
	; done using 3 lists for AltGr, Shift and unShift.

altgrnum	db '~','','','','\','|','{','[',']','}','\'
		;  1x  2   3   4x  5x  6x  7   8   9   0    (4,$,Eur)

altgrchr	db 10h,'@',12h,'',17h,'',18h,'',1eh,'',26h,''
		;  q       ex      ix      ox      ax      lx
		db 1fh,'',21h,'',2eh,'',31h,'',32h,'',56h,'|'
		;  sx      fx      cx      nx      m       \|
		db 2bh,'\',0,0
		;  \|

numshift	db 0,27,'!"','','$%&/()=?`~'
		; Shift-Backspace -> ~, cent instead of paragraph...

shiftchr	db 15h,'Z',1ah,'',1bh,'*',27h,'',28h,'',29h,''
		;  Y       {       }       :       "       ~
		db 2bh,'|',2ch,'Y',33h,';',34h,':',35h,'_',56h,'>',0,0
		;  |       Z       <       >       ?       \|

lowchr		db 15h,'z',1ah,'',1bh,'+',27h,'',28h,'',29h,'^'
		;  y       [       ]       ;       ''      `
		db 2bh,'#',2ch,'y',35h,'-',0ch,'',0dh,27h,56h,'<',0,0
		;  \       z       /       -       =  ('') \|
		; 33h and 34h stay ',' and '.'

	; also nice: alpha, beta, `+vowel, upcase acc.,
	; infty, element, ca., sqrt, le/ge, omega, gamma,
	; delta, pi, equiv, +-, >>, <<, inv!, inv?, half,
	; quarter, ptas, cent, ae, yen, block/line gfx, etc...

	; e0 prefix: e02f is num /, but 352f is US / and 352d is GR -,
	; so WE do not need to store the prefix... the BIOS does it.
	; We only need to translate 35xx, the BIOS already made e02f
	; from the e0 variant of 352f.

	; Compose: We do not care for accent/vowel compose here.

	; AltGr: 0..9 A..Z and ;[' give scan/ascii00, others are dead.
	; AltGr 0..9 give special scan: 1->scan 78h etc!

oldjmp:	jmp far [cs:oldi9]	; do nothing...


align 4
ente    db 'Int 9 keyboard warper by EA',0

inst:   cli				; because we hook ints
        mov word [es:bx+10h],cs
        mov word [es:bx+0Eh],ente	; *offset* first free byte
	mov byte [cs:used],1		; inst to be done only once

        xor bx,bx
        mov es,bx
	mov bx,[es:36]		; make a backup of the int 9 vector
	mov [cs:oldi9],bx
	mov bx,[es:38]
	mov [cs:oldi9+2],bx
        mov word [es:36],I9	; *offset*	; hook INT 9
        mov word [es:38],cs
        sti

	jmp nix

