; LBAcache - a hard disk cache based on XMS, 386 only,
; and aware of the 64bit LBA BIOS Int 13 Extensions.
; GPL 2 software by Eric Auer <eric@coli.uni-sb.de> 2001-2002

; CHS-only version has been discontinued in 2002.



; %define DBGbinsel 1	; debug binsel!

	; status table handling functions
	; DUMB BUT FAST experimental version:
	; bin is always equal sector number modulo sectors (or none)!

	; NEW 27.11.2001: shrink table by using one entry for more
	; than one sector! (2..16 - MS SmartDrv has the same range)
	; BUGFIX 24.01.2002: flush* were the wrong size!

	; *** NEW 09.11.2002: shrink factor changed from 4 to 8


%define BINSHR 3	; *** 8 sectors per bin
%define BINMASK 0xf8	; *** 8 sectors per bin -> NOT ((1<<BINSHR)-1)
%define BINBITS 7	; *** 8 sectors per bin -> (1<<BINSHR) - 1
%define BINTABFORM 0x0303	; *** encoding THIS table format:
	; ^- HI is log2(sectors/bin), LO is log2(bytes/bin)
	; *** values for 4 s/bin were 2,0xfc,3,0x0203 (*** was 0x202)
	; *** values for 8 s/bin are  3,0xf8,7,0x0303



	; Format is - per entry - D sector low, B drive, B LRU,
	; W bitfield: lsb for first sector in group

        ; Input is sector number EAX drive DL, output (xms) bin AX            
	; findbin:  finds a bin for a location (stc if not found),
	; newbin:   allocates a new bin for a given location,
	;           flushing old bins if needed.
	;           (main bin selection "intelligence" !)
	; flush:    empties all slots
	; flushone: empties all slots for drive DL only
	; telltabsize: (returns carry on error)
	;           tells in AX how big a table for AX sectors will be
	;           WARNING: sectors > fff0 will break other things!

%ifdef DBGbinsel
fndbin1msg	db '@?',0
fndbinmsg	db '@',0
newbin1msg	db '!?',0
newbinmsg	db '!',0
bitsetmsg	db '+',0
%endif

telltabsize:	; calculate size of the table for THIS format
	mov word [cs:tabsz],BINTABFORM	; encoding THIS table format:
;	cmp ax,8191	;   ^- HI: shr BINSHR, LO: add 8>>BINSHR
;	ja ttsx		; clipping: for BINSHR 0: 7500, else more
	movzx eax,ax	; *** NEW 24.01.2002
	add eax,BINBITS		; <- round up!
	shr eax,BINSHR		; <- ADJUST
	shl eax,3		; 8 bytes per table entry
	cmp eax,0xf000		; maximum allowed size (CY if more)
	cmc			; complement carry: "jb NC / jnb CY"
	ret

; -------------

hashme: 	; find si as pointer into [table], given
		; table length [sectors] entries, 8 (EIGHT) bytes
	push edx	; each, for sector number EAX and drive DL
	push eax
	push ecx
	;
	cmp dl,0x80	; compress bits of drive number a bit
	jb hshdsk
	and dl,0x7f
	add dl,4	; (ca. 4 floppies)
hshdsk:	movzx edx,dl	; derived from drive number
	shl edx,24	; move to some part of those 32bits *** was 9
	xor eax,edx	; XOR in drive into the sector number
	;
	shr eax,BINSHR	; all entries of one main entry hash same!
	movzx ecx,word [cs:sectors]	; usually 512*N,
	shr ecx,BINSHR	; <- ADJUST!
	xor edx,edx	; N in 1,2,4,6,8,10,12,14,16,18 (>100 thus)
	dec ecx		; ... has more interesting prime factors(*)
	div ecx		; MODULO sectors as "HASH" (edx is remainder)
	;
			;  ... use remainder as index ...
	lea edx,[table+edx*8]	; 8by (EIGHT) per MAIN entry
			; still 8 byte per main entry, but 1<<BINSHR
			; sub entries now share one main entry!
	mov si,dx	; pointer to MAIN entry
	;
	pop ecx
	pop eax
	pop edx		; (*) note: 1 bin left unused, we may as well
	ret		; do a sectors-- on install...

; -------------

; macro BINBCHECK ARG does (all registers preserved):
; ARG [ds:si+6],bit 1 shl (al and BINBITS)
; where ARG can for example be OR or TEST

%imacro BINBCHECK 1	; takes the command as arg, works on bitfield
	push ax		; Byte SI+6, Bit AL
	push cx
	and al,BINBITS	; <- ADJUST
	mov cl,al
	mov ax,1
	shl ax,cl	; select the bit in the bitmask
	%1 [ds:si+6],ax	; or: fill bin
			; test: return NZ if bin is filled
	pop cx
	pop ax
%endmacro

; **************************************************************

%include "binsel2.asm"	; the main cleverness functions:

	; findbin EAX.DL (sector, drive) returns CARRY (not found)
	; or the sub-bin (in AX) that contains the sector.
	; can as side-effect update some statistics embedded in
	; the table.

	; newbin EAX.DL allocates a new bin for the sector and
	; marks the appropriate sub-bin as used. All other sub-bins
	; are discarded from the affected main bin IF the main bin
	; does not share the needed EAX.DL range!

	; can use the table on position table directly, or use
	; hashme EAX.DL to have a suggested pointer SI calculated
	; which points into table. Can use sectors, which is the
	; number of sub-bins (shr BINSHR to get the main table
	; entry number - 8 byte per main table entry. and BINBITS
	; to know sub-bin number, or "and low byte, BINMASK" to
	; calculate EAX.DL of main bin from EAX.DL of sub-bin...

	; macro BINBCHECK ARG does (all registers preserved):
	; ARG [ds:si+6],bit 1 shl (al and BINBITS)
	; where ARG can for example be OR or TEST

; **************************************************************

; -------------

flushone:	; flushing only one drive (DL)
	push ds	; mark all table entries for that
	push di	; drive as empty, using THIS table format
	push cx
	push eax
	mov cx,cs
	mov ds,cx
	mov cx,[ds:sectors]
	add cx,BINBITS	; <- ADJUST: round up
	shr cx,BINSHR	; <- ADJUST: sub entries -> main entries
	mov di,table
	xor eax,eax
flolp:	cmp [di+4],dl
	jnz flon	; do not flush other drives
	dec eax
	mov [di],eax	; sector -1
	inc eax
	mov [di+4],eax	; drive/LRU/bits 0
flon:	add di,8
	loop flolp
	pop eax
	pop cx
	pop di
	pop ds
	ret

; -------------

flush:	push ds ; flushing/initializing the whole table
	push di	; marks every table entry as empty
		; using THIS table format now!
	push cx
	push eax
	mov cx,cs
	mov ds,cx
	mov cx,[ds:sectors]
	add cx,BINBITS	; <- ADJUST: round up
	shr cx,BINSHR	; <- ADJUST: sub entries -> main entries
	mov di,table
	xor eax,eax
flloop:	dec eax
	mov [ds:di],eax	; sector -1
	add di,4
	inc eax
	mov [ds:di],eax	; drive 0, LRU 0 (unused), bits 0
	add di,4
	loop flloop
	pop eax
	pop cx
	pop di
	pop ds
	ret

