; assemble with: nasm locktone.asm -o locktone.com

; A locktones clone by Eric Auer eric@coli.uni-sb.de
; The original locktones works for Linux and Dos,
; but always in 32bit mode (DPMI for Dos), so I
; wrote this to preserve memory in Dos...

; Function: Run it ONCE. Then changing your caps, num,
; scroll and ins lock state will cause beeping. Nice
; to know ones lock states without looking at the LEDs.
; Of course, rebooting will unload this tool :-).

; The original locktones 0.5 can be found at
; http://www.mielke.cc/ and features lots of
; command line options: Poll frequency and
; tone duration, frequency for each of the four
; shifts, and two modes (beep on changes versus
; beep all the time while the shift is on).

; This clone may be CONFIGURED by changing the CODE
; only, it completely ignores command line options,
; there is not even an uninstall function.

; Please use nasm to assemble - http://nasm.2y.net/
; nasm is free open source:
; http://www.gnu.org/licenses/licenses.html#LGPL

; This is distributed unter the GPL license,
; http://www.gnu.org/licenses/licenses.html#GPL
; which means it is also free open source.
; Copyright by Eric Auer.


        org  100h

entry:
	mov dx,thelastbyte	; message offset
	mov ax,cs		; message segment
	mov ds,ax
	mov ax,0x0900	; string$ output
	int 0x21	; say hello

        mov ax,0x351c	; remember timer int
        int 0x21
        mov [seg1c],es
        mov [ofs1c],bx

        mov dx,int1c	; the handler offset
	mov ax,cs	; the handler segment
	mov ds,ax	
        mov ax,0x251c	; hook int
        int 0x21

        in al,0x61
        mov [spkstat],al

        mov dx,thelastbyte+15
	mov cl,4
	shr dx,cl

        mov ax,0x31ea	; go TSR
        int 21h

ofs1c	dw 0	; offset of old handler
seg1c	dw 0	; segment of old handler

spkstat	db 0	; speaker status on startup
enable	db 1	; 0 to turn the handler off
		; just out spkstat to port 0x61 to
		; turn the speaker off...

; shift state looks like this (here and [0x40:0x17]):
; msb-> ins caps num scroll x x x x <- lsb
oldshifts	db 0
newshifts	db 0

; those values are in tick units (18.2 per second)
onduration	db 2 ; set to 0 for eternal
offduration	db 2 ; set to 0 to have the
		; "no tone while off" mode

countdown	db 0 ; ticks to tone stop

; note that we cannot process multiple
; changes which occur simultaneously...
; for each state we have and "on" and an "off"
; frequency. Order: scr num caps  ins
ontones		dw 880, 622, 311, 440
offtones	dw 220, 155,  78, 110

;------------------

int1c:	test byte [cs:enable],1
	jnz active
        jmp chain		; whole thing enabled?

active:	push ax
	push bx
	push ds

	mov al,[cs:countdown]
	or al,al		; no countdown running
	jz checkshifts
	dec al
	mov [cs:countdown],al
	or al,al
	jnz checkshifts		; countdown still busy
	call mute		; countdown elapsed

checkshifts:
	mov ax,0x40
	mov ds,ax		; bios data segment
	mov al,[ds:0x17]	; shift state
	mov bx,cs
	mov ds,bx
	mov [ds:newshifts],al	; remember this
	mov ah,al
	mov al,[ds:oldshifts]	; compare
	and ax,0xf0f0		; only the locks
	xor al,ah		; diff it
	or al,al
	jz sameshifts		; nothing new
	and ah,al		; change-to-on in ah
	xor ah,0xf0
	and al,ah		; change-to-off in al
	xor ah,0xf0
	shr ah,1
	shr ah,1
	shr ah,1
	shr ah,1
	or al,ah		; AL: low: to off hi: to on
	
	mov bx,ontones		; first freq
search:
	test al,1
	jnz match		; only first match for now
	shr al,1
	inc bx			; next freq
	inc bx
	or al,al
	jnz search		; search on
	jmp short sameshifts	; no more matches

match:	mov al,[ds:onduration]	; assume change to on
	cmp bx,offtones
	jb ontime
	mov al,[ds:offduration]	; change to off

	or al,al
	jnz ontime		; else "no tone for off"
	call mute
	mov [ds:countdown],al
	jmp short sameshifts	; no beeping

ontime:	mov [ds:countdown],al	; start timing
	mov bx,[ds:bx]		; load frequency
	call sound		; calc divisor
	call sound2		; play sound

sameshifts:
	mov al,[ds:newshifts]	; remember this
	mov [ds:oldshifts],al

	pop ds
	pop bx
	pop ax

chain:	jmp far [cs:ofs1c]	; old handler

;------------------

mute:   push ax
	in al,0x61	; speaker state
	xchg al,ah
        in al,0x80	; wait
	xchg al,ah
        and al,0fch	; off
        out 0x61,al	; write back
	pop ax
        ret

sound:	push ax	; make divisor BX from freq BX
	push dx
	mov dx,18	; high part of 1192755
	mov ax,13107	; low part of that one
			; timer chip clock (4.77 Mhz/4)
	cmp bx,30
	jb soundrange	; "mute" if out of range
	cmp bx,20000
	ja soundrange
	div bx		; div dxax (32bit) by cx
	mov bx,ax	; remainder is dx, value is ax
soundgood:	
	pop dx
	pop ax
	ret
soundrange:
	mov bx,60	; gives 20kHz ("mute")
	jmp short soundgood

sound2: push ax
	mov al,0xb6	; needs the divisor for 1.193 MHz
        out 0x43,al	; not the freq, in BX
        in al,0x80	; wait
        mov al,bl	; (b6 was: select that timer)
        out 0x42,al	; low part
	in al,0x80	; wait
        mov al,bh
        out 0x42,al	; high part
        in al,0x61	; speaker state
	xchg al,ah
	in al,0x80	; wait
	xchg al,ah
        or al,03h	; speaker on, timer on
        out 0x61,al	; submit this
	pop ax
	ret

thelastbyte	db "LockTones clone by Eric Auer "
		db "eric@coli.uni-sb.de June 2002"
		db 13,10,"$"

