; Free tiny LockTones clone by Eric Auer eric*coli.uni-sb.de
; --> Assemble with: nasm locktone.asm -o locktone.com
; Nasm, "Netwide Assembler" is a free open source assembler.

; The original LockTones 0.5 is from http://www.mielke.cc/ and
; features lots of command line options: See todo list below.
; The original LockTones is available for Linux and for DOS,
; but the DOS port requires 32bit DPMI and is quite large.


; LOCKTONE usage: Run it! Then changing your caps, num, scroll
; and ins lock state will cause beeps. Each of the 4+4 possible
; changes has another beep frequency. Useful because it lets
; you know ones lock states without looking at the LED lights.

; This clone, LOCKTONE, can only be configured by changing the
; source code and recompiling it. No command line options yet!
; To unload LOCKTONE, simply reboot your DOS. Sorry ;-).

; LOCKTONE is distributed unter the GPL license - It is free
; open source software. Check http://www.gnu.org/ for details.
; Copyright 2002, 2007 by Eric Auer. The 2007 version has a
; reduced (592+env to 432+0 bytes) resident memory footprint.


; TODO: Support unload, enable, disable of the resident LOCKTONE?
;
; TODO: Implement the LockTones command line options as follows:
; -t ontime 2 offtime 2 "beep when caps lock changes" --toggle
; -a ontime 0 offtime 0 "beep while caps lock is on" --active
; -d N ontime N offtime N "set beep on change duration" --duration
;
; -c N --caps N -i N --insert N -n N --num N -s N --scroll N set a
;   frequency for the corresponding beep type (the on one, then calc
;   the off one from it?) LockTones defaults: 300, 450, 600, 1200 Hz
; Less useful: -p N "reduce polling frequency to 10/N Hertz" --poll


        org  100h

entry:	jmp loader

	; we simulate a "BSS" by our writing variables to
	; the (unused by us) PSP command line buffer :-)

%define mute_r 0x90	; we even relocate this tiny call
	; Important: mute must not be > 0x1c bytes long!
%define sound2_r 0xb0	; we even relocate this tiny call
	; Important: sound2_r must not be > 0x40 bytes long!

%define ontones 0xe0	; 4 dw: divisors for "change to on"
	; set to converted frequencies from ontones_init at init
%define offtones 0xe8	; 4 dw: divisors for "change to off"
	; set to converted frequencies from offtones_init at init

	; those values are in tick units (18.2 per second)
%define ontime 0xf0	; db 2 ; use 0 for eternal
%define offtime 0xf1	; db 2 ; 0 for "no tone while off" mode
%define countdown 0xf2	; db 0 ; ticks to tone end, 0 for "n/a"

%define jump1c 0xf3	; db 0xea ; opcode for "jump far"
%define ofs1c 0xf4	; dw: offset of old handler
%define seg1c 0xf6	; dw: segment of old handler

	; shift state looks like this (here and [0x40:0x17]):
	; msb-> ins caps num scroll x x x x <- lsb
%define oldshifts 0xf8	; db reference shift values, "baseline"
%define newshifts 0xf9	; db shift values encountered by handler

%define enable 0xfa	; db: 0 to turn the -handler- off, 1 on
	; you can "out 0x61,[spkstat]" to turn the -speaker- off
%define spkstat 0xfb	; db: speaker status on startup


;------------------

int1c:	test byte [cs:enable],1	; int 1c handler starts here
	jnz active
        jmp chain		; whole thing enabled?

active:	push ax
	push bx
	push ds

	mov al,[cs:countdown]
	or al,al		; no countdown running
	jz checkshifts
	dec al
	mov [cs:countdown],al
	or al,al
	jnz checkshifts		; countdown still busy
	call mute_r		; countdown elapsed

checkshifts:
	mov ax,0x40
	mov ds,ax		; bios data segment
	mov al,[ds:0x17]	; shift state
	mov bx,cs
	mov ds,bx
	mov [ds:newshifts],al	; remember this
	mov ah,al
	mov al,[ds:oldshifts]	; compare
	and ax,0xf0f0		; only the locks
	xor al,ah		; diff it
	or al,al
	jz sameshifts		; nothing new
	and ah,al		; change-to-on in ah
	xor ah,0xf0
	and al,ah		; change-to-off in al
	xor ah,0xf0
	shr ah,1
	shr ah,1
	shr ah,1
	shr ah,1
	or al,ah		; AL: low: to off hi: to on
	
	mov bx,ontones		; first freq
search:
	test al,1
	jnz match		; only first match for now
	shr al,1
	inc bx			; next freq
	inc bx
	or al,al
	jnz search		; search on
	jmp short sameshifts	; no more matches

match:	mov al,[ds:ontime]	; assume change to on
	cmp bx,offtones
	jb beep
	mov al,[ds:offtime]	; change to off

	or al,al
	jnz beep		; else "no tone for off"
	call mute_r
	mov [ds:countdown],al
	jmp short sameshifts	; no beeping

beep:	mov [ds:countdown],al	; start timing
	; mov bx,[ds:bx]	; load frequency
	; call sound		; calc divisor
	mov bx,[ds:bx]		; load divisor :-)
	call sound2_r		; play sound

sameshifts:			; reset all other changes
	mov al,[ds:newshifts]	; remember this
	mov [ds:oldshifts],al

	pop ds
	pop bx
	pop ax

chain:	; jmp far [cs:ofs1c]	; old handler
	jmp jump1c		; offset!

;------------------

	; everything after this point does not stay in RAM

thelastbyte	db "Free 'LockTones' clone by Eric Auer "
		db "eric@coli.uni-sb.de June 2002, 2007"
		db 13,10,"$"

	; Note that we cannot process multiple shift
	; changes which occur simultaneously - we only
	; play the tone for the first detected change.

	; For each state we have and "on" and an "off"
	; frequency. Order: scr num caps  ins

ontones_init	dw 880, 622, 311, 440	; freq for "turns on"
offtones_init	dw 220, 155,  78, 110	; frew for "turns off"

;------------------

	; calls which are relocated to unused PSP areas:
	; must not use any relative references to elsewhere
	; --> no calls, no jumps, no similar stuff here!

mute:   push ax		; stop any ongoing speaker beep
	in al,0x61	; speaker state
	xchg al,ah
        in al,0x80	; wait
	xchg al,ah
        and al,0fch	; off
        out 0x61,al	; write back
	pop ax
        ret
mute_end:	nop

sound2: push ax		; start a speaker beep with divisor BX
	mov al,0xb6	;   This needs the -divisor- for 1.193 MHz,
        out 0x43,al	;   not the -frequency-, in BX as input...!
        in al,0x80	; wait
        mov al,bl	; (b6 was: select that timer)
        out 0x42,al	; low part
	in al,0x80	; wait
        mov al,bh
        out 0x42,al	; high part
        in al,0x61	; speaker state
	xchg al,ah
	in al,0x80	; wait
	xchg al,ah
        or al,03h	; speaker on, timer on
        out 0x61,al	; submit this
	pop ax
	ret
sound2_end:	nop

;------------------

sound:	push ax	; make divisor BX from freq BX
	push dx
	mov dx,18	; high part of 1192755
	mov ax,13107	; low part of that one
			; timer chip clock (4.77 Mhz/4)
	cmp bx,30	; lowest supported freq
	jb soundrange	; "mute" if out of range
	cmp bx,20000	; highest supported freq
	ja soundrange
	div bx		; div dxax (32bit) by cx
	mov bx,ax	; remainder is dx, value is ax
soundgood:	
	pop dx
	pop ax
	ret
soundrange:
	mov bx,60	; gives 20kHz ("mute")
	jmp short soundgood

;------------------

loader:	; mov ax,cs		; message segment
	; mov ds,ax
; say_hello:
	mov dx,thelastbyte	; message offset
	mov ah,9	; string$ output
	int 0x21	; say hello

; free_env:
	push es
	mov es,[cs:2ch]	; environment segment
			; see Ralf Browns IntList tables 1378-1379
	mov ah,0x49
	int 0x21	; free the environment! (saves some RAM)
	pop es		; (jc "could not free... bla bla")

; init_bss:
	push ds
	mov ax,0x40		; also sets ah to 0
	mov ds,ax		; bios data segment
	mov al,[ds:0x17]	; shift state
	pop ds
	mov [newshifts],al	; init (not really needed)
	mov [oldshifts],ah	; init to 0: we beep if <> newshifts
	mov al,2
	mov [ontime],al		; duration of "shift activated" beep
	mov [offtime],al	; duration "shift changed to off" beep
	mov [countdown],ah	; init to 0: no tone active right now
	mov al,1		; handler will start enabled
	mov [enable],al
        in al,0x61		; good for a future unload option:
        mov [spkstat],al	; remember speaker state at startup
	mov ax,0x0d00		; "length 0, CR"
	mov [0x80],ax		; disable command line arg buffer
	mov ah,0x24
	mov [0x82],ax		; just for fun: some "end of string"
	cld
	; Important: mute must not be too big!
	mov si,mute		; offset call
	mov di,mute_r		; offset relocated call
copy_mute:			; no check for overflow!
	movsb
	cmp si,mute_end		; offset where mute ends
	jnz copy_mute
	; Important: sound2 must not be too big!
	mov si,sound2		; offset call
	mov di,sound2_r		; offset relocated call
copy_sound2:			; no check for overflow!
	movsb
	cmp si,sound2_end
	jnz copy_sound2
	; Important: offtones_init must be right after ontones_init
	; Important: offtones must follow right after ontones
	mov si,ontones_init	; offset
	mov di,ontones		; offset
	mov cx,8		; conversion count
	cld
freq_to_div:
	lodsw			; load frequency
	mov bx,ax
	call sound		; convert frequency to divisor
	mov ax,bx
	stosw			; store divisor
	loop freq_to_div

; install_i1c:
	push es
        mov ax,0x351c	; get timer int vector
        int 0x21
        mov [seg1c],es	; remember old vector
        mov [ofs1c],bx	; remember old vector
	pop es
	mov al,0xea	; opcode for "jmp far"
	mov [jump1c],al	; store opcode

        mov dx,int1c	; the handler offset
	mov ax,cs	; the handler segment
	mov ds,ax	
        mov ax,0x251c	; hook int
        int 0x21

; stay_tsr:
        mov dx,thelastbyte+15	; offset: end of resident part
	mov cl,4
	shr dx,cl
        mov ax,0x3100	; go TSR
        int 21h

