/* Output from p2c, the Pascal-to-C translator */
/* From input file "rtf2html.pas" */

/* Original PASCAL and fixed C 7/01 by Eric Auer <eric@coli.uni-sb.de> */

/* EA compile with: */
/* EA -Wall -I/usr/include/p2c -o rtf2html2 rtf2html2.c /usr/lib/libp2c.a */

#include <p2c/p2c.h>

#define runerror(a) { fprintf(stderr,"Error %d\n",a); exit(a); }; /* by EA */

/* AuerSoft 3/99 */

#define stack_debug     false
#define assume_crlf     true
#define pop_debug       false


typedef struct st_node {
  Anyptr previous, next;
  Char unsigned data[101]; /* EA: unsigned */
  unsigned short flag;
} st_node;


Static st_node *sp, *sp2;
Static short sc;


Static Void init_st()
{
  sp = (st_node *)Malloc(sizeof(st_node));
  if (sp == NULL) {
    runerror(0xea);
  }
  sp->previous = NULL;
  sp->next = NULL;
  strcpy(sp->data, "TOS");
  sc = 0;
}


Static Void push()
{
  sp2 = (st_node *)Malloc(sizeof(st_node));
  if (sp2 == NULL) {
    runerror(0xea);
  }
  if (sp == NULL) {
    runerror(0xea);
  }
  sp->next = (Anyptr)sp2;
  sp2->previous = (Anyptr)sp;
  sp2->next = NULL;
  *sp2->data = '\0';
  sp = sp2;
  sc++;
  if (stack_debug)
    fprintf(stderr,"[Push%2d]", sc);
}


Static Void pop()
{
  if (sp == NULL || sp->previous == NULL) {
    runerror(0xea);
  }
  if (stack_debug)
    fprintf(stderr,"[Pop%3d]", sc);
  sc--;
  sp2 = (st_node *)sp->previous;
  sp2->next = NULL;
  Free(sp);
  sp = sp2;
}


Static Void enit_st()
{
  while (sp->previous != NULL)
    pop();
}


#define leave_tab       1
#define leave_tabl      2


/*--------------------------------------------------------------*/

/* EA: unused Static short x; */
Static FILE *inf;
Static FILE *outf;
Static unsigned Char ch; /* EA: unsigned */
Static boolean in_tab, in_box;
// Static unsigned Char inf_NAME[_FNSIZE]; /* EA: unsigned */
// Static unsigned Char outf_NAME[_FNSIZE]; /* EA: unsigned */


Static Void new_env()
{
  push();
  sp->flag = 0;
}


Static Void close_env()
{
  if (*sp->data != '\0') {
    fprintf(outf, "%s\n", sp->data);
    if (pop_debug)
      fprintf(stderr,"Popped: \"%s\"\n", sp->data);
  }
  /* if (sp^.flag and leave_tab)<>0 then
     begin in_tab:=false; writeln('Tabellenende gepoppt',#7); end; */
  pop();
}


Static Void keyword()
{
  unsigned Char wort[256]; /* EA: unsigned */
  unsigned Char ch2; /* EA: unsigned */
  short x, y;
  unsigned Char STR1[106]; /* EA: unsigned */

  *wort = '\0';
  fread(&ch2, 1, 1, inf);
  while (!P_eof(inf) && ch2 != '\n' && ch2 != '\015' && ch2 != '}' &&
	 ch2 != '{' && ch2 != ';' && ch2 != ' ' && ch2 != '\\' &&
	 (strlen(wort) != 1 || strcmp(wort, "-")))
  {   /* bed. Trennung */
    sprintf(wort + strlen(wort), "%c", ch2);
    fread(&ch2, 1, 1, inf);
  }
  if (P_eof(inf))
    fprintf(stderr,"******** EOF inside keyword ********\n");
  if ((uchar)ch2 < 32 && ((1L << ch2) & 0x2400) != 0)
    fread(&ch2, 1, 1, inf);
  if (ch2 == '{')
    new_env();
  if (ch2 == '}')
    close_env();
  if (ch2 == '\\')   /* wegen Kette */
    ch = '\\';
  else
    ch = ' ';
  if (!strcmp(wort, "-"))   /* wortlos ignorieren */
    *wort = '\0';

  if (!strcmp(wort, "*") || !strcmp(wort, "fonttbl")) {   /*skip macro!*/
    x = 1;
    while (x > 0 && !P_eof(inf)) {
      fread(&ch2, 1, 1, inf);
      if (ch2 == '{')
	x++;
      if (ch2 == '}')
	x--;
    }
    if (P_eof(inf))
      fprintf(stderr,"******** EOF inside macro(*)/fonttbl ********\n");
    close_env();
    if (!strcmp(wort, "*"))
      fprintf(stderr,"Macro skipped\n");
    else
      fprintf(stderr,"FontTbl skipped\n");
    *wort = '\0';
  }  /* skip macros (?) and FontTable */

  if (!strcmp(wort, "par")) {
    fprintf(outf, "<BR>\n");
    *wort = '\0';
    if (in_tab) {
      fprintf(outf, "</TD></TR></TABLE>\n");
      in_tab = false;
      fprintf(stderr,"PAR -> Tabellenende!\007\n");
    }
  }
  if (!strcmp(wort, "pard") && in_tab == false)
  {   /* in Tabellen Platz sparen */
    if (in_box) {
      fprintf(outf, "</FONT>\n");
      fprintf(stderr,"BOX closed\n");
      in_box = false;
    }
    fprintf(outf, "<BR>&nbsp;<BR>\n");   /* <HR> */
    *wort = '\0';
  }

  if (!strcmp(wort, "ldblquote") || !strcmp(wort, "rdblquote") ||
      !strcmp(wort, "rquote") || !strcmp(wort, "lquote")) {
    fprintf(outf, "&quot;");
    *wort = '\0';
  }
  if (wort[0] == '\'') {   /*'*/
    strdelete((Anyptr)wort, 1, 1);
    x = wort[0] - '0';
    if (x > 9)
      x -= 7;
    if (x > 16)
      x -= 32;
    y = wort[1] - '0';
    if (y > 9)
      y -= 7;
    if (y > 16)
      y = x - 32;
    sprintf(wort, "%d", x * 16 + y);
    fprintf(outf, "<FONT COLOR=red><B>*</B></FONT><!-- &#%s; -->", wort);
    *wort = '\0';   /*Sonderzeichen Hex*/
  }

  if (!strcmp(wort, "box")) {
    fprintf(outf, "<FONT COLOR=green>\n");
    fprintf(stderr,"BOX opened\n");
    in_box = true;
    *wort = '\0';
    /* sp^.data:='</FONT>'+sp^.data; */
  }

  if (!strcmp(wort, "trowd")) {
    if (in_tab)
      fprintf(outf, "</TD></TR><!-- trowd --><TR><TD>\n");
    else
      fprintf(outf, "<TABLE><TR><TD>\n");
    if (in_tab)
      fprintf(stderr,"Neues TRowD\n");
    else
      fprintf(stderr,"Tabellenanfang\007\n");
    *wort = '\0';
    in_tab = true;
  }
  if (!strcmp(wort, "cell")) {
    fprintf(outf, "</TD><TD>\n");
    *wort = '\0';
  }
  if (!strcmp(wort, "row")) {
    fprintf(outf, "</TD></TR><TR><TD>\n");
    fprintf(stderr,"Neue Tabellenzeile\n");
    *wort = '\0';
  }

  if (in_tab == false) {
    if (!strcmp(wort, "i")) {
      fprintf(outf, "<I>");
      sprintf(STR1, "</I>%s", sp->data);
      strcpy(sp->data, STR1);
      *wort = '\0';
    }
    if (!strcmp(wort, "b")) {
      fprintf(outf, "<B>");
      sprintf(STR1, "</B>%s", sp->data);
      strcpy(sp->data, STR1);
      *wort = '\0';
    }
    if (!strcmp(wort, "ul")) {
      fprintf(outf, "<U>");
      sprintf(STR1, "</U>%s", sp->data);
      strcpy(sp->data, STR1);
      *wort = '\0';
    }
    if (!strcmp(wort, "qj")) {
      fprintf(outf, "<P>\n");
      sprintf(STR1, "</P>%s", sp->data);
      strcpy(sp->data, STR1);
      *wort = '\0';
    }  /* justify */
    if (!strcmp(wort, "qc")) {
      fprintf(outf, "<P ALIGN=center>\n");
      sprintf(STR1, "</P>%s", sp->data);
      strcpy(sp->data, STR1);
      *wort = '\0';
    }  /* centered */
  }  /* das war jetzt bertrieben... */

  if (*wort != '\0')
    fprintf(stderr,"Ignored \"%s\"\n", wort);
}  /*keywort*/


/*--------------------------------------------------------------*/

int main(argc, argv) /* EA added int as return type */
int argc;
Char *argv[]; /* EA: has to stay signed */
{   /*main*/
  PASCAL_MAIN(argc, argv);
  outf = NULL;
  inf = NULL;
  init_st();
  in_tab = false;
  in_box = false;

inf = stdin; outf = stdout; /* EA: pipe this */

  fprintf(outf,"<!-- AuerSoft rtf2html 3/99 rtf -> htm (7/01 piped C) -->\n");

/* 
  strcpy(inf_NAME, "in.rtf");
  if (inf != NULL)
    inf = freopen(inf_NAME, "r+b", inf);
  else
    inf = fopen(inf_NAME, "r+b");
  if (inf == NULL)
    _EscIO(FileNotFound);
  strcpy(outf_NAME, "out.htm");
  if (outf != NULL)
    outf = freopen(outf_NAME, "w", outf);
  else
    outf = fopen(outf_NAME, "w");
  if (outf == NULL)
    _EscIO(FileNotFound);
*/

  fprintf(outf,
	  "<HTML><HEAD><TITLE>AuerSoft Rtf2Html Output</TITLE></HEAD>\n");
  fprintf(outf, "<BODY>\n");
  while (!P_eof(inf)) {
    fread(&ch, 1, 1, inf);
    switch (ch) {

    case 129: case 252:   /*252*/
      fprintf(outf, "&uuml;");
      break;
/* p2c: rtf2html.pas, line 107: Note: Character >= 128 encountered [281] */

    case 154: case 220:  /*220*/
      fprintf(outf, "&Uuml;");
      break;
/* p2c: rtf2html.pas, line 107: Note: Character >= 128 encountered [281] */

    case 247: case 246:   /*246*/
      fprintf(outf, "&ouml;");
      break;
/* p2c: rtf2html.pas, line 108: Note: Character >= 128 encountered [281] */

    case 153: case 214:   /*214*/
      fprintf(outf, "&Ouml;");
      break;
/* p2c: rtf2html.pas, line 108: Note: Character >= 128 encountered [281] */

    case 132: case 228:   /*228*/
      fprintf(outf, "&auml;");
      break;
/* p2c: rtf2html.pas, line 109: Note: Character >= 128 encountered [281] */

    case 142: case 196:   /*196*/
      fprintf(outf, "&Auml;");
      break;
/* p2c: rtf2html.pas, line 109: Note: Character >= 128 encountered [281] */

    case 152: case 223:   /*223*/
      fprintf(outf, "&szlig;");
      break;
/* p2c: rtf2html.pas, line 110: Note: Character >= 128 encountered [281] */

    case '<':
      fprintf(outf, "&lt;");
      break;

    case '>':
      fprintf(outf, "&gt;");
      break;

    case '&':
      fprintf(outf, "&amp;");
      break;

    case '{':   /* create new environment */
      new_env();
      break;

    case '}':   /* close environment */
      close_env();
      break;

    case '\\':
      while (ch == '\\')
	keyword();
      break;

    default:
      if ((ch & (~127)) != 0 && (ch & 255) <= 255) {
/* p2c: rtf2html.pas, line 113: Note: Character >= 128 encountered [281] */
/* p2c: rtf2html.pas, line 113: Note: Character >= 128 encountered [281] */
	fprintf(outf, "<!-- CHR(%d) -->", ch);
      } else
	putc(ch, outf);
      break;
    }/*case*/
  }  /* until eof */
  if (sp->previous != NULL) {
    fprintf(stderr,"\n******** Forgotten environments: ********\n");
    while (sp->previous != NULL) {
      fprintf(stderr,"* ");
      close_env();
    }
  }
  fprintf(outf, "</BODY></HTML>\n");
  if (outf != NULL)
    fclose(outf);
  outf = NULL;
  if (inf != NULL)
    fclose(inf);
  inf = NULL;
  enit_st();
  fprintf(stderr,"ok\n");
  if (inf != NULL)
    fclose(inf);
  if (outf != NULL)
    fclose(outf);
  exit(EXIT_SUCCESS);
}



/* End. */
