; pseudo device to display memory available to system drivers
; Eric Auer <eric@coli.uni-sb.de> 8/2002
; compile using "nasm -o sysmem.sys sysmem.asm"

; displays es:bx+0e pointer, es:bx itself,
; dos version (int 21.30), current cs and int 21.48 maxalloc
; showing mcb chain would be relatively useless.
; showing the driver chain and/or the UMB chain could be useful
; another idea would be showing the A20 status
; Change 8/2007: replaced rol ax,4 by 4x rol ax,1 --> 8086 compatible

        org  0  ; SYS file

next    dw -1,-1
attrib  dw 1000000000000100b    ; very nully NUL device
stra    dw strat	; *offset* prepare, store ES:BX (far call)
inr     dw intr  	; *offset* do the real work (far call)
nam     db 'SYSMEM$$'   ; driver name will become a special filename,
			; so better not use a too normal name...
pb      dd 12345678h	; parameter block
used    db 0		; bits: 2: init done 1: stop checking function 9

strat:  mov word [cs:pb+2],es
        mov word [cs:pb],bx	; we could copy the contents of the
        RETF			; referenced data structure here, too

intr:   pushf
        push bx
        push es
        les bx,[cs:pb]
        mov byte [es:bx+17h],0		; no error
        and word [es:bx+3],7FFDh	; not busy / no error
        or word [es:bx+3],1		; ack state
        cmp byte [es:bx+2],0		; INIT ?
	jnz nix
        jmp inst
nix:    pop es
        pop bx
        popf
        RETF

; -------------------------------------------------------------

inst:			; show various memory information stuff
; we have a pointer to first nonfree byte on es:bx+0e, IF
; dos version is at least 5.0 (int 21.30 -> ah at least 5)
	push ax
	push si

	mov si,parammsg
	call pstring	; first, show pointer es:bx and "hello"
	mov ax,es
	call pax
	mov ax,bx
	call pax

	mov si,dosvermsg
	call pstring	; next, show DOS version
	push bx
	push cx
	mov ax,3000h
	int 21h		; get DOS version
	pop cx		; ignore serial
	pop bx		; ignore oem
	xchg al,ah	; move main to ah, sub to al
	call pax
	call pcrlf	; next line

	mov si,csmsg
	call pstring	; show current CS value
	mov ax,cs
	call pax

	mov si,ptrmsg
	call pstring	; last, show current device TOM pointer
	mov ax,[es:bx+10h]
	call pax
	mov ax,[es:bx+0eh]
	call pax
	call pcrlf	; next line

	mov si,mcbmsg
	call pstring	; bonus: show current MCB maxalloc
	push bx
	mov bx,0ffffh
	mov ah,48h
	int 21h		; try to alloc 1 MB RAM (MCB style)
	mov ax,bx	; ignore found alloc ax, should be none
	call pax	; print remaining alloc, should be all
	pop bx
	call pcrlf	; next line

        mov word [es:bx+10h],cs		; no tsr, so cs:0 as the
        mov word [es:bx+0Eh],0		; *offset* first free byte

	pop si
	pop ax
	jmp nix

; -------------------------------------------------------------

pstring:		; show message$ at CS:SI
	push dx
	push ax
	push ds
	  push cs
	  pop ds
	mov dx,si
	mov ah,9
		int 0x21
	pop ds
	pop ax
	pop dx
	ret

pcrlf:			; move to next line
	push si
	mov si,crlfmsg21
	call pstring
	pop si
	ret

pax:			; show value of AX
	push ax
	push dx
	mov dh,4	; 4 nibbles
showaxlp:
	rol ax,1	; move high nibble to "print pos"
	rol ax,1	; move high nibble to "print pos"
	rol ax,1	; move high nibble to "print pos"
	rol ax,1	; move high nibble to "print pos"
	  push ax
	and al,0x0f
	add al,'0'	; hex -> ascii
	cmp al,'9'
	jbe nothex
	add al,7	; 'A'-('9'+1)
nothex:	mov dl,al
	mov ah,2
		int 0x21	; show a char
	  pop ax
	dec dh
	jnz showaxlp	; on to the next digit
	pop ax
	pop dx
	ret

crlfmsg21	db 13,10,"$",0

parammsg	db "SYSMEM.SYS: Shows memory available to itself",13,10
		db "GPLed software by Eric Auer <eric@coli.uni-sb.de>"
		db " 8/2002",13,10
		db " Parameter block is at: $"
dosvermsg	db " DOS version is: $"
csmsg		db " CS is: $"
ptrmsg		db " DOS 5 device TOM pointer is: $"
mcbmsg		db " Free int 21.48 paragraphs: $"
