; interprets ANSI sequences - the decision ANSI sequence vs. normal
; TTY string is done in SHOW_RX in terminal-disp.asm, and this is
; also where the rejected parts are re-inserted into the TTY stream

; returns CARRY to indicate that the sequence ended with this char
; returns ZERO if sequence was aborted (error found, re-inserting...)

ANSI:
	PUSH bx
        PUSH cx
	mov ah,0	; string terminator and AL -> AX extension
	mov bx,[cs:abufptr]
	mov [bx],ax	; store for later (review/recovery)
	cmp bx,abuffer	; *offset*
	jnz na_first
a_first_char:
	cmp al,'['
	jnz a_analyze_single
	inc word [cs:abufptr]	; advance buffer pointer
	jmp a_notall	; ESC[... always goes on further

a_analyze_single:	; handle short ESCx type commands here
	; we do not update abufptr because ALL short ESCx type
	; commands do end at this point anyhow!
	mov bx,asingletab	; *offset* of 1st command list
	mov cx,[cs:bx]	; load size of list
	inc bx
	inc bx
a_an_loop:
	cmp ax,[cs:bx]
	jnz a_an_goloop
	mov ax,[cs:bx+2]
	jmp ax		; JUMP to handler specified in list
a_an_goloop:
	add bx,4
	loop a_an_loop	; try other list entries
	jmp a_abort	; unparseable ESCx type command


na_first:		; not first, so we are in an ESC[ type string!
	inc bx		; advance buffer pointer
	cmp bx,abufend
	jb na_buf_ok	; next byte+term will at most end up in buffer+end
aa_1:	jmp a_abort	; sequence is too long to parse (to be exact,
			; it is too long to recover if it turns out to
			; be unparseable / unhandled)
na_buf_ok:
	mov [abufptr],bx	; store updated buffer pointer

na_1:	cmp al,' '	; abort on illegal chars, including NUL and space
	jbe aa_1
        cmp al,';'	; a ';' will tell us the next arg is coming up:
        jnz na_nextpar

a_nextpar:		; allocate a new parameter
	mov bx,[cs:aparptr]
	inc bx
	cmp bx,apars+4
	jae aa_1	; abort if more than 4 parameters
	mov al,0
	mov [bx],al	; parameters default to 0 (unless command A..D ...)
	mov [aparptr],bx	; update parameter pointer
	jmp a_notall	; sequence will continue

na_nextpar:
        cmp al,'0'
        jb aa_1		; we cannot handle ESC[?... config sequences yet
			; (which would all have 1 arg and end in h or l...)
			; ... and abort also on '!' ... '/' (21h..2fh)
        cmp al,'9'
        ja a_command	; no "digit or ;" ? -> must be the command

a_parse_number:		; it was a digit what we found!
	mov bx,[cs:aparptr]
	sub al,'0'	; by the way, we will allow leading zeroes!!
	xor cx,cx
	mov cl,al	; store for later
	mov ah,10	; feeling decimal!
	mov al,[bx]	; multiply older digits as a new one is...
	mul ah
	add ax,cx	; ... appended as new lowest digit
	cmp ax,255
	jb a_p_ok	; detect overflow errors
	jmp a_abort	; abort due to numeric overflow
a_p_ok: mov [bx],al	; store new value!
	jmp a_notall	; sequence will continue

a_command:		; this will end the sequence, gracefully or not!
	cmp al,'m'
	jnz a_cmd_fixed	; all other commands know their number of args
	call A_ATTR	; parse parameter list as attribute manipulator list
	jmp a_finished	; this ended the sequence gracefully

a_cmd_fixed:		; limit everything to max 2 args first
	cmp word [cs:aparptr],apars+1
	ja a_more_args	; 3 or more are too many args for everything but "m"
	mov bx,[cs:apars]	; read first 2 arguments
			; (if not set up, will still be 0 as default)
	cmp al,'H'
	jz a_cmd_H
	jb a_cmd_others	; A..G are "others"
	cmp al,'f'
	jb a_cmd_others	; I..Z and a..e are "others"
	jz a_cmd_H	; f is a synonym for H
	cmp al,'r'
	jb a_cmd_others	; g..q are "others"
	jz a_cmd_r
	cmp al,'y'	; y is loopback testing stuff
	jnz a_cmd_others
	jmp a_abort	; we cannot do loopback testing

; ------------------

a_cmd_H:		; one of the two 2 arg concepts we can do
	xchg bl,bh	; first arg is Y, second is X, now X in BL ...

	; the ANSI.SYS default is: not given args default to 0 (thus up/left)
%ifdef SPECIAL_MOVING_CURSOR
	cmp byte [cs:abuffer+1],';'	; was it ESC[;... ?
	jnz a_np1
		; the first argument was not given and defaults to current Y
	mov bh,[cs:rposxy+1]
a_np1:	cmp word [cs:aparptr],apars	; *offset*
	jnz a_np2
		; there was only one arg, other one defaults to current X
	mov bl,[cs:rposxy]
a_np2:
%endif

	add bl,[cs:rstartxy]	; define rstart as the ORIGIN
	add bh,[cs:rstartxy+1]	; define rstart as the ORIGIN
	jmp a_checkrange	; cursor will only move if it stays in range


a_cmd_r:		; sets the scroll region to arg1..arg2 (rows)
	cmp bl,bh
	jae a_r_bug	; arg1 must be < arg2
	mov al,bh
	add al,[cs:rstartxy+1]
	cmp al,[cs:rendxy+1]
	ja a_r_bug	; region would extend below end of screen
	mov [rscrollreg],bx
	jmp a_finished
a_r_bug:		; (could be handled in some other way)
	jmp a_finished	; ignore attempts to set up scroll region "wrong"

a_more_args:
	jmp a_abort	; more than 2 args with ESC[...f ESC[...r ESC[...H
			; or ESC[...y or more than 1 arg with anything else

; ------------------

a_cmd_others:		; all the ESC[... commands with max one argument
	cmp word [cs:aparptr],apars
	jnz a_more_args	; abort, too many arguments
	mov bl,[cs:apars]
	mov ah,bl	; this is our argument (if not set, it will
			; still be ZERO - the default value!)
	cmp byte [cs:abuffer+1],'A'	; was it ESC[A...ESC[D ?
	jb na_default_1
	cmp byte [cs:abuffer+1],'D'	; was it ESC[A...ESC[D ?
	ja na_default_1
		; ESC[A ... ESC[D should behave like ESC[1A...ESC[1D,
		; so we pretend to have an "1" arg rather than "0" default
	inc ah		; special case: an argument defaulting to ONE
na_default_1:

	mov bx,acmdlist	; *offset* 2nd command list
	mov cx,[cs:bx]	; load size of list
	inc bx
	inc bx
a_cmd_loop:
	cmp al,[cs:bx]	; scan for command char (byte!)
	jnz a_cmd_goloop
	mov bx,[cs:bx+2]
	jmp bx		; JUMP to handler specified in list
			; AL is the command, AH is the argument!
a_cmd_goloop:
	add bx,4
	loop a_cmd_loop	; try other list entries
	jmp a_abort	; unparseable ESC[... type command

; ------------------

a_delta_pos:	; move cursor by delta in BX and check range etc.
	mov ax,[cs:rposxy]
		; maybe our presence is detectable because we do range
		; checking not after every add/sub, but what the heck...
	sub al,[cs:rstartxy]	; remove window offset first...
	sub ah,[cs:rstartxy+1]
	add al,bl	; move X by BL
	add ah,bh	; move Y by BH
	add al,[cs:rstartxy]	; ...add window offset again
	add ah,[cs:rstartxy+1]
	mov bx,ax	; copy new pos to BX for a_checkrange

a_checkrange:	; check cursor pos BX for range and store it if ok
	mov ax,[cs:rstartxy]
	cmp bl,al
	jb a_nrange	; too left
	cmp bh,ah
	jb a_nrange	; too high
	mov ax,[cs:rendxy]
	cmp bl,al
	ja a_nrange	; too right
	cmp bh,ah
	ja a_nrange	; too low
			; approved!
	mov [cs:rposxy],bx	; save new XY position
	push di
		BX2DI	; convert to linear
	mov [cs:rpos],di	; save new linear position
	pop di
a_nrange:
	jmp a_finished

; ------------------

a_notall:
	or sp,sp	; return NZ - sequence not aborted
        clc		; return NC - sequence in progress
	jmp short a_curret	; pop and return

a_abort:		; after an abort, abuffer should be printed
	xor bx,bx
	or bx,bx	; return ZR - sequence aborted
	stc		; return CY - sequence at end
	jmp short a_curret	; pop and return
	
a_finished:
	or sp,sp	; return NZ - sequence not aborted
	stc		; return CY - sequence at end
a_curret:
	POP cx
	POP bx
        RET

; ------------------

	; r H f y handled as special cases (define scroll area, set
	; cursor pos, set cursor pos, test stuff) (see above)
acmdlist:	; table for parsing one-arg 'ESC[...' type commands
		; handles most VT100 stuff, some diffs to ANSI.SYS/NANSI.SYS
	dw 10	; first value is length of list!
		; not handled: n (arg 5 -> return ESC[0n if ok,
		;                 arg 6 -> return ESC[y;xR cursor pos)
		;                ANSI.SYS only handles arg 6, we ignore all!
		;                ANSI.SYS bug: it adds a CR to the response
	dw 'A',a_c_up
	dw 'B',a_c_down
	dw 'C',a_c_right
	dw 'D',a_c_left
	dw 's',a_c_save
	dw 'u',a_c_restore
	dw 'J',a_c_clearscreen
	dw 'K',a_c_clearline
	dw 'q',a_c_led
	dw 'g',a_c_clear_tab	; <<< *** not currently used
		; NANSI.SYS ESC[xL "insert x lines" not supported
		; NANSI.SYS ESC[xM "delete x lines" also not supported
		; same for @ and P, insert and delete characters
		; but both of them are not VT100 anyway (but VTxxx),
		; and ANSI.SYS (MS) does not support them either
	; only real VT100 do this: ESC[c and ESC[0c -> return ESC[?1;100c
	;             ---                                            ---
	; (N)ANSI.SYS/VTxxx ESC["string"p key redefines (risky, NANSI.SYS
	;   can disable this with /s) not supported anyway :-)
	; (N)ANSI.SYS ESC[xh set video mode not supported, obviously.
	;   video mode numbers are BIOS numbers, BUT "mode" 43 does only
	;   (temp.) change to 8x8 font rather than changing the main mode!
		; all ESC[?xl / ESC[?xh are not supported at all here,
		;   but NANSI.SYS can do x==7, disable/enable wrap at line
		;   (wrapping disabled means all X>rmax revert to X=rmax)
	nop
	nop
	nop
	nop

; ------------------

a_c_clear_tab:
	; <<< *** we would clear a tab stop at the current pos here,
	; <<< *** or all, if the AH argument were 3...
	jmp a_abort

a_c_up:			; move cursor up
	mov bx,0
	sub bh,ah	; load arg negated to Y
	jmp a_delta_pos	; move cursor

a_c_down:		; move cursor down
	mov bx,0
	mov bh,ah	; load arg to Y
	jmp a_delta_pos	; move cursor

a_c_left:			; move cursor left
	mov bx,0
	sub bl,ah	; load arg negated to X
	jmp a_delta_pos	; move cursor

a_c_right:		; move cursor right
	mov bx,0
	mov bl,ah	; load arg to Y
	jmp a_delta_pos	; move cursor

a_c_save:		; save cursor position
	mov ax,[cs:rposxy]
	mov [asaveposxy],ax
	mov ax,[cs:rpos]
	mov [asavepos],ax
	jmp a_finished		; sequence ends here

a_c_restore:		; restore cursor position
	mov ax,[cs:asaveposxy]
	mov [rposxy],ax
	mov ax,[cs:asavepos]
	mov [rpos],ax
	jmp a_finished		; sequence ends here

; ------------------

a_c_clearscreen:	; clear screen if arg is 2 (ANSI.SYS: if any, default)
			; clear from cursor to end if arg is 0 (default),
			; clear from start to cursor if arg is 1
	cmp ah,2	; ANSI.SYS even does HOME if asked to J-clear anything
	jb a_c_cs2
	jz a_c_cs1
a_c_xx:	jmp a_abort	; illegal clear type
a_c_cs1:	call A_CLS
	jmp a_finished		; sequence ends here

a_c_cs2:
	cmp ah,1
	jz a_c_cs_to
a_c_cs_from:	; clear from cursor to end ((N)ANSI does not do this...)
a_c_cs_to:	; clear from home to cursor (ANSI does not do this...)
		call A_CLS	; <<< *** this is lazy and "VT100-WRONG" ;-)
	jmp a_finished		; sequence ends here


a_c_clearline:	; clear line if arg is 2 (ANSI.SYS: if any, default)
		; clear from cursor to end if arg is 0 (default),
		; clear from start to cursor if arg is 1
	mov al,[cs:rstartxy]
	mov bx,[cs:rposxy]	; get current position
	cmp ah,2
	ja a_c_xx	; illegal clear type
	jb a_c_cl
	mov ah,[cs:rendxy]
	jmp short a_c_cl_range	; 2: left to right
a_c_cl:
	or ah,ah
	jz a_c_cl0
	mov ah,bl	; 1: left to cursor
	jmp short a_c_cl_range
a_c_cl0:		; 0, default: cursor to right
	mov ah,[cs:rendxy]
	mov al,bl

a_c_cl_range:		; set up to clear from column AL to AH
	mov bl,al
	inc ah
	sub ah,al
	xor cx,cx
	mov cl,ah
	push di
	mov ax,[cs:rattr]
	BX2DI
a_c_cl_loop:
	stosw		; clear (part of) the current line
	loop a_c_cl_loop
	pop di
	jmp a_finished		; sequence ends here


a_c_led:	; the LED control function, verrry useful :-)
	cmp ah,0
	jnz a_c_led1
	mov word [cs:rled],0	; clear all LEDs
	jmp a_finished
a_c_led1:
	xor cx,cx
	mov cl,ah
	dec cx		; cx now 0..3 for LED 1..4
	mov al,1
	cmp ah,4
	ja a_c_l_bug
	shl al,cl
	or byte [cs:rled],al	; turn on one LED
	jmp a_finished
a_c_l_bug:
	jmp a_abort	; tried to turn on illegal LED

; ---------------------------------------

asingletab:	; table for parsing short commands
		; VT52 compatibility not really supported:
		; ESC< activates VT52 mode, ESC A..D F..K Z are VT52 stuff...
		; also not supported:
			; ESCN and ESCO are more charset shifts
			; ESCD and ESCM are scrolling up and down
		; long types not supported:
			; ESC#x ESC(x, ESC)x, probably others
			; ESC#x is font size, ESC(x and ESC)x are font set
	dw 5	; first value is length of list!
	; dw '=',as_appkey	; activate application keypad
	; dw '>',as_numkey	; set keypad back to normal numeric keypad
				; (modifies how keypad stuff is sent)
	dw 'c',as_reset		; reset terminal
	dw 'E',as_down		; simulated by ESC[B, one down
	dw '7',as_save		; save state
	dw '8',as_restore	; restore state
	dw 'H',as_set_tab	; <<< *** not yet used!

	nop
	nop
	nop
	nop

; ------------------

as_set_tab:
	; <<< *** we would set a tab stop at the current X position...
	jmp a_abort

as_reset:	; "reset terminal"
	mov ax,[cs:rstartxy]	; reset all cursors to upper left corner
	mov [asaveposxy],ax
	mov [rposxy],ax
	mov ax,[cs:rstart]	; also for linear versions of cursors
	mov [asavepos],ax
	mov [rpos],ax
	mov ax,[cs:attr]	; should be the default...
	mov [asaveattr],ax	; reset all colors/attributes to default
	mov [rattr],ax
	jmp a_finished		; sequence ends here

as_down:	; "down"
	mov ah,1	; delta Y is 1
	jmp a_c_down	; see above...: cursor down by one

as_save:	; save state: pos (linear and XY) and attrib
	mov ax,[cs:rposxy]
	mov [asaveposxy],ax
	mov ax,[cs:rpos]
	mov [asavepos],ax
	mov ax,[cs:rattr]
	mov [asaveattr],ax
	mov ax,[cs:rscrollreg]
	mov [asavescrollreg],ax
	jmp a_finished		; sequence ends here

as_restore:	; restore state: pos (linear and XY) and attrib
	mov ax,[cs:asaveposxy]
	mov [rposxy],ax
	mov ax,[cs:asavepos]
	mov [rpos],ax
	mov ax,[cs:asaveattr]
	mov [rattr],ax
	mov ax,[cs:asavescrollreg]
	mov [rscrollreg],ax
	jmp a_finished		; sequence ends here
	
; #######################################

A_CLS:  PUSH di         ; clear the screen, or to be exact the
        PUSH dx		; real BOX shaped output area
	mov cx,[cs:rstartxy]	; upper left corner
        mov bx,cx       	; UL
        mov dx,[cs:rendxy]	; lower right corner
        mov ax,[cs:rattr]
ac_nl:          BX2DI
ac_inl: stosw
        inc bl
        cmp bl,dl	; R
        jbe ac_inl	; loop over columns
        mov bl,cl	; L
        inc bh
        cmp bh,dh	; D
        jbe ac_nl	; loop over rows
        POP dx
        POP di
        RET

; #######################################

A_SCROLL:
	PUSH ax		; just scroll up - in the real BOX
        PUSH si         ; shaped output area PLUS vertical limits
        PUSH di		; defined in rscrollreg
        PUSH bx
        PUSH cx
        PUSH dx
        mov cx,[cs:rstartxy] ; upper left corner
	add ch,[cs:rscrollreg]
        mov bx,cx	; UL
	mov dx,[cs:rendxy]   ; lower right corner

     ; <<< *** this code seems to have an "off by one" error,
     ; <<< *** so it is defined out and we always have the last
     ; <<< *** line according to rendxy as the "down end" of scrolling!
%ifdef FIXED_SCROLL_REGION_END
	mov al,dh
	    mov dh,[cs:rstartxy]     ; special...
	    add dh,[cs:rscrollreg+1] ; ... D !
	cmp al,dh
	jnb as_low_ok
	mov dh,al	; clip D to D from lower right corner
as_low_ok:
%endif

        mov ax,[cs:rattr]
as_nl:          BX2DI
        mov si,di
        add si,[cs:cols]
        add si,[cs:cols]
as_inl:
; * db 26h	; ES:
	es movsw	; *** movs word [es:di], word [es:si]
        inc bl
        cmp bl,dl	; R
        jbe as_inl	; loop over columns
        mov bl,cl	; L
        inc bh
        cmp bh,dh	; D
        jb as_nl	; loop over rows

	; is L in D now...
                BX2DI
        mov ax,[cs:rattr]
as_emp: stosw
        inc bl
        cmp bl,dl	; R
        jbe as_emp	; clear the row at the bottom

        POP dx
        POP cx
        POP bx
        POP di
        POP si
	POP ax
        RET

; #######################################

	; process attribute change commands
A_ATTR: PUSH si			; can take more than one argument!
        mov bx,[cs:rattr]	; invalid arguments are simply ignored
        mov cx,[cs:aparptr]
        mov si,apars	;  *offset*
        sub cx,si
        inc cx		; to know how many arguments there are (1..)
a_lp:   lodsb
        cmp al,47
        ja aa_x
        cmp al,40
        jb aa_2
aa_bg:  and bh,8fh	; 40..47 sets the background color (ANSI)
        sub al,40
        shl al,1
        shl al,1
        shl al,1
        shl al,1
aa_or:  or bh,al
        jmp short aa_x

aa_2:   cmp al,37
        ja aa_x
        cmp al,30
        jb aa_3
aa_fg:  and bh,0f8h	; 30..37 sets the foreground color (ANSI)
        sub al,30
        jmp short aa_or

aa_3:   cmp al,8	; 8 sets the "invisible" property
        ja aa_x
        jnz aa_4
aa_no:  and bh,88h
        jnz aa_x
        mov bh,08h      ; not really invisible...
        jmp short aa_x

aa_4:   cmp al,7	; 7 sets the "inverse" property
        jnz aa_5
aa_inv: xor bh,7fh	; (should be not toggle)
        jmp short aa_x

aa_5:   cmp al,5	; 5 sets the BLINKING property
        jnz aa_6	; <<< *** we cannot do 4, UNDERLINE yet
aa_bli: or bh,80h
        jmp short aa_x

aa_6:   cmp al,1	; 1 sets the bold/bright property
        jnz aa_7	; <<< *** we cannot do 2, PALE yet
aa_bld: or bh,08h
        jmp short aa_x

aa_7:   or al,al	; 0 resets all colors and properties!
        jnz aa_x
aa_nrm: mov bh,16h      ; in THEORY we would set to 07h or do AND 77h...

aa_x:   loop a_lp	; all other values are ignored
        mov [rattr],bx
        POP si
        RET
