
; Erics tiny terminal: handles the more common vt100/ansi sequences,
; interrupt-driven serial communication, runs on the oldest PCs!
; first released version Oct/Nov 2001 Eric Auer <eric@coli.uni-sb.de>
; last version before was (masm, one file) V2.1 4/1998
; batch file wrapper added 11/2002 (nicer command line syntax, help)
; this version: V3.2 4/2005 - port selection bugfixes
; update in V3.3 6/2007: added a forgotten in al,dx term-irq.asm:217

; undocumented debugging feature:
; while scroll lock is on, all typed data will have local echo
; not only in local echo window but also in main window

; %define DEFINED_SENDEN nop
%define DEFINED_SENDEN call SENDEN
; either "nop" or "call SENDEN", obvious purpose ;-)

; include macro definitions:
%include 'term-def.asm'

; --------------------------------------------------------------------

; dat     segment ; Erics Microterminal, 
; made from: V2 (many Features!! Ansi/[n]curses!!)
; current version: see above!
        org  100h
;         assume  cs:dat,ds:dat,es:dat    ; 4/98
; code    PROC

the_beginning:
	mov ax,cs
	mov ds,ax		; useful in case we are a ROM :-)
	mov es,ax
	mov [savesp],sp		; just to be save...
                call GETBIOSDTA	; get screen dimensions and stuff
	jnc nbail1
	jmp bailout
nbail1:	mov ax,[0]		; if we are NO ROM, this will be
				; "int 0x20"
	cmp ax,0x20cd
	jnz skip_getparm
		call GETPARM	; read command line args
	jnc nbail2
bail3:	jmp bailout
skip_getparm:			; no defaults (4/2005) if run in ROM:
		call PROMPTPARM	; read setup from user if we are ROM
	jc bail3		; "quit" ability added 4/2005

nbail2:		call SPEEDSET	; set up serial communications speed
        mov si,msg_hello	; *offset*
                call MSG	; say hello
		call IRQ_INST   ; ***** set up interrupt driven serial
                call SHOW_PROTO	; show current comm/crlf/handshake setup
	mov byte [modlines+1],0bh	; turn off: res res ??? loopback
				; (leave out2) out1 (leave rts) (leave dtr)
        or word [modlines],3  ; turn RTS/DTR on: we are now ready
        or word [modlines],8  ; turn RTS/DTR on: we are now ready
                call MOD_LINES	; inform UART about this
	mov [savesp],sp		; just to be save...


MAINLOOP:			; guess what :-)
        PUSHf
        cli
        mov dx,[cs:comdta]   ; ah=3 dx=comport int 14h
        add dl,5
        in al,dx
        mov ah,al
        inc dx
        in al,dx        ; Status AH/AL
        mov [comstats],ax	; (( ah test 1 nz if data waiting ))
        POPf

; *	push ax
; *	mov ax,[cs:IRQ_buf_a]	; ***** is there data in interrupt
; *	cmp ax,[cs:IRQ_buf_b]	; ***** driven input buffer ?
; *	pop ax
; *	jz shownix	; no new incoming data found

SHOW_DATA_RECEIVED:
        test word [hshake],2          ; hshake test 2: send RTS
        jz no_hs1
	mov byte [modlines+1],(0ffh | RTSSEND)	; clear used flags
        mov byte [modlines],8	; set no flags	; else send no RTS
				; ok, always set one flag: 8 is OUT2
				; and is used as int enable...!
                call MOD_LINES	; inform modem about this
no_hs1:         call GETSH	; get keyboard shift status
	jnc nraus1	; <<<
	jmp raus
nraus1:
		call IRQ_READBUF        ; ***** fetch data from input buffer
        or ax,ax
	js shownix	; only show properly received chars
			; (do not show the -1 we get if no chars received :-))
                call SHOW_RX

shownix:
	mov ax,[cs:comstats]
	cmp ax,[cs:comstats2]
	jz nonewstats		; only show comstats if changed
	mov [comstats2],ax
                call SHOW_STATS ; Modem-/Line-Status comstats
nonewstats:
                call GETSH	; get keyboard shift status
	jnc nraus2 ; <<<
	jmp raus
nraus2:

GET_KEY_TO_TRANSMIT:
        mov BP,[cs:hshake]		; create local copy of hshake !!!
	and BP,0ff3fh			; clear BREAK and FrameERROR
        mov ah,1        ; check for key, peek what key it is
                int 16h ; Z if none waiting
        jnz n_sendnix	
y_sendnix:
	jmp sendnix	; nothing to send
n_sendnix:

; ^C to exit removed: unless DOS or BIOS kills us due to ^C, we will
; treat ^C as a normal key and just send it as is through the line
; (pressing both shifts or F8 is the new way to get out)
;        cmp al,3        ; ^C ends the program
;        jnz n_raus
;        jmp raus

n_raus: or al,al
        jnz normchar	; normal key, is sent 1:1 - may be ENTER, however

CURSOR_AND_FUNCTION:
        mov ah,0
        int 16h		; remove the special key from the queue in any case
                call F_TASTEN	; handle special keys (reads AX, will
				; leave a new value or 0 in AL)
        mov BP,[cs:hshake]		; create local copy of hshake !!!
	and BP,0ff3fh			; clear BREAK and FrameERROR
        or al,al
        jz y_sendnix	; only send printable chars for now
			; <<< *** improve to send cursor thing as well
			; <<< *** (keypad things are sent as ESC O x in alt
			; <<< *** keypad mode, cursor keys are sent as
			; <<< *** ESC A/B/C/D for UP/DOWN/R/L in normal
			; <<< *** and as ESC 0 A/B/C/D in application
			; <<< *** cursor mode. So this would send 1..3 chars
			; <<< *** for each cursor/keypad event !
                call SENDME	; send char from special key handler
	cmp ax,-1
	jz sendnix	; we had a traffic jam, the char from the special key
			; handler was LOST. (<<< *** not handled yet)
	; (if it was not lost, fine)
        jmp short sendnix

normchar:
        cmp al,13       ; if "ENTER" was pressed:
        jnz SEND_NORMAL_KEY

KEY_IS_ENTER:
        mov bx,[cs:crpolicy]
        shl bx,1	; get a key SEQUENCE to send ENTER as 1 or 2 chars!
        mov ax,[cs:send_cr+bx]
        or ah,ah	; if we have a "sequence" of only 1 char, treat it
			; as if it were a normal key
        jz SEND_NORMAL_KEY
			; (index to list selected by the crpolicy)
        PUSH ax
                call SENDME	; send char in ENTER sequence to remote side
	cmp ax,-1
	jz oh_gosh_enter	; if the line was jammed (key LOST), do not
				; resend. (<<< *** not handled yet)
	; (if it was not lost, fine)
oh_gosh_enter:
        POP ax
        mov al,ah

SEND_NORMAL_KEY:
                call GETSH	; get keyboard shift status
	jnc nraus3	; <<<
	jmp raus
nraus3:
                call SENDME     ; send that key to the remote side!
	cmp ax,-1
	jz KEY_WAS_LOST
	jmp short sendok

KEY_WAS_LOST:
	mov BP,[cs:hshake]	; create a local copy !!!
        and BP, 0ff2fh          ; clear the BREAK and FrameERROR status bits
				; and the JAMMED status bit (now 00x0xxxx)
        or BP,10h       	; store "we are jammed" status
                call GETSH	; get keyboard shift status
	jc raus ; <<<
        jmp short sendnix       ; keys will pile up in keyboard buffer
				; until the traffic jam is over
				; (problem: menu keys will do the same!)
	; key was successfully sent:
sendok: mov ah,0        ; take key out of buffer (AH Scan AL Asc)
                int 16h
	mov BP,[cs:hshake]	; create a local copy !!!
        and BP, 0ff2fh          ; clear the BREAK and FrameERROR status bits
				; and the JAMMED status bit (now 00x0xxxx)
	; there was not even a key to be sent:
sendnix:

BREAK_HANDLING:
	; hshake: bits are SSUSxxyU (S is status, U is from user,
	;         x is setting of rx logic from user, y is setting
	;         of tx flag send policy from user)
        mov ax,[cs:comstats]
        test ax,800h    ; Error/Break frame?
        jz nobrk1
        or BP,80h
nobrk1: test ax,200h    ; Break (over) ?
        jz nobrk2
        or BP,40h
nobrk2: cmp BP,[cs:hshake]	; if hshake has changed, update display!!!
        jz nixpro
        mov [hshake],BP
                call SHOW_PROTO	; show current comm/crlf/handshake setup
nixpro: test word [hshake],2		; if hshake test 2, turn on RTS 
        jz no_hs2
	mov byte [modlines+1],0ffh	; and: leave all as-is
        or byte [modlines],RTSSEND	; or: RTS on
                call MOD_LINES		; tell UART about this
no_hs2: 


; <<<< *** not very useful yet: %define PREVENT_JAMMED_KEYBOARD 1
%ifdef PREVENT_JAMMED_KEYBOARD
	push es
	push bx
	push cx
	mov ax,40h
	mov es,ax
	xor cx,cx
	mov ax,[es:1ah]	; keyb: pointer to next char to read, read pointer
	mov bx,[es:1ch]	; keyb: pointer to first free slot, write pointer
prjam0:	cmp ax,bx	; if both are the same, buffer is empty
	jz prjam1
	inc cx	; one more key waiting to be read
	add ax,2	; as if we were reading...
	cmp ax,[es:82h]
	jb prjam0	; if not below, we reached the end of buffer...
	mov ax,[es:80h]	; ...and wrap around to the beginning
	jmp short prjam0
prjam1:	mov ax,[es:82h]
	sub ax,[es:80h]
	shr ax,1	; now ax is size of buffer, in chars
	shr ax,1	; now it is 50% of that
	cmp cx,ax
	jb prjam2	; less than 50% in use, good
	mov ah,0
		int 16h	; read one key from buffer, then discard it!
			; could also use func 04h to flush all the keys...
prjam2:
	pop cx	
	pop bx
	pop es
%endif
; <<<< *** end of PREVENT_JAMMED_KEYBOARD

	jmp MAINLOOP


raus:   mov byte [modlines+1],0fch    ; leave everything on, but...
	and word [modlines],0fcfch    ; turn RTS/DTR off
                call MOD_LINES
                call IRQ_UNINST ; *****
bailout:			; very direct exit - bailing out
	mov sp,[cs:savesp]	; just to be save...
	mov ax,cs
	mov ds,ax
	mov es,ax
	mov ax,[0]		; if we are NO ROM, this will be
				; "int 0x20"
	cmp ax,0x20cd
	jnz rom_bailout
        mov ax,4c00h
                int 21h
rom_bailout:
	RETF			; or "int 0x19" or "int 0x18" or
		; whatever you want to do after leaving the ROM
		; version (for example prompt if you want to
		; return to the_beginning) ...

; ######################################

; F_TASTEN:       ; Taste in AH (Asc=AL=0) behandeln
%include 'term-menu.asm'

; ######################################

; ANSI:		; handles a subset of ANSI: input AL, output BX/CARRY
%include 'term-ansi.asm'

; ######################################

; TTY:		; char AL/AX, Geo 'R', destroys DI BX AX
; includes GETBIOSDATA to init screen geometry and similar stuff
%include 'term-tty.asm'

; ######################################

GETSH:  push bx		; get keyboard shift status
        PUSH ds         ; Shiftstatus holen
        mov bx,40h
        mov ds,bx
        mov bx,[ds:17h]
        POP ds
        mov [shiftstat],bx
        and bx,FLUCHT   ; LRShift, Abbruch?
        cmp bx,FLUCHT
        jz raus_g       ; bei jeder Shiftstatusabfrage
	cmp word [flag_exit],0
	jnz raus_g	; exit if the flag is found to be set!
	clc
        pop bx
        ret
raus_g:	stc
	pop bx
	ret

; ######################################

; GETPARM and PROMPTPARM: initialize by using values from
; command line or keyboard (the latter is for ROM mode)
; includes biostty, bios_xkey and bios_string :-)
%include 'term-set.asm'

; ######################################

; SHOW_ROTATE, SHOW_TX, SHOW_RX, MSG (and WART), SHOW_STATS, SHOW_PROTO:
; functions used to output different kinds of data to the screen
; (or possibly an offscreen buffer, config is in term-data.asm)
%include 'term-disp.asm'

; ######################################

; Serial communications: several setup and I/O API functions
%include 'term-comm.asm'

; ######################################

SENDME: push bx		; send char in AL with conditional SHOW_RX and
			; unconditional SHOW_TX local echo
	mov bx,ax	; save for later
	DEFINED_SENDEN
	call SHOW_TX	; shows AL (but not if AX is -1)
	xchg bx,ax	; get old ax, save new ax in bx
	cmp bx,-1
	jz sendme_notsent
	test byte [cs:shiftstat],10h	; SCROLL LOCK on???
	jz sendme_notsent	; else no special local echo
	call SHOW_RX		; special local echo
sendme_notsent:
	mov ax,bx	; return result of SENDEN
	pop bx
	ret
; without this, code would only be "call SENDEN", "call SHOW_TX", "ret"

; ######################################

; Serial communications: interrupt driven operation, setup and handler
%include 'term-irq.asm'

; ######################################

; local variables and constants for all parts of terminal
%include 'term-data.asm'

savesp	dw 0	; just to be save...

; ######################################

; code    ENDP
; dat     ENDS
; END     CODE

