/*
  FreeDOS special UNDELETE tool (and mirror, kind of)
  Copyright (C) 2001, 2002  Eric Auer <eric@CoLi.Uni-SB.DE>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, 
  USA. Or check http://www.gnu.org/licenses/gpl.txt on the internet.
*/


#include "drives.h"
#include "stdio.h"	/* printf... */

#ifdef __MSDOS__	/* Turbo C thing */
#define DOS
#endif

#ifdef DOS
#include "dos.h"	/*  getfatd... */
#include "dir.h"	/* getdisk, setdisk */
/* We use both the boot sector and getfatd() of Turbo C here */
#endif

void showdriveinfo(struct DPB * d)
{
  if (d != (struct DPB *)0) {
    printf("Drive %c: info: maxsecinclust=%d shlclusttosec=%d",
      d->drive + 'A', d->maxsecinclust, d->shlclusttosec);
    printf(" numressec=%d, fats=%d,\nrootdirents=%d",
      d->numressec, d->fats, d->rootdirents);
    printf(" firstdatasec=%d maxclustnum=%u, secperfat=%d\n\n",
      d->firstdatasec, d->maxclustnum, d->secperfat);
  }
}

int getdrive(struct DPB * mydpb)
{
  struct DPB * dPB = mydpb;
#ifndef DOS
  /* in DOS, we would copy the DPB from DOS here */
  /* Values for a floppy disk (1.4M) simulated:  */
  if (dPB != ((struct DPB *) 0) )
  {
    dPB->drive = 0; dPB->unit = 0; dPB -> bytepersec = 512;
    dPB->maxsecinclust = 0;        dPB->shlclusttosec = 0;
    dPB->numressec = 1; /* (the boot sector) */
    dPB->fats = 2;  dPB->rootdirents = 224; /* 0xe0: 14sec */
    dPB->firstdatasec = 33; /* 0x21: 1+9+9+14 */
    dPB->maxclustnum = 2848; /* 0xb20<0xff6, thus FAT12 */
    dPB->secperfat = 9; /* about 8.34 used */
    /* and root dir starts at sector 0x13 = 19 = 1+9+9 */
  };
  showdriveinfo(dPB);
  return 0; /* we only sim a: */
#endif
#ifdef DOS
  Dword x;	/* sigh... must be 17bits, bad luck for DOS */
  struct fatinfo dtab;
  char bootsec[512];
  getfatd(&dtab); /* Turbo C: get info on FAT */
  if (dPB != ((struct DPB *) 0) ) {
    dPB->drive = getdisk();
    dPB->unit = 0;
    dPB->bytepersec = dtab.fi_bysec;
    if (dtab.fi_bysec != 512) {
      printf("Warning: %dby/sec\n", dtab.fi_bysec);
    }
    x = dtab.fi_sclus;
    dPB->maxsecinclust = x-1;
    dPB->shlclusttosec = 0;
    while (x>1) {
      dPB->shlclusttosec++;
      x>>=1;
    }

    x = dtab.fi_nclus + 2 - 1; /* max cluster number */
    dPB->maxclustnum = x;
    if (x < 0xff6) { /* FAT12: 1.5by/entry */
      dPB->secperfat = ((dPB->bytepersec-1) + (((x<<1)+x)>>1))
	/ dPB->bytepersec;
    } else {
      dPB->secperfat = ((dPB->bytepersec-1) + (x<<1))
	/ dPB->bytepersec;
    };

    if (absread(getdisk(),1,0,bootsec) < 0) {
      printf("Could not read boot sector, assuming defaults\n");
      dPB->numressec = 1; dPB->fats = 2; dPB->rootdirents = 224;
      return -1;
    }
    dPB->numressec = bootsec[0x0e];
    dPB->fats = bootsec[0x10];
    dPB->rootdirents = bootsec[0x12];
    dPB->rootdirents <<= 8;
    dPB->rootdirents += bootsec[0x11];
    if ((dPB->secperfat & 255) != bootsec[0x16]) {
      printf("Sec per FAT not as predicted??? ");
      printf("Predicted %u, but boot indicates %u\n",
        dPB->secperfat, bootsec[0x16]);
      dPB->secperfat = bootsec[0x16];
      if (dPB->secperfat == 0) { dPB->secperfat = 256; }
    }

    dPB->firstdatasec = 1 /* res */ + (dPB->fats * dPB->secperfat);
    dPB->firstdatasec += (dPB->rootdirents+15) >> 4;
  }
  showdriveinfo(dPB);
  return (getdisk()); /* 0 is a:, and so on */
#endif
}


int setdrive(int drive) /* select another drive */
{
#ifndef DOS
  if (drive != 0) { return -1; };
  return 0;	/* lastdrive is A: */
#endif
#ifdef DOS
  return setdisk(drive)-1;
#endif
}


