/*
 * EditorWarper.java in guk.editIM:
 * Copies over the colors and font from the corresponding
 * RENDERER when asked for a table cell EDITOR.
 * By Eric Auer 2003.
 *
 * This file is part of the Input Method Editor made at
 * http://www.mpi.nl/ and is free software, licensed under
 * the GNU General Public License (GPL) which can
 * be found at http://www.gnu.org/licenses/gpl.txt or in the
 * file EditIM-COPYING.txt included in this distribution.
 *
 * Note that some other EditIM files have LGPL license.
 * GPL means: You may copy, use and edit code (not license) at
 * your wish. Everything that contains GPLed code must be GPLed,
 * too. Sources must be available to all users of the binaries.
 * With GPL, you still have to provide access to THIS source
 * file, but the rest of your project can stay closed source.
 */

package guk.editIM;

import javax.swing.*;
import java.awt.Component;

/**
 * Copies over the colors and font from the corresponding
 * RENDERER when asked for a table cell EDITOR.
 * @see javax.swing.DefaultCellEditor
 */
public class EditorWarper extends DefaultCellEditor {

  public EditorWarper(JTextField field) {
    super(field); // we must be able to construct SOMETHING.
  } // constructor


  /**
   * Overridden so that we can copy the design from the
   * RENDERER of the cell over to the editor (copying over
   * foreground and background color, tool tip  and font).
   * This can only happen when table is not null and both
   * rendering and editing components are JComponents. In other
   * cases, EditorWarper works like DefaultCellEditor.
   * @see javax.swing.DefaultCellEditor
   * @see javax.swing.table.TableCellRenderer
   */
  public Component getTableCellEditorComponent(JTable table,
    Object value, boolean isSelected, int row, int column) {
    Component superEditor = super.getTableCellEditorComponent(
      table, value, isSelected, row, column);
    if ((table == null) ||
        (!(superEditor instanceof JComponent)))
      return superEditor;
    Component renderCo = table.getCellRenderer(row, column).
      getTableCellRendererComponent(table, value, isSelected,
      true /* hasFocus */, row, column);
    if (renderCo instanceof JComponent) {
      ((JComponent)superEditor).setFont(
        ((JComponent)renderCo).getFont());
      ((JComponent)superEditor).setBackground(
        ((JComponent)renderCo).getBackground());
      ((JComponent)superEditor).setForeground(
        ((JComponent)renderCo).getForeground());
      ((JComponent)superEditor).setToolTipText(
        ((JComponent)renderCo).getToolTipText());
    }
    return superEditor;

  } // getTableCellEditorComponent

} // class EditorWarper
