/*
 * FontOptimizer.java in guk.editIM: find an Unicode font.
 * Tries Arial Unicode MS and Bitstream Cyberbit. If none of
 * them can be found, FontLoader is invoked and the two
 * fonts are tried again. If still no font is found, use
 * the first font in the list of FontLoader dynamic fonts.
 * By Eric Auer 2003.
 *
 * This file is part of the Input Method Editor made at
 * http://www.mpi.nl/ and is free software, licensed under
 * the GNU General Public License (GPL) which can
 * be found at http://www.gnu.org/licenses/gpl.txt or in the
 * file EditIM-COPYING.txt included in this distribution.
 *
 * Note that some other EditIM files have LGPL license.
 * GPL means: You may copy, use and edit code (not license) at
 * your wish. Everything that contains GPLed code must be GPLed,
 * too. Sources must be available to all users of the binaries.
 * With GPL, you still have to provide access to THIS source
 * file, but the rest of your project can stay closed source.
 */

package guk.editIM;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import guk.editIM.DebugEditIM;
import guk.editIM.FontLoader;

/**
 * FontOptimizer.java in guk.editIM: find an Unicode font.
 * Tries Arial Unicode MS and Bitstream Cyberbit. If none of
 * them can be found, FontLoader is invoked and the two
 * fonts are tried again. If still no font is found, use
 * the first font in the list of FontLoader dynamic fonts.
 */
public class FontOptimizer {

  /** Using Erics font loading / setting abstractor FontLoader
   * a debug level of 2 is already very verbose. Recommended: 0 or 1.
   * Debug levels: -1 mute, 0 normal, 1 verbose, 2 more verbose... */

  /**
   * May be set to non-null by the unicodeFont() method.
   * You can access it if you need direct access to
   * the dynamic font loading system. Further, unicodeFont()
   * will use it whenever it needs a dynamic font.
   */
  public static FontLoader fontLoader = null;

  /**
   * Returns the first Unicode found that is available,
   * using FontLoader only if needed.
   * @return An unicode Font, preferrably Arial Unicode MS
   * or Bitstream Cyberbit, either a system font or if needed
   * a dynamically loaded font (bug in Java 1.3.1: It fails to
   * delete temporary copies of dynamically loaded font files!).
   */
  static public Font unicodeFont() {
    JTextPane textPane = new JTextPane();
      // for font testing (add to JScrollPane or directly if you want)

    boolean foundFont = true;
    /** FIRST try using system fonts before allocating dynamic ones */
    textPane.setFont(new Font("Arial Unicode MS", // first try
      Font.PLAIN, 12));
    if (textPane.getFont().getFamily().equals(
      "Arial Unicode MS")) { // first try success?
      DebugEditIM.println(0, "Using system font Arial Unicode MS.");
    } else {
      DebugEditIM.println(2,
        "No Arial Unicode MS installed, trying Bitstream Cyberbit.");
      textPane.setFont(new Font("Bitstream Cyberbit", // second try
        Font.PLAIN, 12));
      if (textPane.getFont().getFamily().equals(
        "Bitstream Cyberbit")) { // second try success?
        DebugEditIM.println(0, "Using system font Bitstream Cyberbit.");
      } else {
        DebugEditIM.println(2,
          "No Bitstream Cyberbit installed, trying dynamic fonts.");
        foundFont = false;
      } // no Bitstream
    } // no Arial

    /** try using dynamic fonts to enhance flexibility: */
    if (!foundFont) try { // trying dynamically loaded Arial U.
      if (fontLoader == null) {
        fontLoader = new FontLoader(1 /* debug level */);
      }
      DebugEditIM.println(2,
        "FontLoader active, now trying fonts: Arial Unicode MS.");
      textPane.setFont(new Font("Arial Unicode MS", // first try
        Font.PLAIN, 14));
      // setFont seems to fail never, maybe getFont().getFamily() helps
      foundFont = true;
      if (!textPane.getFont().getFamily().equals(
        "Arial Unicode MS")) { // Arial U. also first dynamic try
        foundFont = false;
      }
    } catch (Exception exc) {
      // bad luck even with dynamically loaded Arial Unicode MS.
      foundFont = false;
    } // if / try / catch
    if (!foundFont) try { // try any other dynamic font
      DebugEditIM.println(2,
        "Second attempt to load Unicode font: any other dynamic font.");
      textPane.setFont( fontLoader.fontSet((String)
      fontLoader.getInternalFonts().firstElement(), 0, textPane.getFont()));
      foundFont = true;
    } catch (Exception exc2) {
      // bad luck. if any dynamic fonts had existed, we had taken the first
      // as default font. Probably we got a nonexisting element exception.
      DebugEditIM.println(0,
        "You are pronably stuck to non-Unicode fonts.");
      foundFont = false;
    } // any dynamic (if / try / catch)

    DebugEditIM.println(0, "Using font: <"
      + textPane.getFont().getName() + ">, family <"
      + textPane.getFont().getFamily() + ">, size "
      + textPane.getFont().getSize() + "pt.");

    return textPane.getFont();

  } // unicodeFont

} // class FontOptimizer

