/**
 * A class to generate hotkey buttons that select a certain
 * locale as the Input Method (IM) of the target. The value
 * assigned to the button can be modified later.
 * By Eric Auer 2003.
 *
 * This file is part of the Input Method Editor made at
 * http://www.mpi.nl/ and is free software, licensed under
 * the GNU General Public License (GPL) which can
 * be found at http://www.gnu.org/licenses/gpl.txt or in the
 * file EditIM-COPYING.txt included in this distribution.
 *
 * Note that some other EditIM files have LGPL license.
 * GPL means: You may copy, use and edit code (not license) at
 * your wish. Everything that contains GPLed code must be GPLed,
 * too. Sources must be available to all users of the binaries.
 * With GPL, you still have to provide access to THIS source
 * file, but the rest of your project can stay closed source.
 */

package guk.editIM;

import guk.editIM.MenuHelpers;

import javax.swing.*; // Jstuff

import java.awt.*;
import java.util.Locale;


/**
 * A class to represent hotkeys and buttons that hold the top 10
 * locale selections.
 */
public class LocaleHotkey extends JToggleButton {


  /**
   * The locale which is currently assigned to the button.
   * Clicking the button will trigger an action command
   * selectlocale localename.
   */
  Locale myLocale; // assigned locale or null
  /**
   * The JToggleButton nature of this object.
   */
  JToggleButton me;


  /**
   * Initialize the hotkey and assign an initial locale to it.
   * @param locale The initial locale that should be assigned
   * to this hotkey / button.
   */
  public LocaleHotkey(Locale locale) {
    super(locale.getDisplayName()); // constructor of superclass
    me = this;
    myLocale = locale;
    this.loadLocale(locale);
    me.setMargin(new Insets(2,2,2,2)); // only use a small margin
  }// constructor LocaleHotkey...


  /**
   * Ask for the currently assigned locale.
   * @return The locale which is currently assigned to that button.
   */
  public Locale askLocale() {
    return myLocale;
  }


  /**
   * Assign a new locale to this hotkey / button. Updates the
   * label, tooltip, color, action command and of course the
   * locale that belongs to &quot;us the JToggleButton&quot;.
   * @param locale The new locale which should be assinged to us.
   */
  public void loadLocale(Locale locale) {
    MenuHelpers menu = new MenuHelpers(null);
      // only hueByHash(...) is used here
    myLocale = locale;
    me.setToolTipText(locale.getDisplayName());
    me.setText( locale.getLanguage() );
      // 2 letter country code: getCountry(), often undefined
      // name of language: getDisplayLanguage() (w/ i18n)
      // internal short name: toString() e.g. en__ASCII
      // 2 letter language code: getLanguage()
    me.setActionCommand("selectlocale " + locale.toString());
    me.setBackground(
      menu.hueByHash(me.getBackground(),
        me.getToolTipText().hashCode(), 0.0f) );
    me.setForeground(
      menu.hueByHash(me.getForeground(),
        me.getToolTipText().hashCode(), 0.5f) );
    if (me.isSelected()) {
      me.setSelected(false);
      me.doClick(); // re-select yourself to cause event processing
    }
  }


  // we also have isSelected, doClick, setSelected, ...


}// public class LocaleHotkey

