/**
 *  Helper class to gather and represent existing unicode ranges.
 *  2003 by Eric Auer. Only public method is getIter(), returning
 *  Iterator for a list of Integers (char values of range boundaries)
 *
 * This file is part of the Input Method Editor made at
 * http://www.mpi.nl/ and is free software, licensed under
 * the GNU General Public License (GPL) which can
 * be found at http://www.gnu.org/licenses/gpl.txt or in the
 * file EditIM-COPYING.txt included in this distribution.
 *
 * Note that some other EditIM files have LGPL license.
 * GPL means: You may copy, use and edit code (not license) at
 * your wish. Everything that contains GPLed code must be GPLed,
 * too. Sources must be available to all users of the binaries.
 * With GPL, you still have to provide access to THIS source
 * file, but the rest of your project can stay closed source.
 */

package guk.editIM;

import guk.editIM.*; /* *** */

/*
 *  Helper class to gather and represent existing unicode ranges.
 *  2003 by Eric Auer. Only public method is getIter(), returning an
 *  Iterator for a list of Integers (char values of range boundaries)
 */
public class UnicodeRanges {

  /**
   * Here we keep our knowledge of existing ranges (once for all instances)
   */
  static java.util.List ranges = new java.util.Vector();

  /**
   * enable startup message here
   */
  final boolean debug = false;

  /**
   * The constructor collects our list (only done once even
   * when there are several instances of this object).
   */
  public UnicodeRanges() {
    if (ranges.size() == 0) {
      collectRanges();
    }
  }

  /**
   * This is the only public method.
   * @return An Iterator to read our Integer objects.
   * Each integer marks the boundary between two Unicode
   * ranges. A final integer marks the last possible character.
   */
  public java.util.Iterator getIter() {
    return ranges.iterator();
  }

  /**
   * Init a list of unicode ranges
   */
  private void collectRanges() {
    int i;
    Character.UnicodeBlock ucr = Character.UnicodeBlock.of('\u0000');
    Character.UnicodeBlock here = Character.UnicodeBlock.of('\u0000');
    if (here != null) ranges.add(new Integer(0)); // first range
    if (debug) System.out.print("Scanning for Unicode blocks...");
    //
    for (i = Character.MIN_VALUE;
         i < Character.MAX_VALUE;
         i += 16) {
      here = Character.UnicodeBlock.of((char)i);
      if (here == null) {
        ranges.add(new Integer(i)); // start a NULL RANGE here
        while ((Character.UnicodeBlock.of((char)i) == null) &&
          (i < Character.MAX_VALUE)) i += 16; // skip undefined regions!
        if (i >= Character.MAX_VALUE) continue; // fall off from the end
        here = Character.UnicodeBlock.of((char)i);
      }
      if (!here.equals(ucr)) { // next range
         ucr = here;
         ranges.add(new Integer(i));
      }
    }
    ranges.add(new Integer(Character.MAX_VALUE)); // end of 
    if (debug) System.out.println(" done.");
  }// private void collectRanges()

}// public class UnicodeRanges
