#!/bin/sh

javac -classpath .:guk/resources/ -extdirs extensions/  \
    guk/*.java guk/editIM/*.java uk/ac/gate/guk/im/*.java

# META-INF/services/java.awt.im.spi.InputMethodDescriptor contains:
# uk.ac.gate.guk.im.GateIMDescriptor
jar -cf extensions/gukIM.jar uk/ META-INF/

java -cp .:guk/resources/ -Djava.ext.dirs="extensions/" guk.editIM.EditIM
# or: guk.Editor

# a2ps --sides=duplex -g -Ma4 -4 -Apage -L73 ... -o /dev/null
# or: ... -o - | lpr -P...

javadoc -private -d javadoc/ guk guk.editIM uk.ac.gate.guk.im
# use without -private flag, to only show publics and protecteds.
# 500 vs. 700k, both acceptable. javadoc has a big overhead anyway.

