
// convert ASC file to FLT file, serious work!

import java.io.*;
// import java.util.*;
import java.util.Vector;
import java.util.StringTokenizer;

class AscFilter
{
    // fixation and saccades constants (file format stuff)
    private static final int ONSET = 0;
    private static final int OFFSET = 1;
    private static final int DURATION = 2;
    private static final int STARTING_X = 3;
    private static final int STARTING_Y = 4;
    
    // the next 3 are now managed through DataSharing:
    // private static final int MAX_PARAMETERS = 13; // # parameters +1 (also applies to MSG)
    // private static final int MAX_MESSAGES = 15; // # different message types
    // private static final int MAX_ITEMSOFINTEREST = 20; // # Items included

    private static final int MSG_ONSET = 0;
    private static final int MSG_KEYWORD = 1;
    private static final int MSG_SECONDARY = 2;

    DataSharing dataSharingInterface;
    MasterScripts masterScripts;
    private int MAX_PARAMETERS;
    private int MAX_MESSAGES;
    private int MAX_ITEMSOFINTEREST;

    private BufferedReader inFile;
    private PrintWriter outFile;
    //private PrintWriter outFilter;
    private boolean skip; // flag : is an item to be skipped (Filtering IV)
    private String channel; // Specs: Filtering III
    private String dataOfInterest; //Specs: Filtering II
    private String[] itemsOfInterest;// = new String[MAX_ITEMSOFINTEREST]; // Specs: Filtering IV
    private String[] messageFrames;//  = new String[MAX_MESSAGES]; // Specs: Filtering I
    private String[] trackerMessages; //Specs: Filtering I - non MSG Messages
    private String fromMessageFrame; //Specs: Filtering I
    private String toMessageFrame;
    private boolean skip_MessageFrames; // flag: True = outside a messageframe (Filtering I)
    private String timeSettingStart; // Specs: TimeSetting
    private int timeSetting; // Specs: Time setting (-1 default)
    private TrialItemCollection trialItems = new TrialItemCollection(); // Specs: Merging
    private double toleranceAbove; // Includes space above and below text boxes
    private double toleranceBelow;
    private DataPooling dataPool; // Specs: Data pooling
    private String fixations; // SPECS: Data pooling -> How to treat too short fixations
    private String blinks; // SPECS: Data pooling -> How to treat blinks
    private int tooShortFixation; // Specs: duration of a too short fixation
    private String outOfRange; // Specs: Data pooling -> How to treat out of range fixations
    private boolean pupilSize;
    private int wordSetToZeroTime; // Word Set to Zero, at what time
	private boolean wordSetToZero; // Word Set to Zero, is it supposed to happen
	
    private String multi_single;//are there severel input files
    private boolean isImage;//is it an image or messagetrial
    private TrialItemImage trialItemImage; // handles the image in a trial
	private int itemCounter; //to detect missing items save nr of last item.
    private String[] dummyItem; //fixed item that is used if an item was missing
	
/* *** unused at the moment - 5/2005
    private String currentObjDPI; // *&*&* DPI Trackeradd - store sthe which Object is currently looked at
    private String currentObjDPINr;
*** */
    private int width,height;
    
    //start = true means start filtering from the constructor
    //mode = "SINGLE" or "MULTI"; only important for displaying the progressbar
    //		(right at the beginning input file readout (method filter())
    public AscFilter(DataSharing dsi,MasterScripts ms,
    		     boolean start, String mode) throws IOException
    {
		dataSharingInterface = dsi;
		masterScripts = ms;

		MAX_ITEMSOFINTEREST=dataSharingInterface.getMax_ItemsOfInterest();
		MAX_MESSAGES=dataSharingInterface.getMax_Messages();
		MAX_PARAMETERS=dataSharingInterface.getMax_Parameters();

		skip=false;
		channel=dataSharingInterface.getChannel();
		dataOfInterest=dataSharingInterface.getDataOfInterest();
		messageFrames = dataSharingInterface.getMessageFrames();
		trackerMessages = dataSharingInterface.getTrackerMessages();
		fromMessageFrame=dataSharingInterface.getFromMessageFrame();
		toMessageFrame=dataSharingInterface.getToMessageFrame();
		if(!fromMessageFrame.equals("NS"))
			skip_MessageFrames=true;
		else
			skip_MessageFrames=false;
		itemsOfInterest=dataSharingInterface.getItemsOfInterest();

		timeSetting=-1; // base timestamp
		timeSettingStart = dataSharingInterface.getTimeSettingStart();
			// what should trigger setting the base timestamp

		toleranceAbove = dataSharingInterface.getToleranceAbove();
		toleranceBelow = dataSharingInterface.getToleranceBelow();

		fixations=dataSharingInterface.getFixations();
		blinks=dataSharingInterface.getBlinks();
		tooShortFixation=dataSharingInterface.getTooShortFixation();
		outOfRange=dataSharingInterface.getOutOfRange();
		pupilSize=dataSharingInterface.getPupilSize();
		wordSetToZero=dataSharingInterface.getWordSetToZero();

		inFile = dataSharingInterface.getInFile();
		outFile = dataSharingInterface.getOutFile();
		dataPool = new DataPooling(outOfRange,fixations,blinks
				   	,tooShortFixation,MAX_PARAMETERS);

		width = dsi.displaySize.x;
                height = dsi.displaySize.y;
                
                multi_single = mode;
		isImage=false;
		wordSetToZeroTime=-10000;
		itemCounter=-1;
		dummyItem = new String[10];
		dummyItem[0]="1"; // ONSET time
		dummyItem[1]="INFO";
		dummyItem[2]="WORD";
		dummyItem[3]="0"; // Item NR
		dummyItem[4]="-1";
		dummyItem[5]="-1";
		dummyItem[6]="-1";
		dummyItem[7]="-1";
		dummyItem[8]="MISSING"; // Item
		dummyItem[9]="unused";

/* *** unused at the moment - 5/2005
                currentObjDPI = "-1"; // default is background
                currentObjDPINr = "-1";
*** */
		if(start)
	    	{
			filter();
			inFile.close();
			outFile.close();
	    	}
    }

    public void filter() throws IOException
    {
		String line = new String();
		boolean eof = false;
		// boolean foundOOR; // flag for out of range fixes
		String startMessage = new String();
		int writeLines=0;
		int testCounter=1;
		int i;

		while (eof==false)
	    	{
			while(dataPool.getReadOn())
		    	{
				line=inFile.readLine();
				// no progressbar for single files
				if(multi_single.equals("MULTI"))
					dataSharingInterface.manageProgressBar(1);
				// System.out.print((testCounter++)+"|");
				if(line == null)
		    		{
/* *** */	System.out.println("End of File reached.");
					eof=true;
					break;
		    		}
				if (line.equals(""))
					continue; // skip / remove empty lines
				StringTokenizer tokenLine = new StringTokenizer(line);
				dataPool.addNewLine(tokenLine);
		    	} // while getReadOn: fill buffer until we have at least 3 fixations

			// every time our buffer gets filled, we try to get
			// rid of fixations by pooling. repeat until we are
			// no longer able to fill the buffer or remove things

			// foundOOR = false;
			if(outOfRange.equals("DONT ALTER") &&
		   	   fixations.equals("DONT ALTER") &&
			   blinks.equals("DONT ALTER"))
			{
			    writeLines=dataPool.getSize(); // no pooling at all
			}
			else
		    	{   /* if doOutOfRange returns true one fixation was out of range
		  		so we need to read up to another fixation to get the three
		  		fixation block */
			    boolean foundOOR = false;
			    if(!outOfRange.equals("DONT ALTER"))
				foundOOR = dataPool.doOutOfRange(dataPool.getSize());
			    if(!foundOOR) // *** why that?
			    {
				// check if we can merge short fixations:
				writeLines=dataPool.doDataPooling(eof);
				// System.out.print("*"+writeLines+"/");

				if (eof) { // only reached if getReadOn wanted more but hit EOF
/* *** */				System.out.println("At EOF1: doDataPooling: " + writeLines +
/* *** */					" getSize: " + dataPool.getSize());
					writeLines = dataPool.getSize(); // *** bug workaround 5/2005
				}

				if(!blinks.equals("DONT ALTER"))
				    writeLines = dataPool.doBlinks(writeLines);
			    }
			    else
			    	writeLines = 0;
		    	}
			// System.out.print(writeLines+"*");

			for(i=0;i<writeLines;i++)
		    	{
				String[] tempTokens = new String[MAX_PARAMETERS];
				String[] tokens = new String[MAX_PARAMETERS];
				for(int j=0;j<tokens.length;j++)
					tokens[j]="unused";
				tempTokens=dataPool.getNextLine();
				startMessage=tempTokens[0];
				// tokens is the line minus the first column:
				System.arraycopy(tempTokens,1,tokens,0,tempTokens.length-1);

				// get rid of eyetracker calibration info
			/*
				if(startMessage.startsWith("0") ||
					startMessage.startsWith("1") ||
					startMessage.startsWith("2") ||
					startMessage.startsWith("3") ||
					startMessage.startsWith("4") ||
					startMessage.startsWith("5") ||
					startMessage.startsWith("6") ||
					startMessage.startsWith("7") ||
					startMessage.startsWith("8") ||
					startMessage.startsWith("9") ||
			*/
				if (startMessage.length()==0 ||
					Character.isDigit(startMessage.charAt(0)) ||
					startMessage.startsWith(">") ||
					startMessage.startsWith("-")) continue;
						
				if (startMessage.equals("MSG"))
					{ doFiltering("MSG",tokens); continue; }
				if (startMessage.equals(fromMessageFrame) ||
					startMessage.equals(toMessageFrame))
                                	{ doFiltering(startMessage,tokens); continue; }

				if (skip==true) continue; // Specs: Filtering IV

				if (skip_MessageFrames==true) continue; // Specs: Filtering I

				// removed message types:
				if (startMessage.equals("SFIX")) continue;
				if (startMessage.equals("SBLINK")) continue;
				if (startMessage.equals("SSACC")) continue;
				if (startMessage.equals("**")) continue;

				if (startMessage.equals("EFIX"))
			    		{ doFiltering("EFIX",tokens); continue; }
				if (startMessage.equals("EBLINK"))
			    		{ doFiltering("EBLINK",tokens); continue; }
				if (startMessage.equals("ESACC"))
			    		{ doFiltering("ESACC",tokens); continue; }

				if (!trackerMessages[0].equals("ALL"))
				{
					int xx=0;
					while(!trackerMessages[xx].equals("unused"))
					{
						if(trackerMessages[xx].equals(startMessage))
							break;
						xx++;
					}
					if(trackerMessages[xx].equals("unused"))
						continue;
// *** the above probably means "suppress this single line"...
					// if true, nothing matched and the frame isn't displayed
				}

				// TimeSetting for Trackermessages
				// (make timestamps relative to a start-timestamp)...
				// !! could probably be optimized, but is only reached if the line
				// !! does not fall in one of the doFiltering categories above ;-)
				try
				{
					if(timeSetting>=0)
					{
						int temp = Integer.parseInt(tokens[MSG_ONSET]) - timeSetting;
						tokens[MSG_ONSET] = Integer.toString(temp);
					}
	    			}
	    			catch(NumberFormatException e)
	    			{
					System.out.println("Not a timestamp: " + tokens[MSG_ONSET]);
	    				continue;
	    			}

				writeTokens(startMessage,tokens);
		    	} // for writeLines
	    	} // while not eof
/* *** */	System.out.println("AscFilter done.");
    }


    // analyze line of tokens (e.g. {"0", "TRIALID", "foobar"})
    // and write a converted version to the output file. core function!
    public void doFiltering(final String startMessage,
			    String[] tokens) throws IOException
    {
        // Specs: Filtering II
        /* if (!startMessage.equals("MSG") &&
	 *   !startMessage.equals("EBLINK") &&
	 *   !dataOfInterest.equals("BOTH"))
	 *   if (!startMessage.equals(dataOfInterest))
	 *	return; // only MSG,EBLINK and the Data of interest (Specs:Filtering II)
	 *		// gets through
	 */

		int temp;
		int i=0;
		int onsetTime = 0;	// needed at several places, better parse only once!
		try {
		    if (startMessage.equals("MSG"))
			onsetTime = Integer.parseInt(tokens[MSG_ONSET]);
		    else
			onsetTime = Integer.parseInt(tokens[ONSET]);
		} catch (NumberFormatException e) {
		    System.out.println("Timestamp missing in '" + startMessage + "'line, removing line!");
		    return; // return without writing line
		}

		// Specs: Merging -> Acquisition: at the end of a trial
	   	// at the end of a trial -> dispose of the trialItems
		if(startMessage.equals("MSG") &&
	   		tokens[MSG_KEYWORD].equals("TRIAL"))
		{
			trialItems.dispose();
			itemCounter=-1;
			if(tokens[MSG_SECONDARY].equals("ABORTED"))
				dataSharingInterface.setAbortedTrialFound();

			// repeated trials confuse VisualizeImage, so we better
			// flag those as to be removed by SecondPassFilter, too
			// (EA 5/2005)
			if(tokens[MSG_SECONDARY].equals("REPEATED"))
				dataSharingInterface.setAbortedTrialFound();
		}
		
		// Specs: Filtering IV
		if(startMessage.equals("MSG") &&
			tokens[MSG_KEYWORD].equals("TRIALID") &&
			!itemsOfInterest[0].equals("ALL"))
			skip = itemsOfInterestCheck(tokens);
		if(skip==true) return;
		
        // Specs: Merging -> Acquisition: at the end of a trial
	// -> dispose of the trialItems
		if(startMessage.equals("MSG") &&
	   		tokens[MSG_KEYWORD].equals("INFO"))
	    	{
                // missing items (item numbers were discontinuous, so we pad!)
				int curItem=Integer.parseInt(tokens[3]);
				if(itemCounter+1!=curItem)
					for(int uu=itemCounter+1;uu<curItem;uu++)
					{    
			                        dummyItem[0]=tokens[MSG_ONSET];
						dummyItem[3]=""+uu;
						// add a dummy item to the database:
						trialItems.acquireTrialItem(4,dummyItem,0,0);
/* *** removed 5/2005
 *						trialItems.addSpaces();
*** */
						int oo=0;
						while(!messageFrames[oo].equals("unused"))
		    			{
							if(messageFrames[oo].equals("INFO") ||
			   					messageFrames[oo].equals("ALL"))
								{
			    					writeTokens(startMessage,dummyItem);
									break;
								}
							oo++;
		    			}
					}
				itemCounter=curItem;

				// add word item to database! add extra vertical size
				trialItems.acquireTrialItem(4, tokens, toleranceAbove, toleranceBelow);
/* *** removed 5/2005
 *				// !!! add pre-word space to word (only for this pass)
 *				// !!! (i.e. not used when the now-produced FLT file is loaded again later)
 *				trialItems.addSpaces();
*** */
				{   // INFO WORD inflation added 5/2005 EA
				    TrialItem tri = TrialItemCollection.convertTrialItem(4, tokens, toleranceAbove, toleranceBelow);
				    if (tri != null) {
					// onset INFO WORD number X1 Y1 X2 Y2 text
					// update Y1 and Y2 to add above/below tolerance
					tokens[5] = "" + (int)Math.round(tri.getItemUpperLeftY());
					tokens[7] = "" + (int)Math.round(tri.getItemLowerRightY());
				    }
				} // INFO WORD inflation
	    	}

		// new 5/2005: log some parameters
		if (startMessage.equals("MSG") &&
	   	    tokens[MSG_KEYWORD].equals("DISPLAY_COORDS"))
		{
		    // write those tokens to output FLT file!
		    writeTokens(startMessage,tokens);
		    // tokens[0] is the timestamp - left as is.
		    tokens[1] = "TOLERANCES";
		    tokens[2] = "" + toleranceAbove;
		    tokens[3] = "" + toleranceBelow;
		    tokens[4] = "" + (int)Math.round((toleranceAbove + toleranceBelow) / 4);
		    tokens[5] = "unused";	// end line here
		}


	     	// find out if the trialid is in the masterscript database
		// if it is then its an ImageTrial
		// also sets the pointer on the right trialid (within masterscripts)
		// added 01/08/03 word set to zero
		if (startMessage.equals("MSG") &&
	   	    tokens[MSG_KEYWORD].equals("TRIALID") &&
	   	    masterScripts!=null)
		{
			// most of the doFiltering() CPU cycles are spent in
			// getTemplate(...) which loads the template image!
			isImage = masterScripts.checkMasterScriptDatabase(tokens[2]);

		        // width and height are the display size here:
			if (isImage) {
/* *** */ System.out.print("Load Image... "); // most time is spent in getTemplate!
			    trialItemImage = masterScripts.getTemplate(width,height);
/* *** */ System.out.println("done.");
			}

			wordSetToZeroTime = masterScripts.getCurrentWordSetToZero();
			// ??? add word set to zero time to the TRIALID message (needed in SBTrans)
			if(wordSetToZeroTime!=-10000) tokens[3] = ""+wordSetToZeroTime;
		}

		/* *** should have a better progress display... */
		if (startMessage.equals("MSG") && tokens[MSG_KEYWORD].equals("TRIALID"))
			System.out.println("Filtering trial: " + tokens[2]
			+ ((masterScripts!=null) ? "" : " (no templates!)"));
		/* *** */

		// Specs: Filtering I
		// you can select message types which should be treated
		// as start / end of trial. the setting NS disables this.
		if(startMessage.equals("MSG"))
	    	    if(fromMessageFrame.equals("NS") ||
	       	        fromMessageFrame.equals(tokens[MSG_KEYWORD]))
		        skip_MessageFrames=false;
        	// special for TrackerMessages
        	if(startMessage.equals(fromMessageFrame) ||
            	    fromMessageFrame.equals("NS"))
             	    skip_MessageFrames=false;

		if(skip_MessageFrames==true) return;

		// needs to be after if(skip_MessageFrames==true) return;
	   	// because the Endmessage needs be in the output file
		if(toMessageFrame.equals(tokens[MSG_KEYWORD]) ||
            	toMessageFrame.equals(startMessage)) skip_MessageFrames=true;

		if (startMessage.equals("MSG"))
	    	{
			i=0;
			while(!messageFrames[i].equals("unused"))
		    	{
				if(messageFrames[i].equals(tokens[MSG_KEYWORD]) ||
			   	messageFrames[i].equals("ALL"))
			    	break;
				i++;
		    	}
			if(messageFrames[i].equals("unused"))
		    	return; // if true, nothing matched and the frame isn't displayed
	    	}

		// Specs: Filtering III
		/* if(!startMessage.equals("MSG") && !channel.equals(tokens[CHANNEL]) &&
	   	 *     !channel.equals("BOTH") && !channel.equals("NS"))
                 *     return;
                 */

		
        	
		// Specs: Time Setting: store timestamp of messages of type
		// timeSettingStart in int timeSetting. Use as base time below.
		try
		{
		    if((!timeSettingStart.equals("NS")) &&
			startMessage.equals("MSG") &&
	   		timeSettingStart.equals(tokens[MSG_KEYWORD]))
	    		timeSetting = onsetTime; // Integer.parseInt(tokens[MSG_ONSET]);
			// NS means "do not use timeSetting at all"

		    if(timeSetting>=0) // make time relative to start time
		    {
		    	if(startMessage.equals("MSG"))
			{
			    // temp=Integer.parseInt(tokens[MSG_ONSET]) - timeSetting;
			    onsetTime = onsetTime - timeSetting;
			    tokens[MSG_ONSET] = Integer.toString(onsetTime);
			}
			else // *** all non-MSG events must have onset AND offset times!
			{
			    // temp=Integer.parseInt(tokens[ONSET]) - timeSetting;
			    onsetTime = onsetTime - timeSetting;
			    tokens[ONSET] = Integer.toString(onsetTime);
			    temp = Integer.parseInt(tokens[OFFSET]) - timeSetting;
			    tokens[OFFSET] = Integer.toString(temp);
			}
		    }
		} catch (NumberFormatException e) {
		    System.out.println("Error in set-time-to-zero timestamp handling!");
		}

                
/* *** unused at the moment - 5/2005 (ENTER WORD / LEAVE WORD events)
                // *&*&* DPI Tracker
                if(startMessage.equals("MSG") &&
                    tokens[MSG_KEYWORD].equals("ENTER"))
                {   
                    currentObjDPI = tokens[8];
                    currentObjDPINr = tokens[3];
                }
                
                if(startMessage.equals("MSG") &&
                    tokens[MSG_KEYWORD].equals("LEAVE"))
                {
                    currentObjDPI = "-1";
                    currentObjDPINr="-1";
                }
*** */

		// Specs: Merging   && Word Time Set To Zero (added 01/08/03)
		// optimized: only parse once... - EA 5/2005
		if(startMessage.equals("EFIX"))
		{
			try
			{
			    double startX = Double.parseDouble(tokens[STARTING_X]);
			    double startY = Double.parseDouble(tokens[STARTING_Y]);
			    int whichItem = checkMessageOrImage(tokens, startX, startY);
			    // is the target an image or rather a message word?
	   		    if (whichItem < 0) // not an item but somewhere on the image
			        tokens = doMergingImageTrial(tokens, startX, startY);
	   		    else
			        tokens = doMergingMessageTrial(tokens, startX, startY, whichItem);
                         } catch (NumberFormatException e) {
			    System.out.println("Invalid fixation coordinates, removing line!");
			    return;
		         }
                } // EFIX handling

		// write modified tokens to output FLT file!
		writeTokens(startMessage,tokens);
    } // doFiltering

    public void writeTokens(String startMessage,
			    String[] tokens) throws IOException
    {
		int i=0;
		outFile.print(startMessage + "\t");
		while(!tokens[i].equals("unused"))
		// *** tabs would look nicer but are "harder to parse" later :-(
	    	outFile.print(tokens[i++]+"    ");
		outFile.println("");
    }
    
    // check if fixation was inside a word (message) item and if so, in which
    // return -1 if not inside a word
    private int checkMessageOrImage(String[] tokens, double startX, double startY)
    {
        if(trialItems.getSize()==0) return -1;
		
	int length = trialItems.getSize();
	double itemUpperX;
	double itemUpperY;
	double itemLowerX;
	double itemLowerY;

        for(int i = 0;i<length;i++)
        {
                itemUpperX = (double)trialItems.
                getTrialItem(i).getItemUpperLeftX();
                itemUpperY = (double)trialItems.
                getTrialItem(i).getItemUpperLeftY();
                itemLowerX = (double)trialItems.
                getTrialItem(i).getItemLowerRightX();
                itemLowerY = (double)trialItems.
                getTrialItem(i).getItemLowerRightY();

                if( (startY <= itemLowerY) &&
		    (startY >= itemUpperY) &&
		    (startX >= itemUpperX) &&
		    (startX <= itemLowerX) )
                    return i; // this item (word) is it
        } // loop over items

        return -1; // not an item (word)
    } // checkMessageOrImage
    
    // add target word info to a fixation with coordinates startX startY
    public String[] doMergingMessageTrial(String[] tokens,
	double startX, double startY, int whichItem)
    {
	// check if there are trialitems
	if(trialItems.getSize()==0) return tokens;

	// not used: double landX = 0.0; double landY =0.0;
	// removed scan-for-item, as it is already done in
	// checkMessageOrImage...
	String pupilSizeString  = new String("");

	// initializing Word Nr and Word length with -1
	// tokens[STARTING_Y+1] = "-1";
	// tokens[STARTING_Y+2] = "-1";
	// always overwritten: if(pupilSize) tokens[STARTING_Y+3]="-1";

	tokens[STARTING_Y+1] = Integer.toString(
	    trialItems.getTrialItem(whichItem).getItemNr());
	tokens[STARTING_Y+2] = Integer.toString(
	    trialItems.getTrialItem(whichItem).getItemName().length());
	    // write Object Nr. / Size after Starting_Y
	// *07/18/2002 write Pupil Size at the and of the line
	if(pupilSize)
		tokens[STARTING_Y+3]=pupilSizeString;

	return tokens;
    } // doMergingMessageTrial

    // add target color info to a fixation with coordinates startX startY
    public String[] doMergingImageTrial(String[] tokens,
	double startX, double startY)
    {
        /* for(int pp=0;pp<tokens.length;pp++) System.out.print(tokens[pp]+"|");
	   System.out.println(""); */
		
       	if(trialItemImage==null)
       	{
       		tokens[STARTING_Y+1] = "no template found";
       		tokens[STARTING_Y+2] = "";
       		return tokens;
       	}

	int x = (int)Math.round(startX);
	int y = (int)Math.round(startY);

	// not used: int landX = 0; int landY = 0; int color;
	String pupilSizeString = new String("");

	// 5/2005: wiggle radius = 1/2 of average of tolerances
	int wiggle = (int)Math.round((toleranceAbove + toleranceBelow) / 4);

	// initializing Regionnumber and color with -1
	tokens[STARTING_Y+1] = "-1";
	tokens[STARTING_Y+2] = "-1";
	// "always" overwritten: if(pupilSize) tokens[STARTING_Y+3]=Integer.toString(-1);
       	// System.out.println(tokens[ONSET]+"/"+startX+"/"+startY);

	int regNumber = trialItemImage.getRegionnumberWiggle(x, y, wiggle, 0);
	    // args above are: coordinates, search radius, background color nr.
	tokens[STARTING_Y+1] = Integer.toString(regNumber);
	tokens[STARTING_Y+2] = trialItemImage.getColorName(regNumber);
		// write Color Nr. and Color Name after Starting_Y

	// *07/18/2002 write Pupil Size at the and of the line
	if(pupilSize)
		tokens[STARTING_Y+3] = pupilSizeString;

	return tokens;
    } // doMergingImageTrial

    // Checks whether an Item is going to be displayed
    // returns true if Item is to be skipped
    public boolean itemsOfInterestCheck(String[] tokens)
    {
	int i=0;
	String withoutWildcard;

	while(!itemsOfInterest[i].equals("unused"))
	    {
		if(itemsOfInterest[i].startsWith("*"))
		    {
			withoutWildcard = itemsOfInterest[i].substring(1);
			if(tokens[2].endsWith(withoutWildcard))
			    return false;
		    }
		if(itemsOfInterest[i].endsWith("*"))
		    {
			withoutWildcard =
			    itemsOfInterest[i].substring(0,itemsOfInterest[i].length()-1);
			if(tokens[2].startsWith(withoutWildcard))
			    return false;
		    }
		// tokens[2] because startMessage isn't in the tokens
		if(tokens[2].equals(itemsOfInterest[i]) ||
		   itemsOfInterest[i].equals("ALL"))
		    return false;
		i++;
	    }
	return true;
    }
} // class AscFilter

// ********************** class TrialItem *********************************
// saves a single TrialItem (Word)
class TrialItem
{
    protected static final int ITEM_NR = 0;
    protected static final int ITEM_UPPERLEFT_X = 1;
    protected static final int ITEM_UPPERLEFT_Y = 2;
    protected static final int ITEM_LOWERRIGHT_X = 3;
    protected static final int ITEM_LOWERRIGHT_Y = 4;
    protected static final int ITEM_NAME = 5;

    private int itemNr;
    private double itemUpperLeftX;
    private double itemUpperLeftY;
    private double itemLowerRightX;
    private double itemLowerRightY;
    private String itemName;

    public TrialItem(){}

    public TrialItem(int nr,double ux,double uy,double lx,double ly,String name)
    {
	itemNr = nr;
	itemUpperLeftX=ux;
	itemUpperLeftY=uy;
	itemLowerRightX=lx;
	itemLowerRightY=ly;
	itemName=name;
    }

    public int getItemNr(){ return itemNr; }
    public double getItemUpperLeftX(){ return itemUpperLeftX; }
    public double getItemUpperLeftY(){ return itemUpperLeftY; }
    public double getItemLowerRightX(){ return itemLowerRightX; }
    public double getItemLowerRightY(){ return itemLowerRightY; }
    public String getItemName(){ return itemName; }

/* *** was only used for addSpaces:
 *  public void setItemUpperLeftX(double newItemUpperLeftX)
 *  { itemUpperLeftX = newItemUpperLeftX; }
*** */
} // class TrialItem


// ******************* class TrialItemCollection / subclass of TrialItem ************+
// stores all Items of a Trial (all word sof the sentence)
class TrialItemCollection extends TrialItem
{
    private Vector trialItemsVector = new Vector(10,50);
    private TrialItem[] trialItemsArray;
    private boolean array;

    public TrialItemCollection(){array=false;}

    public TrialItem getTrialItem(int number)
    {
	if (array==false) return (TrialItem)trialItemsVector.get(number);
	else return trialItemsArray[number];
    }

    public void newTrialItem(TrialItem newItem) { trialItemsVector.add(newItem);}

    public void setSize() {trialItemsVector.trimToSize();}

    public int getSize()
    {
	if (array==false) return trialItemsVector.size();
	else return trialItemsArray.length;
    }

    public static TrialItem convertTrialItem(int parameterOffset, String[] tokens,
        double toleranceAbove, double toleranceBelow)
    {
	TrialItem item = null;
	try {
		item = new TrialItem(
		Integer.parseInt(tokens[ITEM_NR+parameterOffset-1]),

		(double)Integer.parseInt(tokens[ITEM_UPPERLEFT_X+parameterOffset-1]),
		(double)Integer.parseInt(tokens[ITEM_UPPERLEFT_Y+parameterOffset-1])
			- toleranceAbove,
		(double)Integer.parseInt(tokens[ITEM_LOWERRIGHT_X+parameterOffset-1]),
		(double)Integer.parseInt(tokens[ITEM_LOWERRIGHT_Y+parameterOffset-1])
			+ toleranceBelow,
		tokens[ITEM_NAME+parameterOffset-1]);
	} catch (NumberFormatException e) {
	    System.out.println("INFO WORD parse error! Tokens at " + parameterOffset + " are:");
	    System.out.println(tokens[ITEM_UPPERLEFT_X+parameterOffset-1] +  ", " +
		tokens[ITEM_UPPERLEFT_Y+parameterOffset-1] +  ", " +
		tokens[ITEM_LOWERRIGHT_X+parameterOffset-1] +  ", " +
		tokens[ITEM_LOWERRIGHT_Y+parameterOffset-1]);
	}
	return item;
    }


    // store "inflated" (by tolerance) message / word item in our
    // trial item collection
    public void acquireTrialItem(int parameterOffset, String[] tokens,
	double toleranceAbove, double toleranceBelow)
    {
        TrialItem item = convertTrialItem(parameterOffset, tokens,
	    toleranceAbove, toleranceBelow);
	newTrialItem(item);
    }

    public void dispose() { trialItemsVector.clear(); }

    public void toArray()
    {
	trialItemsArray = new TrialItem[trialItemsVector.size()];
	trialItemsVector.copyInto(trialItemsArray);
	array=true;
    }

/* *** disabled 5/2005
 *  // Add Spaces prior to the item to the item
 *  public void addSpaces()
 *  {   // starting with the second item
 *	if(getSize()==1) return;
 *	for(int i=1;i<getSize();i++)
 *	    {   // if itemUpperLeftY of item i-1 is equal to ~ of item i
 *		// then the new itemUpperLeftX of i
 *		// is (itemLowerRightX of i-1) + 1
 *		double UY_i = getTrialItem(i).getItemUpperLeftY();
 *		double UY_iMinus1 = getTrialItem(i-1).getItemUpperLeftY();
 *		double LX_iMinus1 = getTrialItem(i-1).getItemLowerRightX();
 *
 *		if(UY_iMinus1 == UY_i)
 *		    getTrialItem(i).setItemUpperLeftX(LX_iMinus1 + 1);
 *	    }
 *  }
*** */

} // class TrialItemCollection


// ********************** class DataPooling *************************
// DataPooling stores all lines between three fixations
// manages out of range fixations and blinks
class DataPooling
{
    // Fixation constants
    private static final int DP_STARTMESSAGE = 0;
    private static final int DP_ONSET = 1;
    private static final int DP_OFFSET = 2;
    private static final int DP_DURATION = 3;
    private static final int DP_STARTING_X = 4;
    private static final int DP_STARTING_Y = 5;

    // Specs: 1/2 degree of visual angle in pixels
    private static final int SPATIAL_DISTANCE = 11;

    // Directions
    private static final int UP = 0;
    private static final int DOWN = 1;
    private static final int UPNDOWN = 2;

    private Vector lineVector = new Vector(50,50);
    private String outOfRange;
    private String fixations; // how to treat too short fixations
    private String blinks; // how to treat blinks
    private int tooShortFixation; // duration of a too short fixation
    private boolean readOn; //if fixationCounter is less than 3 read on
    private int fixationCounter;
    private String[] tempTokens = new String[20];
    private int max_parameters;


    public DataPooling(String oor,String fix,String bl,int tSF,int mp)
    {
	outOfRange=oor;
	tooShortFixation=tSF;
	fixations=fix;
	blinks=bl;
	readOn=true;
	fixationCounter=0;
	max_parameters=mp;
    }

    public void addNewLine(StringTokenizer tokenLine)
    {
	String[] tokens = new String[max_parameters];
	int i;
	for(i=0;i<tokens.length;i++) tokens[i]="unused";
	i=0;

	while (tokenLine.hasMoreTokens())
	    tokens[i++]=tokenLine.nextToken();
	lineVector.add(tokens);
	// System.out.print(fixationCounter+"|");
	if(tokens[DP_STARTMESSAGE].equals("EFIX")) fixationCounter++;
	if(fixationCounter==3) readOn=false;
    }

    public String[] getNextLine()
    {   // returns and deletes the first element
	// tempTokens=getLine(0);
	//if(tempTokens[DP_STARTMESSAGE].equals("EFIX"))
	if(getLine(0)[DP_STARTMESSAGE].equals("EFIX"))
	    {
		fixationCounter--;
		// System.out.print("_"+fixationCounter+"_");
		readOn=true;
	    }

	return (String[])lineVector.remove(0);
    }

    public String[] getLine(int number)
    {
	return (String[])lineVector.get(number);
    }

    // new 5/2005 for debugging
    public String showLine(int number)
    {
        String[] things = getLine(number);
        String result = "[ ";
        for (int i=0; i<things.length; i++)
	{
	    if (things[i].equals("unused")) break;
            result = result + things[i] + " ";
	}
        return (result + "]");
    }

    public int getSize() {return lineVector.size();}

    private void removeLine(int number)
    {
	if(getLine(number)[DP_STARTMESSAGE].equals("EFIX"))
	    {
		fixationCounter--;
		readOn=true;
	    }
	lineVector.remove(number);
    }

    private void replaceLine(int number,String[] replacement)
    {
	lineVector.set(number,replacement);
    }

    public boolean getReadOn()
    {
	if(fixationCounter<3) readOn=true;
	return readOn;
    }

    /* if eof is true then the end of the input file has been
       reached and there are less than 3 fixations in the set.
    */
    public int doDataPooling(boolean eof)
    {
	int j;
	int firstFixation = 0;
	int secondFixation = 0;
	int thirdFixation = getSize()-1;
	int firstDuration;
	int storeWriteUpTo = -1; // stores the linenr that is written up to

	/* two cases for fixations DONT ALTER
	   1: before EOF. Last line is a fixation and shouldn't be written
	   2: On EOF. all lines should be processed
	   applies only for fixations DONT ALTER. and return getSize().
	   in the switch below cases 0,1,2 mean that the eof has been reached
	   and all lines can be written
	*/
	if(fixations.equals("DONT ALTER") && (eof != true))
	    return (getSize()-1);
	if(fixations.equals("DONT ALTER"))
	    return getSize();

	/* dependant on how many fixations are left in the file */
	switch(fixationCounter)
	    {
	    case 0: return getSize();
	    case 1:
		firstDuration=Integer.parseInt(getLine(firstFixation)[DP_DURATION]);
		if(firstDuration<tooShortFixation)
		    if(fixations.equals("REMOVE") ||
		       fixations.equals("POOL REMOVE"))
			{
			    removeLine(firstFixation);
			    return getSize();
			}
		    else return getSize();
		else return getSize();
	    case 2:
		// find second fixation
		j=1;
		while(!getLine(j)[DP_STARTMESSAGE].equals("EFIX")) j++;
		secondFixation = j;

		// if first line isnt EFIX write up to this line
		// only happens at the beginning of the filtering process
		if(!getLine(0)[DP_STARTMESSAGE].equals("EFIX")) return secondFixation;

		storeWriteUpTo=poolDownward(firstFixation,secondFixation);
		// if first Fixation isnt short check second fixation
		if(storeWriteUpTo == -1)
		    storeWriteUpTo=poolDownward(secondFixation,firstFixation);
		// if secondFixation isnt short either write all
		if(storeWriteUpTo == -1) return getSize();
		return storeWriteUpTo;
	    case 3:
		// find second fixation
		j=1;
		while(!getLine(j)[DP_STARTMESSAGE].equals("EFIX")) j++;
		secondFixation = j;

		// if first line isnt EFIX write up to this line
		// only happens at the beginning of the filtering process
		if(!getLine(0)[DP_STARTMESSAGE].equals("EFIX")) return secondFixation;

		// see case 2
		storeWriteUpTo = poolDownward(firstFixation,secondFixation);
		if(storeWriteUpTo == -1)
		    storeWriteUpTo = poolUpward(secondFixation,firstFixation);
		/*-1 means its either not too short, or it didn't match and
		  Pool DONT ALTER.*/
		if(storeWriteUpTo == -1) return secondFixation;
		/* if storeWriteUpTo is -2, second is short and it is POOL REMOVE
		   ->test second with third and write nothing*/
		if(storeWriteUpTo == -2)
		    {
			poolDownward(secondFixation,thirdFixation);
			storeWriteUpTo = firstFixation;
		    }
		return storeWriteUpTo;
	    default:
		System.out.println("Runtime Error : "+fixationCounter);
		System.exit(1);
	    }

	return -1;
	// if(eof==false) return secondFixation; else return getSize();
    }

    /* checks forward(downward) : firstFixation->secondFixation or
       secondFixation->thridFixation
       returns the line number that can be written up to */
    private int poolDownward(int shortFixation,int toCheckFixation)
    {
	int shortDuration=Integer.parseInt(getLine(shortFixation)[DP_DURATION]);
	//int toCheckDuration=Integer.parseInt(getLine(toCheckFixation)[DP_DURATION]);
	if(shortDuration<tooShortFixation)
	    if(fixations.equals("REMOVE"))
		{
		    removeLine(shortFixation);
		    return toCheckFixation;
		}
	    else
		{
		    if(angleCalculation(shortFixation,toCheckFixation))
			{
			    mergeFixations(shortFixation,toCheckFixation);
			    return toCheckFixation;
			}
		    else
			{

/* *** */ if ( (shortDuration > (tooShortFixation/3)) && fixations.equals("POOL REMOVE"))
/* *** */	System.out.println("poolDownward REMOVE: " + showLine(shortFixation));

			    if(fixations.equals("POOL REMOVE"))
				{
				    removeLine(shortFixation);
				    return toCheckFixation;
				}
			    if(fixations.equals("POOL DONT ALTER"))
				return (-1); // test not necessary , but better readable
			}
		}
	return -1;
    }

    /* checking upward(backward).
       second -> first */
    private int poolUpward(int shortFixation,int toCheckFixation)
    {
	int shortDuration=Integer.parseInt(getLine(shortFixation)[DP_DURATION]);
	//int toCheckDuration=Integer.parseInt(getLine(toCheckFixation)[DP_DURATION]);
	if(shortDuration<tooShortFixation)
	    if(fixations.equals("REMOVE"))
		{
		    removeLine(shortFixation);
		    return toCheckFixation;
		}
	    else
		{
		    if(angleCalculation(shortFixation,toCheckFixation))
			{
			    mergeFixations(shortFixation,toCheckFixation);
			    return toCheckFixation;
			}
		    else
			{

/* *** */ if ( (shortDuration > (tooShortFixation/3)) && fixations.equals("POOL REMOVE"))
/* *** */	System.out.println("poolUpward REMOVE: " + showLine(shortFixation));

			if(fixations.equals("POOL REMOVE"))
			    return (-2); // another poolDownward-Test is necessary
			}
		}
	return -1;
    }

    /* test whether fixationA is within the spatial distance to
       fixationB -> true if yes , false if no */
    private boolean angleCalculation(int fixationA,int fixationB)
    {
	double fixationA_X = Double.parseDouble(getLine(fixationA)[DP_STARTING_X]);
	double fixationA_Y = Double.parseDouble(getLine(fixationA)[DP_STARTING_Y]);
	double fixationB_X = Double.parseDouble(getLine(fixationB)[DP_STARTING_X]);
	double fixationB_Y = Double.parseDouble(getLine(fixationB)[DP_STARTING_Y]);

	/* Manhattan distance would use:
	 *  if((Math.abs(fixationB_X-fixationA_X)<=SPATIAL_DISTANCE) &&
	 *  (Math.abs(fixationB_Y-fixationA_Y)<=SPATIAL_DISTANCE)) return true;
	 */
        double euclid_distance = Math.sqrt(Math.pow(fixationB_X-fixationA_X,2)
        				+Math.pow(fixationB_Y-fixationA_Y,2));

        if (euclid_distance<=SPATIAL_DISTANCE)
	    return true;
	return false;
    }

    /* merges two fixations or a fixation and a blink
       toMerge is the too short fixation or the blink
       toMerge is merged with mergeWith */
    private void mergeFixations(int toMerge,int mergeWith)
    {
	String[] line_ToMerge = getLine(toMerge);	// short one
	String[] line_MergeWith = getLine(mergeWith);	// normal one

	int toMerge_Duration = Integer.parseInt(line_ToMerge[DP_DURATION]);
	int toMerge_Onset = Integer.parseInt(line_ToMerge[DP_ONSET]);
	int mergeWith_Duration=Integer.parseInt(line_MergeWith[DP_DURATION]);
	int mergeWith_Offset=Integer.parseInt(line_MergeWith[DP_OFFSET]); // end
	int mergeWith_Onset=Integer.parseInt(line_MergeWith[DP_ONSET]); // start

        if (toMerge_Onset > mergeWith_Onset) { // short is after normal
// System.out.println("Merging: " + toMerge_Duration + "@" + toMerge_Onset +
// " after long " + mergeWith_Duration + "@" + mergeWith_Onset);
	    mergeWith_Offset += toMerge_Duration; // normal fixation ends later now
	    line_MergeWith[DP_OFFSET] = Integer.toString(mergeWith_Offset);
	} else { // *** short is BEFORE normal (added 5/2005 EA)
	    // DPI log files often contain far more merge-before than merge-after cases!
// System.out.println("Merging: " + toMerge_Duration + "@" + toMerge_Onset +
// " before long " + mergeWith_Duration + "@" + mergeWith_Onset);
	    mergeWith_Onset -= toMerge_Duration; // normal fixation starts earlier now
	    line_MergeWith[DP_ONSET] = Integer.toString(mergeWith_Onset);
	}

	mergeWith_Duration += toMerge_Duration;
	line_MergeWith[DP_DURATION] = Integer.toString(mergeWith_Duration);

	replaceLine(mergeWith,line_MergeWith);
	removeLine(toMerge);
    }

    /* Specs: DataPooling - Blinks */
    public int doBlinks(int storeWriteUpTo)
    {
	int lastEncounteredFixation=-1;

	for(int i=0;i<storeWriteUpTo;i++)
	    {
		if(getLine(i)[DP_STARTMESSAGE].equals("EFIX"))
		    {
			lastEncounteredFixation=i;
			// System.out.print(lastEncounteredFixation+"|");
			continue;
		    }
		if(!getLine(i)[DP_STARTMESSAGE].equals("EBLINK")) continue;
		if(blinks.equals("REMOVE"))
		    {
			removeLine(i);
			storeWriteUpTo--;
			i--;
			continue;
		    }
		// ADD(-1 means no previous fixation)
		switch(lastEncounteredFixation)
		    {
		    case (-1):
			removeLine(i);
			storeWriteUpTo--;
			i--;
			break;
		    default:
			mergeFixations(i,lastEncounteredFixation);
			storeWriteUpTo--;
			i--;
		    }
	    }
	return storeWriteUpTo;
    }

    /* Specs: Datapooling - Out of Range */
    public boolean doOutOfRange(int storeWriteUpTo)
    {
	int lastEncounteredFixation=-1;
	double starting_X;
	double starting_Y;
	boolean foundOOR = false; // was an out of range fix found ?
	int duration;

	for(int i=0;i<storeWriteUpTo;i++)
	    {
		if(getLine(i)[DP_STARTMESSAGE].equals("EFIX"))
		    {
// *** probably would be faster to check for 1st char being '-', but would
// *** it catch all relevant cases? By the way, why no "if too big" check?
			starting_X = Double.parseDouble(getLine(i)[DP_STARTING_X]);
			starting_Y = Double.parseDouble(getLine(i)[DP_STARTING_Y]);
			duration=Integer.parseInt(getLine(i)[DP_DURATION]);

			//if it is out of range
			if(starting_X<0.0 || starting_Y<0.0)
			    {   //remove it on remove
				if(outOfRange.equals("REMOVE"))
				{
				    removeLine(i);
				    storeWriteUpTo--;
				    i--;
				    foundOOR = true;
				    continue;
				}

				switch(lastEncounteredFixation)
				    { //if it is the first and it is too short remove it
				    case (-1):
					if(duration<tooShortFixation)
					    {
						removeLine(i);
						storeWriteUpTo--;
						i--;
						foundOOR = true;
						continue;
					    }
					else
					    {   // otherwise dont alter
						lastEncounteredFixation=i;
						continue;
					    }
				    default: //a previous fix exists so add it
					mergeFixations(i,lastEncounteredFixation);
					storeWriteUpTo--;
					i--;
					foundOOR = true;
				    }
			    }
			else //otherwise save position
			   lastEncounteredFixation=i;
		    }
	    }
	return foundOOR;
    }

} // class DataPooling

