/* ****** Fixations class ******************
   object representation of all fixations of an flt (output) file as
   well as the text objects (word position information) of the FLT...
*/

// import java.util.*;
import java.util.Hashtable;
import java.util.Vector;
import java.util.StringTokenizer;
// import java.io.*;

class Fixations
{
    private Vector fixations;
    private int current;

    public Fixations()
    {
	fixations = new Vector(100,200);
	current = -1;
        // maxLineNumber = 0;
        // maxCharacterNumber = 0;
    }

    public Vector getList(){ return fixations; }

    public Object getPrevious()
    {
        current--;
        return fixations.get(current);
    }

    public Object getNext()
    {
        current++;
        return fixations.get(current);
    }

    public FixationTrialID findTrial(String tr)
    {
        for(int i=0;i<fixations.size();i++)
        {
            Object tmp = fixations.get(i);
            if (tmp instanceof SingleFixation) continue;

            FixationTrialID temp = (FixationTrialID)tmp;
            if (temp.getName().equals(tr))
            {
                current=i;
                return temp;
            }
        }
        return null;
    }

    public boolean isFixation(Object tmp)
    {       //there are also TrialIds in the Vector
            if(tmp instanceof SingleFixation) return true;
            return false;
    }

    public boolean isNextFixation()
    {
            if(current+1>=fixations.size()) return false;
            Object tmp = fixations.get(current+1);
            if(tmp instanceof SingleFixation) return true;
            return false;
    }

    public boolean isPriorFixation()
    {
            if(current-1<=0) return false;
            Object tmp = fixations.get(current-1);
            if(tmp instanceof SingleFixation) return true;
            return false;
    }

    // removed handling of ab / bel arguments (above / below "boxtolerance")
    // 5/2005 - instead, boxtolerance now modifies INFO WORD coordinates in
    // AscFilter when creating FLT files... - EA 5/2005
    public Hashtable acquire(String outputString)
    {
	int maxLineNumber = 0;
	// private int maxCharacterNumber;

	Hashtable toc = new Hashtable(); // *&*&* DPI 
        TextObjectCollection currentTOC = new TextObjectCollection();
        StringTokenizer tokenText = new StringTokenizer(outputString,"\n");

        while(tokenText.hasMoreTokens())
        {
            String line = tokenText.nextToken();
            int length = line.length();
            maxLineNumber++;
            StringTokenizer tokenLine= new StringTokenizer(line);

            while(tokenLine.hasMoreTokens())
            {
                String token = tokenLine.nextToken();

                if(token.equals("MSG"))
                {
                    token = tokenLine.nextToken(); // skip over timestamp
                    token = tokenLine.nextToken();
                    if(token.equals("TRIALID"))
                    {
                        token = tokenLine.nextToken();
                        fixations.add(new FixationTrialID(maxLineNumber,
                            // maxCharacterNumber+1,
                            // maxCharacterNumber+length,
                            token));
                        // *&*&* DPI
                        toc.put(token,currentTOC=new TextObjectCollection());
                    } // TRIALID

                    if(token.equals("MOUSECLICK"))
                    {
                        token = tokenLine.nextToken(); // skip over timestamp
                        token = tokenLine.nextToken(); // x-coord
			String token1 = tokenLine.nextToken(); // y-coord
			String token2 = tokenLine.nextToken(); // HIT or MISS
                        fixations.add(new SingleFixation(maxLineNumber,
                                      // maxCharacterNumber+1,
                                      // maxCharacterNumber+length,
                                      Integer.parseInt(token),
                                      Integer.parseInt(token1),
                                      token2));
			// mouseclicks have no duration or end-time
			// and usually no word name / number / length,
			// but can have a color - which is ignored here
                    } // MOUSECLICK

                    // *&*&* DPI
                    if(token.equals("INFO"))
                    {
                        token = tokenLine.nextToken();
			if (token.equals("WORD")) {
                            token = tokenLine.nextToken(); // !!! skip word number
                            currentTOC.addItem(Integer.parseInt(tokenLine.nextToken()),
                                           Integer.parseInt(tokenLine.nextToken()),
                                               // no longer "-(int)ab" (5/2005)
                                           Integer.parseInt(tokenLine.nextToken()),
                                           Integer.parseInt(tokenLine.nextToken()),
                                               // no longer "+(int)bel" (5/2005)
                                           tokenLine.nextToken());
                            // used: Xmin Ymin Xmax Ymax text
                            currentTOC.addSpaces();
                        } else {
                            System.out.println("INFO but not INFO WORD? Line: " + line);
			}
                    } // INFO
                    // maxCharacterNumber+=length;
		    // maxCharacterNumber++;	// *** must count \n - fixed 5/2005
                    break;
                } // MSG

                if (token.equals("EFIX"))
                {
                    token = tokenLine.nextToken(); // !!! skip start-time
                    token = tokenLine.nextToken(); // !!! skip end-time
                    token = tokenLine.nextToken(); // !!! skip duration
                    token = tokenLine.nextToken(); // X
                    String token1 = tokenLine.nextToken(); // Y
                    fixations.add(new SingleFixation(maxLineNumber,
                                      // maxCharacterNumber+1,
                                      // maxCharacterNumber+length,
                                      (int)Math.round(Double.parseDouble(token)),
                                      (int)Math.round(Double.parseDouble(token1)),
				      "NONE"));
                    // last tokens on line are ignored: color number or word number,
                    // and finally color name or word length
                } // EFIX

                // maxCharacterNumber+=length;
		// maxCharacterNumber++;	// *** must count \n - fixed 5/2005
                break;
            } // while
        } // while
        fixations.trimToSize();
        // print(); was: print all
        return toc;
    }

    public void correctFixation(String trialid,int cX, int cY)
    {
       	int dummy = current;
       	findTrial(trialid);

       	while(current<fixations.size())
       	{
            SingleFixation temp = (SingleFixation)getNext();
            // System.out.println(""+temp.getX()+"|"+temp.getY());
            temp.setCorrectionX(cX);
            temp.setCorrectionY(cY);
            // System.out.println(""+temp.getX()+"/"+temp.getY());
            if(!isNextFixation()) break;
        }
        current=dummy;
    }

    public void printTrial(String trialid) // print only 1 trial
    {	// based on previous version "print()" which printed all trials
	boolean printing = false;
	int fixNr = -99;
        for(int i=0;i<fixations.size();i++)
        {
            Object tmp = fixations.get(i);
            if((tmp instanceof SingleFixation) && (printing))
            {
                SingleFixation temp = (SingleFixation)tmp;
                System.out.println(" #" + fixNr + "\t" +
                    temp.getX()+ "\t" +
                    temp.getY()+ "\t" +
                    temp.getLineNumber()+ "\t" +
                    // temp.getCharacterLineNumber() + " / " +
                    temp.getMouseclick());
		fixNr++;
            }
            if(tmp instanceof FixationTrialID)
            {
                FixationTrialID temp = (FixationTrialID)tmp;
	        if (printing)
		{
		    printing = false;
		    System.out.println("--- end " + trialid + " ---");
		    continue;
		}
		if (temp.getName().equals(trialid))
		{
		    printing = true;
                    System.out.println("Trial: " + temp.getName() +
			", line: " + temp.getLineNumber());
                        // + " / " + temp.getCharacterLineNumber());
		    System.out.println("number\tX\tY\tline\tmouse");
		    fixNr = 1;
	        }
            } // trialid
        } // for
    } // printTrial

} // class Fixations



/* *******************************************************************
   ************************   Class SingleFixation   *****************
   ******************************************************************* */
// added 01/08/03 Mouseclick Trials 
   
class SingleFixation
{
	private int lineNumber;
	// private int characterNumberToThisLine;
	// private int characterNumberEndOfThisLine;
	private int x;
	private int y;
	private String mouseclick; // NONE, HIT or MISS

	public SingleFixation()
	{
		x=-1;
		y=-1;
		lineNumber=-1;
	        // characterNumberToThisLine=-1;
        	// characterNumberEndOfThisLine=-1;
		mouseclick = new String("NONE");
	}

	// arguments: line number, X, Y, mouseclick
	public SingleFixation(int n, int tx, int ty, String mc)
	{
		lineNumber=n;
	        // characterNumberToThisLine=c;
        	// characterNumberEndOfThisLine=e;
		x=tx;
		y=ty;
		mouseclick=mc;
	}

	public void setX(int tx){ x=tx; }

	public void setY(int ty){ y=ty; }

        public void setCorrectionX(int tx)
	{
		if(mouseclick.equals("NONE")) x+=tx;
	}

	public void setCorrectionY(int ty)
	{
        	if(mouseclick.equals("NONE")) y+=ty;
	}

	public int getX(){ return x; }

	public int getY(){ return y; }

	public int getLineNumber(){ return lineNumber; }

	// public int getCharacterLineNumber()
        // { return characterNumberToThisLine; }

	// public int getCharacterEndNumber()
        // { return characterNumberEndOfThisLine; }

	public String getMouseclick() { return mouseclick; }
} // class SingleFixation


/* *******************************************************************
   ***********************   Class FixationTrialID   *****************
   ******************************************************************* */

class FixationTrialID
{
	private String name;
	private int lineNumber;
	// private int characterNumberToThisLine;
	// private int characterNumberEndOfThisLine;

	public FixationTrialID(int n, String na)
	{
		name=na;
		lineNumber=n;
	        // characterNumberToThisLine=c;
        	// characterNumberEndOfThisLine=e;
	}

	public String getName(){ return name; }

	public int getLineNumber(){ return lineNumber; }

	// public int getCharacterLineNumber()
        // { return characterNumberToThisLine; }

	// public int getCharacterEndNumber()
        // { return characterNumberEndOfThisLine; }

} // class FixationTrialID
