import java.awt.image.*;
import java.awt.*;
import java.io.*;


public class ImageLoader
{
    
    /**
        load method - see read for details
        
        Arguments:
            sdir and sfile are the result of the FileDialog()
            getDirectory() and getFile() methods.

        Returns:
            Image Object, be sure to check for (Image)null !!!!

    */
    public static Image  load(String sdir, String sfile) {
		return(load(sdir + sfile));
	}

 
	    /**
        load method - see read for details
        
        Arguments:
            sdir - full path name

        Returns:
            Image Object, be sure to check for (Image)null !!!!

    */
    public static Image  load(String sdir) 
    {
	Image img;
	if (sdir.toLowerCase().endsWith(".pcx")) {
	    img = PCXLoader.load(sdir);
	} else if (sdir.toLowerCase().endsWith(".bmp")) {
	    img = BMPLoader.load(sdir);
	} else {
            // BufferedImage read ImageInputStream stream
	    try { // *** javax.imageio requires Java 1.4 or newer ***

		BufferedImage bi;

/* *** the tedious style would be:
 *		    //  FileImageInputStream is a subclass of ImageInputStream
 *		ImageReader ir = new javax.imageio.ImageReader(null);	// null: just files
 *		BufferedImage bi;	// subclass of java.awt.Image
 *		ir.setInput(fiis);	// any ImageInputStream
 *		bi = ir.read(0);	// 0 is the image index for animations
 *		fiis.close();
*** */

// Short version:	bi = javax.imageio.ImageIO.read(new File(sdir));
// Version which compiles on older Java versions:

		try {
			Class imageio = Class.forName("javax.imageio.ImageIO");
			Class[] argtypes = new Class[1];
			argtypes[0] = Class.forName("java.io.File");
			java.lang.reflect.Method read = imageio.getMethod("read", argtypes);
			Object[] args = new Object[1];
			args[0] = new File(sdir);
			bi = (BufferedImage)read.invoke(null, args);
		} catch (ClassNotFoundException e) {
			System.out.println("Java 1.4 needed to load image: " + sdir);
			return null;
		} // NoSuchMethodException SecurityException IllegalAccessException
		  // IllegalArgumentException InvocationTargetException...

		return (Image)bi;

/* *** compiler cannot know that those are thrown when we dynamically load classes:
	    } catch (FileNotFoundException fnfe) {
		System.err.println("Image file not found: " + sdir);
		return null;
	    } catch (IOException ioe) {
		System.err.println("Cannot read image file: " + sdir);
		return null;
*** */
	    } catch (Exception e) {
		System.err.println("Error processing image: " + sdir);
		System.err.println("Exception " + e.getMessage() + ": " + e);
		// could also printStackTrace
		return null;
	    }
	}
	return img;
    }

} // end class ImageLoader

