/* class TrialIDWindow
   displays a window containing all trial IDs of a trial
   selecting one lets you choose the image that is displayed
   in the imageview window
*/

import java.awt.*;
import javax.swing.*;
// import java.awt.event.*; 
import java.awt.event.ActionEvent;
// import java.awt.image.*;
// import javax.swing.event.*;
// import java.io.*;
import java.io.IOException;
// import java.util.*;
import java.util.Vector;

class TrialIDWindow extends JFrame implements java.awt.event.ActionListener
{
    private int PROGRAMWIDTH;
    // height is being calculated
    private int PROGRAMHEIGHT;
    private String title;

    private Vector trialIDs;
    private VisualizeImage imageViewWindow;
    private MasterScripts masterScripts;
    private DataSharing dsi;
    private FilterGUI gui;

    private JPanel panelRadiobuttons = new JPanel();
    private JScrollPane scrolledPanelRadiobuttons;
    private JRadioButton[] radiobutton;
    private ButtonGroup buttonGroup = new ButtonGroup();

    private JLabel label;

    private int currentTextPosition;

    public TrialIDWindow()
    {
    }

    public TrialIDWindow(Vector ti,String t,VisualizeImage vi,
			MasterScripts ms,DataSharing d,FilterGUI g)
    {
		imageViewWindow=vi;
		masterScripts=ms;
		gui = g;
		dsi=d;
        	
        	String[] temp = dsi.getItemsOfInterest();
        	trialIDs = new Vector(30,50);
        	for(int i=0;i<temp.length;i++)
        	{
            	if(temp[i].equals("unused")) break;
            	if(temp[i].equals("ALL"))
            	{
                	trialIDs=ti;
                	break;
            	}
            	trialIDs.add(temp[i]);
        	}
        	trialIDs.trimToSize();
        	
		title=t;
		currentTextPosition=0;
		initComponents();
		if(radiobutton.length>0)
		{
			try
			{
				changeTrialID(radiobutton[0].getText());
			}
			catch(IOException e)
			{
				System.out.println("Error during changeTrialID");
			}
		}
    }

    //initializes the form
    public void initComponents()
    {
    	setTitle(title);
		label = new JLabel(title+":");
		radiobutton = new JRadioButton[trialIDs.size()];

		getContentPane().setLayout(new BorderLayout());
		getContentPane().add(label,"North");
		panelRadiobuttons.setLayout(new GridLayout(trialIDs.size(),1,10,0));
		setRadioButtons(panelRadiobuttons,buttonGroup);
		scrolledPanelRadiobuttons = new JScrollPane(panelRadiobuttons);
        	scrolledPanelRadiobuttons.setHorizontalScrollBarPolicy
	    	(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
		getContentPane().add(scrolledPanelRadiobuttons,"Center");
		//getContentPane().add(panelRadiobuttons,"Center");

        	addWindowListener(new java.awt.event.WindowAdapter()
	    	{
			public void windowClosing(java.awt.event.WindowEvent evt)
			{
		    	exitForm(evt);
			}
	    	}
			  	);
		SystemAdjustment sysAdj = new SystemAdjustment();
		sysAdj.setDimension(getContentPane());
		PROGRAMWIDTH=sysAdj.getWidth();
		PROGRAMHEIGHT=300;
		Toolkit tk = Toolkit.getDefaultToolkit();
		Dimension d=tk.getScreenSize();
		int screenHeight = d.height;
		int screenWidth = d.width;
		if(PROGRAMWIDTH>screenWidth) PROGRAMWIDTH=screenWidth;
		// resize and move to x y w h:
		setBounds((screenWidth-PROGRAMWIDTH),100,	// was: ,1
		  	PROGRAMWIDTH,PROGRAMHEIGHT);
		// WHY ONLY SUN? if(sysAdj.getSystem().startsWith("Sun")) pack();
		// WHY NOT? // if(sysAdj.getSystem().startsWith("Mac")) pack();
		// *** problem is that "resize as wanted" (pack()) can mean
		// *** "higher than screen". Disabling pack() for this reason.
		// *** pack();
    }

    private JButton addButton(Container c,String s,boolean add)
    {
		JButton b = new JButton(s);
		if(add) c.add(b);
		b.addActionListener(this);
		return b;
    }

    private JRadioButton addRadioButton(JPanel buttonPanel,
					ButtonGroup g,
					String buttonName,
					boolean v)
    {
		JRadioButton button = new JRadioButton(buttonName,v);
		button.addActionListener(this);
		g.add(button);
		buttonPanel.add(button);
		button.setActionCommand(buttonName);
		return button;
    }

    private void setRadioButtons(JPanel p,ButtonGroup bg)
    {
	
        for(int i = 0; i<trialIDs.size();i++)
			radiobutton[i] = addRadioButton(p,bg,(String)trialIDs.get(i),false);     
		if(radiobutton.length>0) radiobutton[0].setSelected(true);
    }

    // handles GUI events
    public void actionPerformed(ActionEvent evt)
    {
		Object source = evt.getSource();
		String arg = evt.getActionCommand();

		if(evt.getSource() instanceof JRadioButton)
		{
			try
			{
				changeTrialID(arg);
                toFront();
			}
			catch(IOException e)
			{
				System.out.println("Could not change TrialID");
			}
		}
    }

   // what happens when a new trial has been selected
   public void changeTrialID(String trialid) throws IOException
   {
        if(masterScripts!=null)
        {
            //if it is an image trial open imageviewwindow
            if(masterScripts.checkMasterScriptDatabase(trialid))
            {
                if(imageViewWindow==null)
                {
                    //is it being called the first time
                    imageViewWindow=
                            new VisualizeImage(masterScripts.getScriptPath(0),
                            masterScripts.getTemplate_Name(),gui,dsi,trialid,
                            masterScripts.getCurrentOffset());
                }
                else
                {
                    imageViewWindow.setImage(masterScripts.getScriptPath(0),
                            masterScripts.getTemplate_Name(),trialid,
                            masterScripts.getCurrentOffset());
                }
                // moveToPosition_OutputWindow(trialid);
                imageViewWindow.setVisible(true);
            }
        }
        // else moveToPosition_OutputWindow(trialid);
    }
    
    public VisualizeImage getImageViewWindow(){return imageViewWindow;}
    public void setImageViewWindow(VisualizeImage vi){imageViewWindow=vi;}
    
/* *** seems to be unused
 *  // moves the cursor to the chosen trial in the output window of the gui
 *  private void moveToPosition_OutputWindow(String trialid)
 *  {
 *  	if(dsi.getBackupTextAreaOutput().equals("to be created")) return;
 *		gui.showTab("OUTPUT");
 *		gui.erasePreviousLinePointer(dsi.getBackupTextAreaOutput(),currentTextPosition);
 *		int findTrial = dsi.getBackupTextAreaOutput().indexOf(trialid);
 *		int i= gui.countRows(dsi.getBackupTextAreaOutput(),
 *					findTrial);
 *		// this is an odd behavior of jtextarea
 *		// if i go up in the text it is displayed at the top of the area
 *		// if i go down it is displayed at the bottom.
 *
 *		// if(i>currentTextPosition) gui.goToPosition(i);
 *		// else gui.goToPosition(findTrial);
 *
 *		gui.setPointer(dsi.getBackupTextAreaOutput(),findTrial);
 *		gui.goToPosition(findTrial);
 *		currentTextPosition = findTrial;
 *	}
*** */

    	private void exitForm(java.awt.event.WindowEvent evt)
    	{
    		setVisible(false);
    	}
}
