/*
This class transforms an Image into a PixelGrabber and then
extracts the color from a given pixel

EA 5/2005: removed lots of unused stuff, optimized var scopes, fixed offset
*/

import java.awt.*;
import java.awt.image.*;
// import javax.swing.*;
// import java.io.*; (IOException when loading an image)


// *** ... "extends JFrame" was unused - EA 5/2005: only need a ImageObserver
class TrialItemImage
{
    private String path;
    private String fileName;
    private int width, height;
    private int imageWidth, imageHeight;
    private int offset;
    private int pixels[];
    private Point bestWiggle;	// new 5/2005

    // private Image image; - now local to setImage - 5/2005 EA
    // private PixelGrabber grabber; - now local to setImage - 5/2005 EA
    // private Point imagePos; - now local to setImage - 5/2005 EA
    
    public TrialItemImage()
    {
	// image = null;
        // imagePos= new Point();
	bestWiggle = new Point();
	path = "";
	fileName = "";
	width = 0;
	height = 0;
        offset = 0;
	pixels = null;
    }

    public TrialItemImage(String p, String f,int w,int h,int offs)
    {
	path = p;
	fileName = f;
	width = w;
	height = h;
        offset = offs;
	pixels = null;
	bestWiggle = new Point();
	try
	    {
		setImage();	// load image and create pixels array
	    }
	catch (java.io.IOException e)
	    {
		System.out.println("TrialItemImage(" + p + ", " + f + "," +
		    w + ", " + h + ", " + offs + ") failed!");
		pixels = null;
	    }
	if (pixels == null) {
	    width = 0;
	    height = 0;
	}
    }

    public void setImage() throws java.io.IOException
    {

	// instead of extending a JFrame we now 5/2005 just use ImageObserver
	// as needed by various "doSomethingWithImage(...,this)" constructs.
	// image observers can do imageUpdate(...) which decides whether enough
	// information is known about an image to be able to use it for sth.!
	// arguments: image, x y w h and flags which tell what is needed...
	// Components are actually not very minimal at all, but still...
	Canvas anyObserver = new Canvas();	// minimal ImageObserver
        anyObserver.setEnabled(false);		// strip down
        anyObserver.setVisible(false);		// strip down

     	Image image = ImageLoader.load(path + fileName);
	if (image == null)
	    {
		System.out.println("TrialItemImage.setImage could not load " + path + fileName);
		return;
	    }
	imageWidth = image.getWidth(anyObserver);
	imageHeight = image.getHeight(anyObserver);
        
        // DPI: create canvas of display size
        
        BufferedImage myBufferedImage = new BufferedImage(width, height,
                                                    BufferedImage.TYPE_INT_RGB);
        // *** must treat offset in DPI style here! fixed 5/2005 - EA
	// *** same formula is used in VisualizeImage.
        Point imagePos = new Point();
        imagePos.x = (width-imageWidth) / 2;
        // *** was wrong: imagePos.y = height-(imageHeight-offset);
        if (offset < 0) {		// e.g. -5 is "5 pixels from bottom"
	    imagePos.y = (height - imageHeight) + offset;
	} else {
            imagePos.y = offset;	// fixed to DPI style 5/2005
	}
        Graphics2D myGraphics2D = myBufferedImage.createGraphics();
        myGraphics2D.drawImage(image, imagePos.x, imagePos.y, anyObserver);
	image.flush();
        
	// re-use the image object as "image of the canvas" now:
        image = myBufferedImage; // just a typecast at the moment
	// this somehow saves RAM compared to using (Image)myBufferedImage
	// in the new PixelGrabber(...) line. Interesting.
	myBufferedImage.flush();
        
	pixels = new int[width*height];	// pixel array of display size

	PixelGrabber grabber = new PixelGrabber(image,
	    0, 0, width, height, pixels, 0, width);
	try
	    {
		grabber.grabPixels(); // this takes quite a bit of CPU :-(
	    }
	catch(InterruptedException e)
	    {
		System.err.println("Error getting pixels");
		pixels = null;
	    }
	image.flush();
	myGraphics2D.dispose(); // grabber will just fall out of scope, too
    }

    // Take care: IF we used this as JFrame, THEN the next 2 methods would
    // override the Java Swing idea of the size of the paint area... Anyway,
    // we use getWidth and getHeight for completely GUI unrelated things now.
    public int getWidth(){ return width; }
    public int getHeight(){ return height; }

    public Point getBestWiggle() { return bestWiggle; } // new 5/2005

    // new 5/2005 EA: search adjacent areas to find non-background pixel
    public int getRegionnumberWiggle(int x, int y, int radius, int background)
    {
	int best = background;
	bestWiggle.x = -1;	// default point was the one (or "the none"...)
	bestWiggle.y = -1;

	int rn = getRegionnumber(x,y);
	if ((rn != background) || (radius < 1)) return rn;

	if (radius > 3) { // recurse if big radius: inner part first
		rn = getRegionnumberWiggle(x, y, radius-4, background);
	    if (rn != background) return rn;
	}

	int diag = (int)Math.round( (1.0f/Math.sqrt(2)) * radius);
	int xList[] = {x-radius, x+radius, x, x, x-diag, x+diag, x-diag, x+diag};
	int yList[] = {y, y, y-radius, y+radius, y-diag, y-diag, y+diag, y+diag};

        for (int i = 0; i < xList.length; i++) {
	    rn = getRegionnumber(xList[i], yList[i]);
	    if ((rn != background) && (best != background) && (best != rn)) {
		// bestWiggle.x = -1; bestWiggle.y = -1;
		return background;	// undecided
	    }
	    if (rn != background) {
		best = rn;
		bestWiggle.x = xList[i];	// non-default point is the one!
		bestWiggle.y = yList[i];
	    }
	} // for

	return best;
    }

    public int getRegionnumber(int x, int y)
    {
	if (x<0 || y<0 || x>=width || y>=height) return 0;
        int pixel = pixels[y*width+x];
	// int alpha = (pixel >> 24) & 0xff;
	int red = (pixel >> 16) & 0xff;
	int green = (pixel >> 8) & 0xff;
	int blue = (pixel) & 0xff;

	// regionnumbers are 3 bytes shift right scaled (>> 6)
	// each rgb part is an int 0-3 (2 high bits of 0-255 intensity)
	return (16 * (blue >> 6) + 4 * (green >> 6) + (red >> 6));
    }

    // returns a String for a given regionnumber
    public String getColorName(int rn) // simplified 5/2005 - EA
    {
	// regionnumber bits: bbggrr   reduced bits: bgr
        switch (rn) {
            case 0: return "black";	// shortcut...
            case 63: return "white";	// shortcut...
            case 21: return "grey";	// dark grey
            case 42: return "grey";	// light grey
            case 34: return "violet";	// dark magenta
            case 10: return "brown";	// dark yellow
            // no special names for dark cyan / red / green / blue yet
	}

	// andrea would call dark / less-blue cyan "green" and
	// would call "2/3 red plus 1/3 green" "black"...?
	// we *now* call that "cyan" and "red"...!
        int reduced = ((rn & 2) >> (1-0)) | ((rn & 8) >> (3-1)) | ((rn & 32) >> (5-2));
	// now we have rrggbb --> rgb bits
	// System.out.println("Region Number: " + rn + " ---> " + reduced);
        switch (reduced) {
           case 0: return "black";
           case 1: return "red";
           case 2: return "green";
           case 3: return "yellow";
           case 4: return "blue";
           case 5: return "pink";	// magenta
           case 6: return "turquoise";	// cyan
	   case 7: return "white";
        }
        return "unknown";
    }

}

