// Adjust the new Trackeroutputfile to the conventions of the old tracker output
// In other words: Convert a DPI logfile to SMI logfile style, basically
// just shuffling the FIXATION event columns around and prefixing MSG to all
// non-FIXATION lines. FIXATION events are called EFIX after conversion.

import java.io.*;
import java.util.StringTokenizer;
// import javax.swing.*;

public class AdjustInFile 
{

//    public AdjustInFile() { }
    
    public static File doAdjust(File old) throws IOException
    {
        BufferedReader in = new BufferedReader(new FileReader(old));
        String path = old.getCanonicalFile().getCanonicalPath();
	// File must keep same directory and basename, as other filter
	// parts create output file names by replacing the extension!
        String output = path.substring(0,path.length()-4)+".tmp";
        File outFile = new File(output);
        PrintWriter out = new PrintWriter(new FileWriter(outFile));
    	String line = new String("");
        int i=0;

        while ((line = in.readLine()) != null)
	{
            if(line.equals("")) continue; // remove empty lines
            if(line.indexOf("FIXATION")!=-1)
            {
                i=1;
                StringTokenizer tokenLine= new StringTokenizer(line);
                String[] tokens = new String[6];
                tokens[0]="EFIX  ";
                while(tokenLine.hasMoreTokens())
                {    
                    String token = tokenLine.nextToken();
                    if(i==1) tokens[2]=token; // offset time (!)
                    // FIXATION keyword gets erased
                    if(i==3) tokens[4]=token; // x
                    if(i==4) tokens[5]=token; // y
                    if(i==5) tokens[1]=token; // onset time (!)
                    if(i==6) tokens[3]=token; // duration
                    i++;
                }
		// *** could strip leading 00s from offset and
		// *** could add leading 00s to onset for nice layout
                for(int x=0;x<6;x++)
                   out.print(tokens[x]+" ");
                out.println("");
                
                continue; // done with this line
            }
            out.println("MSG   " + line); // prefix line with "MSG"
        }
        
        out.close();
        return outFile;
    }
    
/* *** used to be applied to MSG lines, but is not needed... - EA 5/2005
    // remove unwanted Bracket before offset
    private String removeBracket(String s)
    {
        if(s.startsWith("(")) s=s.substring(1);
        
        return s;
    }
*** */
    
}
