
import java.io.*;
// import java.util.*;
import java.util.StringTokenizer;
import java.util.Vector;
// import javax.swing.*; (progress bar JPanel / JProgressBar, and a JTextArea)
// import java.awt.*; (DPI displaysize Point)

/* Set between the GUI (FilterGUI) and the actual filter (AscFilter),
   DataSharing conducts the exchange of variables.
*/

class DataSharing
{
    private BufferedReader inFile;
    private PrintWriter outFile;
    private PrintWriter logFile;
    private File inBackup;// File-Object of InputFile
    private File outBackup;
    private File logBackup;
	private String outFileName;
	private String logFileName;
    // private boolean skip; // flag : is an item to be skipped (Filtering IV)
    private String channel; // Specs: Filtering III (L,R,BOTH)
    private String dataOfInterest; //Specs: Filtering II (EFIX; ESACC; BOTH; NONE)
    private String[] itemsOfInterest; // Specs: Filtering IV
    private String[] messageFrames; // Specs: Filtering I
    // TrackerMessages = non-MSG messages that are handled in messageFrames[]
    private String[] trackerMessages; //Specs:Filtering I
    private String fromMessageFrame; //Specs: Filtering I
    private String toMessageFrame;
    // private boolean skip_MessageFrames; // flag: True = outside a messageframe (Filtering I)
    private String timeSettingStart; // Specs: TimeSetting
    // private int timeSetting; // Specs: Time setting (-1 default)
    // private TrialItemCollection trialItems = new TrialItemCollection(); // Specs: Merging
    private double toleranceAbove; // Includes space above and below text boxes
    private double toleranceBelow;
    // private DataPooling dataPool; // Specs: Data pooling
    private String fixations; // SPECS: Data pooling -> How to treat too short fixations
    private String blinks; // SPECS: Data pooling -> How to treat blinks(DONT ALTER, ADD, REMOVE)
    private int tooShortFixation; // Specs: duration of a too short fixation
    private String outOfRange; // Specs: Data Pooling -> how to treat out of range fixations
    private int max_messages;
    private int max_itemsofinterest;
    private int max_parameters;
    private boolean pupilSize;
	private boolean wordSetToZero; // noun Set To Zero time (specified in the MasterScripts)

    // data shared with Dialog Boxes
    private boolean timeSettingDialog; // was Dialog canceled or did it end on ok(Back)
    private boolean messageFramesDialog;
    private boolean itemsOfInterestDialog;

    // scanned data from file
    private Vector scannedItemsOfInterest;
    private String scannedChannel;
    private Vector scannedMessageFrames;
    private Vector scannedTrackerMessages;

    // backup of the textareas (ouput,input and log)
    private String backupTextArea_Output;
    private String backupTextArea_Input;
    private String backupTextArea_Log;

    // the progressbar (uses javax.swing GUI)
    private int lineCount;
    private javax.swing.JProgressBar bar;
    private int progressBarCurrent;
    private javax.swing.JPanel panel;
    
    // DPI
    public java.awt.Point displaySize;
    
    private boolean abortedTrialFound;

    // constructor for parameters not given (default)
    public DataSharing(int max_mes,int max_ioi,int max_p)
    {
		max_messages = max_mes;
		max_itemsofinterest = max_ioi;
		max_parameters=max_p;
		itemsOfInterest = new String[max_itemsofinterest];
		messageFrames = new String[max_messages];
		trackerMessages = new String[max_messages];
		//skip=false;
		channel="NS";
		dataOfInterest="BOTH";
		for(int i=0;i<max_messages;i++) messageFrames[i] = "unused";
		for(int i=0;i<max_messages;i++) trackerMessages[i] = "unused";
		messageFrames[0]="ALL";
		trackerMessages[0]="ALL";
		fromMessageFrame="NS";
		toMessageFrame="NS";
		//skip_MessageFrames=false;
		for(int i=0;i<max_itemsofinterest;i++) itemsOfInterest[i] = "unused";
		itemsOfInterest[0]="ALL";
		//timeSetting=-1;
		timeSettingStart="NS";
		toleranceAbove=0;
		toleranceBelow=0;
		fixations="DONT ALTER";
		blinks="DONT ALTER";
		tooShortFixation=100;
		outOfRange="DONT ALTER";
		pupilSize = true;
		wordSetToZero = false;

		timeSettingDialog=false; // radiobutton is set to 'no'
		messageFramesDialog=false;
		itemsOfInterestDialog=false;

		scannedItemsOfInterest = new Vector(20,50);
       	scannedMessageFrames = new Vector(20,50);
       	scannedTrackerMessages = new Vector(10,50);
		scannedChannel = new String("NS");

		backupTextArea_Output = new String("to be created");
		backupTextArea_Input = new String("choose an input file");
		backupTextArea_Log = new String("to be created");

		lineCount=0;
		progressBarCurrent=0;
		
		outFileName= new String("NS");
		logFileName= new String("NS");
		
		abortedTrialFound = false;
                
                displaySize=new java.awt.Point();
    }

    public void setInFile(File in) throws IOException
    {
	inBackup = in;
	inFile=new BufferedReader(new FileReader(in));
    }
    public void setOutFile(File out) throws IOException
    {
		outBackup = out;
		outFile=new PrintWriter(new FileWriter(out));
    }
    public void setLogFile(File log) throws IOException
    {
		logBackup= log;
		logFile=new PrintWriter(new FileWriter(log));			
    }
    public void setChannel(String ch) {channel=ch;}
    public void setDataOfInterest(String doi) {dataOfInterest=doi;}
    public void setTimeSettingStart(String tss) {timeSettingStart=tss;}
    public void setToleranceAbove(double ta) {toleranceAbove=ta;}
    public void setToleranceBelow(double tb) {toleranceBelow=tb;}
    public void setFixations(String f) {fixations=f;}
    public void setBlinks(String b) {blinks=b;}
    public void setTooShortFixation(int tsf) {tooShortFixation=tsf;}
    //possibel error due referencing, maybe arraycopy
    public void setItemsOfInterest(String[] ioi) {itemsOfInterest=ioi;}
    public void setMessageFrames(String[] mf) {messageFrames=mf;}
    public void setTrackerMessages(String [] tm) {trackerMessages=tm;}
    public void setFromMessageFrame(String from) {fromMessageFrame=from;}
    public void setToMessageFrame(String to) {toMessageFrame=to;}
    public void setOutOfRange(String oor) {outOfRange=oor;}
    public void setPupilSize(boolean ps) {pupilSize=ps;}
    public void setWordSetToZero(boolean wstz) {wordSetToZero=wstz;}
	
    public void setTimeSettingDialog(boolean ok) {timeSettingDialog=ok;}
    public void setMessageFramesDialog(boolean ok) {messageFramesDialog=ok;}
    public void setItemsOfInterestDialog(boolean ok) {itemsOfInterestDialog=ok;}

    public void setBackupTextAreaOutput(String ta) {backupTextArea_Output=ta;}
    public void setBackupTextAreaInput(String ta) {backupTextArea_Input=ta;}
    public void setBackupTextAreaLog(String ta) {backupTextArea_Log=ta;}
    public void setOutBackup(File f) {outBackup=f;}
    
	public void setAbortedTrialFound() {abortedTrialFound=true;} 

    public BufferedReader getInFile() {return inFile;}
    public PrintWriter getOutFile() {return outFile;}
    public PrintWriter getLogFile() {return logFile;}
    public File getInBackup() {return inBackup;}
    public File getOutBackup() {return outBackup;}
    public File getLogBackup() {return logBackup;}
    public String getChannel() {return channel;}
    public String getDataOfInterest() {return dataOfInterest;}
    public String getTimeSettingStart() {return timeSettingStart;}
    public double getToleranceAbove() {return toleranceAbove;}
    public double getToleranceBelow() {return toleranceBelow;}
    public String getFixations() {return fixations;}
    public String getBlinks() {return blinks;}
    public int getTooShortFixation() {return tooShortFixation;}
    public String[] getItemsOfInterest() {return itemsOfInterest;}
    public String[] getMessageFrames() {return messageFrames;}
    public String[] getTrackerMessages() {return trackerMessages;}
    public String getFromMessageFrame(){return fromMessageFrame;}
    public String getToMessageFrame(){return toMessageFrame;}
    public int getMax_ItemsOfInterest() {return max_itemsofinterest;}
    public int getMax_Messages() {return max_messages;}
    public int getMax_Parameters() {return max_parameters;}
    public String getOutOfRange() {return outOfRange;}
    public boolean getPupilSize() {return pupilSize;}
	public boolean getWordSetToZero() {return wordSetToZero;}

    public boolean getTimeSettingDialog() {return timeSettingDialog;}
    public boolean getMessageFramesDialog() {return messageFramesDialog;}
    public boolean getItemsOfInterestDialog() {return itemsOfInterestDialog;}

    public String getScannedChannel() {return scannedChannel;}
    public Vector getScannedItemsOfInterest() {return scannedItemsOfInterest;}
    public Vector getScannedTrackerMessages() {return scannedTrackerMessages;}
    public Vector getScannedMessageFrames() {return scannedMessageFrames;}

    public String getBackupTextAreaOutput() {return backupTextArea_Output;}
    public String getBackupTextAreaInput() {return backupTextArea_Input;}
    public String getBackupTextAreaLog() {return backupTextArea_Log;}
    public int getLineCount() {return lineCount;}
	
	public boolean isAbortedTrialFound() {return abortedTrialFound;}

    public void resetMessageFrames()
    {
		for(int i=0;i<max_messages;i++) messageFrames[i] = "unused";
		messageFrames[0]="ALL";

        	for(int i=0;i<max_messages;i++) trackerMessages[i] = "unused";
		trackerMessages[0]="ALL";
    }

    public void resetItemsOfInterest()
    {
		for(int i=0;i<max_itemsofinterest;i++) itemsOfInterest[i] = "unused";
		itemsOfInterest[0]="ALL";
    }

    public void resetFiles() throws IOException
    {
		if(inFile!=null) inFile.close();
		if(outFile!=null) outFile.close();
		if(logFile!=null) logFile.close();
		inFile=new BufferedReader(new FileReader(inBackup));
        if(outBackup!=null)
			outFile=new PrintWriter(new FileWriter(outBackup));
        if(logBackup!=null)
			logFile=new PrintWriter(new FileWriter(logBackup));
    }

    public void completeReset()
    {
		channel="NS";
		dataOfInterest="BOTH";
		for(int i=0;i<max_messages;i++) messageFrames[i] = "unused";
		for(int i=0;i<max_messages;i++) trackerMessages[i] = "unused";
		messageFrames[0]="ALL";
		trackerMessages[0]="ALL";
		fromMessageFrame="NS";
		toMessageFrame="NS";
		timeSettingStart="NS";
		toleranceAbove=0;
		toleranceBelow=0;
		fixations="DONT ALTER";
		blinks="DONT ALTER";
		tooShortFixation=100;
		outOfRange="DONT ALTER";
		pupilSize = true;
		wordSetToZero = false;

		timeSettingDialog=false; // radiobutton is set to 'no'
		messageFramesDialog=false;

		abortedTrialFound=false;
    }

    /* generates a name for the ouput file */
    public String setOutFileName(String name,String suffix,String type) throws IOException
    {
		String output = new String();
		String path;
		//File tmpFile;

		if (name.equals("unused"))
	    	{
			path = inBackup.getCanonicalFile().getCanonicalPath();
			output = path.substring(0,path.length()-4)+suffix;

	    	}
		else
	    	{
			output = name;
	    	}
		if (type.equals("FLT"))
	    	outFileName=output;
		if (type.equals("LOG"))
	    	logFileName=output;
		/*if (type.equals("FLT"))
	    	setOutFile(new File(output));
		if (type.equals("LOG"))
	    	setLogFile(new File(output));*/
		return output;
    }
	
	public void createFiles() throws IOException
	{
       if(!outFileName.equals("NS"))
	   	setOutFile(new File(outFileName));
       if(!logFileName.equals("NS"))
	   	setLogFile(new File(logFileName));
	}
	
    public void closeInFile() throws IOException {if(inFile!=null) inFile.close();}
    public void closeOutFile() throws IOException {if(outFile!=null) outFile.close();}
    public void closeLogFile() throws IOException {if(logFile!=null) logFile.close();}

    public void closeAll() throws IOException
    {
		try
	    	{
				closeInFile();
				closeOutFile();
				closeLogFile();
	    	}
		catch(IOException e)
	    	{
			System.out.println("closeAll failed. Exiting.");
			System.exit(1);
	    	}
    }

    public void DataToString()
    {
		System.out.println("max_messages = "+max_messages);
		System.out.println("max_itemsofinterest = "+max_itemsofinterest);
		System.out.println("max_parameters = "+max_parameters);
		//itemsOfInterest = new String[max_itemsofinterest];
		//messageFrames = new String[max_messages];
		System.out.println("channel = "+channel);
		System.out.println("dataOfInterest = "+dataOfInterest);
		System.out.println("timeSettingStart = "+timeSettingStart);
		System.out.println("toleranceAbove = "+toleranceAbove);
		System.out.println("toleranceBelow = "+toleranceBelow);
		System.out.println("pupilSize = "+pupilSize);
		System.out.println("fixations = "+fixations);
		System.out.println("blinks = "+blinks);
		System.out.println("Out of range = "+outOfRange);
		System.out.println("tooShortFixation = "+tooShortFixation);
    }

    public String getPath(String whatFile) throws IOException
    {
		if(whatFile.equals("INPUT"))
	    	return inBackup.getCanonicalFile().getCanonicalPath();
		if(whatFile.equals("OUTPUT"))
			if(outBackup==null)
				return outFileName;
	    	else
				return outBackup.getCanonicalFile().getCanonicalPath();
		if(whatFile.equals("LOG"))
            if(logBackup==null)
				return logFileName;
	    	else
				return logBackup.getCanonicalFile().getCanonicalPath();

		return "ERROR"; //should never happen
    }

    // scans input file for trial items and stores them in a vector
    // and the channel
    // fills the input TextArea and saves it in a string
    // *** why JTextArea? StringBuffer would be more obvious...???
    public void scanInputFile() throws IOException
    {
		BufferedReader scanFile = new BufferedReader(inFile);
		String line = new String();
		String token = new String();
        	javax.swing.JTextArea area = new javax.swing.JTextArea();

		area.setText("");

		while ((line = scanFile.readLine()) != null)
	    	{
			boolean alreadyIn=false;
                	area.append(line+"\n"); // fill Input TextArea
			StringTokenizer tokenLine= new StringTokenizer(line);
			if(line.equals("")) continue;
			token = tokenLine.nextToken();
			//get rid of eyetracker calibration info
		/*
			if(token.startsWith("0") ||
			token.startsWith("1") ||
			token.startsWith("2") ||
			token.startsWith("3") ||
	                token.startsWith("4") ||
			token.startsWith("5") ||
			token.startsWith("6") ||
			token.startsWith("7") ||
        	        token.startsWith("8") ||
			token.startsWith("9") ||
		*/
			if (token.length()==0 ||
			Character.isDigit(token.charAt(0)) ||	// speedup? - EA
			token.charAt(0)=='>' ||
			token.charAt(0)=='-' ) continue;
			
                        scannedChannel="BOTH"; // *&*&* DPI no channels
                        
                        /*
			if(token.equals("EVENTS"))
		    	{
				//include it in TrackerMessages if it is not already in
                        	alreadyIn=false;
                        	for(int i=0;i<scannedTrackerMessages.size();i++)
					if(token.equals(scannedTrackerMessages.get(i)))
						alreadyIn=true;
                        	if(!alreadyIn) scannedTrackerMessages.add(token);

                        	token= tokenLine.nextToken();
				token= tokenLine.nextToken();
				if(token.equals("LEFT"))
			    	if(tokenLine.hasMoreTokens())
					{
				    	scannedChannel="BOTH";
				    	continue;
					}
			    	else scannedChannel="LEFT";
				else
			    	if(token.equals("RIGHT"))
					if(tokenLine.hasMoreTokens())
				    	{
						scannedChannel="BOTH";
						continue;
				    	}
					else scannedChannel = "RIGHT";
				continue;
		    	}
			*/

                	if(token.equals("EFIX") ||
                    	token.equals("ESACC") ||
                    	token.equals("SSACC") ||
                    	token.equals("SFIX") ||
                    	token.equals("**") ||
                    	token.equals("SBLINK") ||
                    	token.equals("EBLINK")) continue; // speedup: ignore those

                	//collect MessageFrames and TrialIDs
			if(token.equals("MSG"))
                	{
                    	while(tokenLine.hasMoreTokens())
		    	{
                        	alreadyIn=false;
				token = tokenLine.nextToken();
                        	token = tokenLine.nextToken();
                                //Dpi
                                if(token.equals("DISPLAY_COORDS"))
                                {
                                    tokenLine.nextToken();
                                    tokenLine.nextToken();
                                    displaySize.x=Integer.parseInt(tokenLine.nextToken());
                                    displaySize.y=Integer.parseInt(tokenLine.nextToken());
                                }
                                
                        	//ItemsOfInterest
				if(token.equals("TRIALID"))
			    	scannedItemsOfInterest.add(tokenLine.nextToken());
                        	// MessageFrames
                        	for(int i=0;i<scannedMessageFrames.size();i++)
					if(token.equals(scannedMessageFrames.get(i)))
						alreadyIn=true;
                        	if(!alreadyIn) scannedMessageFrames.add(token);
                        	break;
		    	}
                	}
                	else
                	{ // collect TrackerMessages (except for EVENTS, see above)
                    	alreadyIn=false;
                    	for(int i=0;i<scannedTrackerMessages.size();i++)
                        	if(token.equals(scannedTrackerMessages.get(i)))
					alreadyIn=true;
                    	if(!alreadyIn) scannedTrackerMessages.add(token);
                	}
	    	} // while line
		scanFile.close();
		backupTextArea_Input=area.getText();
		lineCount = area.getLineCount();
        	scannedItemsOfInterest.trimToSize();
        	scannedMessageFrames.trimToSize();
        	scannedTrackerMessages.trimToSize();

        	/*
		for(int i=0;i<scannedMessageFrames.size();i++)
            	System.out.println(scannedMessageFrames.get(i));
        	System.out.println("******************");
        	for(int i=0;i<scannedTrackerMessages.size();i++)
            	System.out.println(scannedTrackerMessages.get(i));
		*/
    }

    public void setProgressBarCurrent(int i) { progressBarCurrent=i; }
    public int getProgressBarCurrent() { return progressBarCurrent; }
    public void setProgressBar(javax.swing.JProgressBar pb, javax.swing.JPanel p)
    {
    	bar = pb;
    	panel =p;
    }

    public void manageProgressBar(int i)
    {
    	progressBarCurrent+=i;
    	updateProgressBar(progressBarCurrent);
    }

    public void updateProgressBar(int p)
    {
        bar.setValue(p);
        panel.removeAll();
        panel.add(bar);
        panel.revalidate();
    }

    // for debugging
    public void createLogFile() throws IOException
    {
		// PrintWriter logFile = new PrintWriter(new FileWriter("debug.txt"));
		int i = 0;

		logFile.println("Frame(s) of messages :");
		while(!messageFrames[i].equals("unused"))
			logFile.println(messageFrames[i++]);
		i=0;
       		while(!trackerMessages[i].equals("unused"))
			logFile.println(trackerMessages[i++]);
		logFile.println();
		logFile.println("   Trial from "+fromMessageFrame+" to "+toMessageFrame);
		logFile.println();
		logFile.print("Data of interest : ");
		if(dataOfInterest.equals("EFIX")) logFile.println("fixations only");
		if(dataOfInterest.equals("ESACC")) logFile.println("saccades only");
		if(dataOfInterest.equals("BOTH")) logFile.println("both");
		if(dataOfInterest.equals("NONE")) logFile.println("none");
		logFile.println();
		logFile.print("Channels of interest : ");
		if(channel.equals("L")) logFile.println("left only");
		if(channel.equals("R")) logFile.println("right only");
		if(channel.equals("BOTH")) logFile.println("both");
		if(channel.equals("NS")) logFile.println("not specified");
		logFile.println();
		i=0;
		logFile.println("Items of interest :");
		while(!itemsOfInterest[i].equals("unused"))
			logFile.println(itemsOfInterest[i++]);
		logFile.println();
		logFile.println("Box tolerance : ");
		logFile.println("Above : " + toleranceAbove);
		logFile.println("Below : "+ toleranceBelow);
		logFile.println();
		logFile.print("Pupil Size : ");
		if(pupilSize) logFile.println("included");
		else logFile.println("not included");
		logFile.println();
		logFile.print("Word Set To Zero : ");
		if(wordSetToZero) logFile.println("yes");
		else logFile.println("no");
		logFile.println();
		logFile.print("Time setting (set to zero): ");
		if(!timeSettingStart.equals("NS"))
	    	{
			logFile.println("yes");
			logFile.println("With each : "+timeSettingStart);
	    	}
		else
	    	logFile.println("no");
		logFile.println();
		logFile.println("Data pooling : ");
		logFile.print("too short fixations: ");
		if(fixations.equals("DONT ALTER")) logFile.println("Don't alter");
		if(fixations.equals("REMOVE")) logFile.println("Remove");
		if(fixations.equals("POOL REMOVE")) logFile.println("Pool or remove");
		if(fixations.equals("POOL DONT ALTER")) logFile.println("Pool or don't alter");
		logFile.println("specified minimum : " +tooShortFixation);
		logFile.print("Blinks: ");
		if(blinks.equals("DONT ALTER")) logFile.println("Don't alter");
		if(blinks.equals("REMOVE")) logFile.println("Remove");
		if(blinks.equals("ADD")) logFile.println("Add");
		logFile.print("Out Of Range: ");
		if(outOfRange.equals("DONT ALTER")) logFile.println("Don't alter");
		if(outOfRange.equals("REMOVE")) logFile.println("Remove");
		if(outOfRange.equals("ADD")) logFile.println("Add");
		logFile.println();

		logFile.close();
    }

    public boolean saveOptionTemplate(File file)
    {
    	try
    	{
    	PrintWriter outOpTem = new PrintWriter(new FileWriter(file));
        int i=0;

    	outOpTem.println("[DATAMODIFICATION]");
    	outOpTem.println(";; Channel : R, L or BOTH");
    	outOpTem.println("Channel = "+channel);
    	outOpTem.println(";; Blinks : DONT ALTER, REMOVE or ADD");
    	outOpTem.println("Blinks = "+blinks);
    	outOpTem.println(";; Eye Tracking Events : NONE, EFIX, ESACC or BOTH");
    	outOpTem.println("Events = "+dataOfInterest);
    	outOpTem.println(";; Set To Zero : (message identifier see below) or NS");
    	outOpTem.println("Zero = "+timeSettingStart);
		outOpTem.println(";; Word Set to Zero : YES or NO");
    	if(wordSetToZero)
    		outOpTem.println("WordZero = YES");
    	else outOpTem.println("WordZero = NO");
    	outOpTem.println(";; Pupil Size : YES or NO");
    	if(pupilSize)
    		outOpTem.println("Pupil = YES");
    	else outOpTem.println("Pupil = NO");
    	outOpTem.println();
    	outOpTem.println("[DATAPOOLING]");
    	outOpTem.println(";; Minimum Fixation Duration");
    	outOpTem.println("Duration = "+tooShortFixation);
    	outOpTem.println(";; Too Short Fixations : DONT ALTER, REMOVE, ");
    	outOpTem.println(";; POOL DONT ALTER or POOL REMOVE");
    	outOpTem.println("Fixation = "+fixations);
    	outOpTem.println(";; Out Of Range Fixations : DONT ALTER, REMOVE or ADD");
    	outOpTem.println("Range = "+outOfRange);
    	outOpTem.println();
        outOpTem.println("[BOXTOLERANCE]");
        outOpTem.println(";; Box Tolerance");
        outOpTem.println("Above = "+toleranceAbove);
        outOpTem.println("Below = "+toleranceBelow);
        outOpTem.println();
        outOpTem.println("[MESSAGES]");
        outOpTem.println(";; Regular Messages (i.e. line starts with MSG) : ");
        outOpTem.println(";; First Word (i.e. the message identifier) after");
        outOpTem.println(";; the onset (e.g. TRIALID) or ALL");
        outOpTem.print("Message = ");
        while(!messageFrames[i].equals("unused"))
	{
			if(i!=0) outOpTem.print(",");
			outOpTem.print(messageFrames[i++]);
	}
	outOpTem.println();
        outOpTem.println(";; Tracker Messages (i.e. any Message that is not a fixation,");
        outOpTem.println(";; a saccade, a blink or an MSG)");
        outOpTem.print("Tracker = ");
        i=0;
        while(!trackerMessages[i].equals("unused"))
	{
			if(i!=0) outOpTem.print(",");
			outOpTem.print(trackerMessages[i++]);
	}
	outOpTem.println();
        outOpTem.println(";; Trial from to : message identifier or (both!) NS");
        outOpTem.println("From = "+fromMessageFrame);
        outOpTem.println("To = "+toMessageFrame);

	outOpTem.close();
        return true;
        }
        catch(IOException e)
        {
		System.out.println("could not save options.");
        	return false;
        }
    }

    public boolean openOptionTemplate(File file)
    {
    	try
    	{
    		BufferedReader inOpTem = new BufferedReader(new FileReader(file));
    		String line = new String("");
        	int i=0;

                while ((line = inOpTem.readLine()) != null)
	    	{
	    		if(line.startsWith("[") ||
	    		   line.startsWith(";") ||
	    		   line.equals("")) continue;

	    		// Channel needs to be checked
	    		// possible channels(scanned) and template channels might differ
	    		if(line.startsWith("Channel"))
	    		{
	    			String dummy = stripLine(line);
                                if(scannedChannel.equals("BOTH"))
                                	channel=dummy;
                                else if(scannedChannel.startsWith(dummy))
                                	channel= dummy;
	    		}
	    		if(line.startsWith("Blinks"))
	    			blinks=stripLine(line);
	    		if(line.startsWith("Events"))
	    			dataOfInterest=stripLine(line);
	    		if(line.startsWith("Zero") )
	    			timeSettingStart=stripLine(line);
				if(line.startsWith("WordZero"))
	    			if(stripLine(line).equals("YES"))
	    				wordSetToZero=true;
	    			else wordSetToZero=false;
	    		if(line.startsWith("Pupil"))
	    			if(stripLine(line).equals("YES"))
	    				pupilSize=true;
	    			else pupilSize=false;
                if(line.startsWith("Duration"))
	    			tooShortFixation=Integer.parseInt(stripLine(line));
	    		if(line.startsWith("Fixation"))
	    			fixations=stripLine(line);
	    		if(line.startsWith("Range"))
	    			outOfRange=stripLine(line);
	    		if(line.startsWith("Above"))
	    			toleranceAbove=Double.parseDouble(stripLine(line));
	    		if(line.startsWith("Below"))
	    			toleranceBelow=Double.parseDouble(stripLine(line));
	    		if(line.startsWith("From"))
	    			fromMessageFrame=stripLine(line);
	    		if(line.startsWith("To"))
	    			toMessageFrame=stripLine(line);
	    		if(line.startsWith("Message"))
	    		{
                		StringTokenizer tokens = new StringTokenizer(stripLine(line),",");
				String token = new String("");
				i=0;
				messageFrames[0]="unused";
				while(tokens.hasMoreTokens())
				{
		                        token= (tokens.nextToken()).trim();
					if (token.equals("ALL")) // bugfix - EA 5/2005
					{
						messageFrames[i++] = token;
					} else {		// only add to list if actually found in data
						for(int o=0;o<scannedMessageFrames.size();o++)
							if(((String)scannedMessageFrames.get(o)).equals(token))
								messageFrames[i++]=token;
					}
				} // while
				}
			if(line.startsWith("Tracker"))
	    		{
                		StringTokenizer tokens = new StringTokenizer(stripLine(line),",");
				String token = new String("");
				int u=0;
				trackerMessages[0]="unused";
				while(tokens.hasMoreTokens())
				{
		                        token= (tokens.nextToken()).trim();
					if (token.equals("ALL")) // bugfix - EA 5/2005
					{
						trackerMessages[i++] = token;
					} else {		// only add to list if actually found in data
						for(int o=0;o<scannedTrackerMessages.size();o++)
							if(((String)scannedTrackerMessages.get(o)).equals(token))
								trackerMessages[u++]=token;
					}
				} // while
			}
	    		//System.out.println(channel);
                }
                inOpTem.close();
         	return true;
        }
        catch(IOException e)
        {
		System.out.println("could not load options.");
        	return false;
        }
    }

    // part of openOptionTemplate
    // strips the line read of all unneccessary information (tag word,spaces and =)
    private String stripLine(String line)
    {
    	 return (line.substring(line.indexOf("=")+1)).trim();
    }
}

