
import java.io.*;
import java.awt.*;
import javax.swing.*;
// import java.util.*;
import java.util.Vector;
// import java.awt.event.*;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.ActionListener;
// import javax.swing.event.*;  
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
// import javax.swing.text.*;
import javax.swing.text.Document;
import javax.swing.text.AttributeSet;
import javax.swing.text.PlainDocument;
import javax.swing.border.TitledBorder;
// import javax.swing.plaf.*;
import java.util.regex.Pattern; // needs Java 1.4+!
import java.util.regex.Matcher; // needs Java 1.4+!

class FilterGUI extends JFrame implements ActionListener, DocumentListener
{
    // unused: private int max_messages, max_itemsofinterest, max_parameters
    private int PROGRAMWIDTH;
    private int PROGRAMHEIGHT;
    private static final int MAX_MESSAGES = 100; // # different message types
    private static final int MAX_ITEMSOFINTEREST = 1000; //# Items included
    private static final int MAX_PARAMETERS = 100; // # parameters +1 (also applies to MSG)
    private static final String VERSION = "     ver 0.99";

    // Variables declaration
    private Vector dataSharingInterface;
    //private Vector trialItemsVector;
    private boolean trialItemsVectorNew; // was a new Inputfile selected since last selection
    private File[] fileArray; // stores the Inputfiles selected in the Openfile dialog
    private Vector documentMenuVector;
    private int currentDocument;
    private MasterScripts masterScripts;
    private Vector outputLineStarts;	// 5/2005

    // private JPanel panelIO_left;
    // private JPanel panelIO_right;

    private JButton jButton_Input_File;
    private JButton jButton_Output_File;
    private JButton jButton_Log_File;

    private JTextField jTextField_Input_File;
    private JTextField jTextField_Output_File;
    private JTextField jTextField_Log_File;

    private JRadioButton jRadioButton_IOI_All;	// all trials
    private JRadioButton jRadioButton_IOI_Specified;

    private JRadioButton jRadioButton_SM_All;	// all message types
    private JRadioButton jRadioButton_SM_Specified;

    private JComboBox jComboBox_SM_From;
    private JComboBox jComboBox_SM_To;

    private JCheckBox jCheckBox_SMD_1_LeftChannel;
    private JCheckBox jCheckBox_SMD_1_RightChannel;

    private JRadioButton jRadioButton_SMD_2_BlinksDontAlter;
    private JRadioButton jRadioButton_SMD_2_BlinksAdd;
    private JRadioButton jRadioButton_SMD_2_BlinksRemove;

    private JCheckBox jCheckBox_Saccades;
    private JCheckBox jCheckBox_Fixations;

    private JRadioButton jRadioButton_SMD_4_No; // set time to zero? no!
    private JRadioButton jRadioButton_SMD_4_Yes; // set time to zero? yes!

    private DoubleTextField jTextField_above;	// extra text item slack
    private DoubleTextField jTextField_below;	// extra text item slack

    private JRadioButton jRadioButton_SMD_6_No;	// include pupil size? no!
    private JRadioButton jRadioButton_SMD_6_Yes; // include pupil size? yes!

    private JMenu jMenu_Documents; // list of already  visited files

    private JRadioButtonMenuItem jMenuItem_ManualSelection;
    private JRadioButtonMenuItem jMenuItem_AutoSelection;

    private JTabbedPane outputTabbedPane;
    private JTextArea jTextArea_Input;
    private JTextArea jTextArea_Output;
    private JTextArea jTextArea_Log;
    private JScrollPane scrolledTextArea_Input;
    private JScrollPane scrolledTextArea_Output;
    private JScrollPane scrolledTextArea_Log;

    private JButton startButton;	// Input to Output conversion start

    private DataPoolingDialog dataPoolingDialog;
    private MessageFrameDialog messageFrameDialog;
    private TimeSettingDialog timeSettingDialog;
    private ItemsOfInterestDialog itemsOfInterestDialog;
    private SetMasterScriptDialog setMasterScriptDialog;

    private VisualizeImage imageViewWindow;
    private TrialIDWindow trialIDWindow;

    private JMenuBar menuBar;

    private ButtonGroup buttonGroup_MultiSelectionMenu;
    private ButtonGroup buttonGroup_DocumentMenu;

    // End of variables declaration

    /** Creates new form Frame */
    public FilterGUI()
    {
		currentDocument = -1;
		dataSharingInterface = new Vector(10,20);
		outputLineStarts = new Vector(100,200); // 5/2005
		initComponents ();
    }

    /** This method is called from within the constructor to
     * initialize the form.*/
    private void initComponents() // of FilterGUI
    {

	JPanel panelInput_Output;

	JPanel panelItemsOfInterest;
	JPanel panelIOI_left;
	JPanel panelIOI_right;
	ButtonGroup groupIOI;

	JPanel panelSelectMessages;
	JPanel panelSM_upper;
	// JPanel panelSM_upper_left;
	// JPanel panelSM_upper_right;
	ButtonGroup groupSM;
	JPanel panelSM_lower1;
	JPanel panelSM_lower2;

	JPanel panelSelect_Modify;
	JPanel panelSMD_1;		// main interface: channel left / right
	JPanel panelSMD_2;		// main interface: what to do with blinks
	ButtonGroup groupSMD_2;
	JPanel panelSMD_3;		// main interface: saccade / fixation pooling
	JPanel panelSMD_4;		// main interface: whether to set time to 0
	ButtonGroup groupSMD_4;
	JPanel panelSMD_5;		// main interface: text item extra slack
	JPanel panelSMD_6;		// main interface: include pupil size?
	ButtonGroup groupSMD_6;

	JMenu jMenu_Options;
	JMenu jMenu_MultiSelection;
	JMenuItem jMenuItem_MasterScripts;
	JMenuItem jMenuItem_MasterScripts_Save;
	JMenuItem jMenuItem_MasterScripts_Load;


	panelInput_Output = new JPanel();
        jButton_Input_File = addButton(panelInput_Output,"Input-File :",false);
	jButton_Input_File.setMnemonic(KeyEvent.VK_P);
        jButton_Output_File = addButton(panelInput_Output,"Output-File :",false);
        jButton_Log_File = addButton(panelInput_Output,"Log-File :",false);
        jTextField_Input_File = new JTextField();
        jTextField_Output_File = new JTextField();
        jTextField_Log_File = new JTextField();

        panelItemsOfInterest = new JPanel();
        panelIOI_left = new JPanel();
        panelIOI_right = new JPanel();
	groupIOI = new ButtonGroup();
        jRadioButton_IOI_All =
	    addRadioButton(panelIOI_right,groupIOI,"all Items",true);
	jRadioButton_IOI_Specified =
	    addRadioButton(panelIOI_right,groupIOI,"specified",false);


        panelSelect_Modify = new JPanel();
        panelSMD_1 = new JPanel();
        jCheckBox_SMD_1_LeftChannel = addCheckBox(panelSMD_1,"left eye",true);
        jCheckBox_SMD_1_RightChannel = addCheckBox(panelSMD_1,"right eye",true);
        panelSMD_2 = new JPanel();
	groupSMD_2 = new ButtonGroup();
        jRadioButton_SMD_2_BlinksDontAlter =
	    addRadioButton(panelSMD_2,groupSMD_2,"don't alter",true);
        jRadioButton_SMD_2_BlinksAdd =
	    addRadioButton(panelSMD_2,groupSMD_2,"add to previous fixation",false);
        jRadioButton_SMD_2_BlinksRemove =
	    addRadioButton(panelSMD_2,groupSMD_2,"remove",false);
        panelSMD_3 = new JPanel();
        jCheckBox_Saccades = addCheckBox(panelSMD_3,"saccades",true);
        jCheckBox_Fixations = addCheckBox(panelSMD_3,"fixations",true);
        panelSMD_4 = new JPanel();
	groupSMD_4 = new ButtonGroup();
        jRadioButton_SMD_4_No = addRadioButton(panelSMD_4,groupSMD_4,"no",true);
        jRadioButton_SMD_4_Yes = addRadioButton(panelSMD_4,groupSMD_4,"yes",false);
	panelSMD_5 = new JPanel();
	jTextField_above = new DoubleTextField(0,3);
	jTextField_below = new DoubleTextField(0,3);
        panelSMD_6 = new JPanel();
	groupSMD_6 = new ButtonGroup();
        jRadioButton_SMD_6_No = addRadioButton(panelSMD_6,groupSMD_6,"no",false);
        jRadioButton_SMD_6_Yes = addRadioButton(panelSMD_6,groupSMD_6,"yes",true);

        jTextArea_Input = addTextArea("ASC Input Window");
	scrolledTextArea_Input = new JScrollPane(jTextArea_Input);
	jTextArea_Output = addTextArea("FLT Output Window");
	scrolledTextArea_Output = new JScrollPane(jTextArea_Output);
	jTextArea_Output.setLineWrap(true); // new 5/2005
	jTextArea_Log = addTextArea("Config Log Window");
	scrolledTextArea_Log = new JScrollPane(jTextArea_Log);
	outputTabbedPane= new JTabbedPane();

	startButton = addButton(getContentPane(),"Create FLT",false);
	// new JButton("Start");

	menuBar = new JMenuBar();

        getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints3;

        addWindowListener(new java.awt.event.WindowAdapter()
	    {
		public void windowClosing(java.awt.event.WindowEvent evt)
		{
		    exitForm(evt);
		}
	    }
	);

	gridBagConstraints3 = new GridBagConstraints();

        // Input/ Output panel
	GridBagLayout gbl1 = new GridBagLayout();
        panelInput_Output.setLayout(gbl1);
        panelInput_Output.setBorder(new TitledBorder("Input/Output"));
        panelInput_Output.setName("Input/Output");

	jTextField_Input_File.setColumns(25);
	jTextField_Output_File.setColumns(25);
	jTextField_Log_File.setColumns(25);
        addGridBagComponent(panelInput_Output,gbl1,jButton_Input_File,0,0,1,1,0,0);
        addGridBagComponent(panelInput_Output,gbl1,jButton_Output_File,0,1,1,1,0,0);
	addGridBagComponent(panelInput_Output,gbl1,jButton_Log_File,0,2,1,1,0,0);
	addGridBagComponent(panelInput_Output,gbl1,jTextField_Input_File,1,0,2,1,1.0,0);
	addGridBagComponent(panelInput_Output,gbl1,jTextField_Output_File,1,1,2,1,1.0,0);
	addGridBagComponent(panelInput_Output,gbl1,jTextField_Log_File,1,2,2,1,1.0,0);

        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
	gridBagConstraints3.gridwidth = 2; // give file selection / name thing 2 grid columns
	gridBagConstraints3.weightx = 1.0; // very dominant
	gridBagConstraints3.fill = gridBagConstraints3.BOTH;
        getContentPane().add(panelInput_Output, gridBagConstraints3);

        // Items of Interest Panel
        panelItemsOfInterest.setLayout(new GridLayout(1, 2));
        panelItemsOfInterest.setBorder(new TitledBorder("Items of Interest"));
        panelItemsOfInterest.setName("Items of Interest");

        panelIOI_left.setLayout(new GridLayout(2, 1));
        panelIOI_left.add(new JLabel("Include", JLabel.CENTER));
        panelItemsOfInterest.add(panelIOI_left);
        panelIOI_right.setLayout(new GridLayout(2, 1,0,-5));
        panelItemsOfInterest.add(panelIOI_right);

        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
	gridBagConstraints3.fill = GridBagConstraints.HORIZONTAL;
        getContentPane().add(panelItemsOfInterest, gridBagConstraints3);

        // Select Message Panel
        panelSelectMessages = new JPanel();
        panelSelectMessages.setLayout(new GridLayout(3, 1));
        panelSelectMessages.setBorder(new TitledBorder("Select Messages"));
        panelSelectMessages.setName("Select Messages");

        panelSM_upper = new JPanel();
        panelSM_upper.setLayout(new BoxLayout(panelSM_upper, BoxLayout.X_AXIS));
        // panelSM_upper_left = new JPanel();
        // panelSM_upper_right = new JPanel();
        // panelSM_upper_left.add(new JLabel("Include", JLabel.RIGHT));
        // panelSM_upper.add(panelSM_upper_left);
	panelSM_upper.add(new JLabel("Include:  ", JLabel.RIGHT));
	groupSM = new ButtonGroup();
        jRadioButton_SM_All =
	    addRadioButton(panelSM_upper,groupSM,"all Messages",true);
	//    addRadioButton(panelSM_upper_right,groupSM,"all Messages",true);
        jRadioButton_SM_Specified =
	    addRadioButton(panelSM_upper,groupSM,"specified",false);
	//    addRadioButton(panelSM_upper_right,groupSM,"specified",false);
        // panelSM_upper_right.setLayout(new GridLayout(2, 1));
        // panelSM_upper.add(panelSM_upper_right);
        panelSelectMessages.add(panelSM_upper);

        panelSM_lower1 = new JPanel();
        panelSM_lower1.setLayout(new BoxLayout(panelSM_lower1, BoxLayout.X_AXIS));
	panelSM_lower1.add(new JLabel("Trial from:  ", JLabel.RIGHT));
        jComboBox_SM_From = new JComboBox();
	jComboBox_SM_From.setEditable(false);
        panelSM_lower1.add(jComboBox_SM_From);
        panelSelectMessages.add(panelSM_lower1);

        panelSM_lower2 = new JPanel();
        panelSM_lower2.setLayout(new BoxLayout(panelSM_lower2, BoxLayout.X_AXIS));
        panelSM_lower2.add(new JLabel("Trial to:  ", JLabel.RIGHT));
        jComboBox_SM_To = new JComboBox();
        jComboBox_SM_To.setEditable(false);
        panelSM_lower2.add(jComboBox_SM_To);
        panelSelectMessages.add(panelSM_lower2);

	// fillComboboxes();

        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 0;
	gridBagConstraints3.weightx = 0.25;	// give it some remaining space
	gridBagConstraints3.fill = gridBagConstraints3.BOTH;
	gridBagConstraints3.anchor=GridBagConstraints.WEST;
        getContentPane().add(panelSelectMessages, gridBagConstraints3);

        // Select & Modify Data Panel
	GridBagLayout gbl2 = new GridBagLayout();
        panelSelect_Modify.setLayout(gbl2);
        panelSelect_Modify.setBorder(new TitledBorder("Select & Modify Data"));

        panelSMD_1.setLayout(new GridLayout(1, 2));
        panelSMD_1.setBorder(new TitledBorder("Channel"));

        panelSMD_2.setLayout(new GridLayout(3, 1,0,-5));
        panelSMD_2.setBorder(new TitledBorder("Blinks"));

        panelSMD_3.setLayout(new GridLayout(1, 2));
        panelSMD_3.setBorder(new TitledBorder("Eye Tracking Events"));

        panelSMD_4.setLayout(new GridLayout(1, 2));
        panelSMD_4.setBorder(new TitledBorder("Set Time to zero"));

        panelSMD_6.setLayout(new GridLayout(1, 2));
        panelSMD_6.setBorder(new TitledBorder("Include Pupil Size"));

        GridBagLayout gbl3 = new GridBagLayout();
	panelSMD_5.setLayout(gbl3);
	panelSMD_5.setBorder(new TitledBorder("Set Boxtolerance"));

        addGridBagComponent(panelSMD_5, gbl3, new JLabel("Above", JLabel.CENTER),
		0,0,1,1,1.0,1.0);
	addGridBagComponent(panelSMD_5, gbl3, new JLabel("Below", JLabel.CENTER),
		0,1,1,1,1.0,1.0);
	addGridBagComponent(panelSMD_5,gbl3,jTextField_above,1,0,1,1,1.0,1.0);
	addGridBagComponent(panelSMD_5,gbl3,jTextField_below,1,1,1,1,1.0,1.0);

	addGridBagComponent(panelSelect_Modify,gbl2,panelSMD_1,0,0,1,1,1.0,1.0);
	addGridBagComponent(panelSelect_Modify,gbl2,panelSMD_2,0,1,1,1,1.0,1.0);
	addGridBagComponent(panelSelect_Modify,gbl2,panelSMD_3,0,2,1,1,1.0,1.0);
	addGridBagComponent(panelSelect_Modify,gbl2,panelSMD_4,0,3,1,1,1.0,1.0);
        addGridBagComponent(panelSelect_Modify,gbl2,panelSMD_5,0,4,1,1,1.0,1.0);
        addGridBagComponent(panelSelect_Modify,gbl2,panelSMD_6,0,5,1,1,1.0,1.0);

	jTextField_above.getDocument().addDocumentListener(this);
	jTextField_below.getDocument().addDocumentListener(this);

	gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 2;
	gridBagConstraints3.weighty = 0.5;	// give it the remaining space
	gridBagConstraints3.fill = gridBagConstraints3.BOTH;
	gridBagConstraints3.anchor=GridBagConstraints.NORTH;
        getContentPane().add(panelSelect_Modify, gridBagConstraints3);

        // Output Window
	scrolledTextArea_Input.setHorizontalScrollBarPolicy
		(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
	scrolledTextArea_Output.setHorizontalScrollBarPolicy
	    	(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
	scrolledTextArea_Log.setHorizontalScrollBarPolicy
	    	(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
	// ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);
	outputTabbedPane.addTab("Input",scrolledTextArea_Input);
	outputTabbedPane.addTab("Output",scrolledTextArea_Output);
	outputTabbedPane.addTab("Logfile",scrolledTextArea_Log);

        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 1;
	gridBagConstraints3.gridheight = 2; // 3
	gridBagConstraints3.gridwidth = 3; // 2
	gridBagConstraints3.weightx=1.0;
	gridBagConstraints3.weighty=1.0;
	// Insets(top,left,bottom,right)
	gridBagConstraints3.insets = new Insets(5,5,5,5); // was: ,35
	gridBagConstraints3.fill = GridBagConstraints.BOTH;
        getContentPane().add(outputTabbedPane, gridBagConstraints3);

	// Conversion Start Button
	gridBagConstraints3.gridx = 3; // 0
    	gridBagConstraints3.gridy = 0; // 3
	gridBagConstraints3.gridheight = 1;
	gridBagConstraints3.gridwidth = 1;
	gridBagConstraints3.weightx=0.25;	// give it not much extra space
	gridBagConstraints3.weighty=0.25;	// give it not much extra space
	gridBagConstraints3.insets = new Insets(0,5,0,5); // was ,35
	gridBagConstraints3.fill = GridBagConstraints.BOTH; // let it grow
	getContentPane().add(startButton, gridBagConstraints3);

	// Menubar
	setJMenuBar(menuBar);

	// Filemenu
	menuBar.add(makeMenu("File", KeyEvent.VK_F, new Object[]
	{	"Open",
                "Open FLT",
		null,
		"Close",
		"Close all",
		null,
		"Process",
		"Process all"
	}, this));

	// Optionsmenu
	jMenu_Options = new JMenu("Options");
	jMenu_Options.setMnemonic(KeyEvent.VK_O);
	jMenu_MultiSelection = new JMenu("MultiSelection");
	menuBar.add(jMenu_Options);
	jMenu_Options.add(jMenu_MultiSelection);
	jMenuItem_ManualSelection = new JRadioButtonMenuItem("Manual");
	jMenuItem_AutoSelection = new JRadioButtonMenuItem("Auto");
	buttonGroup_MultiSelectionMenu = new ButtonGroup();
	jMenu_Options.addSeparator();
	jMenuItem_MasterScripts = new JMenuItem("Select Masterscripts");
	jMenu_Options.add(jMenuItem_MasterScripts);
       	jMenuItem_MasterScripts_Load = new JMenuItem("Load Masterscripts");
       	jMenu_Options.add(jMenuItem_MasterScripts_Load);
       	jMenuItem_MasterScripts_Save = new JMenuItem("Save Masterscripts");
       	jMenu_Options.add(jMenuItem_MasterScripts_Save);

	buttonGroup_MultiSelectionMenu.add(jMenuItem_ManualSelection);
	buttonGroup_MultiSelectionMenu.add(jMenuItem_AutoSelection);
	jMenu_MultiSelection.add(jMenuItem_ManualSelection);
	jMenu_MultiSelection.add(jMenuItem_AutoSelection);
	jMenuItem_ManualSelection.addActionListener(this);
	jMenuItem_AutoSelection.addActionListener(this);
	jMenuItem_ManualSelection.setSelected(true);
	jMenuItem_MasterScripts.addActionListener(this);
	jMenuItem_MasterScripts_Save.addActionListener(this);
	jMenuItem_MasterScripts_Load.addActionListener(this);

	// Documentmenu
	documentMenuVector = new Vector(10,50);
	jMenu_Documents = new JMenu("Documents");
	jMenu_Documents.setMnemonic(KeyEvent.VK_D);
	menuBar.add(jMenu_Documents);
	buttonGroup_DocumentMenu = new ButtonGroup();

        // ImageView Menu
	menuBar.add(makeMenu("ImageView", KeyEvent.VK_I, new Object[]
	    { "ImageView Window", "Trial ID Window" }, this));

	// Option Templates Menu
	menuBar.add(makeMenu("Templates", KeyEvent.VK_T, new Object[]
	    {
		"Open As",
		"Open Default",
		null,
		"Save Default",
		"Save As",
		null,
		"Reset",
	    }, this));

	// disable all menu items
	set_Enabled(false,"RESET");

	// Debugging Menu
//	menuBar.add(makeMenu("Debugging",KeyEvent.VK_B, new Object[]
//	    { "Create LogFile" }, this));

	SystemAdjustment sysAdj= new SystemAdjustment();
	sysAdj.setDimension(getContentPane());
	PROGRAMWIDTH=sysAdj.getWidth();
	PROGRAMHEIGHT=sysAdj.getHeight();
	setTitle("DPIFilter"+VERSION);
       	setName("mainFrame");
	Toolkit tk = Toolkit.getDefaultToolkit();
	Dimension d=tk.getScreenSize();
	int screenHeight = d.height;
	int screenWidth = d.width;
	setBounds((screenWidth-PROGRAMWIDTH)/2,(screenHeight-PROGRAMHEIGHT)/2,
	PROGRAMWIDTH,PROGRAMHEIGHT);
	// if(sysAdj.getSystem().startsWith("Sun")) or Mac or Linux...
	pack();
    } // initComponents of FilterGUI

    public JTextArea addTextArea(String title)
    {
	JTextArea t = new JTextArea(20, 50); // rows, cols
	t.setBorder(new TitledBorder(title));
	t.setEditable(false);
        t.setText("");
        t.setLineWrap(false);

        return t;
    }

    private JRadioButton addRadioButton(JPanel buttonPanel,
					ButtonGroup g,
					String buttonName,
					boolean v)
    {
	JRadioButton button = new JRadioButton(buttonName,v);
	button.addActionListener(this);
	g.add(button);
	buttonPanel.add(button);
	return button;
    }

    private JCheckBox addCheckBox(JPanel p, String name,boolean v)
    {
	JCheckBox c = new JCheckBox(name);
	c.setSelected(v);
	c.addActionListener(this);
	p.add(c);
	return c;
    }

    private JButton addButton(Container c,String s,boolean add)
    {
	JButton b = new JButton(s);
	if(add) c.add(b);
	b.addActionListener(this);
	return b;
    }

    private void addGridBagComponent(Container cont,
				     GridBagLayout gbl,
				     Component c,
				     int x, int y,
				     int width, int heigt,
				     double weightx, double weighty )
    {
	GridBagConstraints gbc = new GridBagConstraints();
	gbc.fill = gbc.BOTH;
	gbc.gridx = x; gbc.gridy = y;
	gbc.gridwidth = width; gbc.gridheight = heigt;
	gbc.weightx = weightx; gbc.weighty = weighty;
	gbl.setConstraints( c, gbc );
	cont.add( c );
    }

    public static JMenu makeMenu(Object parent, int hotkey, Object[] items, Object target)
    {
	JMenu m = null;
	if(parent instanceof JMenu)
	    m=(JMenu)parent;
	else if (parent instanceof String)
	    m = new JMenu((String)parent);
	else
	    return null;

	if (hotkey!=0) m.setMnemonic(hotkey);
	for(int i= 0; i<items.length;i++)
	    {
		if(items[i]==null)
		    m.addSeparator();
		else
		    m.add(makeMenuItem(items[i], target));
	    }
	return m;
    }

    public static JMenuItem makeMenuItem(Object item, Object target)
    {
	JMenuItem r = null;

	if(item instanceof String)
	    r=new JMenuItem((String)item);
	else if (item instanceof JMenuItem)
	    r = (JMenuItem)item;
	else
	    return null;

	if (target instanceof ActionListener)
	    r.addActionListener((ActionListener)target);
	return r;
    }

    // Select Messages, trial to from Comboboxes
    private void fillComboboxes()
    {
	String toBackup;
	String fromBackup;
	boolean isToBackup = false;
	boolean isFromBackup = false;
	//count>0->refresh the list
	//count=0->first vistit
	if(jComboBox_SM_From.getItemCount()>0)
	    {
		toBackup =(String)jComboBox_SM_To.getSelectedItem();
		fromBackup=(String)jComboBox_SM_From.getSelectedItem();
		jComboBox_SM_From.removeAllItems();
		jComboBox_SM_To.removeAllItems();
	    }
	else
	    {
		toBackup="not specified";
		fromBackup="not specified";
	    }

	DataSharing dsi = (DataSharing)dataSharingInterface.get(currentDocument);
        String[] frame = dsi.getMessageFrames();
        String[] track_Mes = dsi.getTrackerMessages();
        Vector scFrames = dsi.getScannedMessageFrames();
        Vector scTrack = dsi.getScannedTrackerMessages();
	int i=0;

	addToComboBox("not specified");
	// System.out.println("Select Messages ("+frame.length+" items) = ");
	// for (int x=0; x<frame.length; x++) System.out.println("  "+frame[x]);
	if(frame[0].equals("ALL"))
	{
		for(int x=0;x<scFrames.size();x++)
			addToComboBox((String)scFrames.get(x));
		isToBackup=true;
		isFromBackup=true;
	}
	else while(!frame[i].equals("unused"))
		{
			//check whether the TRIAL messages are still in the frame
			if(frame[i].equals(toBackup))
		    		isToBackup = true;
			else if(frame[i].equals(fromBackup))
		    		isFromBackup = true;

			addToComboBox(frame[i]);
			i++;
		}
	boolean[] is={false,false};
	i=0;
	if(track_Mes[0].equals("ALL"))
	{
		for(int x=0;x<scTrack.size();x++)
			addToComboBox((String)scTrack.get(x));
		is[0]=true;
		is[1]=true;
	}
	else while(!track_Mes[i].equals("unused"))
		{   //check whether the TRIAL messages are still in the frame
			if(track_Mes[i].equals(toBackup))
				is[1] = true;
			else if(track_Mes[i].equals(fromBackup))
				is[0]=true;

			addToComboBox(track_Mes[i]);
			i++;
		}


	//if FALSE ->trial is not in the frame
	if(isRegular(toBackup,scFrames))
            if(!isToBackup) toBackup = "not specified";
            else;
        else if(!is[1]) toBackup="not specified";
	if(isRegular(fromBackup,scFrames))
            if(!isFromBackup) fromBackup="not specified";
            else;
        else if(!is[0]) fromBackup="not specified";

	jComboBox_SM_From.setSelectedItem(fromBackup);
	jComboBox_SM_To.setSelectedItem(toBackup);
    }

    // is it a regular(e.g. Trialmessage) or a Trackermessage
    private boolean isRegular(String frame, Vector scFra)
    {
	for(int i=0;i<scFra.size();i++)
		if(((String)scFra.get(i)).equals(frame)) return true;

        return false;
    }

    private void addToComboBox(String message)
    {
	jComboBox_SM_From.addItem(message);
	jComboBox_SM_To.addItem(message);
    }

    // Adds and removes to the Document Menu
    // action : either ADD or REMOVE or REMOVEALL
    // number: -1 if ADD and REMOVEALL, otherwise the number of the item to remove
    // name: The File to add or null
    public void manageDocumentMenu(String action,int number,File f) throws IOException
    {
	if(action.equals("ADD"))
	{
	    String name = new String();
	    String path = new String();

	    path = f.getCanonicalFile().getCanonicalPath();
	    if (path.indexOf(File.separator)!= -1) {
		name = path.substring(path.lastIndexOf(File.separator)+1);

		JRadioButtonMenuItem newMenu = new JRadioButtonMenuItem(name);

		jMenu_Documents.add(newMenu);
		newMenu.addActionListener(this);
		documentMenuVector.add(newMenu);
		buttonGroup_DocumentMenu.add(newMenu);
	    } else {
		showErrorMessage("File name must contain a dot", "Selection error");
	    }
	}

	if(action.equals("REMOVE") && (currentDocument>-1))
	    {
			jMenu_Documents.remove((JRadioButtonMenuItem)documentMenuVector
				       	.get(currentDocument));
			buttonGroup_DocumentMenu.remove((JRadioButtonMenuItem)documentMenuVector
							.get(currentDocument));
			documentMenuVector.removeElementAt(currentDocument);
			dataSharingInterface.removeElementAt(currentDocument);
			
			//handles currentDocument
			if(documentMenuVector.size()==1) currentDocument=0;
			else if((documentMenuVector.size()>1) &&
		      	(currentDocument>0)) currentDocument--;
			else if(documentMenuVector.size()==0) currentDocument=-1;
			else if(currentDocument==0) currentDocument=0;

			//if currentDocument=-1 it is like close all(e.g. REMOVEALL)
			if(currentDocument!=-1)
		    	{
					((JRadioButtonMenuItem)documentMenuVector.
			 		get(currentDocument)).setSelected(true);
					paintDocument(currentDocument);
		    	}
			else resetComponents();
	    }

	if(action.equals("REMOVEALL") && (currentDocument>-1))
	    {
			buttonGroup_DocumentMenu = new ButtonGroup();
			jMenu_Documents.removeAll();
			documentMenuVector.removeAllElements();
			dataSharingInterface.removeAllElements();
			currentDocument=-1;		
			resetComponents();
	    }
    }

    public boolean resetTrialIDWindow()	// new 5/2005
    {
	if (trialIDWindow!=null)
	{
	    trialIDWindow.setVisible(false);
	    trialIDWindow.setEnabled(false);
	    trialIDWindow.removeAll();
	    trialIDWindow = null;
	    return true;
	}
	return false;
    }

    public boolean resetImageViewWindow()	// new 5/2005
    {
	if (imageViewWindow!=null)
	{
	    imageViewWindow.setVisible(false);
	    imageViewWindow.setEnabled(false);
	    imageViewWindow.removeAll();
	    imageViewWindow = null;
	    return true;
	}
	return false;
    }

    public void resetComponents()
    {
		JTextArea areaToFill=null;

		jCheckBox_SMD_1_RightChannel.setEnabled(true);
		jCheckBox_SMD_1_LeftChannel.setEnabled(true);
		jCheckBox_SMD_1_RightChannel.setSelected(true);
		jCheckBox_SMD_1_LeftChannel.setSelected(true);

		jTextField_Input_File.setText("");
		jTextField_Output_File.setText("");
		jTextField_Log_File.setText("");

		jTextArea_Output.setText("");
		jTextArea_Input.setText("");
		jTextArea_Log.setText("");

		jComboBox_SM_From.removeAllItems();
		jComboBox_SM_To.removeAllItems();

		jRadioButton_SM_All.setSelected(true);
		jRadioButton_IOI_All.setSelected(true);


		jRadioButton_SMD_2_BlinksDontAlter.setSelected(true);

		jCheckBox_Saccades.setSelected(true);
		jCheckBox_Fixations.setSelected(true);

		jTextField_above.setText(""+0.0);
		jTextField_below.setText(""+0.0);
		jRadioButton_SMD_4_No.setSelected(true);
		jRadioButton_SMD_6_Yes.setSelected(true);

		timeSettingDialog=null;
		messageFrameDialog=null;
		itemsOfInterestDialog=null;
		dataPoolingDialog=null;
		resetTrialIDWindow();
		resetImageViewWindow();
		setMasterScriptDialog=null;
        	masterScripts=null;
		set_Enabled(false,"RESET");
    }

    // enables or disables components
    // what: RESET and AUTO
    public void set_Enabled(boolean set,String what)
    {
		if(what.equals("AUTO")) set=true;
		jCheckBox_SMD_1_RightChannel.setEnabled(false);
		jCheckBox_SMD_1_LeftChannel.setEnabled(false);
		jRadioButton_IOI_All.setEnabled(set);
		jRadioButton_IOI_Specified.setEnabled(set);

		JMenu menu = menuBar.getMenu(0);
		for(int i=2;i<menu.getMenuComponentCount();i++)
	    	menu.getMenuComponent(i).setEnabled(set);
		menuBar.getMenu(2).setEnabled(set);
		menuBar.getMenu(3).setEnabled(set);
		menuBar.getMenu(3).getMenuComponent(1).setEnabled(set);
        	menuBar.getMenu(4).setEnabled(set);

		//if(what.equals("RESET")) menuBar.getMenu(3).setEnabled(false);

		if(what.equals("AUTO")) set=false;
		jTextField_Input_File.setEnabled(set);
		jTextField_Output_File.setEnabled(set);
		jTextField_Log_File.setEnabled(set);
		jButton_Output_File.setEnabled(set);
		jButton_Log_File.setEnabled(set);

		jComboBox_SM_From.setEnabled(set);
		jComboBox_SM_To.setEnabled(set);

		jRadioButton_SM_All.setEnabled(set);
		jRadioButton_SM_Specified.setEnabled(set);

		jRadioButton_SMD_2_BlinksDontAlter.setEnabled(false);
		jRadioButton_SMD_2_BlinksRemove.setEnabled(false);
		jRadioButton_SMD_2_BlinksAdd.setEnabled(false);

		jCheckBox_Saccades.setEnabled(false);
		jCheckBox_Fixations.setEnabled(set);

		jTextField_above.setEnabled(set);
		jTextField_below.setEnabled(set);
		jRadioButton_SMD_4_No.setEnabled(set);
		jRadioButton_SMD_4_Yes.setEnabled(set);
		jRadioButton_SMD_6_No.setEnabled(false);
		jRadioButton_SMD_6_Yes.setEnabled(false);

		startButton.setEnabled(set);
    }

    // Analysis the user input on the GUI
    public void actionPerformed(ActionEvent evt)
    {
	Object source = evt.getSource();



	if(evt.getSource() instanceof JMenuItem || source==jButton_Input_File)
	    {
		try
		    {
		    	String arg = evt.getActionCommand();
                        // arg_2 only used if imageView and TrialID Window need to be reset
                        String arg_2= new String();
                       	// *** erase after debugging (???)
                       	if (source==jButton_Input_File) arg=getFiles("INPUT");
                	// ***

			if(arg.equals("Create LogFile"))
			    debugging(true);

			// File menu
			if(arg.equals("Open")) arg=getFiles("INPUT");
                        if(arg.equals("Open FLT")) arg=getFiles("FLT");
			if(arg.equals("Close"))
			    {
				((DataSharing)dataSharingInterface.
				 get(currentDocument)).closeAll();
				manageDocumentMenu("REMOVE",currentDocument,null);
			    }
			if(arg.equals("Close all"))
			    {
				manageDocumentMenu("REMOVEALL",-1,null);
				for(int i=0;i<dataSharingInterface.size();i++)
				    ((DataSharing)dataSharingInterface.get(i)).
					closeAll();
			    }
			if(arg.equals("Process")) source=startButton;
			if(arg.equals("Process all"))
			    {
				if(dataSharingInterface.size()==1)
				    source=startButton;
				else
				    {
					for(int i=0;i<dataSharingInterface.size();i++)
					   ((DataSharing)dataSharingInterface.get(i)).
					       resetFiles();

					if(!startMultiAscFilter()) return;
				    }
			    }
			// Options menu
			if(arg.equals("Auto") && (dataSharingInterface.size()!=0))
			    paintDocument(currentDocument);
			if(arg.equals("Manual") && (dataSharingInterface.size()!=0))
			    paintDocument(currentDocument);
			if(arg.equals("Select Masterscripts"))
			    {
					if (currentDocument == -1) // test new 6/2005
					{
						showErrorMessage("Must load a document first","File error");
						return;
					}

					if(setMasterScriptDialog==null)
			    		// is it being called the first time
			    			setMasterScriptDialog =
							new SetMasterScriptDialog(this,masterScripts,
						        	(String)((DataSharing)dataSharingInterface.
				 				get(currentDocument)).getPath("INPUT"));
					else
						setMasterScriptDialog.showDialog();
					setMasterScriptDialog.show();
					masterScripts = setMasterScriptDialog.getScripts();
					// *debugging* if(masterScripts!=null) masterScripts.print();
		    	}
		    	if(arg.equals("Save Masterscripts"))
			    {
			    	if (masterScripts != null) // 6/2005
				    masterScripts.saveScripts();
				else
				    showErrorMessage("No Masterscripts selected yet","Save error");
			    }
			if(arg.equals("Load Masterscripts"))
			    {
			    	masterScripts = new MasterScripts();
			    	if(masterScripts.loadScripts()==false)
			    		showErrorMessage("MasterScripts.dat not found.",
			    					"File error");
                    // *debugging* if(masterScripts!=null) masterScripts.print();
			    }

		// Document menu : switching between documents
		// stronger trialIDWindow / imageViewWindow reset 5/2005
		for(int i=0;i<documentMenuVector.size();i++)
		    if(((JRadioButtonMenuItem)documentMenuVector.get(i)).
		        getText().equals(arg))
			{
			    currentDocument=i;  // *** 6/2005: hope this is correct!
			    // *** at least getGUIReadOut should be more happy with it...
			    if (!getGUIReadOut()) // error handling 6/2005
			    {
				showErrorMessage("No current document!","File error");
				set_Enabled(true,"RESET");
			    }
			    jComboBox_SM_From.removeAllItems();
			    jComboBox_SM_To.removeAllItems();
			    currentDocument=i;
			    paintDocument(i);
			    trialItemsVectorNew=true;
			    dataPoolingDialog=null;
			    messageFrameDialog=null;
			    timeSettingDialog=null;
                            if((imageViewWindow!=null) &&
                                imageViewWindow.isVisible() &&
                                menuBar.getMenu(3).getMenuComponent(0)
                                    .isEnabled())
                                    arg_2="ImageView Window";
                            resetImageViewWindow();
			    if((trialIDWindow!=null) &&
				trialIDWindow.isVisible())
				    arg="Trial ID Window";
				    // work through TrialIDWindow so that
				    // the right trials are displayed
			    resetTrialIDWindow();
			    break;
			}

		// ImageView menu: open IV window for 1st trial or
		// make existing IV window visible
		if(arg.equals("ImageView Window") ||
                    arg_2.equals("ImageView Window"))
		    {
		    	if(imageViewWindow==null)
		    	{
		    		String trialid =
		    		    (String)(((DataSharing)dataSharingInterface.
		    			get(currentDocument))
		    			.getItemsOfInterest())[0];
				// this updates the "currentTrial" value of MasterScripts:
		    		masterScripts.checkMasterScriptDatabase(trialid);

		    		//is it being called the first time
		    		imageViewWindow = new VisualizeImage(masterScripts.getScriptPath(0),
					masterScripts.getTemplate_Name(),this,
                                        (DataSharing)dataSharingInterface
					.get(currentDocument),trialid,
                                        masterScripts.getCurrentOffset());
				}
				imageViewWindow.setVisible(true);
			}
			if(arg.equals("Trial ID Window"))
			{
				String path = (String)(((DataSharing)dataSharingInterface
							.get(currentDocument)).getPath("INPUT"));
     				String title;
				if (path.indexOf(File.separator)!=-1)
				    title = path.substring(path.lastIndexOf(File.separator)+1);
				else
				    title = path;	// not normally used
				// *** new 5/2005: re-init window:
				// otherwise, the trial list is never updated
				resetTrialIDWindow();
				resetImageViewWindow();
				Vector trialIDs = ((DataSharing)dataSharingInterface.
		    			get(currentDocument))
		    			.getScannedItemsOfInterest();
				trialIDWindow = new TrialIDWindow(trialIDs,title,
					imageViewWindow,masterScripts,
					(DataSharing)dataSharingInterface
					.get(currentDocument),this);
				trialIDWindow.setVisible(true);
                                imageViewWindow=trialIDWindow.getImageViewWindow();
			}

                        // Template Menu
                        if(arg.equals("Save Default"))
                        {
			    if (!getGUIReadOut()) // error handling 6/2005
			    {
				showErrorMessage("No current document!","File error");
				return;
			    }
                            ((DataSharing)dataSharingInterface.
		    	        get(currentDocument)).saveOptionTemplate(new File("Default.cfg"));
		    	}
		    	if(arg.equals("Save As"))
		    	{
			    if (!getGUIReadOut()) // error handling 6/2005
			    {
				showErrorMessage("No current document!","File error");
				return;
			    }
		    	    File temFile=getTemplateFile("SAVE");
		    	    if(temFile!=null)
                        	((DataSharing)dataSharingInterface.
		    		    get(currentDocument)).saveOptionTemplate(temFile);
		    	    else
		    		showErrorMessage("File was not written","File Access Cancelled");
		    	}
		    	if(arg.equals("Open Default"))
		    	{
		    		((DataSharing)dataSharingInterface.
		    		get(currentDocument)).openOptionTemplate(new File("Default.cfg"));
		    		paintDocument(currentDocument);
		    	}
		    	if(arg.equals("Open As"))
		    	{
		    		File temFile=getTemplateFile("OPEN");
		    		if(temFile!=null)
                        	{
                        		((DataSharing)dataSharingInterface.
		    			get(currentDocument)).openOptionTemplate(temFile);
		    			paintDocument(currentDocument);
		    		}
		    		else
		    		   showErrorMessage("Could not open file","File Access Cancelled");
		    	}
		    	if(arg.equals("Reset"))
		    	{
		    		((DataSharing)dataSharingInterface.
		    			get(currentDocument)).completeReset();
		    		jComboBox_SM_From.removeAllItems();
				jComboBox_SM_To.removeAllItems();
		    		paintDocument(currentDocument);
                        }
		    }
		catch(IOException e)
		    {
			System.out.println("Menu / File action error in '" +
				evt.getActionCommand() +"': " + e);
		    }
	    }

	// at start only input is enabled
	if(dataSharingInterface.size()==0) return;

	DataSharing dsi = (DataSharing)dataSharingInterface.get(currentDocument);

	if (source==jButton_Output_File) getFiles("OUTPUT");
	if (source==jButton_Log_File) getFiles("LOGFILE");

	if (source==jCheckBox_Fixations)
	    {
		if(!jCheckBox_Fixations.isSelected()) return;
		else
		    {
			if(dataPoolingDialog==null)
			    //is it being called the first time
			    dataPoolingDialog=
				new DataPoolingDialog(this,dsi);
			dataPoolingDialog.show();
		    }
	    }

	// Select Message
	if(source==jRadioButton_SM_Specified)
	    {
		if(messageFrameDialog==null)
		    //is it being called the first time
		    messageFrameDialog=
			new MessageFrameDialog(this,dsi);
		messageFrameDialog.showDialog(true);
		//updates comboboxes
		fillComboboxes();
		//if cancel button on dialog revert to all radiobutton
		if(!dsi.getMessageFramesDialog())
		    jRadioButton_SM_All.setSelected(true);
		else timeSettingDialog=null;
	    }

	if(source==jRadioButton_SM_All)
	    {
		dsi.resetMessageFrames();
		//updates comboboxes
		fillComboboxes();
                timeSettingDialog=null;
	    }

	// Time Setting: which event should force timestamps to 0?
	if(source==jRadioButton_SMD_4_Yes)
	    {
			if(timeSettingDialog==null)
			    	//is it being called the first time
			    	timeSettingDialog=
					new TimeSettingDialog(this,dsi);
			else timeSettingDialog.setWordZero();
			timeSettingDialog.show();
			//if cancel button on dialog revert to no radiobutton
			if(!dsi.getTimeSettingDialog())
		    	jRadioButton_SMD_4_No.setSelected(true);
	    }

	if(source==jRadioButton_SMD_4_No)
	    dsi.setTimeSettingStart("NS");	// never force timestamp to 0

	// Items of Interest
	if(source==jRadioButton_IOI_Specified)
	    {
		if((itemsOfInterestDialog==null) || trialItemsVectorNew)
		 {
		     // is it being called the first time
		     itemsOfInterestDialog= new ItemsOfInterestDialog(this,dsi,
						   dsi.getScannedItemsOfInterest());
		     trialItemsVectorNew=false;
		 }
		itemsOfInterestDialog.showDialog(true);
		// if cancel button on dialog revert to "all"
		if(!dsi.getItemsOfInterestDialog())
		    jRadioButton_IOI_All.setSelected(true);
	    }

	if(source==jRadioButton_IOI_All)
	    dsi.resetItemsOfInterest();

	if (source==startButton) // FLT creation
	    {
		resetTrialIDWindow();	// 5/2005
		resetImageViewWindow();	// 5/2005
		try
		    {
			// in order to be able to start the process over with new settings
			dsi.resetFiles();

			if(!startAscFilter()) return;
			fillOutputWindowFromFile("OUTPUT",dsi.getOutBackup(),
						 jTextArea_Output,dsi);
			fillOutputWindowFromFile("LOG",dsi.getLogBackup(),
						 jTextArea_Log,dsi);
                        paintDocument(currentDocument);
                        outputTabbedPane.setSelectedIndex(1);
		    }
		catch(IOException e)
		    {
			System.out.println("AscFilter file action error: " + e);
		    }
	    }

    }

    public void insertUpdate(DocumentEvent e)
    {
	setIntField();
    }

    public void removeUpdate(DocumentEvent e)
    {
	setIntField();
    }

    public void changedUpdate(DocumentEvent e)
    {
    }

    public void setIntField()
    {
	// if(jTextField_above.isValid() && jTextField_below.isValid())
    }

    // Opens a open file standard dialog and transfers the file to DataSharing
    // return needed to build the new trialIDWindow
    public String getFiles(String whatDialog)
    {
	JFileChooser d = new JFileChooser();
	File f;
	String path;
	d.setMultiSelectionEnabled(false);

	try
	    {
		// d.setCurrentDirectory(new File("."));
		// if the open is invoked for the first time set current
		// directory to the current work directory (start directory
		// the filter
		if(fileArray==null)
			d.setCurrentDirectory(new File(System.
						getProperty("user.dir")));
                else  d.setCurrentDirectory(fileArray[0]);

		if(whatDialog.equals("INPUT"))
		    {
			d.setMultiSelectionEnabled(true);
			d.setFileFilter(new javax.swing.filechooser.FileFilter()
			    {
				public boolean accept(File f)
				{
				    return f.getName().toLowerCase().endsWith(".log")
					|| f.isDirectory();
				}

				public String getDescription(){ return "Asc-Files (*.log)"; }
			    });

			d.setDialogTitle("Select Input-File");
			int result = d.showOpenDialog(null);
			if(result == JFileChooser.APPROVE_OPTION)
			    {
				String ret = new String("");
				fileArray = d.getSelectedFiles();

				// prepare to add a new document
				trialItemsVectorNew=true;
				// enable the components in order to change them
				if(currentDocument==-1)
				    set_Enabled(true,"RESET");
				else
				    if (!getGUIReadOut())
				    {
					System.out.println("No current document???");
				        return ret; // should never happen...?
				    }
				currentDocument=documentMenuVector.size();
				jComboBox_SM_From.removeAllItems();
				jComboBox_SM_To.removeAllItems();
				dataPoolingDialog=null;
				messageFrameDialog=null;
				timeSettingDialog=null;
				// if the TrialIDWindow was visible set it to the right trials
				if((trialIDWindow!=null) &&
				    trialIDWindow.isVisible())
					ret= "Trial ID Window";
				resetTrialIDWindow();
                                resetImageViewWindow();
                                // adds the datasharing object , too
                                ProgressDialog progressDialog =
					new ProgressDialog(this,dataSharingInterface,
							   this,fileArray,masterScripts);

				((JRadioButtonMenuItem)documentMenuVector.
				 get(currentDocument)).setSelected(true);
				// if a Default.cfg template exists load it
				if((new File("Default.cfg")).exists())
					((DataSharing)dataSharingInterface.
		    			get(currentDocument)).openOptionTemplate(new File("Default.cfg"));
				paintDocument(currentDocument);
				// for(int u=0;u<fileArray.length;u++)
				//     System.out.println(fileArray[u].getCanonicalFile().getCanonicalPath());
				return ret;
			    }
		    }

		if(whatDialog.equals("OUTPUT"))
		    {
			d.setFileFilter(new javax.swing.filechooser.FileFilter()
			    {
				public boolean accept(File f)
				{
				    return f.getName().toLowerCase().endsWith(".flt")
					|| f.isDirectory();
				}

				public String getDescription(){ return "Flt-Files"; }
			    });
			d.setDialogTitle("Select Output-File");

			int result = d.showSaveDialog(null);

			if(result == JFileChooser.APPROVE_OPTION)
			    {
					f = d.getSelectedFile();
					path = f.getCanonicalFile().getCanonicalPath();
					jTextField_Output_File.setText(path);
					((DataSharing)dataSharingInterface.
				 		get(currentDocument)).setOutFile(f);
			    }
		    }

		if(whatDialog.equals("LOGFILE"))
		    {
			d.setFileFilter(new javax.swing.filechooser.FileFilter()
			    {
				public boolean accept(File f)
				{
				    return f.getName().toLowerCase().endsWith(".lg")
					|| f.isDirectory();
				}

				public String getDescription(){ return "Log-Files (*.lg)"; }
			    });
			d.setDialogTitle("Select Log-File");

			int result = d.showSaveDialog(null);

			if(result == JFileChooser.APPROVE_OPTION)
			    {
				f = d.getSelectedFile();
				path = f.getCanonicalFile().getCanonicalPath();
				jTextField_Log_File.setText(path);
				((DataSharing)dataSharingInterface.
				 get(currentDocument)).setLogFile(f);
			    }
		    }
                
                if(whatDialog.equals("FLT"))
                {
                    d.setMultiSelectionEnabled(false);
                    d.setFileFilter(new javax.swing.filechooser.FileFilter()
                        {
                            public boolean accept(File f)
                            {
                                return f.getName().toLowerCase().endsWith(".flt")
                                    || f.isDirectory();
                            }

                            public String getDescription(){ return "Flt-Files (*.flt)"; }
                        });

                    d.setDialogTitle("Select an already filtered FLT Input File");

                    int result = d.showOpenDialog(null);

                    if(result == JFileChooser.APPROVE_OPTION)
                    {
                        String ret = new String("");
                        f = d.getSelectedFile();

                        // disable the components in order to change them
                        set_Enabled(false,"RESET");
                        jComboBox_SM_From.removeAllItems();
                        jComboBox_SM_To.removeAllItems();
                        dataPoolingDialog=null;
                        messageFrameDialog=null;
                        timeSettingDialog=null;
                        // if the TrialIDWindow was visible set it to the right trials
                        if((trialIDWindow!=null) &&
                            trialIDWindow.isVisible())
                                ret= "Trial ID Window";
                        resetTrialIDWindow();
			resetImageViewWindow();

                        if (!f.exists())
				return "";

			// this also resets the OUTPUT and LOG areas:
                        DataSharing dsi = new DataSharing(MAX_MESSAGES,
				MAX_ITEMSOFINTEREST, MAX_PARAMETERS);
                        dsi.setInFile(f);
                        dsi.setOutBackup(f);
                        
                        // scanning for items of interest
                        dsi.scanInputFile(); 
                       
                       currentDocument=0;
                       fillOutputWindowFromFile("OUTPUT",f,
                                         jTextArea_Output,dsi);
/* *** */	jTextArea_Input.setText("none - using FLT file directly");
			outputTabbedPane.setSelectedIndex(1);
                       dataSharingInterface.add(dsi);
                       menuBar.getMenu(3).setEnabled(true);
                       menuBar.getMenu(3).getMenuComponent(0).setEnabled(false);
                       menuBar.getMenu(3).getMenuComponent(1).setEnabled(true);
                       // menuBar.getMenu(2).setEnabled(true);

                       return ret;
                    }
                }
	    }
	catch(IOException e)
	    {
		showErrorMessage("Wrong File Type.","File error");
	    }
	return ""; //unimportant
    }

    // Displays Standard Dialog Boxes to select a File to open or save a template
    public File getTemplateFile(String whatDialog)
    {
    	JFileChooser d= new JFileChooser();
	File f;
	d.setMultiSelectionEnabled(false);

	// try {
		//d.setCurrentDirectory(new File("."));
		d.setCurrentDirectory(new File(System.
					getProperty("user.dir")));

		d.setFileFilter(new javax.swing.filechooser.FileFilter()
		{
			public boolean accept(File f)
			{
			 	return f.getName().toLowerCase().endsWith(".cfg")
					|| f.isDirectory();
			}

			public String getDescription(){return "CFG-Files (*.cfg)";}
		});
                if(whatDialog.equals("SAVE"))
		{
			d.setDialogTitle("Save Template-File As");
			int result = d.showSaveDialog(null);
			if(result == JFileChooser.APPROVE_OPTION)
				return d.getSelectedFile();
		}

	        if(whatDialog.equals("OPEN"))
	        {
			d.setDialogTitle("Open Template-File");
			int result = d.showOpenDialog(null);
			if(result == JFileChooser.APPROVE_OPTION)
				if((d.getSelectedFile()).exists())
					return d.getSelectedFile();
				else return null;
		}
	// } catch(IOException e) {
	//    showErrorMessage("Wrong File Type.","File error");
	// }
	return null; // should never happen
    }

    // performs action when START Button has been hit.
    // return true if process was succesful, false if not
    public boolean startAscFilter() //throws IOException
    {
		DataSharing dsi = (DataSharing)dataSharingInterface.get(currentDocument);

		if(!getGUIReadOut()) return false;
        
		try
	    	{
				dsi.createFiles();
				//AscFilter Parameters: 1. DataSharing Object
                // 2. is the Masterscript Object
				// 3. is the filtering process to start from the constructor
				// 4. is it a single or multi filtering
				AscFilter newFilter = new AscFilter(dsi,masterScripts,true,"SINGLE");
				dsi.createLogFile();
				
				// if an aborted Trial was found
				// modified: remove REPEATED trials, too, as
				// they confuse VisualizeImage - EA 5/2005
				if(dsi.isAbortedTrialFound())
				{
					int selection=JOptionPane.
								showConfirmDialog(this,
								"Do you want to remove the\naborted or repeated trials?",
// *** \n (Note: You must leave the TRIAL MSG in!!)",
								"Aborted Trial(s) found",
								JOptionPane.YES_NO_OPTION,
								JOptionPane.QUESTION_MESSAGE);
					if(selection== JOptionPane.OK_OPTION)
					{  
						SecondPassFilter spf = new SecondPassFilter(dsi);
					}
				}	
	    	}
		catch(IOException e)
	    	{
				showErrorMessage("I/O Error in ASC to FLT conversion","File error");
				System.exit(0);
	    	}
		return true;
    }

    // Document 0 ist the template if Auto
    public boolean startMultiAscFilter() throws IOException
    {
   		if(!getGUIReadOut()) return false;

		if(jMenuItem_AutoSelection.isSelected())
	    	{
			DataSharing source = (DataSharing)dataSharingInterface.get(0);
			for(int i=1;i<dataSharingInterface.size();i++)
		    	{
					DataSharing target = (DataSharing)dataSharingInterface.get(i);

					target.setMessageFrames(source.getMessageFrames());
					target.setDataOfInterest(source.getDataOfInterest());
					target.setTimeSettingStart(source.getTimeSettingStart());
					target.setToleranceAbove(source.getToleranceAbove());
					target.setToleranceBelow(source.getToleranceBelow());
					target.setFixations(source.getFixations());
					target.setBlinks(source.getBlinks());
					target.setTooShortFixation(source.getTooShortFixation());
					target.setFromMessageFrame(source.getFromMessageFrame());
					target.setToMessageFrame(source.getToMessageFrame());
					target.setOutOfRange(source.getOutOfRange());
					target.createFiles();
		    	}
	    }

	resetTrialIDWindow();	// 5/2005
	resetImageViewWindow();	// 5/2005
	ProgressDialog doFiltering = new ProgressDialog(this,dataSharingInterface,masterScripts);

	// display the right document
	paintDocument(currentDocument);

	return true;
    }

    // readout for all components not already set
    // returns false if error occured
    public boolean getGUIReadOut()
    {
		if (currentDocument == -1) return false; // new 6/2005
		DataSharing dsi = (DataSharing)dataSharingInterface.get(currentDocument);
		if (dsi == null) return false; // new 6/2005

		if(jCheckBox_SMD_1_LeftChannel.isSelected())
	    	if(jCheckBox_SMD_1_RightChannel.isSelected())
			dsi.setChannel("BOTH");
	    	else dsi.setChannel("L");
		else
	    	if(jCheckBox_SMD_1_RightChannel.isSelected())
			dsi.setChannel("R");
	    	else dsi.setChannel("NS");

		if(jRadioButton_SMD_2_BlinksDontAlter.isSelected())
	    	dsi.setBlinks("DONT ALTER");
		else if(jRadioButton_SMD_2_BlinksAdd.isSelected())
	    	dsi.setBlinks("ADD");
		else if(jRadioButton_SMD_2_BlinksRemove.isSelected())
	    	dsi.setBlinks("REMOVE");

		if(jCheckBox_Saccades.isSelected())
	    	if(jCheckBox_Fixations.isSelected())
			dsi.setDataOfInterest("BOTH");
	    	else dsi.setDataOfInterest("ESACC");
		else
	    	if(jCheckBox_Fixations.isSelected())
			dsi.setDataOfInterest("EFIX");
	    	else dsi.setDataOfInterest("BOTH");
			
		if(!jCheckBox_Saccades.isSelected() &&
		   !jCheckBox_Fixations.isSelected())
		   	   dsi.setDataOfInterest("NONE");

		if(jTextField_above.isValid() && jTextField_below.isValid())
	    	{
			dsi.setToleranceAbove(jTextField_above.getValue());
			dsi.setToleranceBelow(jTextField_below.getValue());
	    	}
		else
	    	{
			showErrorMessage("invalid tolerance value","Data error");
			return false;
	    	}

		if(jRadioButton_SMD_6_No.isSelected())
			dsi.setPupilSize(false);
		else dsi.setPupilSize(true);

		String from = (String)jComboBox_SM_From.getSelectedItem();
		String to = (String)jComboBox_SM_To.getSelectedItem();
		if(from.equals("not specified")) dsi.setFromMessageFrame("NS");
		else dsi.setFromMessageFrame(from);
		if(to.equals("not specified")) dsi.setToMessageFrame("NS");
		else dsi.setToMessageFrame(to);

		return true;
    }

    // fills all Output Windows
    public void fillOutputWindows()
    {
		JTextArea areaToFill = null;

		for(int i=0;i<3;i++)
	    	{
			if(i==0) areaToFill = jTextArea_Output;
			else if(i==1) areaToFill = jTextArea_Input;
			else if(i==2) areaToFill = jTextArea_Log;

			areaToFill.setText("");
			if(i==0) {
		    		areaToFill.setText(((DataSharing)dataSharingInterface.get(currentDocument))
				       	.getBackupTextAreaOutput());
				collectOutputLineNumbers(); // 5/2005
			} else if(i==1)
		    		areaToFill.setText(((DataSharing)dataSharingInterface.get(currentDocument))
				       	.getBackupTextAreaInput());
			else if(i==2)
		    		areaToFill.setText(((DataSharing)dataSharingInterface.get(currentDocument))
				       	.getBackupTextAreaLog());
			areaToFill.select(0,0);
	    	}
    }


    // fills the textarea from file and saves it in a String
    public void fillOutputWindowFromFile(String what,File f,
					 JTextArea areaToFill,DataSharing dsi)
    {
		areaToFill.setText("");

		// fill from file
		// add spaces in front of each line (for indication pointer)
		try
	    	{
			BufferedReader outputFile = new BufferedReader(new FileReader(f));
			String line;
/* *** */		String xline = new String("(none)");

			while ((line = outputFile.readLine()) != null)
			{
/* *** */			xline = line;
		    		areaToFill.append("    " + line + "\n");
			}
			outputFile.close();
/* *** */		System.out.println("SINGLE fOWFF: Last line was: '" + xline + "'");
	    	}
		catch(IOException e)
	    	{
			showErrorMessage("Error in file-handling.","File error");
	    	}
		areaToFill.select(0,0);		// move the cursor up

		if(what.equals("INPUT"))
			dsi.setBackupTextAreaInput(areaToFill.getText());
		else if(what.equals("OUTPUT")) {
			dsi.setBackupTextAreaOutput(areaToFill.getText());
			collectOutputLineNumbers(); // 5/2005
		} else if(what.equals("LOG"))
			dsi.setBackupTextAreaLog(areaToFill.getText());
    }

    public JTextArea getOutputWindow() { return jTextArea_Output; }

    // sets all components to their respective right values
    private void paintDocument(int number) throws IOException
    {
		DataSharing dsi = (DataSharing)dataSharingInterface.get(currentDocument);

		fillOutputWindows();

		jTextField_Input_File.setText(dsi.getPath("INPUT"));
		jTextField_Output_File.setText(dsi.getPath("OUTPUT"));
		jTextField_Log_File.setText(dsi.getPath("LOG"));

		fillComboboxes();
		if(!dsi.getFromMessageFrame().equals("NS"))
	    	jComboBox_SM_From.
			setSelectedItem((String)dsi.getFromMessageFrame());
		if(!dsi.getToMessageFrame().equals("NS"))
	    	jComboBox_SM_To.
			setSelectedItem((String)dsi.getToMessageFrame());
		if(!(dsi.getMessageFrames())[0].equals("ALL"))
	    	jRadioButton_SM_Specified.setSelected(true);
		else jRadioButton_SM_All.setSelected(true);

		if(!(dsi.getItemsOfInterest())[0].equals("ALL"))
	    	jRadioButton_IOI_Specified.setSelected(true);
		else jRadioButton_IOI_All.setSelected(true);

		if(dsi.getBlinks().equals("DONT ALTER"))
	    	jRadioButton_SMD_2_BlinksDontAlter.setSelected(true);
		else if(dsi.getBlinks().equals("ADD"))
	    	jRadioButton_SMD_2_BlinksAdd.setSelected(true);
		else if(dsi.getBlinks().equals("REMOVE"))
	    	jRadioButton_SMD_2_BlinksRemove.setSelected(true);

		if(dsi.getDataOfInterest().equals("BOTH"))
	    	{
				jCheckBox_Saccades.setSelected(true);
				jCheckBox_Fixations.setSelected(true);
	    	}
		else if(dsi.getDataOfInterest().equals("NONE"))
	    	{
				jCheckBox_Saccades.setSelected(false);
				jCheckBox_Fixations.setSelected(false);
	    	}	
		else if(dsi.getDataOfInterest().equals("ESACC"))
	    	{
			jCheckBox_Saccades.setSelected(true);
			jCheckBox_Fixations.setSelected(false);
	    	}
		else
	    	{
			jCheckBox_Saccades.setSelected(false);
			jCheckBox_Fixations.setSelected(true);
	    	}

		jTextField_above.setText(""+dsi.getToleranceAbove());
		jTextField_below.setText(""+dsi.getToleranceBelow());

		if(!dsi.getTimeSettingStart().equals("NS"))
	    	jRadioButton_SMD_4_Yes.setSelected(true);
		else jRadioButton_SMD_4_No.setSelected(true);

		if(dsi.getPupilSize())
	    	jRadioButton_SMD_6_Yes.setSelected(false);
		else jRadioButton_SMD_6_No.setSelected(false);

		// If AUTO has been selected disable certain Components
		// and enable them again if Manual has been selected
		if((jMenuItem_AutoSelection.isSelected()) &&
	   	(currentDocument>0)) set_Enabled(true,"AUTO");
		if((jMenuItem_ManualSelection.isSelected()) &&
	   	(currentDocument>0)) set_Enabled(true,"RESET");
        	if(currentDocument==0) set_Enabled(true,"RESET");

		//intialize channel box
		jCheckBox_SMD_1_RightChannel.setEnabled(false);
		jCheckBox_SMD_1_LeftChannel.setEnabled(false);
		jCheckBox_SMD_1_RightChannel.setSelected(false);
		jCheckBox_SMD_1_LeftChannel.setSelected(false);

		if(dsi.getScannedChannel().equals("LEFT"))
	    	{
			jCheckBox_SMD_1_RightChannel.setSelected(false);
			jCheckBox_SMD_1_RightChannel.setEnabled(false);
	    	}
		if(dsi.getScannedChannel().equals("RIGHT"))
	    	{
			jCheckBox_SMD_1_LeftChannel.setSelected(false);
			jCheckBox_SMD_1_LeftChannel.setEnabled(false);
	    	}

		// special treatment of the ImageView menu
		// only enabled if an output was created and a masterscript exists
		if(!dsi.getBackupTextAreaOutput().equals("to be created") &&
		    masterScripts!=null)
		{
			// only use trials which are of interest and were found in the file:
			for(int uu=0;uu<(dsi.getScannedItemsOfInterest()).size();uu++)
			{
				String trialid =
					(String)(((DataSharing)dataSharingInterface.
		    			get(currentDocument))
		    			.getScannedItemsOfInterest()).get(uu);
				if(masterScripts.checkMasterScriptDatabase(trialid))
				{
					menuBar.getMenu(3).getMenuComponent(0).setEnabled(true);
					break;
				}
                		else menuBar.getMenu(3).getMenuComponent(0).setEnabled(false);
                	}
		}
		else menuBar.getMenu(3).getMenuComponent(0).setEnabled(false);

		// *** disabled 5/2005: pack();
    }

/* *** now 5/2005 unused
    public void goToPosition(int position)
    {
	try
	{
		jTextArea_Output.setCaretPosition(position);
	} catch (Exception e)
	{
		System.out.println("Invalid caret position: " + position);
		System.out.println("Size of JTextArea: " +
			jTextArea_Output.getText().length());
	}
    }
*** */

/* *** now 5/2005 unused
    public void highlight(int start, int end)
    {
        jTextArea_Output.setEditable(true);
	try
	{
        	jTextArea_Output.select(start, end);
	} catch (Exception e)
	{
		System.out.println("Invalid highlight position: " +
			start + " to " + end);
		System.out.println("Size of JTextArea: " +
			jTextArea_Output.getText().length());
	}
        jTextArea_Output.setEditable(false);
    }
*** */

    // show the output tab and highlight the selected line - new 5/2005
    public void showOutputLine(int line)
    {
	int start;
	int end;
	int position;

	showTab("OUTPUT");
	line--;	// use 0 based line numbers now

	if ((outputLineStarts.size() <= (line + 1)) || (line < 0))
	{
		System.out.println("Attempted out-of-range scrolling");
		return;
	}

	start = ((Integer)outputLineStarts.get(line)).intValue();
	end = ((Integer)outputLineStarts.get(line + 1)).intValue() - 1;

	if ((line - 10) < 0)
		position = ((Integer)outputLineStarts.get(0)).intValue();
	else
		position = ((Integer)outputLineStarts.get(line - 10)).intValue();

	Point scrollTo;
	try
	{
		scrollTo = jTextArea_Output.modelToView(position).getLocation();
	} catch (javax.swing.text.BadLocationException ble)
	{
		scrollTo = new Point(0, 0);
	}
	double extentHeight = scrolledTextArea_Output.getViewport().
		getExtentSize().getHeight(); // height of visible part
	double textHeight = jTextArea_Output.getHeight();
	scrollTo.setLocation(0, scrollTo.getY()); // left edge
	// avoid scrolling beyond the bottom, which would look ugly:
	if ((scrollTo.getY() + extentHeight) > textHeight)
	{
		if ((textHeight - extentHeight) > 0)
			scrollTo.setLocation(0, textHeight - extentHeight);
		else
			scrollTo.setLocation(0, 0);
	}

        jTextArea_Output.setEditable(true);
	try
	{	// EA 5/2005: scroll to two positions above/below the line first
		// to avoid the line itself being too close to the top/bottom
		scrolledTextArea_Output.getViewport().setViewPosition(scrollTo);
        	jTextArea_Output.setCaretPosition(start);
		jTextArea_Output.moveCaretPosition(end);
	} catch (Exception e)
	{
		System.out.println("Highlight error! (" + start + ", " + end + ")");
	}
        jTextArea_Output.setEditable(false);
    }

    public void prepareOutputText(String string)
    {
        jTextArea_Output.setText("");
        int currentLetter = 0;
	char theChar = '\0';

        jTextArea_Output.append("    "); // changed to use 4 spaces to match rest
        while(currentLetter<string.length())
        {   // tuned 5/2005
            // String test=string.substring(currentLetter,currentLetter+1);
            // if(test.equals("\n")) jTextArea_Output.append("\n  ");
	    theChar = string.charAt(currentLetter);
            if(theChar == '\n')
		jTextArea_Output.append("\n    "); // changed as above
            else
		jTextArea_Output.append(Character.toString(theChar));
            currentLetter++;
        }
	if (theChar != '\n')
	{
/* *** */	System.out.println("No newline at end of file. Fixing.");
		jTextArea_Output.append("\n");
	}
        jTextArea_Output.select(0,0);
        jTextArea_Output.setEditable(false);
    }

/* *** (was already commented out before 5/2005!)
    public void erasePreviousLinePointer(String string,int position)
    {
	int currentLetter=position;
        String test = new String("");

	while(!test.equals("\n"))
	{
		if(currentLetter==0 &&
		   !string.substring(0,1).equals(">")) return;
		if(currentLetter==0 &&
		   string.substring(0,1).equals(">"))
		{
			jTextArea_Output.insert("\b ",currentLetter+1);
			return;
		}
		test=string.substring(currentLetter-1,currentLetter);
		currentLetter--;
	}
        // jTextArea_Output.setCaretPosition(currentLetter+2);
        jTextArea_Output.replaceRange(" ",currentLetter+1,currentLetter+3);
    }
*** */

/* *** (was already commented out before 5/2005!)
    public void setPointer(String string,int position)
    {
	int currentLetter=position;
        String test = new String("");

	while(!test.equals("\n"))
	{
		if(currentLetter==0)
		{
			jTextArea_Output.insert(">",0);
			break;
		}
		test=string.substring(currentLetter-1,currentLetter);
		currentLetter--;
	}
        // jTextArea_Output.setCaretPosition(currentLetter+2);
        jTextArea_Output.select(currentLetter+2,currentLetter+3);
        jTextArea_Output.cut();
        jTextArea_Output.insert(">",currentLetter+2);
    }
*** */

/* *** found to be unused (5/2005)
    public void setFixationPointer(int last,int start)
    {
    	jTextArea_Output.replaceRange(" ",last,last+2);
    	jTextArea_Output.replaceRange(">",start,start+1);
    }
*** */

    // only used with argument "OUTPUT" at the moment
    public void showTab(String whatTab)
    {
	if (whatTab.equals("OUTPUT")) outputTabbedPane.setSelectedIndex(1);
	else if (whatTab.equals("INPUT")) outputTabbedPane.setSelectedIndex(1);
	else if (whatTab.equals("LOG")) outputTabbedPane.setSelectedIndex(1);
    }

    // find char numbers for each line start in the output tab
    public void collectOutputLineNumbers()
    {
	int i;
	outputLineStarts.clear();
	try
	{
	    for (i=0; i < jTextArea_Output.getLineCount(); i++)
		outputLineStarts.add(new Integer(
		    jTextArea_Output.getLineStartOffset(i)));
	    // finally, add offset of end of last line:
	    i = jTextArea_Output.getLineCount()-1;
	    outputLineStarts.add(new Integer(
		jTextArea_Output.getLineEndOffset(i)));
	}
	catch (javax.swing.text.BadLocationException ble)
	{
	    System.out.println("collectOutputLineNumbers error?");
	}
	outputLineStarts.trimToSize();	// remove unused spaces
    }

/* *** found to be unused 5/2005
    // counts the rows by searching for carriage returns
    // if the number is bigger than the number of rows in the area
    // the letter count is returned. used by TrialIDWindow
    // *** comment 5/2005: this NEVER returns the row count,
    // *** always some letter count!
    public int countRows(String string, int start)
    {
	int rows =jTextArea_Output.getRows();
	int i=0;
	int currentLetter=start;

	while(i<rows-2)
	{	// tuned 5/2005
		// String test=string.substring(currentLetter,currentLetter+1);
		if (string.charAt(currentLetter) == '\n') i++;
		currentLetter++;
	}

	return currentLetter;
    }
*** */

    public int getCurrentDocument(){ return currentDocument; }

    private void showErrorMessage(String message, String title)
    {
		JOptionPane.showMessageDialog(this,message,title,
				      JOptionPane.ERROR_MESSAGE);
    }

    public int getMax_ItemsOfInterest() { return MAX_ITEMSOFINTEREST; }
    public int getMax_Messages() { return MAX_MESSAGES; }
    public int getMax_Parameters() { return MAX_PARAMETERS; }

    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt)
    {
	resetTrialIDWindow(); // 5/2005
	resetImageViewWindow(); // 5/2005
        try
	    {
		for(int i=0;i<dataSharingInterface.size();i++)
		    ((DataSharing)dataSharingInterface.get(i)).closeAll();
		System.exit (0);
	    }
	catch(IOException e)
	    {
		showErrorMessage("Error in file-handling.","File error");
	    }
    }

    // true -> in file; false -> on screen
    private void debugging(boolean stringOrFile)
    {

	try
	    {
		if(stringOrFile)
		    ((DataSharing)dataSharingInterface.get(currentDocument))
			.createLogFile();
	    }
	catch(IOException e)
	    {
		System.out.println("Could not create debug log file");
		System.exit(0);
	    }
    }
}

// ********************* Class DataPoolingDialog **********************
// shows the dialog to manage datapooling
class DataPoolingDialog extends JDialog implements ActionListener
{
    private int PROGRAMWIDTH;
    private int PROGRAMHEIGHT;

    // private  JTextField jTextField = new JTextField("100",5);
    private IntTextField jTextField = new IntTextField(100,5);

    private JPanel panelTSF = new JPanel();
    private ButtonGroup groupTSF = new ButtonGroup();
    private JRadioButton jRadioButton_TSF_Remove =
	addRadioButton(panelTSF,groupTSF,"remove",false);
    private JRadioButton jRadioButton_TSF_DontAlter =
	addRadioButton(panelTSF,groupTSF,"don't alter",true);
    private JRadioButton jRadioButton_TSF_PoolOrRemove =
	addRadioButton(panelTSF,groupTSF,"pool or remove",false);
    private JRadioButton jRadioButton_TSF_PoolOrDontAlter =
	addRadioButton(panelTSF,groupTSF,"pool or don't alter",false);

    private JPanel panelOORF = new JPanel();
    private ButtonGroup groupOORF = new ButtonGroup();
    private JRadioButton jRadioButton_OORF_Remove =
	addRadioButton(panelOORF,groupOORF,"remove",false);
    private JRadioButton jRadioButton_OORF_DontAlter =
	addRadioButton(panelOORF,groupOORF,"don't alter",true);
    private JRadioButton jRadioButton_OORF_AddToPrevious =
	addRadioButton(panelOORF,groupOORF,"add to previous",false);

    private JPanel panelOK = new JPanel();
    private JButton ok = addButton(panelOK,"Back",true);
    private JButton cancel = addButton(panelOK,"Cancel",true);

    private DataSharing dataSharingInterface;

    public DataPoolingDialog(JFrame parent, final DataSharing dsi)
    {
	super(parent,"Data pooling",true);

	dataSharingInterface=dsi;
	initComponents();

    }

    public DataPoolingDialog(JDialog parent, final DataSharing dsi)
    {
	super(parent,"Data pooling",true);

	dataSharingInterface=dsi;
	initComponents();
    }

    public void initComponents()
    {
	// GridBagLayout gbl = new GridBagLayout();

	getContentPane().setLayout(new GridBagLayout());
	GridBagConstraints gbc = new GridBagConstraints();

	gbc.insets = new Insets(4,2,4,2);
	// 1st row
	gbc.gridx = 0;
	gbc.gridy=0;
	getContentPane().add(new JLabel("Minimum Fixation Duration (msec):"), gbc);
	gbc.gridx = 1;
	gbc.gridy=0;
	gbc.anchor=GridBagConstraints.WEST;
        gbc.fill = GridBagConstraints.BOTH;
	getContentPane().add(jTextField,gbc);

	// 2nd row
	gbc.gridx=0;
	gbc.gridy=1;
	gbc.anchor=GridBagConstraints.NORTHWEST;
        gbc.fill = GridBagConstraints.NONE;
	getContentPane().add(new JLabel("Fixations Below Minimum:"), gbc);

	panelTSF.setLayout(new GridLayout(4,1));

	gbc.gridx=1;
	gbc.gridy=1;
	getContentPane().add(panelTSF,gbc);

	// 3rd row
	gbc.gridx=0;
	gbc.gridy=2;
	gbc.anchor=GridBagConstraints.NORTHWEST;
	getContentPane().add(new JLabel("Out-of-Range Fixations:"), gbc);

	panelOORF.setLayout(new GridLayout(3,1));
	gbc.gridx=1;
	gbc.gridy=2;
	getContentPane().add(panelOORF,gbc);

	// Back Button
	gbc.gridx=0;
	gbc.gridy=3;
	gbc.gridwidth=2;
	gbc.anchor=GridBagConstraints.CENTER;
	getContentPane().add(panelOK,gbc);

	showDialog();

	SystemAdjustment sysAdj = new SystemAdjustment();
	sysAdj.setDimension(getContentPane());
	PROGRAMWIDTH=sysAdj.getWidth();
	PROGRAMHEIGHT=sysAdj.getHeight();
	Toolkit tk = Toolkit.getDefaultToolkit();
	Dimension d=tk.getScreenSize();
	int screenHeight = d.height;
	int screenWidth = d.width;
	setBounds((screenWidth-PROGRAMWIDTH)/2,(screenHeight-PROGRAMHEIGHT)/2,
		  PROGRAMWIDTH,PROGRAMHEIGHT);
	// if(sysAdj.getSystem().startsWith("Sun")) or Mac or Linux...
	pack();
    }

    public void actionPerformed(ActionEvent evt)
    {
	Object source = evt.getSource();

	if (source== ok)
	    {
		dataSharingInterface.
		    setTooShortFixation(Integer.
					parseInt(jTextField.getText().trim()));
		String selecTSF = groupTSF.getSelection().getActionCommand();
		String selecOORF = groupOORF.getSelection().getActionCommand();
		if(selecTSF.equals("remove"))
		    dataSharingInterface.setFixations("REMOVE");
		else if(selecTSF.equals("don't alter"))
		    dataSharingInterface.setFixations("DONT ALTER");
		else if(selecTSF.equals("pool or remove"))
		    dataSharingInterface.setFixations("POOL REMOVE");
		else if(selecTSF.equals("pool or don't alter"))
		    dataSharingInterface.setFixations("POOL DONT ALTER");

		if(selecOORF.equals("remove"))
		    dataSharingInterface.setOutOfRange("REMOVE");
		else if(selecOORF.equals("don't alter"))
		    dataSharingInterface.setOutOfRange("DONT ALTER");
		else if(selecOORF.equals("add to previous"))
		    dataSharingInterface.setOutOfRange("ADD");

		setVisible(false);
	    }

	if(source==cancel) setVisible(false);
    }

    private JRadioButton addRadioButton(JPanel buttonPanel,
					ButtonGroup g,
					String buttonName,
					boolean v)
    {
	JRadioButton button = new JRadioButton(buttonName,v);
	//button.addActionListener(this);
	g.add(button);
	buttonPanel.add(button);
	button.setActionCommand(buttonName);
	return button;
    }

    private JButton addButton(Container c,String s,boolean add)
    {
	JButton b = new JButton(s);
	if(add) c.add(b);
	b.addActionListener(this);
	return b;
    }

    //recalls the settings for the Document
    public void showDialog()
    {
	jTextField.setText(""+dataSharingInterface.getTooShortFixation());

	if(dataSharingInterface.getFixations().equals("DONT ALTER"))
	    jRadioButton_TSF_DontAlter.setSelected(true);
	else if(dataSharingInterface.getFixations().equals("REMOVE"))
	    jRadioButton_TSF_Remove.setSelected(true);
	else if(dataSharingInterface.getFixations().equals("POOL REMOVE"))
	    jRadioButton_TSF_PoolOrRemove.setSelected(true);
	else if(dataSharingInterface.getFixations().equals("POOL DONT ALTER"))
	    jRadioButton_TSF_PoolOrDontAlter.setSelected(true);

	if(dataSharingInterface.getOutOfRange().equals("DONT ALTER"))
	    jRadioButton_OORF_DontAlter.setSelected(true);
	else if(dataSharingInterface.getOutOfRange().equals("REMOVE"))
	    jRadioButton_OORF_Remove.setSelected(true);
	else if(dataSharingInterface.getOutOfRange().equals("ADD"))
	    jRadioButton_OORF_AddToPrevious.setSelected(true);
    }
}

// ******************************** Class MessageFrameDialog ***********************
class MessageFrameDialog extends JDialog implements ActionListener
{
    private int PROGRAMWIDTH;
    private int PROGRAMHEIGHT;

    private DataSharing dataSharingInterface;
    private Vector frame;
    private Vector trackerMessages;
    private int size;

    private JPanel panelCheckBoxes = new JPanel();
    private JCheckBox[] checkbox;

    private JPanel panelButtons = new JPanel();
    private JButton ok = addButton(panelButtons,"Back",true);
    private JButton cancel = addButton(panelButtons,"Cancel",true);
    private JLabel spaceContainer = addLabel(panelButtons,"                   ");
    private JButton all = addButton(panelButtons,"All",true);
    private JButton none = addButton(panelButtons,"None",true);

    public MessageFrameDialog(JFrame parent, DataSharing dsi)
    {
		super(parent,"Select Messages",true);

		dataSharingInterface = dsi;
		frame=dsi.getScannedMessageFrames();
		trackerMessages=dsi.getScannedTrackerMessages();
		size=frame.size()+trackerMessages.size();//System.out.println("S="+size);
		initComponents();
    }

    public MessageFrameDialog(JDialog parent, DataSharing dsi)
    {
		super(parent,"Select Messages",true);

		dataSharingInterface = dsi;
		frame=dsi.getScannedMessageFrames();
		trackerMessages=dsi.getScannedTrackerMessages();
		size=frame.size()+trackerMessages.size();
		initComponents();
    }

    public void initComponents()
    {
		checkbox=new JCheckBox[size];
		getContentPane().setLayout(new BorderLayout());

		panelCheckBoxes.setLayout(new GridLayout(5,size/4+1,10,0));
		setCheckboxes(panelCheckBoxes);
		getContentPane().add(panelCheckBoxes,"Center");

		getContentPane().add(panelButtons,"South");
		showDialog(false);

		SystemAdjustment sysAdj = new SystemAdjustment();
		sysAdj.setDimension(getContentPane());
		PROGRAMWIDTH=sysAdj.getWidth();
		PROGRAMHEIGHT=sysAdj.getHeight();
		Toolkit tk = Toolkit.getDefaultToolkit();
		Dimension d=tk.getScreenSize();
		int screenHeight = d.height;
		int screenWidth = d.width;
		setBounds((screenWidth-PROGRAMWIDTH)/2,(screenHeight-PROGRAMHEIGHT)/2,
		  	PROGRAMWIDTH,PROGRAMHEIGHT);
		// if(sysAdj.getSystem().startsWith("Sun")) or Mac or Linux...
		pack();
    }

    public void actionPerformed(ActionEvent evt)
    {
		Object source = evt.getSource();
		int i = 0;
		String[] frames = new String[dataSharingInterface.getMax_Messages()];
		String[] track_Mes = new String[dataSharingInterface.getMax_Messages()];
		for(int x=0;x<dataSharingInterface.getMax_Messages();x++)
		    	frames[x] = "unused";
		for(int x=0;x<dataSharingInterface.getMax_Messages();x++)
		    	track_Mes[x] = "unused";

		if (source== ok)
	    	{
	        	int x=0;
			for(i = 0; i<frame.size();i++)
		    	if(checkbox[i].isSelected())
				frames[x++]=(String)frame.get(i);
			// if(x==0) ... complain about empty selection?
			if (x==0)	// foolproofing - EA
			{
				JOptionPane.showMessageDialog(this,
					"No message types selected!",
					"Selection error",
				      JOptionPane.ERROR_MESSAGE);
				return;	// stay in dialog
			}
			x=0;

        		int y=0;
                	for(; i<size;i++)
                	{
		    	if(checkbox[i].isSelected())
				track_Mes[x++]=(String)trackerMessages.get(y);
		    	y++;
			}
			// if(x==0) ... complain about empty selection?
                	// for(int z = 0; z<track_Mes.length;z++) System.out.println(track_Mes[z]);

			dataSharingInterface.setMessageFrames(frames);
			dataSharingInterface.setTrackerMessages(track_Mes);
			// button on mainframe is set to specified
			dataSharingInterface.setMessageFramesDialog(true);
			setVisible(false);
	    	}
		if(source==cancel)
	    	{   // button on mainframe is set to all, not to "as selected",
		    // as the user did not want to make a selection apparently
			dataSharingInterface.setMessageFramesDialog(false);
			setVisible(false);
	    	}

		if(source==all) setSelection(true,"ALL");
		if(source==none) setSelection(false,"ALL"); // could block "ok" button
    }

    private JCheckBox addCheckBox(JPanel p, String name)
    {
		JCheckBox c = new JCheckBox(name);
		c.setSelected(true);
		//c.addActionListener(this);
		p.add(c);
		return c;
    }

    private JButton addButton(Container c,String s,boolean add)
    {
		JButton b = new JButton(s);
		if(add) c.add(b);
		b.addActionListener(this);
		return b;
    }

    private JLabel addLabel(Container c,String s)
    {
		JLabel b = new JLabel(s);
		c.add(b);
		return b;
    }

    public void showDialog(boolean show)
    {
		int i=0;
		int x = 0;
		String[] frames = dataSharingInterface.getMessageFrames();
		String[] track_Mes = dataSharingInterface.getTrackerMessages();
		setSelection(false,"ALL");

		while(!frames[i].equals("unused"))
		{
	    	if(frames[i].equals("ALL")) setSelection(true,"REGULAR");
	    	else for(x = 0; x<frame.size();x++)
		     		if(frames[i].equals(checkbox[x].getText()))
		    			checkbox[x].setSelected(true);
	    	i++;
		}
		i=0;
		while(!track_Mes[i].equals("unused"))
		{
	    	if(track_Mes[i].equals("ALL")) setSelection(true,"TRACKER");
	    	else for(x=frame.size(); x<size;x++)
				if(track_Mes[i].equals(checkbox[x].getText()))
		    			checkbox[x].setSelected(true);
	    	i++;
		}
		if(show) show();
    }

    private void setCheckboxes(JPanel p)
    {
		int i=0;
		int x=0;

		for(i = 0; i<frame.size();i++)
			checkbox[i] = addCheckBox(p,(String)frame.get(i));
		for(; i<size;i++)
			checkbox[i] = addCheckBox(p,(String)trackerMessages.get(x++));
    }

    private void setSelection(boolean set,String what)
    {
		if(what.equals("ALL"))
			for(int i = 0; i<size;i++)
				checkbox[i].setSelected(set);
		else if(what.equals("REGULAR"))
			for(int i=0;i<frame.size();i++)
				checkbox[i].setSelected(set);
		else for(int i=frame.size();i<size;i++)
				checkbox[i].setSelected(set);
    }
}

// ****************************************************************
// ****************** Class TimeSettingDialog *********************
// ****************************************************************

class TimeSettingDialog extends JDialog implements ActionListener
{
    private int PROGRAMWIDTH;
    private int PROGRAMHEIGHT;

    private DataSharing dataSharingInterface;
    private Vector frame;

    private JPanel panelRadioButton = new JPanel();
    private ButtonGroup group = new ButtonGroup();
	// "set word to 0 y/n" and (?) "set time to 0 which"
    private JRadioButton[] radiobutton;

    private JPanel panelNorth = new JPanel();
	private JPanel panelWordZero = new JPanel();
	private JPanel panelWordZeroYesNo = new JPanel();
	private ButtonGroup group_WordZero = new ButtonGroup();
	private JRadioButton jRadioButton_WordZeroYes;
	private JRadioButton jRadioButton_WordZeroNo;
	private JPanel panelCenter = new JPanel();

    private JPanel panelButtons = new JPanel();
    private JButton ok = addButton(panelButtons,"Back",true);
    private JButton cancel = addButton(panelButtons,"Cancel",true);

    public TimeSettingDialog(JFrame parent, DataSharing dsi)
    {
		super(parent,"Set Time to Zero",true);

		dataSharingInterface = dsi;
		initComponents();
    }

    public TimeSettingDialog(JDialog parent, DataSharing dsi)
    {
		super(parent,"Set Time to Zero",true);

		dataSharingInterface = dsi;
		initComponents();
    }

    public void initComponents() // of TimeSettingDialog
    {
    	// detrime the size of the array
    	int size=0;
    	String[] frame = dataSharingInterface.getMessageFrames();
    	if(frame[0].equals("ALL"))
    		size= dataSharingInterface.getScannedMessageFrames().size();
    	else while(!frame[size++].equals("unused"));

    	radiobutton = new JRadioButton[size];
	getContentPane().setLayout(new BorderLayout());

	panelRadioButton.setLayout(new GridLayout(4,size/4+1,10,0));
	panelNorth.setLayout(new BorderLayout());
	panelWordZero.setLayout(new BorderLayout());
	panelWordZeroYesNo.setLayout(new GridLayout(1,2));
	panelWordZero.setBorder(new TitledBorder("Words"));
	panelCenter.setLayout(new BorderLayout());
	panelCenter.setBorder(new TitledBorder("Messages"));

        panelWordZero.add(new JLabel("Word Set To Zero"), "North");
	jRadioButton_WordZeroNo=addRadioButton(panelWordZeroYesNo,group_WordZero,"no",true);
	jRadioButton_WordZeroYes=addRadioButton(panelWordZeroYesNo,group_WordZero,"yes",false);
        panelWordZero.add(panelWordZeroYesNo,"South");
	panelNorth.add(panelWordZero,"North");		
	panelNorth.validate();
	getContentPane().add(panelNorth,"North");
	panelCenter.add(new JLabel("Set to Zero with each message of type"), "North");

	panelCenter.add(panelRadioButton,"Center");
	panelCenter.validate();
        getContentPane().add(panelCenter,"Center");

	setWordZero();	// set to default from datasharing
	setRadiobuttons(panelRadioButton);	// create and set to default

	getContentPane().add(panelButtons,"South");
	showDialog();
	// sets 1 radiobutton[] to true (from config file), etc.!

	SystemAdjustment sysAdj = new SystemAdjustment();
	sysAdj.setDimension(getContentPane());
	PROGRAMWIDTH=sysAdj.getWidth();
	if(PROGRAMWIDTH<250) PROGRAMWIDTH=250;
	PROGRAMHEIGHT=sysAdj.getHeight();
	Toolkit tk = Toolkit.getDefaultToolkit();
	Dimension d=tk.getScreenSize();
	int screenHeight = d.height;
	int screenWidth = d.width;
	setBounds((screenWidth-PROGRAMWIDTH)/2,(screenHeight-PROGRAMHEIGHT)/2,
	  	PROGRAMWIDTH,PROGRAMHEIGHT);
	// if(sysAdj.getSystem().startsWith("Sun")) or Mac or Linux...
		pack();
    } // initComponents of TimeSettingDialog

    public void actionPerformed(ActionEvent evt)
    {
		Object source = evt.getSource();

		if (source== ok)
	    	{
			String selection = group.getSelection().getActionCommand();
				// "which event should trigger time set to zero"

			dataSharingInterface.setTimeSettingStart(selection);

			dataSharingInterface.setWordSetToZero(
				jRadioButton_WordZeroYes.isSelected());

			// radiobutton on mainframe is set to yes
			dataSharingInterface.setTimeSettingDialog(true);
			setVisible(false);
	    	}

		if(source==cancel)
	    	{   // radiobutton on mainframe is set to no
			dataSharingInterface.setTimeSettingDialog(false);
			setVisible(false);
	    	}
    }

    private JRadioButton addRadioButton(JPanel buttonPanel,
					ButtonGroup g,
					String buttonName,
					boolean v)
    {
		JRadioButton button = new JRadioButton(buttonName,v);
		//button.addActionListener(this);
		g.add(button);
		buttonPanel.add(button);
		button.setActionCommand(buttonName);
		return button;
    }

    private JButton addButton(Container c,String s,boolean add)
    {
		JButton b = new JButton(s);
		if(add) c.add(b);
		b.addActionListener(this);
		return b;
    }

    private JLabel addLabel(Container c,String s)
    {
		JLabel b = new JLabel(s);
		c.add(b);
		return b;
    }

	public void setWordZero()
	{
        
		if(dataSharingInterface.getWordSetToZero())
			jRadioButton_WordZeroYes.setSelected(true);
		else
			jRadioButton_WordZeroNo.setSelected(true);
    }

	private void setRadiobuttons(JPanel p)
    {
		String[] frame = dataSharingInterface.getMessageFrames();
		Vector scFrame = dataSharingInterface.getScannedMessageFrames();
		int i = 0;
		boolean set;

		if(frame[0].equals("ALL")) // message types
			for(int x=0;x<scFrame.size();x++)
			{
				set=false;
				if(x==0) set=true; // 5/2005: x, not i. otherwise ALL
					// radiobuttons get selected instead of just one!
				radiobutton[x] = addRadioButton(panelRadioButton,
						   	group, (String)scFrame.get(x), set);
			}
		else while(!frame[i].equals("unused"))
	    		{
				set=false;
				if(i==0) set=true;
				radiobutton[i]= addRadioButton(panelRadioButton,
						  	group, frame[i], set);
				i++;
	    		}
    }

    public void showDialog()
    {
        String[] frame = dataSharingInterface.getMessageFrames();
        int i=0;
        boolean found = false;
    	// test ... != null necessary to test if the RadioButton exists
		while(!frame[i].equals("unused"))
		{
			if(dataSharingInterface.getTimeSettingStart().equals(frame[i]))
				for(int z=0;z<radiobutton.length;z++)
		 			if(radiobutton[z].getText().equals(frame[i])
				   	&& (radiobutton[z] !=null))
					{
						radiobutton[z].setSelected(true);
						found=true; // where is this triggered???
						break;
					}
			if(found) break;
			i++;
		}
		setWordZero();
    }
}

// ********************** Class ItemsOfInterestDialog **************************
class ItemsOfInterestDialog extends JDialog implements ActionListener
{
    private int PROGRAMWIDTH;
    // height is being calculated
    private int PROGRAMHEIGHT;

    private DataSharing dataSharingInterface;
    private String[] itemPatterns;
    private boolean firstShow; // load ITEMPAT only once
    private Vector trialItems;

    private JPanel panelCheckboxes = new JPanel();
    private JCheckBox[] checkbox;

    private JLabel label = new JLabel("Select Trial Items");

    private JPanel panelButtons = new JPanel();
    private JButton ok = addButton(panelButtons,"Back",true);
    private JButton cancel = addButton(panelButtons,"Cancel",true);
    private JLabel spaceContainer = addLabel(panelButtons,"                   ");
    private JButton all = addButton(panelButtons,"All",true);
    private JButton none = addButton(panelButtons,"None",true);
    private JTextField jTextField_Search = new JTextField(10);

    // ti = trialItems
    public ItemsOfInterestDialog(JFrame parent, DataSharing dsi,Vector ti)
    {
	super(parent,"Items Of Interest",true);

        itemPatterns=null;
	firstShow=true;
	dataSharingInterface = dsi;
	trialItems = ti;
        try
	{    
		getItemPatterns();
	}
	catch(IOException e)
	{
		System.out.println("Could not getItemPatterns (parent: JFrame)");
	}
	initComponents();
    }

    public ItemsOfInterestDialog(JDialog parent, DataSharing dsi,Vector ti)
    {
	super(parent,"Items Of Interest",true);


	itemPatterns=null;
	firstShow=true;
	dataSharingInterface = dsi;
	trialItems = ti;
        try
	{    
		getItemPatterns();
	}
	catch(IOException e)
	{
		System.out.println("Could not getItemPatterns (parent: JDialog)");
	}
	initComponents();
    }

    public void initComponents() // of ItemsOfInterestDialog
    {
	checkbox = new JCheckBox[trialItems.size()];

	getContentPane().setLayout(new BorderLayout());

	panelCheckboxes.setLayout(new GridLayout(trialItems.size()/4+1,6,10,0));
	setCheckboxes(panelCheckboxes);
	getContentPane().add(label,"North");
	getContentPane().add(panelCheckboxes,"Center");

        panelButtons.add(jTextField_Search);
// ***	jTextField_Search.addKeyListener(this); *** problematic!
// *** not better either:
//	jTextField_Search.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "processRegexp");
//	jTextField_Search.getActionMap().put("processRegexp",
// *** better, I hope - EA 5/2005:
	jTextField_Search.addActionListener(
		new AbstractAction() {
			public void actionPerformed(ActionEvent e) {
				searchMatch(jTextField_Search.getText());
			}
		}
	);
	getContentPane().add(panelButtons,"South");
	showDialog(false);

	SystemAdjustment sysAdj = new SystemAdjustment();
	sysAdj.setDimension(getContentPane());
	PROGRAMWIDTH=sysAdj.getWidth();
	PROGRAMHEIGHT=sysAdj.getHeight();
	Toolkit tk = Toolkit.getDefaultToolkit();
	Dimension d=tk.getScreenSize();
	int screenHeight = d.height;
	int screenWidth = d.width;
	if(PROGRAMWIDTH>screenWidth) PROGRAMWIDTH=screenWidth;
	// int PROGRAMHEIGHT = ((trialItems.size()/4)+1)*50;
	setBounds((screenWidth-PROGRAMWIDTH)/2,(screenHeight-PROGRAMHEIGHT)/2,
	    PROGRAMWIDTH,PROGRAMHEIGHT);
	// if(sysAdj.getSystem().startsWith("Sun")) or Mac or Linux...
	pack();
    }

    public void actionPerformed(ActionEvent evt)
    {
		Object source = evt.getSource();
		String[] items = new String[dataSharingInterface.getMax_ItemsOfInterest()];
		for(int x=0;x<dataSharingInterface.getMax_ItemsOfInterest();x++)
	    	items[x] = "unused";
		int x=0;

		if (source== ok) // "back" button
	    	{    
			for(int i = 0; i<trialItems.size();i++)
			if(checkbox[i].isSelected())
				items[x++]=(String)trialItems.get(i);

			dataSharingInterface.setItemsOfInterest(items);
			if (x==0)	// foolproofing - EA
			{
				showErrorMessage("No items selected!", "Selection error");
				// radiobutton on mainframe is set to all
				dataSharingInterface.setItemsOfInterestDialog(false);
				return;	// stay in dialog
			}
			// radiobutton on mainframe is set to specified
			dataSharingInterface.setItemsOfInterestDialog(true);
			setVisible(false);
	    	}
		if(source==cancel) // "cancel" button
	    	{   //radiobutton on mainframe is set to all
			dataSharingInterface.setItemsOfInterestDialog(false);
			setVisible(false);
	    	}
		if(source==all)  // "all" button
			setSelection(true);
		if(source==none) // "none" button
			setSelection(false);
    }

/* *** this method spoils composing, e.g. ^ plus e to get  ***
	public void keyPressed(KeyEvent evt)
    {
    	int keyCode = evt.getKeyCode();
    	if(keyCode==KeyEvent.VK_ENTER) searchMatch(jTextField_Search.getText());
    }

    public void keyTyped(KeyEvent evt){	}
    public void keyReleased(KeyEvent evt){}
    // replaced by action listener for text field... - EA 5/2005
*** */

    public void showDialog(boolean show)
    {
		String[] items = dataSharingInterface.getItemsOfInterest();
		int i=0;
		setSelection(false);

		while(!items[i].equals("unused"))
		{
	    	    if(items[i].equals("ALL"))
			setSelection(true);
	    	    else
			for(int x = 0; x<trialItems.size();x++)
			    if(items[i].equals(checkbox[x].getText()))
		    		checkbox[x].setSelected(true);
	    	    i++;
		}
		if(show)
		{	// load ITEMPAT only once
		    if(firstShow)
		    {
			setItemPatterns();
			firstShow=false;
		    }
		    show();
		}
    }


    private JCheckBox addCheckBox(JPanel p, String name)
    {
		JCheckBox c = new JCheckBox(name);
		c.setSelected(true);
		//c.addActionListener(this);
		p.add(c);
		return c;
    }

    private JButton addButton(Container c,String s,boolean add)
    {
		JButton b = new JButton(s);
		if(add) c.add(b);
		b.addActionListener(this);
		return b;
    }

    private JLabel addLabel(Container c,String s)
    {
		JLabel b = new JLabel(s);
		c.add(b);
		return b;
    }

    private void setCheckboxes(JPanel p)
    {
		for(int i = 0; i<trialItems.size();i++)
			checkbox[i] = addCheckBox(p,(String)trialItems.get(i));
    }

    private void setSelection(boolean set)
    {
		for(int i = 0; i<trialItems.size();i++)
			checkbox[i].setSelected(set);
    }
	
    // line must start with: + check matches ; - uncheck matches
    //                       # check matches and uncheck all others
    // second may be ^ -> matchpattern starts with
    //               $ -> matchpattern ends with
    // if none of the above match anywhere in string
    // -----
    // Pattern / java.util.regex needs Java 1.4 or newer!
    private void searchMatch(String pattern)
    {
	if (pattern.length() < 2)
	    return;
	String what = pattern.substring(0,1);
	boolean set= false;
	Pattern p;
	try {	// Error trap - EA 5/2005
		p = Pattern.compile(pattern.substring(1));
	} catch (java.util.regex.PatternSyntaxException pse) {
		showErrorMessage("Syntax: [+-][^$]regular expression", "Syntax error");
		return;	// invalid regular expression syntax
	}
	if(what.equals("+"))
		set=true;
	else if (what.equals("-"))
		set=false;
	else {
		showErrorMessage("Syntax: [+-][^$]regular expression", "Syntax error");
		return;	// invalid regular expression syntax
	}
		
        for(int i=0;i<checkbox.length;i++)
		{
 			Matcher m = p.matcher(checkbox[i].getText());
			if(what.equals("#")) {
				if(m.matches())
					checkbox[i].setSelected(true);
				else
					checkbox[i].setSelected(false);
			} else {
				if(m.matches())
					checkbox[i].setSelected(set);
			}
		}
		
/* *** version without regex:
		String what = pattern.substring(0,1);
		String where = null;
  		pattern=pattern.substring(1);
		boolean set= false;
		if(what.equals("+")) set=true;
		if(pattern.startsWith("^")) where="FRONT";
		else if(pattern.startsWith("$")) where="BACK";
		else where="NA";
		pattern=pattern.substring(1);

		for(int i=0;i<checkbox.length;i++)
		{
			if(what.equals("#")) {
				if(checkPattern(where,pattern,checkbox[i].getText()))
					checkbox[i].setSelected(true);
				else
					checkbox[i].setSelected(false);
			} else {
				if(checkPattern(where,pattern,checkbox[i].getText()))
					checkbox[i].setSelected(set);
			}
		}
*** */ 		
	}
	
/* *** regexp matcher replacement for old java versions
    private boolean checkPattern(String where, String pattern, String checkb)
    {
	if(where.equals("FRONT")) {
		if(checkb.startsWith(pattern))
			return true;
        	else
			return false;
	}	
	if(where.equals("BACK")) {
		if(checkb.endsWith(pattern))
			return true;
        	else
			return false;
	}	
	if(checkb.indexOf(pattern)!=-1)
		return true;
	return false;	
    }
*** */
	
    private void getItemPatterns() throws IOException
    {
        File f=new File("ITEMPAT.dat");
        if(!f.exists())
            return;
        Vector temp = new Vector(5,5);
        String line = new String("");
        BufferedReader input = new BufferedReader(new FileReader(f));
													
        while ((line = input.readLine()) != null)
        {
            if (line.equals("") || line.startsWith(";")) continue;
            temp.add(line);
        }
		
        itemPatterns=(String[])temp.toArray(new String[0]);
        // for(int i=0;i<itemPatterns.length;i++)
        //     System.out.println(itemPatterns[i]);
    } // getItemPatterns
	
	private void setItemPatterns()
	{
		if(itemPatterns==null) return;
		for(int i=0;i<itemPatterns.length;i++)
			searchMatch(itemPatterns[i]);
	}
	
	private void showErrorMessage(String message, String title)
    {
		JOptionPane.showMessageDialog(this,message,title,
				      JOptionPane.ERROR_MESSAGE);
    }
} // end of ItemsOfInterestDialog class


// *************** Class IntTextField *******************
// comfortclass of JTextField so that only integers are accepted
class IntTextField extends JTextField
{
    public IntTextField(int defval, int size)
    {
	super(""+defval, size);
    }

    protected Document createDefaultModel()
    {
	return new IntTextDocument();
    }

    public boolean isValid()
    {
	try
	    {
		Integer.parseInt(getText());
		return true;
	    }
	catch(NumberFormatException e)
	    {
		return false; // obvious
	    }
    }

    public int getValue()
    {
	try
	    {
		return Integer.parseInt(getText());
	    }
	catch(NumberFormatException e)
	    {
		return 0; // obvious... but maybe a warning message would be good?
	    }
    }
}

// ********************* Class IntTextDocument ******************
// part of InTextField- checks the input
class IntTextDocument extends PlainDocument
{
    public void insertString(int offs, String str, AttributeSet a)
    throws javax.swing.text.BadLocationException
    {
	if(str==null) return;
	String oldString = getText(0,getLength());
	String newString = oldString.substring(0,offs) +str+oldString.substring(offs);
	try
	    {
		Integer.parseInt(newString+"0");
		super.insertString(offs,str,a);
	    }
	catch(NumberFormatException e)
	    {
		System.out.println("String is no int: " + newString);
	    }
    }
}

// ******************** Class DoubleTextField ****************
// just like the integer counterpart
class DoubleTextField extends JTextField
{
    public DoubleTextField(double defval, int size)
    {
	super(""+defval, size);
    }

    protected Document createDefaultModel()
    {
	return new DoubleTextDocument();
    }

    public boolean isValid()
    {
	try
	    {
		Double.parseDouble(getText());
		return true;
	    }
	catch(NumberFormatException e)
	    {
		return false; // obvious...
	    }
    }

    public double getValue()
    {
	try
	    {
		return Double.parseDouble(getText());
	    }
	catch(NumberFormatException e)
	    {
		return 0; // obvious, but might be good to show a warning
	    }
    }
}

// ************* Class DoubleTextDocument **************
class DoubleTextDocument extends PlainDocument
{
    public void insertString(int offs, String str, AttributeSet a)
    throws javax.swing.text.BadLocationException
    {
	if(str==null) return;
	String oldString = getText(0,getLength());
	String newString = oldString.substring(0,offs) +str+oldString.substring(offs);
	try
	    {
		Double.parseDouble(newString+"0");
		super.insertString(offs,str,a);
	    }
	catch(NumberFormatException e)
	    {
		System.out.println("String is no double: " + newString);
	    }
    }
}

// ************** Class ProgressDialog *********************
// displays a Dialog to place a progressbar then calls ProgressThread
// is called by startMultiAscFilter and getFiles of FilterGUI
class ProgressDialog extends JDialog
{
    private int PROGRAMWIDTH;
    private int PROGRAMHEIGHT;
    private int max; //number of lines in all documents

    private ProgressThread progressThread;
    private JLabel label;
    private Vector dsi;
    private MasterScripts masterScripts;
    private FilterGUI gui;
    private File[] fileArray;

    //called by startMultiAscFilter(FilterGUI)
    public ProgressDialog(JFrame parent,Vector dataSharing,MasterScripts ms)
    {
	super(parent,"Please Wait",true);
	max=0;
	dsi = dataSharing;
	masterScripts = ms;
	initComponents();
    }

    // called by getFiles (FilterGUI)
    public ProgressDialog(JFrame parent,Vector dataSharing,FilterGUI g,
    			  File[] files,MasterScripts ms)
    {
	super(parent,"Please Wait",true);
	max=0;
	dsi = dataSharing;
	masterScripts = ms;
	gui=g;
	fileArray=files;
	initComponents();
    }


    public void initComponents() // of ProgressDialog
    {
    	label = new JLabel("Overall Progress");
        getContentPane().setLayout(new BorderLayout());
        getContentPane().add(label,BorderLayout.NORTH);

	SystemAdjustment sysAdj = new SystemAdjustment();
	sysAdj.setDimension(getContentPane());
	PROGRAMWIDTH=sysAdj.getWidth();
	if(PROGRAMWIDTH<250) PROGRAMWIDTH=250;
	PROGRAMHEIGHT=sysAdj.getHeight();
	Toolkit tk = Toolkit.getDefaultToolkit();
	Dimension d=tk.getScreenSize();
	int screenHeight = d.height;
	int screenWidth = d.width;
	setBounds((screenWidth-PROGRAMWIDTH)/2,(screenHeight-PROGRAMHEIGHT)/2,
		  PROGRAMWIDTH,PROGRAMHEIGHT);
	// if(sysAdj.getSystem().startsWith("Sun")) or Mac or Linux...
	pack();
	//catches open window event to start the thread
	addWindowListener(new java.awt.event.WindowAdapter()
	    {
		public void windowOpened(java.awt.event.WindowEvent evt)
		{
                   start();
		}
	    }
			  );
	setVisible(true);
    }

    private void start()
    {
      	if(fileArray==null)
      	{
      		calculateMax(dsi);
    		progressThread = new ProgressThread(this,label,max,dsi,masterScripts);
    	}
    	else progressThread = new ProgressThread(this,label,gui,dsi,fileArray,masterScripts);
	progressThread.start();
    }

    // adds up the lines auf all input files
    private void calculateMax(Vector dataSharingInterface)
    {
    	for(int i=0;i<dataSharingInterface.size();i++)
    	   max+=((DataSharing)dataSharingInterface.get(i)).getLineCount();
    }
}


// ***************** ProgressThread ************************
// creats a thread to display a ProgressBar
// is called (only) by ProgressDialog
// displays for startMultiAscFile and getFiles of FilterGUI
class ProgressThread extends Thread
{

    private JProgressBar pb;
    private JPanel progPanel;
    //private ProgressInfo pi;
    private JDialog f;
    private JLabel label;
    private boolean interrupt;
    private int max;
    private Vector dataSharingInterface;
    private MasterScripts masterScripts;
    private JTextArea area;
    private FilterGUI gui;
    private File[] fileArray;

    public ProgressThread(JDialog f, JLabel l,int m,Vector dsi,MasterScripts ms)
    {
        this.f = f;
        label = l;
        max = m;
        area = new JTextArea();
        dataSharingInterface=dsi;
        masterScripts = ms;
        progPanel = new JPanel();
        f.getContentPane().add(progPanel, BorderLayout.CENTER);
        setPriority(3);
    }

    public ProgressThread(JDialog f, JLabel l,FilterGUI g,Vector dsi,
    			  File[] files,MasterScripts ms)
    {
        this.f = f;
        label = l;
        gui=g;
        fileArray=files;
        max = fileArray.length;
        dataSharingInterface=dsi;
        masterScripts = ms;
        progPanel = new JPanel();
        f.getContentPane().add(progPanel, BorderLayout.CENTER);
        setPriority(3);
    }

    public void run()
    {
        interrupt=false;
        try
        	{
        		createProgBar("Testing");
        	}
        catch(IOException e)
        	{
			System.out.println("Progress bar thread error.");
        	}
    }

    public void createProgBar(String title) throws IOException
    {
        pb = new JProgressBar(0,max);
        pb.setSize(100,100);
        pb.setStringPainted(true);
        progPanel.add(pb);
        f.pack(); // ???
        if(fileArray==null) doFiltering();
        else doLoading();
        cleanup();
    }

    // startMultiAscFilter (FilterGUI)
    public void doFiltering() throws IOException
    {
        int currentPosition=0;

        for(int i=0;i<dataSharingInterface.size();i++)
	    {
		DataSharing dsi = (DataSharing)dataSharingInterface.get(i);
		dsi.setProgressBar(pb,progPanel);
		dsi.setProgressBarCurrent(currentPosition);

		//AscFilter Parameters: 1. DataSharing Object
		// 2. ist the filtering process to start from the constructor
		// 3. ist it a single or multi filtering
	        AscFilter newFilter = new AscFilter(dsi,masterScripts,true,"MULTI");

	 	dsi.createLogFile();
	 	currentPosition+=dsi.getProgressBarCurrent();
		//to save the data from the files to the string vars
		fillOutputWindowFromFile("OUTPUT",dsi.getOutBackup(),
					area,dsi);
		fillOutputWindowFromFile("LOG",dsi.getLogBackup(),
				        area,dsi);
	    }

    }

    // getFiles (FilterGUI)
    public void doLoading() throws IOException
    {
    	int MAX_ITEMSOFINTEREST=gui.getMax_ItemsOfInterest();
		int MAX_MESSAGES=gui.getMax_Messages();
		int MAX_PARAMETERS=gui.getMax_Parameters();

    	for(int w=0;w<fileArray.length;w++)
		{
			if (!fileArray[w].exists()) continue;
			// also resets OUTPUT and LOG panels:
			DataSharing dsi = new DataSharing(MAX_MESSAGES,
				MAX_ITEMSOFINTEREST, MAX_PARAMETERS);
                        
                        // AdjustInFile aif = new AdjustInFile();
                        File inf = AdjustInFile.doAdjust(fileArray[w]);

			dsi.setInFile(inf);
			dsi.setOutFileName("unused",".flt","FLT");
			dsi.setOutFileName("unused",".lg","LOG");
			// scanning for items of interest
			dsi.scanInputFile();

			// fillOutputWindowFromFile("INPUT",fileArray[w],
			//	jTextArea_Input,dsi);
			// "now done in scanInputFile; for speedup"

			dataSharingInterface.add(dsi);
                        updateProgressBar(w+1);
			gui.manageDocumentMenu("ADD",-1,fileArray[w]);

		}
    }

    public void updateProgressBar(int p)
    {
        label.setText(" Overall Progress");
        pb.setValue(p);
        progPanel.removeAll();
        progPanel.add(pb);
        progPanel.revalidate();
    }
    public void reset()
    {
        interrupt=true;
    }

    public void cleanup()
    {
        updateProgressBar(0);
        progPanel.removeAll();
        f.validate();
        pb = null;
        f.setVisible(false);
    }

    private void fillOutputWindowFromFile(String what,File f,
					 JTextArea areaToFill,DataSharing dsi)
    {
	areaToFill.setText("");

	// fill from file
	// add spaces in front of each line (for indication pointer)
	try
	    {
		BufferedReader outputFile= new BufferedReader(new FileReader(f));
		String line;
/* *** */	String xline = new String("(none)");

		while ((line = outputFile.readLine()) != null)
		{
/* *** */	    xline = line;
		    areaToFill.append("    " + line + "\n");
		}
		outputFile.close();
/* *** */	System.out.println("MULTI fOWFF: Last line was: '" + xline + "'");
	    }
	catch(IOException e)
	    {
		System.out.println("Error in output file handling.");
	    }
	areaToFill.select(0,0); // move the cursor up

	if(what.equals("INPUT")) dsi.setBackupTextAreaInput(areaToFill.getText());
	else if(what.equals("OUTPUT")) dsi.setBackupTextAreaOutput(areaToFill.getText());
	else if(what.equals("LOG")) dsi.setBackupTextAreaLog(areaToFill.getText());

    }

}

// ****************** Class SetMasterScriptDialog **************************
// Display the Dialog for choosing the Masterscripts
class SetMasterScriptDialog extends JDialog implements ActionListener
{
    private int PROGRAMWIDTH;
    private int PROGRAMHEIGHT;

    private MasterScripts masterScripts;
    private Vector fileVector = new Vector(10,10);
    private String path;

    private JPanel panelAdd_Erase;
    private JButton jButton_Add;
    private JButton jButton_Erase;
    private JList list;
    private DefaultListModel model;
    private JScrollPane scrollPane;

    private JPanel panelOK = new JPanel();
    private JButton ok = addButton(panelOK,"Back",true);
    private JButton cancel = addButton(panelOK,"Cancel",true);

    public SetMasterScriptDialog(JFrame parent, MasterScripts ms, String p)
    {
	super(parent,"Masterscripts",true);

	masterScripts = ms;
	path=p;
	initComponents();
     	try
     	{
     		if(ms!=null) showDialog();
     	}
     	catch(IOException e)
     	{
		System.out.println("Problem with MasterScript dialog");
     	}
    }

    public void initComponents() // of SetMasterScriptDialog
    {
	model = new DefaultListModel();
	list = new JList(model);
	scrollPane = new JScrollPane(list);
        list.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

	panelAdd_Erase = new JPanel();
	panelAdd_Erase.setLayout(new GridLayout(2,1,10,10));
        jButton_Add = addButton(panelAdd_Erase,"Add",true);
        jButton_Erase = addButton(panelAdd_Erase,"Erase",true);

	getContentPane().setLayout(new BorderLayout(10,10));
	//  panel
	getContentPane().add(panelAdd_Erase,"East");
	getContentPane().add(panelOK,"South");
        getContentPane().add(scrollPane,"Center");

	SystemAdjustment sysAdj = new SystemAdjustment();
	//maybe adjust to System
	scrollPane.setPreferredSize(new Dimension(70,100));
	sysAdj.setDimension(getContentPane());
	PROGRAMWIDTH=sysAdj.getWidth();
	PROGRAMHEIGHT=sysAdj.getHeight();
	Toolkit tk = Toolkit.getDefaultToolkit();
	Dimension d=tk.getScreenSize();
	int screenHeight = d.height;
	int screenWidth = d.width;
	setBounds((screenWidth-PROGRAMWIDTH)/2,(screenHeight-PROGRAMHEIGHT)/2,
		  PROGRAMWIDTH,PROGRAMHEIGHT);
	// if(sysAdj.getSystem().startsWith("Sun")) or Mac or Linux...
	pack();
    }

    public void actionPerformed(ActionEvent evt)
    {
	Object source = evt.getSource();

	if (source== ok)
	    {
                masterScripts = new MasterScripts((Vector)fileVector.clone());
                fileVector.removeAllElements();
		setVisible(false);
	    }

	if(source==cancel)
		{
			setVisible(false);
		}

	if(source==jButton_Add) addFiles();
	if(source==jButton_Erase) eraseFile();
    }

    private JButton addButton(Container c,String s,boolean add)
    {
	JButton b = new JButton(s);
	if(add) c.add(b);
	b.addActionListener(this);
	return b;
    }

    private JLabel addLabel(Container c,String s)
    {
	JLabel b = new JLabel(s);
	c.add(b);
	return b;
    }

    //recalls the settings for the Document
    public void showDialog()  throws IOException
    {
    	if(masterScripts!=null)
    	{
            model.clear();
            //System.out.println(""+masterScripts.getSize());
            for(int i=0;i<masterScripts.getSize();i++)
            {
            	fileVector=masterScripts.getMasterScripts();
            	model.addElement(masterScripts.getScriptName(i));
            }
    	}
    }

    public MasterScripts getScripts()
    {
    	return masterScripts;
    }

    public void addFiles()
    {
	JFileChooser d= new JFileChooser();
	File[] fileArray;
	d.setMultiSelectionEnabled(true);

	try
	    {
		d.setCurrentDirectory(new File(path));


			d.setFileFilter(new javax.swing.filechooser.FileFilter()
			    {
				public boolean accept(File f)
				{
				    return f.getName().toLowerCase().endsWith(".txt")
					|| f.isDirectory();
				}

				public String getDescription(){return "Script-Files (*.txt)";}
			    });

			d.setDialogTitle("Select Script-File");
			int result = d.showOpenDialog(null);
			if(result == JFileChooser.APPROVE_OPTION)
			    {
				fileArray = d.getSelectedFiles();

                                for(int i=0;i<fileArray.length;i++)
                                {
					String path =fileArray[i].
						getCanonicalFile().getCanonicalPath();
     					String title = path.
     						substring(path.lastIndexOf(File.separator)+1);
					model.addElement(title);
					fileVector.add(fileArray[i]);
				}
			    }
		}
	catch(IOException e)
	{
		System.out.println("addFiles I/O error");
	}
   }

   private void eraseFile()
   {
   	fileVector.removeElementAt(list.getSelectedIndex());
   	model.removeElement(list.getSelectedValue());
   }
}






