import java.io.*;
import java.util.Vector;
import java.util.StringTokenizer;

// 01/08/03 added MouseClick Trials (hitColorVector,
// wordSetToZeroVector)

class MasterScripts
{
     private Vector scripts;  // masterscript file name vector
     private Vector pictureVector;
     private Vector templateVector;
     private Vector offsetVector;
     private Vector trialIDVector;
     private Vector hitColorVector; // added 01/08/03
     private Vector wordSetToZeroVector; // added 01/08/03
     private int currentTrial; // number of the trial currently processed

     // gets called from MasterScriptsDialog Class
     public MasterScripts(Vector fa)
     {
          scripts= fa;
          pictureVector=new Vector(20,20);
          templateVector=new Vector(20,20);
     	  offsetVector=new Vector(20,20);
     	  trialIDVector=new Vector(20,20);
		  hitColorVector = new Vector(20,20);
		  wordSetToZeroVector = new Vector(20,20);
     	  currentTrial=-1;
     	  try
     	  {
     	  	scanScriptFiles();
     	  }
     	  catch(IOException e)
     	  {
		System.out.println("I/O Error during MasterScripts scan");
     	  }
     }

     public MasterScripts()
     {
	  scripts= new Vector(20,20);
          pictureVector=new Vector(20,20);
          templateVector=new Vector(20,20);
     	  offsetVector=new Vector(20,20);
     	  trialIDVector=new Vector(20,20);
		  hitColorVector = new Vector(20,20);
		  wordSetToZeroVector = new Vector(20,20);
     	  currentTrial=-1;
     }

     public String getScriptFileName(int number) throws IOException
     	{ return ((File)scripts.get(number)).getCanonicalFile().getCanonicalPath(); }

     public int getCurrentTrial() { return currentTrial; }

     public int getSize(){ if (scripts==null) return 0; return scripts.size(); }

     public Vector getMasterScripts(){ return (Vector)scripts.clone(); }

     public String getScriptName(int number) throws IOException
     {
     	String path =getScriptFileName(number);
     	return path.substring(path.lastIndexOf(File.separator)+1);
     }

     public int getWordSetToZero(int number)
 	{ return Integer.parseInt((String)wordSetToZeroVector.get(number)); }

     public int getOffset(int n) 
        { return Integer.parseInt((String)offsetVector.get(n)); }
		
     public void arrayToVector(File[] fileArray)
     {
     	for(int i=0;i<fileArray.length;i++)
     		scripts.add(fileArray);
     }

     private void scanScriptFiles() throws IOException
     {
     	  File file;
     	  int current=0;
     	  String line = new String();
	  String token = new String();
	  String dummy = new String(); //temp variable

	  if (getSize()==0)
	  {
		System.out.println("No Master Scripts to scan!");
		return;
	  }

     	  for(int i=0;i<getSize();i++)
     	  {
     	  	file=(File)scripts.get(i);
     	  	if(!file.exists()) {
			System.out.println("File missing: " + file.getPath());
			System.exit(0);
		}
     	  	BufferedReader input = new BufferedReader(new FileReader(file));

     	        while ((line = input.readLine()) != null)
	 	{
			if(line.equals("")) continue;
			int errorAt=0;
			StringTokenizer tokenLine= new StringTokenizer(line);

		    try
		    {
		        	//first token of the line
				token = tokenLine.nextToken();
				if(token.equals("#") ||
				token.equalsIgnoreCase("define")) continue;

				//store next token in dummy (discard it
				//later if it isnot a imagetrial)
				dummy = tokenLine.nextToken();
				// next token should be an irrelvant number
				token = tokenLine.nextToken();
				//next token
				token = tokenLine.nextToken();
				if(!token.startsWith("image")) continue;
				//saving the trial
				trialIDVector.add(dummy);
				errorAt=1;
                                //next token: the offset
                                token = tokenLine.nextToken();
                        	offsetVector.add(token);
                                errorAt=2;
                        	//next token the template
				token = tokenLine.nextToken();
				//check if a entire path is given and remove it
				token = stripDirectory(token);
                                System.out.print("Image: " + token +
				    "            \r");
				templateVector.add(token);
				errorAt=3;
				wordSetToZeroVector.add("-10000");
			}
			catch (java.util.NoSuchElementException e)
			{       // the error means that there where some tokens missing
				// cleaning up the Vectors
				if(errorAt==1)
					trialIDVector.
					removeElementAt(trialIDVector.size()-1);
				if(errorAt==2)
					{
						trialIDVector.
						removeElementAt(trialIDVector.size()-1);
						pictureVector.
						removeElementAt(pictureVector.size()-1);
					}
				if(errorAt==3)
					{
						/*trialIDVector.
						removeElementAt(trialIDVector.size()-1);
						pictureVector.
						removeElementAt(pictureVector.size()-1);
						templateVector.
						removeElementAt(templateVector.size()-1);*/
						
					}
				continue;
			} // catch
		} // while lines
	} // for scripts.size
	System.out.println("\nMaster scripts: image file names for all trials loaded.");
     }

     public boolean checkMasterScriptDatabase(String trialid)
     {  //System.out.println(trialid);
	 	int index = trialid.indexOf("PAGE");
        if(index>=0) trialid=trialid.substring(0,index);
		
     	for(int i=0;i<trialIDVector.size();i++)
		{
			String toCheck = (String)trialIDVector.get(i);
     		if(trialid.equals(toCheck))
     		{
     			currentTrial=i;
     			return true;
     		}
		}
		//System.out.println("nonono");
     	return false;
     }

     public String getTemplate_Name() { return (String)templateVector.get(currentTrial); }

     public String getScriptPath(int number) throws IOException
     {
     	String path = ((File)scripts.get(number)).getCanonicalFile().getCanonicalPath();
     	return path.substring(0,path.lastIndexOf(File.separator)+1);
     }

     public TrialItemImage getTemplate(int width,int height) throws IOException
     {
     	String path =((File)scripts.get(0)).getCanonicalFile().getCanonicalPath();
     	String minusTitle = path.substring(0,path.lastIndexOf(File.separator)+1);
     	//System.out.println(path+"|"+minusTitle+"|"+(String)templateVector.get(currentTrial));
     	TrialItemImage image = new TrialItemImage(minusTitle, (String)templateVector.get(currentTrial),
		width, height, getCurrentOffset());
        // if there is no image(the template isn't there) return null
        if(image.getWidth() == 0) return null;
     	return image;
     }
	 
     public int getCurrentWordSetToZero() { return getWordSetToZero(currentTrial); }

     public int getCurrentOffset() { return getOffset(currentTrial); }

	// check if the template name is an entire path
	// if so strip it.
	public String stripDirectory (String str)
	{
                int sepWin=  str.lastIndexOf("\\");
		int sepMac= str.lastIndexOf("/");
		if(sepWin !=-1 &&
			sepMac !=-1) return str;
		
		if(sepWin !=-1)
			return str.substring(sepWin+1,str.length());
		if(sepMac !=-1)
			return str.substring(sepMac+1,str.length());

		return str;			
	}
        
    public boolean saveScripts()
    {
	if (getSize()==0)
	{
	    System.out.println("No Master Scripts to save!");
	    return false;
	}
     	try
    	{
	    PrintWriter outMSTem =
    		new PrintWriter(new FileWriter(new File("MasterScripts.dat")));
            File file;

            for(int i=0;i<getSize();i++)
     	    {
     	  	file=(File)scripts.get(i);
     	  	outMSTem.println(file.getCanonicalFile().getCanonicalPath());
     	    }
     	    outMSTem.close();
     	    return true;
        }
     	catch (IOException e)
     	{
	    System.out.println("Error saving master scripts");
     	    return false;
     	}
     } // saveScripts

     public boolean loadScripts()
     {
     	try
    	{
    		BufferedReader inMSTem =
    			new BufferedReader(new FileReader(new File("MasterScripts.dat")));
    		String line = new String("");
        	int i=0;
                scripts.removeAllElements();

                while ((line = inMSTem.readLine()) != null)
	    	{
	    		scripts.add(new File(line));
	    	}
	    	inMSTem.close();
	    	scanScriptFiles();
     	 	return true;
	}
	catch (IOException e)
     	 {
		System.out.println("Error loading master scripts");
     	 	return false;
     	 }
     } // loadScripts

     /* Debugging */
     public void print()
     {
     	for(int i=0;i<pictureVector.size();i++)
     	{
     		System.out.println(trialIDVector.get(i)+" | "+
     			pictureVector.get(i)+" | "+
     			templateVector.get(i)+" | "+
     			offsetVector.get(i) +" | " +
				hitColorVector.get(i) +" |" +
				wordSetToZeroVector.get(i));				
     	} 
     } // print
}
