/* class SecondPassFilter
   Modifies the filtered file (FLT file) - Erases Aborted or Repeated Trials
*/

import java.io.*;

class SecondPassFilter
{
    // fixation and saccades constants for SMI style files:
    // channel 0, onset 1, offset 2, duration 3,
    // start x 4, start y 5, land x (or efix pupil size) 6, land y 7,
    // amplitude 8, peak velocity 9
    // msg onset 0, msg keyword 1, msg 2nd 2

    DataSharing dsi;
    private BufferedReader inFile;
    private PrintWriter outTemp;
    java.util.Vector toWrite;

	public SecondPassFilter(DataSharing ds) throws IOException
	{
           dsi = ds;
	   toWrite = new java.util.Vector(100,100);
		   
	   File in = dsi.getOutBackup();
	   inFile = new BufferedReader(new FileReader(in));
	   String path = dsi.getPath("OUTPUT") ;
	   String entry = path.substring(0,path.lastIndexOf(File.separator)+1);
	   // System.out.println(entry);
	   File neu = new File(entry+"out.tmp");
	   outTemp = new PrintWriter(new FileWriter(neu));
		   
	   eraseAborted();
	   outTemp.close();
	   inFile.close();
	   in.delete();
	   neu.renameTo(in);
	}
	
        // read the file and remove all repeated or aborted trials
	private void eraseAborted() throws IOException
	{
	    String line = new String();
	    String which = "(no TrialID)";

	    while ((line = inFile.readLine()) != null)
	    {
		if (line.indexOf("TRIALID")!=-1) // next trial - write previous
		{
                    writeLines();
		    toWrite.clear();
		    which = line.substring(line.indexOf("TRIALID"));
		}

		if (line.indexOf("TRIAL")!=-1 &&
		    (line.indexOf("ABORTED")!=-1 || line.indexOf("REPEATED")!=-1))
		{
		    toWrite.clear(); // zap buffer if trial ends by abort / repeat
		    System.out.println("Removed aborted/repeated trial: " + which);

		    // new 5/2005: throw away extra lines between abort and TRIALID
		    // (in particular: TRIAL_RESULT 0)
		    while ((line = inFile.readLine()) != null)
			if (line.indexOf("TRIALID")!=-1) {
			    toWrite.add(line);
			    which = line.substring(line.indexOf("TRIALID"));
			    break; // break out of while()
			}
		}
                else
		{
		    toWrite.add(line); // store this line
		}
            } // while
        // print the remaining lines
		writeLines();
	}
	
	private void writeLines() throws IOException
	{
		for (int i=0; i<toWrite.size(); i++)
			outTemp.println((String)toWrite.get(i));
	}
}
