
// import java.awt.*; (Container, Dimension, font)
import java.awt.Font;
import javax.swing.*;
import javax.swing.plaf.*; // pluggable Look and Feel
// import java.awt.event.*;
// import java.io.*;
// import java.util.*;

/* gathers info about the system */

class SystemAdjustment
{
    private int height;
    private int width;
    private String system;

    public SystemAdjustment()
    {
	height=0;
	width=0;
	system=System.getProperty("os.name");
    }

    public void setDimension(java.awt.Container c)
    {
	java.awt.Dimension dim = c.getPreferredSize();
	int offsetH=0;
	int offsetW=0;

	if(system.startsWith("Windows"))
	    {
		offsetH=62;
		offsetW=29;
	    }

	if(system.startsWith("Sun"))
	    {
		offsetH=100;
		offsetW=100;
	    }

	height = (int)dim.getHeight()+offsetH;
	width = (int)dim.getWidth()+offsetW;

	/* System.out.println(system);
	 * System.out.println(""+width);
	 * System.out.println(""+height);
         */
    }

    public int getWidth() {return width;}
    public int getHeight() {return height;}
    public String getSystem() {return system;}

    public static void setGlobalFont(String fontname, String fs)
    {
	int fontSize = Integer.parseInt(fs);
	Font userEntryFont = new Font(fontname, Font.PLAIN, fontSize);
	Font defaultFont = new Font(fontname, Font.PLAIN, fontSize);
	Font boldFont = new Font(fontname, Font.BOLD, fontSize);

	// User entry widgets
	UIManager.put("Text.font", new FontUIResource(userEntryFont));
	UIManager.put("TextField.font", new FontUIResource(userEntryFont));
	UIManager.put("TextArea.font", new FontUIResource(userEntryFont));
	UIManager.put("TextPane.font", new FontUIResource(userEntryFont));
	UIManager.put("List.font", new FontUIResource(userEntryFont));
	UIManager.put("Table.font", new FontUIResource(userEntryFont));
	UIManager.put("ComboBox.font", new FontUIResource(userEntryFont));


	// Non-user entry widgets
	UIManager.put("Button.font",new FontUIResource(defaultFont));
	UIManager.put("Label.font", new FontUIResource(defaultFont));
	UIManager.put("Menu.font", new FontUIResource(defaultFont));
	UIManager.put("MenuItem.font", new FontUIResource(defaultFont));
	UIManager.put("ToolTip.font", new FontUIResource(defaultFont));
	UIManager.put("ToggleButton.font", new FontUIResource(defaultFont));
	UIManager.put("TitledBorder.font", new FontUIResource(boldFont));
	UIManager.put("CheckBox.font", new FontUIResource(defaultFont));
	UIManager.put("RadioButton.font", new FontUIResource(defaultFont));
	UIManager.put("PopupMenu.font", new FontUIResource(defaultFont));
	UIManager.put("TableHeader.font", new FontUIResource(defaultFont));
	UIManager.put("PasswordField.font", new FontUIResource(defaultFont));

	// Containters
	UIManager.put("ToolBar.font", new FontUIResource(defaultFont));
	UIManager.put("MenuBar.font", new FontUIResource(defaultFont));
	UIManager.put("Panel.font", new FontUIResource(defaultFont));
	UIManager.put("ProgressBar.font", new FontUIResource(defaultFont));
	UIManager.put("TextPane.font", new FontUIResource(defaultFont));
	UIManager.put("OptionPane.font", new FontUIResource(defaultFont));
	UIManager.put("ScrollPane.font", new FontUIResource(defaultFont));
	UIManager.put("EditorPane.font", new FontUIResource(defaultFont));
	UIManager.put("ColorChooser.font", new FontUIResource(defaultFont));
	UIManager.put("TabbedPane.font", new FontUIResource(defaultFont));
	UIManager.put("InternalFrame.font", new FontUIResource(defaultFont));
    }

}
