/* 
 * this class creates a form to display an
 * image (a TrialItem) and handles all drawing
 * functions like showing fixations, drawing
 * lines between fixations, and so on.
 */

import java.io.*; // File access in correctOutputFile
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import javax.swing.*;
// import javax.swing.event.*;
// import java.util.*;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.StringTokenizer;

// changed Ver1.6 05/18/03 made scalable
// added Ver 2.0 08/01/03 added Mouseclick

// JFrame overrides removed 5/2005: getWidth, getHeight, update.
// JFrame overrides working: paint.
// added fixation count display and colored lines 5/2005 - EA.
// made image offset DPI style 5/2005 - EA
// fixed some scaling / correction bugs 5/2005 - EA

class VisualizeImage extends JFrame implements ActionListener,
	AdjustmentListener, KeyListener, MouseMotionListener,
	javax.swing.event.ChangeListener, MouseListener // M.L. new 6/2005
{
    private Image image;			// canvas for drawing
    private TrialItemImage trialItemImage;	// pixel array with read methods
    private int width, height;	// size of canvas (display), not of embedded image!

    private Fixations fixations;
    private Hashtable toc;		// text objects (words)
    private FilterGUI gui;
    private DataSharing dsi;

    private String path;
    private String fileName;
    private String currentTrial;	// trial ID
    private int offset;	// encodes image Y position relative to canvas

    // unused: private String trialTitel;
    // unused: private int lastLine;
    // unused: private PixelGrabber grabber;
    // private String mode; // with LINES, WITHOUT - imagepanel property now!

    private ImagePanel jPanel_Image; // see ImagePanel class below
    private JPanel jPanel_Buttons;
    private JButton jButton_Next;
    private JButton jButton_Previous;
    private JButton jButton_All;
    private JButton jButton_Clear;
    private JPanel jPanel_Unten;

    private JTextField jTextField_Stats;	// new 5/2005
    private JScrollBar jScrollBar_Horizontal;
    private JScrollBar jScrollBar_Vertical;
    private JButton jButton_Save;
    private JButton jButton_Origin;
    private JButton jButton_ToggleLines; // new 5/2005
    private JSpinner jSpinner_Wiggle;	// new 5/2005 (needs Java 1.4+!)
    // unused: private JLabel label;
    // removed correction{H,V} from this class to make the separate
    // correction handling in ImagePanel more obvious and cleaner - EA 5/2005

    // changed Ver1.6 05/18/03 made scalable - cleaned up 5/2005 EA
    // old implementation used global deltaWidth and deltaHeight scale factors

    private int mouseX;	// for dragging
    private int mouseY;
    private int myWiggle = 10;	// 5/2005: fixation image hit search radius

    private int fixPointSize; // the diameter of the drawn points
    private int setOffWidth; // depending on the os we need different offsets of the screen border
    private int setOffHeight; // used in scaleImage and initComponents

    public VisualizeImage()
    {
	path = "";
	fileName = "";
	gui = null;		// ...
	dsi = null;		// ...
	currentTrial = "";
	offset = 0;

	image = null;
	trialItemImage = null;
	if (jPanel_Image != null) jPanel_Image.disposeImagePanel();	// ...
	jPanel_Image = null;	// ...
	width = 0;
	height = 0;
	// lastLine=0;
        // changed Ver1.6 05/18/03 made scalable
        fixPointSize=10;

        SystemAdjustment sysAdj= new SystemAdjustment();
        if(sysAdj.getSystem().startsWith("Mac"))
        {
        	setOffWidth=80;
        	setOffHeight=200;
        }
        else
        {
        	setOffWidth=80;
        	setOffHeight=100;
        }
	setVisible(false);	// plus maybe getContentPane().setVisible(true);?
    }

    // only called when you open a new window, NOT when you just change
    // to another trial (using setImage)...!
    public VisualizeImage(String p, String f, FilterGUI g, DataSharing d,
        String ct, int offs)
    {
		this();	// call VisualizeImage()

		path = p;
		fileName = f;
		currentTrial = ct;
		offset = offs;
		gui = g;
		dsi = d;

		initComponents();	// only called once when you open the window

        	fixations = new Fixations();	// all text objects and fixations from the whole FLT

        	//*&*&* DPI changed to  get the text components, too
/* *** EA 5/2005 removed getToleranceAbove / getToleranceBelow, as it gets
 *     lost if you reload the FLT file later. instead modified AscFilter to
 *     modify INFO WORD coordinates based on above / below "boxtolerance"
 *              toc = fixations.aquire(dsi.getBackupTextAreaOutput(),
 *                      dsi.getToleranceAbove(),dsi.getToleranceBelow());
 *** */
		// get all trial IDs and fixations for the whole FLT file:
		toc = fixations.acquire(dsi.getBackupTextAreaOutput());
        	// fixations.printTrial(currentTrial); // moved to setImage

		try
	    	{   // loads the image (was: setImage() without args...)
		    setImage(path, fileName, currentTrial, offset);
	    	}
		catch (IOException e)
	    	{
		    System.out.println("VisualizeImage could not load image!");
	    	}
    }

    // called from TrialIDWindow for non-first images and now (5/2005)
    // also called by constructor with arguments, now AFTER initComponents
    public void setImage(String p, String f, String ct, int offs) throws IOException
    {
	path = p;
	fileName = f;
        currentTrial = ct;
        offset = offs;

	image = null;

/* *** */ System.out.print("--> "); // createImage / ImageLoader: relatively fast
        BufferedImage bi = createImage(ImageLoader.load(path + fileName), offset);
		// BufferedImage of *displaysize* size
		// ImageLoader-loaded image is X centered and Y offset
	if(bi == null) {
		System.out.println("Error while loading image");
		setEnable(false);
		return;
	}
	image = bi;	// boring image now

        width = dsi.displaySize.x;
        height = dsi.displaySize.y;

	trialItemImage = null;
/* *** */ System.out.print("--> ");
	trialItemImage = new TrialItemImage(path, fileName,
            width, height, offset);	// passing *display* size here!
        
        double scaleFactor = scaleImage();
	// image.getWidth() and image.getHeight() now return scaled values!

	Graphics2D scaledGraphics = bi.createGraphics();
        scaledGraphics.scale(scaleFactor, scaleFactor);
	// for drawing on the scaled canvas: now we can draw in displaySize
	// based coordinates and still get a scaled result... :-)

	if (jPanel_Image != null) {
	    getContentPane().remove(jPanel_Image);
	    jPanel_Image.disposeImagePanel();	// ...
	}

	// we passed the canvas / *display* size again...
	// jPanel_Image = new ImagePanel(image, fixPointSize,
        //    (TextObjectCollection)toc.get(currentTrial), offset,
        //    width, height, "LINES");	// can be LINES or WITHOUT...

	if (jButton_ToggleLines.getText().equals("Circles")) {
	    jPanel_Image = new ImagePanel(image, fixPointSize,
                (TextObjectCollection)toc.get(currentTrial),
	        scaledGraphics, "LINES", trialItemImage);
	} else {
	    jPanel_Image = new ImagePanel(image, fixPointSize,
                (TextObjectCollection)toc.get(currentTrial),
	        scaledGraphics, "WITHOUT", trialItemImage);
	}

        FixationTrialID fti=fixations.findTrial(currentTrial);
	if (fti == null) {
		System.out.println("Trial '" + currentTrial + "' not in fixation database!");
		return;
	}

	jPanel_Image.addMouseMotionListener(this);
	jPanel_Image.addMouseListener(this); // new 6/2005
        setTitle(fileName+" -> " + currentTrial);
	getContentPane().add(jPanel_Image,"Center");

       	fixations.printTrial(currentTrial);

        // moveToPosition_OutputWindow(fti.getLineNumber());
	gui.showOutputLine(fti.getLineNumber()); // set cursor in text pane

        // lastLine=0;
        if(image==null) setEnable(false); else setEnable(true);
        jButton_Previous.setEnabled(false);
        jButton_Save.setEnabled(false);
        // System.out.println("ScrollTo: " + width/2 + "/" + height/2);
        jScrollBar_Horizontal.setValue(width/2);
        jScrollBar_Vertical.setValue(height/2);
        jButton_Next.setEnabled(true);
	validate();
	pack();
	jPanel_Image.setCorrection(0, 0, myWiggle); // 5/2005
	updateStats();

	setVisible(true);
// ***        this.requestFocus();

	setLocation(setOffWidth/2, setOffHeight/2);	// EA 5/2005
	bi = null;
	System.gc();	// time for garbage collection now
    } // setImage

    // changed Ver1.6 05/18/03 made scalable
    // updated 5/2005 simplified - EA
    // resize canvas image to fit to screen size, returns used scale factor
    // also replaces image by scaledInstance of itself
    private double scaleImage()
    {
        double deltaHeight; // difference between scaled image and real image size
        double deltaWidth;
	Image newimage;
    	if (image==null) return 1.0;

    	Toolkit tk = Toolkit.getDefaultToolkit();
	Dimension d=tk.getScreenSize();
	int screenHeight = d.height;
	int screenWidth = d.width;
	int oldWidth = image.getWidth(this);
	int oldHeight = image.getHeight(this);
	int newHeight = 0;
	int newWidth = 0;

	// System.out.println("sH="+screenHeight+"|sW="+screenWidth);
	// System.out.println("h="+height+"|w="+width);
	// has the screen the right proportions
	// why fixed?	if(screenHeight>height+70 && screenWidth>width+40) return;
	// *** better use OS specific value...
	// *** should also check button- and scrollbar- sizes here!?
	if (screenHeight > (height + setOffHeight) &&
	    screenWidth > (width + setOffWidth)) {
/* *** */	System.out.println("scaleImage: not needed.");
		return 1.0;	// no scaling needed, "image = image"
	}

	deltaWidth = (double)(screenWidth-setOffWidth)/(double)width;
	deltaHeight = (double)(screenHeight-setOffHeight)/(double)height;
	// even SCALE_FAST getScaledInstance takes a lot of CPU time...
/* *** */	System.out.print("scaleImage: max. dW="+deltaWidth+"|dH="+deltaHeight+" / ");

	if (deltaWidth < deltaHeight) // width the limiting factor?
	{
		newWidth = (int)Math.round(width*deltaWidth);
		image = image.getScaledInstance(newWidth, -1, Image.SCALE_FAST);
        } else {
		newHeight = (int)Math.round(height*deltaHeight);
		image = image.getScaledInstance(-1, newHeight, Image.SCALE_FAST);
        }
	// if we used newimage = image... above: copy / flush now!
	// image.flush();
	// image = newimage;
	// newimage.flush();

	// disabled 5/2005: Keep ORIGINAL canvas size in those!
	// width = image.getWidth(this);
	// height = image.getHeight(this);

	// recalculate values after aspect-ratio preserving getScaledInstance
	deltaWidth = (double)image.getWidth(this)/(double)oldWidth;
	deltaHeight = (double)image.getHeight(this)/(double)oldHeight;
/* *** */	System.out.println("real dW="+deltaWidth+"|dH="+deltaHeight);

        if (image.getWidth(this)<=800) fixPointSize=8;
        if (image.getWidth(this)<=600) fixPointSize=6;
        if (image.getWidth(this)<=400) fixPointSize=4;

	newimage = null;
	return deltaWidth;	// or deltaHeight: both are equal here!
    } // scaleImage

    //initializes the form
    public void initComponents()
    {
    	// unused: Toolkit tk = Toolkit.getDefaultToolkit();
	// Dimension d=tk.getScreenSize(); ... = d.height ... = d.width ...
	width = dsi.displaySize.x;
	height = dsi.displaySize.y;

/* *** already done in setImage(...)
 *	if (jPanel_Image != null) jPanel_Image.disposeImagePanel();	// ...
 *   	jPanel_Image = new ImagePanel(image, fixPointSize,
 *                          (TextObjectCollection)toc.get(currentTrial), offset,
 *                          width, height, "LINES"); // can be LINES or WITHOUT
 *	// "toggle lines" button will be initialized below for the 1st time...
 *      // scaleImage();
 *   	jPanel_Image.addMouseMotionListener(this);
*** */
    	jPanel_Buttons = new JPanel();
	jPanel_Buttons.setLayout(new BoxLayout(jPanel_Buttons, BoxLayout.X_AXIS));
	// BoxLayout allows glue

    	jPanel_Unten = new JPanel(new BorderLayout());
    	jPanel_Buttons = new JPanel();	// default is double buffer, flow layout
    	jButton_Next = addButton(jPanel_Buttons,"Next",true,KeyEvent.VK_N);
        jButton_Previous = addButton(jPanel_Buttons,"Previous",true,KeyEvent.VK_P);
        jButton_All = addButton(jPanel_Buttons,"All",true,KeyEvent.VK_A);
        jButton_Clear = addButton(jPanel_Buttons,"Clear",true,KeyEvent.VK_C);
    	getContentPane().setLayout(new BorderLayout());

    	// getContentPane().add(jPanel_Image,"Center"); - NOT YET!

//		jPanel_Unten.add(jPanel_Buttons,"South");
//		getContentPane().add(jPanel_Unten,"South");

        jScrollBar_Horizontal= new JScrollBar(Adjustable.HORIZONTAL);
        jScrollBar_Vertical = new JScrollBar(Adjustable.VERTICAL);
	// System.out.println("ScrollNew: " + width/2 + "/" + height/2);
        jScrollBar_Horizontal.setValues(width/2,0,0,width);
        jScrollBar_Vertical.setValues(height/2,0,0,height);
        jScrollBar_Horizontal.addAdjustmentListener(this);
        jScrollBar_Vertical.addAdjustmentListener(this);
//      jPanel_Unten.add(jScrollBar_Horizontal,"North");

        getContentPane().add(jScrollBar_Vertical,"East");
        jPanel_Buttons.add(new JLabel("Stats:"));
	jPanel_Buttons.add(Box.createHorizontalGlue());
		// maybe Box.Filler ChangeShape(min, pref, max Dimension) ?

        jTextField_Stats = new JTextField("[Statistics]", 30);
	jTextField_Stats.setEditable(false);
	jTextField_Stats.setFocusable(false);
	jPanel_Buttons.add(jTextField_Stats);	// new JTextField 5/2005
        jPanel_Buttons.add(new JLabel("Wiggle:"));

	if (jButton_ToggleLines != null)		// ...
	    jPanel_Buttons.remove(jButton_ToggleLines);	// re-init this one!

	// new wiggle +/- buttons 5/2005
	jSpinner_Wiggle = new JSpinner(new SpinnerNumberModel(10,0,99,5));
	jPanel_Buttons.add(jSpinner_Wiggle);
	jSpinner_Wiggle.addChangeListener(this); // we have a stateChanged method

	jButton_ToggleLines = addButton(jPanel_Buttons,"Style",true,KeyEvent.VK_L);
	    // new button show lines / hide lines 5/2005
        jButton_Save = addButton(jPanel_Buttons,"Save",true,KeyEvent.VK_S); // Save
        jButton_Origin = addButton(jPanel_Buttons,"Origin",true,KeyEvent.VK_O);

	jPanel_Unten.add(jScrollBar_Horizontal,"North");
		jPanel_Buttons.validate();
	jPanel_Buttons.setMinimumSize(jPanel_Buttons.getSize());
		jPanel_Buttons.validate();
	jPanel_Unten.add(jPanel_Buttons,"South");
		jPanel_Unten.validate();
		getContentPane().add(jPanel_Unten,"South");
	getContentPane().validate();

        this.addKeyListener(this);
        setTitle(fileName+" -> " + currentTrial);

        addWindowListener(new java.awt.event.WindowAdapter()
	    {
		public void windowClosing(java.awt.event.WindowEvent evt)
		{
		    exitForm(evt);
		}
	    }
        );

	// *** why??	setBounds(1,1,width,height); - image size is NOT window size!
	setLocation(setOffWidth/2, setOffHeight/2);	// EA 5/2005

	pack();
	// getContentPane().setVisible(true);
	// setVisible(true); - NOT YET!
        // this.requestFocus();

        jButton_Previous.setEnabled(false);
        jButton_Save.setEnabled(false);
        if(image==null) setEnable(false);
    }

    // public boolean isFocusTraversable() { return true; }

    private JButton addButton(JComponent c,String s,boolean add, int hotkey)
    {	// JComponent c instead of Container c...
	JButton b = new JButton(s);
	b.setMnemonic(hotkey);
	if(add) c.add(b);
	c.validate(); // *** testing... ***
	b.addActionListener(this);
	return b;
    }

    private void setEnable(boolean set)
    {
/*
 *      jButton_Next.setEnabled(set);
 *      jButton_Previous.setEnabled(set);
 *      jButton_Clear.setEnabled(set);
 *      jButton_All.setEnabled(set);
 *      jScrollBar_Horizontal.setEnabled(set);
 *      jScrollBar_Vertical.setEnabled(set);
 *      jButton_Origin.setEnabled(set);
 *      jButton_Save.setEnabled(set);
 *	jSpinner_Wiggle.setEnabled(set);
 */
    }

/* *** - pretty useless, hides all components on window close,
 *       but the window closes anyway. and we forgot to un-hide
 *       on the next window open anyway ;-)
 *  private void mySetVisible(boolean set)
 *  {
 *      jButton_Next.setVisible(set); etc. etc. ...
*** */

    // handles GUI events
    public void actionPerformed(ActionEvent evt)
    {
	Object source = evt.getSource();

	if(source == jButton_Next) doButtonNext();
       	if(source == jButton_Previous) doButtonPrevious();
       	if(source == jButton_Clear) doButtonClear();
       	if(source == jButton_All) doButtonAll();
       	if(source == jButton_Origin) doButtonOrigin();
	if(source == jButton_Save) doButtonSave();

	// next is new 5/2005:
	if(source == jButton_ToggleLines) doButtonToggleLines();

// ***      	this.requestFocus();
    }

    public void keyPressed(KeyEvent evt)
    {
    	int d = 1;	// size of movement or wiggle change
    	int keyCode = evt.getKeyCode();
    	if (evt.isShiftDown()) d = 10; // change faster if shift pressed

    	if(keyCode==KeyEvent.VK_UP)
    		jScrollBar_Vertical.setValue(jScrollBar_Vertical.getValue()-d);
    	else if(keyCode==KeyEvent.VK_DOWN)
    		jScrollBar_Vertical.setValue(jScrollBar_Vertical.getValue()+d);
    	else if(keyCode==KeyEvent.VK_LEFT)
    		jScrollBar_Horizontal.setValue(jScrollBar_Horizontal.getValue()-d);
    	else if(keyCode==KeyEvent.VK_RIGHT)
    		jScrollBar_Horizontal.setValue(jScrollBar_Horizontal.getValue()+d);
        else if((keyCode==KeyEvent.VK_A || keyCode==KeyEvent.VK_SPACE)
		&& jButton_All.isEnabled())
		doButtonAll();
	else if(keyCode==KeyEvent.VK_N && jButton_Next.isEnabled())
		doButtonNext();
	else if(keyCode==KeyEvent.VK_P && jButton_Previous.isEnabled())
		doButtonPrevious();
	else if(keyCode==KeyEvent.VK_S && jButton_Save.isEnabled())
		doButtonSave(); // Save
	else if(keyCode==KeyEvent.VK_O && jButton_Origin.isEnabled())
		doButtonOrigin();
	else if(keyCode==KeyEvent.VK_C && jButton_Clear.isEnabled())
		doButtonClear();
	else if(keyCode==KeyEvent.VK_L)
		doButtonToggleLines();	// 5/2005
	else if(keyCode==KeyEvent.VK_PLUS)
		doButtonWigPlus(d);	// 5/2005
	else if(keyCode==KeyEvent.VK_MINUS)
		doButtonWigMinus(d);	// 5/2005

// ***    	this.requestFocus();
    }

    public void keyTyped(KeyEvent evt){	/* NOTHING */ }

    public void keyReleased(KeyEvent evt){ /* NOTHING */ }

/* *** disabled: there was no MouseListener, so this must have been unused.
    public void mousePressed(MouseEvent evt) // for MouseListener
    {
    	mouseX = evt.getX();
    	mouseY = evt.getY();
    }
*** */
    public void mousePressed(MouseEvent evt) { /* NOTHING */ }

    public void mouseReleased(MouseEvent evt) { /* NOTHING */ }

    // point to focus, new 6/2005:
    public void mouseEntered(MouseEvent evt) { this.requestFocus(); }

    // point to focus, new 6/2005:
    public void mouseExited(MouseEvent evt) { this.transferFocus(); }

    public void mouseDragged(MouseEvent evt) // for MouseMotionListener
    {
    	int x = evt.getX();
    	int y = evt.getY();

    	jScrollBar_Vertical.setValue(jScrollBar_Vertical.getValue() + (y-mouseY));
    	jScrollBar_Horizontal.setValue(jScrollBar_Horizontal.getValue() + (x-mouseX));
	// *** could make movement use the current scale factor...

    	mouseY = y;
    	mouseX = x;
    }

    public void mouseClicked(MouseEvent evt) // was dummy before 6/2005
    {
	int i = evt.getButton();	// convenient but needs Java 1.4
	if (i == MouseEvent.BUTTON1)	// left button: add (all)
	{
	    if (evt.isShiftDown())
		{ if (jButton_All.isEnabled()) doButtonAll(); }
	    else
		{ if (jButton_Next.isEnabled()) doButtonNext(); }
	}
	else if (i == MouseEvent.BUTTON2) // middle button: other stuff
	{
	    if (evt.isShiftDown())
		doButtonOrigin();
	    else
		doButtonToggleLines();
	}
	else if (i == MouseEvent.BUTTON3) // right button: remove (all)
	{
	    if (evt.isShiftDown())
		{ if (jButton_Clear.isEnabled()) doButtonClear(); }
	    else
		{ if (jButton_Previous.isEnabled()) doButtonPrevious(); }
	}
    } // mouseClicked

    public void mouseMoved(MouseEvent evt) // for MouseMotionListener
    {
    	mouseX=evt.getX();
    	mouseY=evt.getY();
    }

    // wer are an AdjustmentListener for our scrollbars:
    public void adjustmentValueChanged(AdjustmentEvent evt)
    {
        int correctionH = -((width/2) - jScrollBar_Horizontal.getValue());
        int correctionV = -((height/2) - jScrollBar_Vertical.getValue());
        if (correctionH==0 && correctionV==0 && myWiggle==0)
		jButton_Save.setEnabled(false);
        else
		jButton_Save.setEnabled(true);
        jPanel_Image.setCorrection(correctionH, correctionV, myWiggle);
		// update visuals
	// a bit of waste of CPU: dragging the mouse does TWO adj.Val.Changed
	// ... so we could try to catch that somehow ...
	updateStats();
        repaint();
    }
	
    public boolean isFocusable(){ return  true; }

    // we are a ChangeListener for our spinner: (5/2005)
    public void stateChanged(javax.swing.event.ChangeEvent e) // e just has a source...
    {
        myWiggle = ((Integer)jSpinner_Wiggle.getValue()).intValue();

	float goodness = 1.0f - (0.02f * (myWiggle-10));
	if (goodness < 0) goodness = 0;
	if (goodness > 1.0f) goodness = 1;
	// 0..10 (maybe 20) are okay, ..., 60..?? are really bad:
	Component [] spiCom = jSpinner_Wiggle.getEditor().getComponents();
	for (int sc=0; sc<spiCom.length; sc++) {
	    // typically only one thing: a javax.swing.JFormattedTextField
	    spiCom[sc].setBackground(new Color(1.0f, goodness, goodness));
	    if (spiCom[sc] instanceof javax.swing.text.JTextComponent) {
		((javax.swing.text.JTextComponent)spiCom[sc]).setEditable(false);
		((javax.swing.text.JTextComponent)spiCom[sc]).setFocusable(false);
	    }
	} // JSpinner itself also has Up/Down JButtons. Not much more.
	// not really useful for JSpinner, just the "border":
	// jSpinner_Wiggle.setBackground(new Color(1.0f, goodness, goodness));

	adjustmentValueChanged(null);
    }

    private void doButtonWigPlus(int howmuch) // 5/2005
    {
	if (((SpinnerNumberModel)jSpinner_Wiggle.getModel()).getMaximum().
		compareTo(new Integer(myWiggle + howmuch)) >= 0)
	    myWiggle += howmuch;
	jSpinner_Wiggle.setValue(new Integer(myWiggle));
	adjustmentValueChanged(null);
    }

    private void doButtonWigMinus(int howmuch) // 5/2005
    {
	if (((SpinnerNumberModel)jSpinner_Wiggle.getModel()).getMinimum().
		compareTo(new Integer(myWiggle - howmuch)) <= 0)
	    myWiggle -= howmuch;
	jSpinner_Wiggle.setValue(new Integer(myWiggle));
	adjustmentValueChanged(null);
    }

    private void doButtonNext()
	{
		if (!fixations.isNextFixation())	// trap error - EA 5/2005
		    return;
		SingleFixation sf = (SingleFixation)fixations.getNext();
           	int x = sf.getX();
           	int y = sf.getY();
		String mouseclick=sf.getMouseclick();
/* *** scaling and correction are done while drawing, must NOT be done here! EA 5/2005
 *         	//changed Ver1.6 05/18/03 made scalable
 *         	x=(int)Math.round(x*deltaWidth); y=(int)Math.round(y*deltaHeight);
 *         	jPanel_Image.setNewPoint(x+correctionH,y+correctionV,mouseclick);
*** */
		jPanel_Image.setNewPoint(x, y, mouseclick);
           	// moveToPosition_OutputWindow(sf.getLineNumber());
		gui.showOutputLine(sf.getLineNumber());
		jButton_Previous.setEnabled(fixations.isPriorFixation());
		jButton_Next.setEnabled(fixations.isNextFixation());
		updateStats();
                repaint();	// indirectly triggers reconstructFixations - 5/2005
	} // doButtonNext
	
	private void doButtonPrevious() // un-show 1 fixation, leave at least 1
	{
		if (!fixations.isPriorFixation())	// trap error - EA 5/2005
		    return;
		SingleFixation sf = (SingleFixation)fixations.getPrevious();
           	jPanel_Image.erasePoints(1);
           	// moveToPosition_OutputWindow(sf.getLineNumber());
		gui.showOutputLine(sf.getLineNumber());
		jButton_Previous.setEnabled(fixations.isPriorFixation());
		jButton_Next.setEnabled(fixations.isNextFixation());
		updateStats();
                repaint();	// indirectly triggers reconstructFixations - 5/2005
	} // doButtonPrevious

	private void doButtonAll()
	{
	   while(fixations.isNextFixation())
           {
               	SingleFixation sf = (SingleFixation)fixations.getNext();
               	int x = sf.getX();
               	int y = sf.getY();
		String mouseclick = sf.getMouseclick();
/* *** scaling and correction are done while drawing, must NOT be done here! EA 5/2005
 *             	// changed Ver1.6 05/18/03 made scalable
 *             	x=(int)Math.round(x*deltaWidth); y=(int)Math.round(y*deltaHeight);
 *             	jPanel_Image.setNewPoint(x+correctionH,y+correctionV,mouseclick);
*** */
		jPanel_Image.setNewPoint(x, y, mouseclick);
               	jButton_Next.setEnabled(false);
               	jButton_Previous.setEnabled(true);
           }
	   updateStats();
	   repaint();	// indirectly triggers reconstructFixations - 5/2005
	} // doButtonAll

	private void doButtonClear()
	{
		// needed to update the "current" pointer inside fixations, too!
		FixationTrialID fti = fixations.findTrial(currentTrial);
		// because we know fti anyway, why not scroll there? :-)
		gui.showOutputLine(fti.getLineNumber());
           	jPanel_Image.eraseAll();
		// no really useful idea, removed: doButtonOrigin();
           	jButton_Next.setEnabled(fixations.isNextFixation());
           	jButton_Previous.setEnabled(false);
		updateStats();
                repaint();	// indirectly triggers reconstructFixations - 5/2005
	} // doButtonClear

	private void doButtonToggleLines() // new 5/2005 EA
	{
		String theMode = jPanel_Image.getMode();
		if ((theMode != null) && theMode.equals("WITHOUT")) {
			theMode = "LINES";
		} else {
			theMode = "WITHOUT";
		}

		jPanel_Image.setMode(theMode);
		repaint();	// indirectly triggers reconstructFixations

		if (theMode.equals("WITHOUT")) {
			jButton_ToggleLines.setText("Lines");
		} else {
			jButton_ToggleLines.setText("Circles");
		}
	} // doButtonToggleLines

	private void doButtonOrigin()
	{
		// System.out.println("ScrollCenter: " + width/2 + "/" + height/2);
           	jScrollBar_Horizontal.setValue(width/2);
           	jScrollBar_Vertical.setValue(height/2);
           	jButton_Save.setEnabled(false);
		doButtonWigMinus(myWiggle);	// force myWiggle to 0
           	jPanel_Image.setCorrection(0, 0, myWiggle); // update visuals
		updateStats();
                repaint();	// indirectly triggers reconstructFixations - 5/2005
	} // doButtonOrigin

        // make the visual X Y offsets permanent and modify the log file by
        // applying the offsets. recheck where the changed fixations "look at".
	private void doButtonSave()
	{
	    int correctionH = -((width/2) - jScrollBar_Horizontal.getValue());
	    int correctionV = -((height/2) - jScrollBar_Vertical.getValue());

            fixations.correctFixation(currentTrial, correctionH, correctionV);
                // make "database" changes permanent for all non-mouseclick
                // fixations of the current trial

            jPanel_Image.setCorrection(correctionH, correctionV, myWiggle);
		// update visuals
            jPanel_Image.applyCorrectionToPointList();
                // make visual changes (from setCorrection) permanent

	    int realWiggle = myWiggle;	// needed for correctOutputFile!
            // reset visual X Y correction 0 0 relative to updated values
	    doButtonOrigin();	// also resets myWiggle!

	    try		// ** we modify the real FLT file now: **
              	{
                    correctOutputFile(dsi.getBackupTextAreaOutput(),
                        dsi.getOutBackup(), correctionH, correctionV, realWiggle);
                        // update the FILE with the fixations and other events by
                        // applying our X Y offset correction, using correctLine
                    gui.fillOutputWindowFromFile("OUTPUT",dsi.getOutBackup(),
                        gui.getOutputWindow(),dsi);
                    // gui.paintDocument(gui.getCurrentDocument());

		    // re-read fixations mainly to keep line numbers in sync - 5/2005
/* *** */	    System.out.println("File updated, re-reading fixations!");
		    // get all trial IDs and fixations for the whole FLT file:
		    fixations = new Fixations();
		    toc = fixations.acquire(dsi.getBackupTextAreaOutput());
        	    fixations.printTrial(currentTrial);
/* *** */           System.out.println("Corrections stored.\n");
		    doButtonClear();	// make sure that point list is cleared
              	}
              	catch(IOException e)
              	{
                    System.out.println("Failed to apply offset correction to trial in file!");
                }

	    repaint();
	} // doButtonSave


    // classify fixation locations given the current visual offsets
    // new method (EA 5/2005)
    public void updateStats()
    {
        int corrX = -((width/2) - jScrollBar_Horizontal.getValue());
        int corrY = -((height/2) - jScrollBar_Vertical.getValue());
	int fixInWord = 0;
	int fixInImage = 0;
	int fixOut = 0;
	java.util.Iterator iter = jPanel_Image.getPointList().iterator();

	while (iter.hasNext()) {
	    FixationCoords coords = (FixationCoords)iter.next();
	    if (!(coords.getMouseclick().equals("NONE")))
		continue; // ignore mouseclick HIT / MISS "fixations"
	    int x = coords.getX() + corrX;
	    int y = coords.getY() + corrY;
	    int where = checkMessageOrImage(x, y); // uses toc TextObjectCollection

	    if (where < 0) { // outside all words: must be image or none
	        int thePixel = trialItemImage.getRegionnumberWiggle(x, y, myWiggle, 0);
	        // assume for stats that the background is black:
		// [same for getRegionnumberWiggle: radius ..., background 0...]
	        if ((thePixel != 0) && (thePixel != 63)) {
		    fixInImage++;
		    // name hit: trialItemImage.getColorName(thePixel)
	        } else
		    fixOut++;
	    } else { // hit a word
	        fixInWord++;
	        // name hit: (((TextObjectCollection)toc.get(currentTrial))
	        //     .getItem(where)).itemName
	    }
	} // while
        jTextField_Stats.setText("Offset (" + corrX + "," + corrY +
	    "), Word: " + fixInWord + ", Image: " + fixInImage +
	    ", Out: " + fixOut + " of " + (fixInWord + fixInImage + fixOut));

	if ((fixInWord + fixInImage) > 0) {
	    float good = 1.0f * (fixInWord + fixInImage) /
		(fixInWord + fixInImage + fixOut);
	    if (good < 0.5f)
	        jTextField_Stats.setBackground(new Color(1.0f, 0.5f, 0.5f));
	    else	// 50% to 100% good: light red to light green
		jTextField_Stats.setBackground(
		    new Color(1.5f - good, good, 0.5f));
	} else {
	    jTextField_Stats.setBackground(Color.white);
	}
    } // updateStats

	
/* *** now unused
    private void moveToPosition_OutputWindow(int start, int end)
    {
 *	gui.showTab("OUTPUT");
	// only ensures "cursor location visible", so we make sure
	// to scroll UP to get the selected text on top...

	// if(i>currentTextPosition) gui.goToPosition(i);
	// else gui.goToPosition(findTrial);
	// currentTextPosition = i;

	// gui.setFixationPointer(lastLine,start);

 *      gui.goToPosition(start);
 *      gui.highlight(start,end);
        // lastLine=start;
    }
*** */

    // update the FILE with the fixations and other events by
    // applying our X Y offset correction, using correctLine
    // wiggle defines the image hit search radius (new 5/2005)
    public void correctOutputFile(String outputString, File f,
        int corrX, int corrY, int wiggle) throws IOException
    {
            boolean correction = false;

            // now VisualizeImage object-wide variable, because
            // updateStats also uses trialItemImage - EA 5/2005
            // TrialItemImage trialItemImage =
            // new TrialItemImage(path,fileName,width,height,offset);

            // findTrial(currentTrial);
            PrintWriter outFile=new PrintWriter(new FileWriter(f));

            StringTokenizer tokenText = new StringTokenizer(outputString,"\n");

                while(tokenText.hasMoreTokens())
                {
                    String line = tokenText.nextToken();
                    StringTokenizer tokenLine= new StringTokenizer(line);

                    while(tokenLine.hasMoreTokens())
                    {
                        String token = tokenLine.nextToken();

                        if(token.equals("MSG"))
                        {
                            token = tokenLine.nextToken(); // skip timestamp
                            token = tokenLine.nextToken();
                            if(token.equals("TRIALID")) {  // new trial?
                                if (correction) // end of corrected trial
                                {
                                    correction=false;
                                    break;
                                }
                                else // could be start of corrected trial
                                {
                                    token = tokenLine.nextToken(); // trial ID
                                    if (currentTrial.equals(token))
				    {
					// store line and add new line with
					// CORRECTION parameter info - 5/2005
					outFile.println(line.trim());
					line = "MSG\t0000000    CORRECTION    " +
					    + corrX + "    " + corrY + "    " +
					    wiggle;
/* *** */				System.out.println("Correction: (" + corrX +
/* *** */				    "," + corrY + ") r=" + wiggle +
/* *** */					    " for trial " + token);
                                        correction=true;
				    }
                                    break;
                                }
                            } else break;
                        }
			// apply X Y origin change only to FIX / SACC events
                        if ((correction) &&
                            (token.equals("EFIX") || token.equals("ESACC")))
                            line = correctLine(line, corrX, corrY, wiggle);
                            // line = correctLine(line, trialItemImage, corrX, corrY);
                        // System.out.println(line.trim());
                        break;
                    } // while line has tokens

                    outFile.println(line.trim());
                } // while file has lines
                outFile.close();
    } // correctOutputFile

    // apply X / Y offset correction to 4th / 5th token in line and
    // recalculate hit location description for the corrected coordinates
    // using wiggle as search radius for image hits (wiggle new 5/2005 EA)
    // was: private String correctLine(String l, TrialItemImage trialItemImage)
    private String correctLine(String l, int xCorr, int yCorr, int wiggle)
    {
            StringBuffer returnLine = new StringBuffer(200);
            int i=0;
            String token = new String();
            StringTokenizer tokenLine= new StringTokenizer(l);
            int x=0;
            int y=0;
            int startX=0;
            int startY=0;
            int messageNr=-1;
	    int regionNr=-1;

            while(tokenLine.hasMoreTokens())
            {
                token=tokenLine.nextToken();
		if (i<4)
		{
		    // no modifications
		}
                else if (i==4) // x coordinate
                {
                   
                    x = Integer.parseInt(token);
                    // System.out.println(""+x+"/"+correctionH+"/"+(new Integer(correctionH)).doubleValue());
                    // *** must not SCALE correction! -  EA 5/2005
                    // x=x+((int)Math.round(correctionH/deltaWidth)); //changed Ver1.6 05/18/03 made scalable
                    x = x + xCorr;
                    token = "" + x;
                    
                }
                else if (i==5) // y coordinate
                {
                    y = Integer.parseInt(token);
                    // *** must not SCALE correction! - EA 5/2005
                    // y=y+((int)Math.round(correctionV/deltaHeight)); //changed Ver1.6 05/18/03 made scalable
                    y = y + yCorr;
                    token = "" + y;
                }
                else if(i==6)
                {
                       
                    startX = x;
                    startY = y;
                    messageNr = checkMessageOrImage(startX,startY); 
                    if(messageNr==-1) // if not a word (so it must be the image)
                    {    
                        regionNr = trialItemImage.getRegionnumberWiggle(startX, startY, wiggle, 0);
			token = "" + regionNr;
                    }
                    else
                    {
                        token = "" + messageNr;
                    }
                }
                else if(i==7)
                {
                    if(messageNr==-1)
                        token = trialItemImage.getColorName(regionNr);
                    else // store the word length (*** why not the word itself?)
                        token = "" + (((TextObjectCollection)
			    toc.get(currentTrial)).getItem(messageNr)).itemName.length();
                }

                i++;
		returnLine.append(token);
                if(i==1)
		    returnLine.append("\t");
                else
		    returnLine.append("    "); // tabs would look better...
		    // ... but some parser probably expects spaces here :-(

            } // loop over tokens

            return returnLine.toString();
    } // correctLine
        
    // returns the Number of the TextObject or -1 if it is a fix on the image
    // check if coordinates are inside any of the text objects
    private int checkMessageOrImage(int startX, int startY)
    {
        TextObjectCollection t= (TextObjectCollection)toc.get(currentTrial);
        int length = t.getSize();
                
        for(int i = 0;i<length;i++)
        {
            TextObject to=t.getItem(i);
            if(startY <= to.lY && startY >= to.uY &&
		startX >= to.uX && startX <= to.lX)
                return i;
        }
                
        return -1;
    }
    
    private BufferedImage createImage(Image i, int offs) // create image of same size as the
    // display used for the experiment, draw boxes and image i on it to represent stimuli
    {
        Point imagePos = new Point();
	if (i == null) return null;
/* *** */	System.out.print("createImage: ");
        BufferedImage myBufferedImage = new BufferedImage(dsi.displaySize.x, dsi.displaySize.y,
            BufferedImage.TYPE_INT_RGB);
	// ... image is x centered relative to DISPLAYSIZE in DPI ...
        imagePos.x = (dsi.displaySize.x-i.getWidth(this))/2;
	// *** bugfix: negative offset is "from bottom", positive is "from top",
	// *** so you cannot simply do "y - (i{{mage}}.getHeight(this) - offs)"!
	// *** same formula is used in TrialItemImage!
        // imagePos.y=dsi.displaySize.y-(image.getHeight(this)-offs);
	if (offs < 0) {
		imagePos.y = (dsi.displaySize.y-i.getHeight(this)) + offs;
		// fixed to DPI style 5/2005 - EA
	} else {
		imagePos.y = offs;	// fixed to DPI style 5/2005
	}
        // System.out.println("createImage imagePos = " + imagePos.toString() + ", offs = " + offs);
	// EA 5/2005 *** calc removed at ImagePanel, only done here now.

        Graphics2D myGraphics2D = myBufferedImage.createGraphics();
        myGraphics2D.drawImage(i, imagePos.x, imagePos.y, this);
	// i, not image, right? (5/2005) (also used in line arts below!)

	// *** new eye candy 5/2005 - EA ...
	myGraphics2D.setColor(Color.gray);
	float myDash[] = {3.3f, 10.0f};	// short line, long space, etc.
	Stroke normalStroke = myGraphics2D.getStroke();
	myGraphics2D.setStroke(new BasicStroke(2.0f,
                BasicStroke.CAP_BUTT, BasicStroke.JOIN_MITER, 10f, myDash, 0.0f));
		// see Java tutorial: Graphics2D Stroking and Filling...
		// width, line ending, line joints, miterlimit, dash array, dash phase
	myGraphics2D.draw(new Rectangle(imagePos.x - 1,imagePos.y - 1,
		i.getWidth(this) + 1, i.getHeight(this) + 1));

/* *** */	System.out.println("Image " + i.getWidth(this) + "x" + i.getHeight(this)
/* *** */	    + " at " + imagePos.x + "/" + imagePos.y + " on " + dsi.displaySize.x + "x" + dsi.displaySize.y);

	myGraphics2D.draw(new java.awt.geom.Line2D.Float(0, 0, dsi.displaySize.x-1, dsi.displaySize.y-1));
	myGraphics2D.draw(new java.awt.geom.Line2D.Float(dsi.displaySize.x-1, 0, 0, dsi.displaySize.y-1));

	myGraphics2D.drawLine(imagePos.x, imagePos.y,
		imagePos.x+i.getWidth(this), imagePos.y+i.getHeight(this));
	myGraphics2D.drawLine(imagePos.x, imagePos.y+i.getHeight(this),
		imagePos.x+i.getWidth(this), imagePos.y);

	myGraphics2D.setStroke(new BasicStroke(2.0f));
	// ... end of new eye candy ***
        
        TextObjectCollection t= (TextObjectCollection)toc.get(currentTrial);
	if (t == null) {	// EA 5/2005
		System.out.println("createImage aborted: No currentTrial set yet");
		// happens if you load a file after having visualized another
		// but forgot to close the TrialIDWindow trial picker...
		myGraphics2D.dispose();
		return myBufferedImage;
	}

        int length = t.getSize();
        
        for(int x=0;x<length;x++)
        {
            if((x%2)==0) 
                myGraphics2D.setColor(Color.orange);
            else 
                myGraphics2D.setColor(Color.white);
            TextObject to=t.getItem(x);
            myGraphics2D.drawRect(to.uX, to.uY, to.lX-to.uX, to.lY-to.uY);
            myGraphics2D.setColor(Color.orange);

		// show text quite big but not too big - EA 5/2005
		java.awt.Font oldFont = myGraphics2D.getFont();
		java.awt.geom.Rectangle2D bbox = oldFont.getStringBounds(to.itemName,
			myGraphics2D.getFontRenderContext());
		float fontsize = oldFont.getSize2D();
		float xzoomed = fontsize * (to.lX-to.uX) / (float)(bbox.getWidth());
		float yzoomed = fontsize * (to.lY-to.uY) / (float)(bbox.getHeight());
		fontsize = (xzoomed < yzoomed) ? xzoomed : yzoomed;
		fontsize = (float)0.8 * fontsize;
		myGraphics2D.setFont(oldFont.deriveFont(fontsize));

	    myGraphics2D.drawString(to.itemName, to.uX+8, to.lY-1);

		myGraphics2D.setFont(oldFont);
        }
	myGraphics2D.setStroke(normalStroke);
        myGraphics2D.dispose();
        return myBufferedImage;
    }

    // why, actually?
    private void exitForm(java.awt.event.WindowEvent evt)
    {
    	setVisible(false);
    }
} // end of VisualizeImage class which extends JFrame and implements stuff



// ************** new Panel class  ***************++
// gets an Image and draws it
class ImagePanel extends JPanel	// overrides only paintComponent
{
    private Image image;
    private Graphics2D scaled;	// "handle" to draw in scaled ways
    private String mode; // see VisualizeImage class
    private LinkedList pointList; // representing the fixations
    private int correctionH;
    private int correctionV;
    private int aWiggle;
    private int fixPointSize; //changed Ver1.6 05/18/03 made scalable
    // private int offset;
    // private int width;
    // private int height;
    private TrialItemImage trialItIm;	// only for reconstructFixations eye candy!
    
    //*&*&* DPI
    TextObjectCollection toc;
    // private Point imagePos; *** seems to be bad idea - 5/2005 EA

    public Graphics2D getScaled() { return scaled; }

    public void disposeImagePanel()	// new 5/2005
    {
	// getGraphics().dispose(); - not useful, getGraphics creates fresh copy
	if (scaled != null) scaled.dispose();
	scaled = null;
	if (image != null) image.flush();
	image = null;
	trialItIm = null;
    }

    // a painting area for an image x-wise centered on it...
    // public ImagePanel(Image i,int fps,TextObjectCollection toc,int offset,
    //     int width,int height, String ipmode)
    public ImagePanel(Image i, int fps, TextObjectCollection toc,
	Graphics2D scaledGraphics, String ipmode, TrialItemImage trii)
    {
	disposeImagePanel();
    	image = i;
        // this.offset=offset;
        // this.width=width;
        // this.height=height;
	scaled = scaledGraphics;
	// apply scaleFactor to "outside world" coordinates
	// to get coordinates for drawing on the ImagePanel

    	fixPointSize=fps; // changed Ver1.6 05/18/03 made scalable
        pointList=new LinkedList();
	setMode(ipmode);
        correctionH=0;
        correctionV=0;
        this.toc=toc;

        trialItIm = trii;	// only for reconstructFixations eye candy!

	// lock size to current size of our image:
	Dimension scaledSize = new Dimension(image.getWidth(this), image.getHeight(this));
	this.setPreferredSize(scaledSize);
	this.setMinimumSize(scaledSize);
	this.setMaximumSize(scaledSize);
        // JPanels default to be opaque which tells the paint manager that
	// the background should be filled before calling paintComponents.
	// This wastes time and causes flicker, so we declare "us" transparent!
	this.setOpaque(false);	// declare transparent, stop filling background
	// this.setBackground(Color.black); // reduce flickery looks: match Image background
    } // ImagePanel

    // public boolean isOpaque() { return false; } // force Component to be transparent

    public void paintComponent(Graphics g)
    {
    	super.paintComponent(g);
    	if(image!=null)
        {
            // g.drawImage(image,imagePos.x,imagePos.y,this); // *** see above
	    g.drawImage(image, 0, 0, this); // *** unscaled, relative to imagepanel!
            // drawTextBoxes(g);
            reconstructFixations(g);
        }
        else g.drawString("No Template found",300,250);
	// g.dispose();	not needed for "paint" and "update" style methods
    }

    public void setMode(String m)
    {
        mode = m;
    }

    public String getMode(){ return mode; }

    public void setNewPoint(int x, int y, String mc)
    {
        pointList.add(new FixationCoords(x,y,mc));

    }

    public void erasePoints(int howMany)
    {
        for(int i=0;i<howMany;i++)
            if (pointList.size()>0)	// EA: keyboard "P" foolproofing
		pointList.removeLast();	// strange: isPriorFixation() true!
        Graphics gr = getGraphics();
        paintComponent(gr);
	gr.dispose();
    }

    public void eraseAll()
    {
        pointList.clear();
        Graphics gr = getGraphics();
        paintComponent(gr);
	gr.dispose();
    }


    // draw fixations and mouseclicks and apply the current X Y offset
    // as set by setCorrection to the non-mouseclicks while drawing
    // 5/2005: also count number of in/out region fixations while drawing
    public void reconstructFixations(Graphics gr)
    {
        int x = -1;
        int y = -1;
        int prevX = -1;
        int prevY = -1;
	String mouseclick = new String();

        for(int i=0;i<pointList.size();i++)
        {
            mouseclick = ((FixationCoords)pointList.get(i)).getMouseclick();
            if(mouseclick.equals("NONE"))
	    {
		int xraw = ((FixationCoords)pointList.get(i)).getX() + correctionH;
		int yraw = ((FixationCoords)pointList.get(i)).getY() + correctionV;
		x = (int)Math.round(xraw * scaled.getTransform().getScaleX());
		y = (int)Math.round(yraw * scaled.getTransform().getScaleY());

            	gr.setColor(Color.black);
            	gr.drawOval(x-1, y-1, 2, 2); // black dot in center
            	if(i==0) // first
		    gr.setColor(new Color(0.5f, 0.5f, 1.0f)); // light blue
            	else if (i==pointList.size()-1) // last
		    gr.setColor(new Color(1.0f, 0.5f, 0.5f)); // light red
		else // others
		    gr.setColor(Color.white);
            	// changed Ver1.6 05/18/03 made scalable
            	gr.drawOval(x-(fixPointSize/2), y-(fixPointSize/2),
		    fixPointSize, fixPointSize); // circle around it
		// changed 5/2005: show fixation number
		if (mode.equals("LINES"))
                    gr.drawString("" + (i+1), (x+fixPointSize/2)+1, y);

/* *** */ // nice visual feedback but ImagePanel now needs trial Item Image!
		    if (trialItIm.getRegionnumberWiggle(xraw, yraw, aWiggle, 0) != 0)
		    { // show wiggle effect if we hit an image object:
			Point wigWhere = trialItIm.getBestWiggle();
			if (wigWhere.x != -1) { // note: no X Y correction needed!
			    wigWhere.x = (int)Math.round(wigWhere.x * scaled.getTransform().getScaleX());
			    wigWhere.y = (int)Math.round(wigWhere.y * scaled.getTransform().getScaleY());
			    gr.setColor(Color.magenta);
			    gr.drawLine(x, y, wigWhere.x, wigWhere.y);
			} else
			    gr.setColor(Color.green);
			gr.drawOval(x-((fixPointSize/2)-1), y-((fixPointSize/2)-1),
			    fixPointSize-2, fixPointSize-2);
		    } // else we hit a word or just nothing...
/* *** */

            }
            else
            {
                // no correction on mouseclick points, as they have
		// mouse coordinates, not eye coordinates...
		int xraw = ((FixationCoords)pointList.get(i)).getX();
		int yraw = ((FixationCoords)pointList.get(i)).getY();
		x = (int)Math.round(xraw * scaled.getTransform().getScaleX());
		y = (int)Math.round(yraw * scaled.getTransform().getScaleY());

		gr.setColor(Color.black);
		gr.drawRect(x-(fixPointSize/2),y-(fixPointSize/2),
                    fixPointSize,fixPointSize);
		gr.setColor(Color.white);
		if(mouseclick.equals("HIT"))
		{
                    gr.drawString("H",(x+fixPointSize/2)+1,y);
		    gr.fillOval(x-(fixPointSize/2),y-(fixPointSize/2),
			fixPointSize,fixPointSize); // filled circle: hit!
		}
		else
		{
                    gr.drawString("M",(x+fixPointSize/2)+1,y);
		    gr.drawLine(x-(fixPointSize/2),y-(fixPointSize/2),
			x+(fixPointSize/2),y+(fixPointSize/2));
		    gr.drawLine(x+(fixPointSize/2),y-(fixPointSize/2),
			x-(fixPointSize/2),y+(fixPointSize/2)); // crossed out
		}
	    } // mouse points
            // colored lines new 5/2005 - EA
            if ((prevX >= 0) && (prevY >= 0) && mode.equals("LINES")) {
		float huestep = 1.0f / pointList.size();
		float hue = i * huestep;
		gr.setColor(new Color(Color.HSBtoRGB(hue, 1.0f, 0.75f)));
		hue += huestep / 3;
                gr.drawLine(prevX, prevY,
                    prevX + (x - prevX)/3, prevY + (y - prevY)/3);
		gr.setColor(new Color(Color.HSBtoRGB(hue, 1.0f, 0.75f)));
		hue += huestep / 3;
                gr.drawLine(prevX + (x - prevX)/3, prevY + (y - prevY)/3,
                    prevX + 2 * (x - prevX)/3, prevY + 2 * (y - prevY)/3);
		gr.setColor(new Color(Color.HSBtoRGB(hue, 1.0f, 0.75f)));
                gr.drawLine(prevX + 2 * (x - prevX)/3,
                    prevY + 2 * (y - prevY)/3, x, y);
            }
            prevX = x;
            prevY = y;
	} // for loop

	if (mode.equals("LINES")) { // show arrow to visualize movement - EA 5/2005
	    prevX = image.getWidth(this) / 2;
	    prevY = image.getHeight(this) / 2;
	    x = (int)Math.round(correctionH * scaled.getTransform().getScaleX());
	    y = (int)Math.round(correctionV * scaled.getTransform().getScaleY());
	    float len = (float)Math.sqrt((correctionH*correctionH) + (correctionV+correctionV));
	    if (len > 50) len = 50;
	    gr.setColor(new Color(len/50, 0, 1.0f)); // now draw a nice triangle:
	    gr.drawLine(prevX, prevY, prevX + x, prevY + y);
	    gr.drawLine(prevX - (y/10), prevY + (x/10), prevX + x, prevY + y);
	    gr.drawLine(prevX + (y/10), prevY - (x/10), prevX + x, prevY + y);
	    gr.drawLine(prevX + (y/10), prevY - (x/10), prevX - (y/10), prevY + (x/10));
	}
    } // reconstructFixations


    // update the X Y offset for ImagePanel visualization
    public void setCorrection(int cX, int cY, int wiggleRadius)
    {
        correctionH = cX;
        correctionV = cY;
	aWiggle = wiggleRadius;
        Graphics gr = getGraphics();
        paintComponent(gr);
	gr.dispose();
    }

    // make visual changes permanent: change pointlist items by X Y offset
    // (from setCorrection) and reset the offsets to 0.
    public void applyCorrectionToPointList()
    {
        for(int i=0;i<pointList.size();i++)
        {
            if((((FixationCoords)pointList.get(i)).getMouseclick()).equals("NONE"))
	    {
		((FixationCoords)pointList.get(i)).setCorrectionX(correctionH);
            	((FixationCoords)pointList.get(i)).setCorrectionY(correctionV);
	    }
        }
        setCorrection(0, 0, aWiggle);	// reset correctionH, correctionV to 0,0
    }

    public java.util.List getPointList() { return pointList; } // new 5/2005


} // end of class ImagePanel which extends JPanel


// ***************** FixationCoords **********************
// manages everthing necessary about a FixationPoint in the graph
class FixationCoords
{
    private int x;
    private int y;
    private String mouseclick;

    public FixationCoords(int tx, int ty,String mc)
    {
        x = tx;
        y = ty;
        mouseclick = mc;
    }

    public int getX() { return x; }
    public int getY() { return y; }
    public String getMouseclick() { return mouseclick; }

    // apply RELATIVE coordinate offset correction:
    public void setCorrectionX(int tx) { x += tx; }
    public void setCorrectionY(int ty) { y += ty; }

} // end of class FixationCoords which is quite small

