/* This is part of the NEWTRACK eyetracking software, (c) 2004 by  */
/* Eric Auer. NEWTRACK is free software; you can redistribute it   */
/* and modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2  */
/* of the License, or (at your option) any later version.          */
/*     NEWTRACK is distributed in the hope that it will be useful, */
/*     but WITHOUT ANY WARRANTY; without even the implied warranty */
/*     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.     */
/*     See the GNU General Public License for more details.        */
/* You should have received a copy of the GNU General Public       */
/* License (license.txt) along with this program; if not, check    */
/* www.gnu.org or write to the Free Software Foundation, Inc., 59  */
/* Temple Place, Suite 330, Boston, MA  02111-1307 USA.            */

/* definition of data types and compatibility macros: DJGPP/DOS version   */
/* UPDATE 2/2004: Make Linux compilation possible except for lowlevel I/O */
/* Lets you compile a Linux binary of the pcx2tpl tool, nothing else yet. */
/* Port I/O, CLI/STI and VESA would need "root" powers.  */
/* DOS/BIOS calls are generally not accessible in Linux. */

#ifndef ARCH_H
#define ARCH_H


#ifdef __DJGPP__	/* things which are not yet possible in Linux */

#include <pc.h> /* things like inportb() */
#include <go32.h>	/* only for _dos_ds... */
#include <sys/farptr.h> /* e.g. _farpeekb(_dos_ds, linear) */

#define _NAIVE_DOS_REGS 1 /* make ...x.ax mean the 16bit ax */
#include <dos.h> /* int86, union REGS */

#endif /* __DJGPP__ */


typedef __signed__ char sint8;
typedef unsigned char uint8;

typedef __signed__ short sint16;
typedef unsigned short uint16;

typedef __signed__ int sint32;
typedef unsigned int uint32;


#ifdef __DJGPP__	/* things which are not yet possible in Linux */

/* o is offset, s is segment, v is value. All of them "DOS-wise"... */
/* must NOT have spaces between word and () in "#define word(...)"! */
#define peek(s, o)      _farpeekw( _dos_ds, ((uint32)(s)<<4)+(o) )
#define peekb(s, o)     _farpeekb( _dos_ds, ((uint32)(s)<<4)+(o) )
#define poke(s, o, v)   _farpokew( _dos_ds, ((uint32)(s)<<4)+(o), (v) )
#define pokeb(s, o, v)  _farpokeb( _dos_ds, ((uint32)(s)<<4)+(o), (v) )

#define CLI disable /* returns nonzero if interrupts were enabled */
#define STI enable  /* (returns nonzero if interrupts were enabled, too) */

/* when using Linux GCC/G++, do if (iopl(0)) printf("root?") before in/out */
/* first. when using Linux GCC/G++, using in/out requires asm/io.h and -O3 */

#define in8(port)   inportb ( port )
#define in16(port)  inportw ( port )
#define in32(port)  inportl ( port )

#define out8(port, data)   outportb ( (port), (data) )
#define out16(port, data)  outportw ( (port), (data) )
#define out32(port, data)  outportl ( (port), (data) )

#define int86regs union REGS
/* which is an union of DWORDREGS, DWORDREGS_W, WORDREGS, BYTEREGS    */
/* contents are edi ... eax di .. ax cflag flags eflags ... _upper_di */
/* ... di in DWORDREGS_W is 32bit, di in WORDREGS is 16bit. ...       */
/* ... _upper_di of BYTEREGS is hi 8 of 16, in WORDREGS hi 16 of 32   */
/* Please use .h.ah or .w.ax or .d.eax but not .x.ax - the latter can */
/* mean either eax or ax or even not exist and be .x.eax instead...   */

#define intr int86 /* auto-converts protected mode pointers for known ints */
/* __dpmi_int is the generic variant which converts nothing for you.  */
/* if an interrupt is unknown, pointers are not converted by int86... */
/* There is also int86x with SREGS. All return the returned EAX int.  */ 

#endif /* __DJGPP__ */


/* "most" stdlib functions work in DJGPP as in GCC/G++, e.g. getenv() */
/* fcntl.h sys/stat.h int open(name, O_RDONLY or O_WRONLY or ...)     */
/* ... with O_CREAT or O_TRUNC or O_APPEND ... O_TEXT or O_BINARY ... */

/* if (__djgpp_map_physical_memory(page_aligned_mem, 16384, 0x40000000))
   printf ("Failed to map physical addresses!\n");
 */ /* uses dpmi.h, first arg is void* to which things are mapped */
/* sys/movedata.h dosmemget(int physLinAddr, int len, void *buf)  */
/* also as ...b and ..w and ...l (len in ... units) and ...put... */

#endif
