/* This is part of the NEWTRACK eyetracking software, (c) 2004 by  */
/* Eric Auer. NEWTRACK is free software; you can redistribute it   */
/* and modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2  */
/* of the License, or (at your option) any later version.          */
/*     NEWTRACK is distributed in the hope that it will be useful, */
/*     but WITHOUT ANY WARRANTY; without even the implied warranty */
/*     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.     */
/*     See the GNU General Public License for more details.        */
/* You should have received a copy of the GNU General Public       */
/* License (license.txt) along with this program; if not, check    */
/* www.gnu.org or write to the Free Software Foundation, Inc., 59  */
/* Temple Place, Suite 330, Boston, MA  02111-1307 USA.            */

/* parsing trials in (SMI Eyelink Saarbruecken "READING") experiment script */
/* Note that the chunker of READING does not support \-protected linebreaks */
/* and that NEWTRACK does not support fetching sound or text from file yet. */

	/* UPDATE: support for external PCX images added 10/2004-11/2004 */
	/* UPDATE: skip rest of line if error encountered in trial line, */
	/*         force IMAGETRIAL / TRIALID timestamp to 0, fixed two  */
	/*         TRIAL RESULT strings to TRIAL_RESULT, added support   */
	/*         for image trials without text: all             4/2005 */
	/* UPDATE: support for MANUAL_ACTIVATE and DRIFT_PSEUDO added,   */
	/*         made DRIFT_CORRECT affect calibration and removed the */
	/*         grid display / wait from AUTO_ACTIVATE: all    4/2005 */
	/* UPDATE: Allow font zooming (in VESA mode) by FONT_ZOOM 4/2005 */
	/* UPDATE: Auto-conversion of READING script image trials 4/2005 */
/* UPDATE: Made .streaming a bit field of STREAMFIX / STREAMWORD  4/2005 */
/* UPDATE: New int reading in do_script_trials for READING compat 4/2005 */
/* UPDATE: Place gaze mark at 1st *nonempty* stimulus line start  4/2005 */
/* UPDATE: Allow either CENTERED or TOPLEFT text layout alignment 4/2005 */
/* UPDATE: Added BLINK (track loss / blink) logging               4/2005 */

#include "tracker.h"		/* include all needed headers */

#include "script.h"		/* script processing specific things */
#include <math.h>		/* fabs, powi, sqrt... */

#if GRAPHICS
#include "vesa.h"		/* for lfbSel, pixelspace, spacePIX, ... */
#endif

#define FLASH_MSG(time) /* time is in milliseconds */		\
              (void) put_string ((cols - strlen (oneline)) / 2,	\
                  (rows-1)/2, 0, 7, 7, -1, -1, oneline);	\
              (void) put_string ((cols - strlen (oneline)) / 2,	\
                  (rows-1)/2, 1, 7, 7, -1, -1, oneline);	\
              (void) debounce (-1, time);	/* delay */	\
              (void) put_string (0, (rows-1)/2, 0, 7, 7, -1, -1, emptyline); \
              (void) put_string (0, (rows-1)/2, 1, 7, 7, -1, -1, emptyline);

#define FLASH_MSG_OPERATOR(time) /* time is in milliseconds */	\
              (void) put_string ((cols - strlen (oneline)) / 2,	\
                  (rows-1)/2, 1, 7, 7, -1, -1, oneline);	\
              (void) debounce (-1, time);	/* delay */	\
              (void) put_string (0, (rows-1)/2, 1, 7, 7, -1, -1, emptyline);


/* if reading is nonzero, assume READING script semantics */
void do_script_trials(char * script, int reading) {	/* process trials */
  char oneword[80];		/* buffers one word */
  char oneline[500];		/* buffers one line, for screen and log */
  char * trial;			/* start of the description of one trial */
  char * ptr;
  int wordlen;
  int t;			/* used type (define line array index) */
  int lines_used;		/* lines used by layouted text */

  int timeout;			/* msec timeout */
  int eyex, eyey;		/* eye coordinates */
  int buttons, i, /* x, y, */ cols, rows;
  char thelabel[80];		/* label for logging */
  char emptyline[160];		/* one empty line on screen */
  uint32 firsttime, lasttime;
  uint32 dwelltime, entertime, lefttime;
  /* dwelltime, entertime and lefttime accumulate time in/out area */
  /* firsttime is when trial starts, for timeout */
  /* lasttime is for timestamp - lasttime calculation */
  uint32 tlb_start = 0;		/* starting time of a blink / track loss */

  int thisarea, lastarea, in_area;	/* for area enter / leave checks */
  int lines_reserved = 0;	/* nonzero if images visible etc. */
#if GRAPHICS
  uint32 histogram[256];
  uint8 * pcxcontents = NULL;   /* PCX file contents */
  uint32 pcxsize = 0;           /* size of PCX file contents */
  char pcxname[256];            /* for logging */
  int imagemargin = 0;          /* distance PCX to upper or lower screen end */
  int fontzoom = 1;		/* zoom factor for logged coordinates 4/2005 */
  int alignment = CENTERED;	/* alignment: text layout control 4/2005 */

  if (lfbSel > 0) fontzoom = FONT_ZOOM;	/* only active in VESA mode */
#endif

          rows = get_resolution_y (&cols, &i);	/* i becomes 1 if fake mode */

  trial = script;
  oneword[0] = oneline[0] = '\0';
  firsttime = timestamp = 0;	/* log lines use "timestamp - firsttime" */

  for (i = 0; i < cols; i++)
      emptyline[i] = ' ';
  emptyline[cols] = '\0';

#if GRAPHICS	/* 10/2004 */
  if (lfbSel > 0) { /* graphics mode on? */
      pixelspace = malloc (vesamode.width * vesamode.height);
      /* the variable itself is global in vesa.h */
    
      if (pixelspace == NULL) {
          LOG_STRING ("TRIAL ERROR nopixelspace");
          return;
      }
  } /* in graphics mode */
#endif /* GRAPHICS */

  while (*trial) {

      firsttime = timestamp;			/* reset any timestamp */

      wordlen = get_word (trial, oneword, &trial, 1 /* skip comments */);
      if (!wordlen)				/* linebreak? */
          continue;
      /* *** Should flush log buffer to disk BEFORE a trial *** */
      /* *** if log buffer is already more than half full!  *** */

      if (!strcmp (oneword, "define")) {	/* define ... line */

          do {
              wordlen = get_word (trial, oneword, &trial, 1 /* skip comments */);
          } while (wordlen);			/* skip rest of line */

      } /* define line */ else {		/* ** stimulus line ** */

          lines_reserved = 0; /* no image loaded */
#if GRAPHICS
          imagemargin = 0; /* no image loaded */
          if (pcxsize)
              free (pcxcontents);
          pcxsize = 0;
#endif
          t = 0;
          while ( (trial_types[t].typename[0]) &&	/* find trial type */
                  strcmp (oneword, trial_types[t].typename) ) {
              t++;
          }
          if (!trial_types[t].typename[0]) {
              LOG_STRING ("TRIAL ERROR notype");
              continue;					/* added 4/2005 */
          }

          wordlen = get_word (trial, oneword, &trial, 1);
          if (!wordlen) {
              LOG_STRING ("TRIAL ERROR nolabel");
              continue;
          }
          strcpy (thelabel, oneword);		/* we know the TRIALID now! */

          wordlen = get_word (trial, oneword, &trial, 1);
          if (!wordlen) {
              sprintf (oneline, "TRIALID %s", thelabel);
              LOG_STRING (oneline);
              LOG_STRING ("TRIAL ERROR notimeout");
              continue;
          }
          timeout = atoi (oneword);
          if (!timeout) timeout = 60000;	/* 1 minute if invalid timeout */

#if GRAPHICS
          if (lfbSel > 0) { /* graphics mode on  */
              uint32 cls;

              inversetext = 1;	/* *** would have to look into the future *** */
              /* ... in order to know what the image background color will be */
              /* inversetext is a global variable used by screen.c */

              clear_screen (0, -1, -1, -1);	/* clear text and VESA canvas */
              /* only clear subject screen now */

              for (cls = 0; cls < (vesamode.width * vesamode.height); cls++)
                  pixelspace[cls] = 255;	/* "nothing else on screen" */
						/* (no analyzed PCX, that is) */
          } /* graphics mode, so clear canvas explicitly */
          /* (later changes can be cleared by using put_string) */
#endif /* GRAPHICS */

          alignment = CENTERED;

          /* *** Main decision thing follows: Allowed type keywords */
          /* *** (as of 4/2005) are:inline inlineleft image image2  */

          wordlen = get_word (trial, oneword, &trial, 1);
          if (strcmp (oneword, "inline") && strcmp (oneword, "inlineleft")) {

#if GRAPHICS  /* -- start 10/2004 change area -- */
              /* image2 is like image but only takes ONE line of text */
              /* which is displayed close to the objects on the image */
              /* while image takes SOME text which is displayed vert. */
              /* centered in the space between screen edge and image. */

              if ( ((!strcmp (oneword, "image")) || (!strcmp (oneword, "image2")))
                  && (lfbSel > 0)) {

                  int is_oneline = (!strcmp(oneword, "image2"));

                  wordlen = get_word (trial, oneword, &trial, 1);
                  if (!wordlen) {
                      sprintf (oneline, "TRIALID %s", thelabel);
                      LOG_STRING (oneline);
                      LOG_STRING ("TRIAL ERROR noimagemargin");
                      continue;
                  }

                  /* auto-conversion of READING-style image syntax (4/2005) */
                  /* READING uses no imagemargin, combined image and text,  */
                  /* but has other (yet ignored here) image trial options.  */
                  if ( (!strcasecmp(oneword + strlen(oneword) - 4, ".bmp")) ||
                       (!strcasecmp(oneword + strlen(oneword) - 4, ".pcx")) ) {

                      (void)strcpy(oneword + strlen(oneword) - 4, ".pcx");
                      /* replace file name suffix: NEWTRACK uses PCX format */
                      strncpy(pcxname, oneword, 255);
                      pcxname[255] = 0;

                      pcxsize = fileread ("PCX", pcxname, &pcxcontents);
                      /* allocates pcxcontents memory */

                      imagemargin = 0;	/* place image on upper screen end */
                      if (!reading)
                          LOG_STRING ("TRIAL PREWARNING readingscriptformat");

                      wordlen = get_word (trial, oneword, &trial, 1);
                      /* read but ignore optional(?) template file name */
                      while (wordlen) {
                          ptr = trial;
                          wordlen = get_word (trial, oneword, &trial, 1);
                          if (!wordlen) trial = ptr;
                          /* must not push trial script pointer too far! */
                      }			/* ignore READING options and text */

                  } else {		/* else use NEWTRACK image syntax: */

                      imagemargin = atoi (oneword);
                      /* margin is in pixels, negative if from bottom */

                      if ( ((oneword[0] < '0') || (oneword[0] > '9')) &&
                           (oneword[0] != '-') && (oneword[0] != '+') ) {
                          LOG_STRING ("TRIAL PREWARNING nonnumimagemargin");
                      }			/* quick and dirty sanity check */

                      wordlen = get_word (trial, oneword, &trial, 1);
                      if (!wordlen) {
                          sprintf (oneline, "TRIALID %s", thelabel);
                          LOG_STRING (oneline);
                          LOG_STRING ("TRIAL ERROR noimagefilename");
                          continue;
                      }
                      strncpy(pcxname, oneword, 255);
                      pcxname[255] = 0;

                      pcxsize = fileread ("PCX", pcxname, &pcxcontents);
                      /* allocates pcxcontents memory */

                  }			/* normal NEWTRACK image syntax */

                  if (pcxsize < (128+768)) {
                      free (pcxcontents);
                      pcxsize = 0;
                      sprintf (oneline, "TRIALID %s", thelabel);
                      LOG_STRING (oneline);
                      LOG_STRING ("TRIAL ERROR imagetoosmall");
                      do { } while (get_word (trial, oneword, &trial, 0));
                      /* ^- added 4/2005: skip rest of failed trial line */
                      continue;
                  }

                  /* we load the image invisibly, to check the properties! */
                  /* needed to check validity, area count, size, layout. */
                  if (pcxshow (pcxsize, pcxcontents, -1 /* x centered */,
                      imagemargin /* neg.: from bottom */,
                      pixelspace, histogram, 0 /* invisible */)) {

                      sprintf (oneline, "TRIALID %s", thelabel);
                      LOG_STRING (oneline);
                      LOG_STRING ("TRIAL ERROR invalidimage");
                      do { } while (get_word (trial, oneword, &trial, 0));
                      /* ^- added 4/2005: skip rest of failed trial line */
                      continue;

                  } else {
                      int best, nareas, minY, maxY;
                      int fontheight = 16 * FONT_ZOOM;

                      best = findmax (histogram, 256);  /* find most used color index */

		      /* *** could update inversetext value based on palette[best] *** */
		      /*  ... but the clear screen already used the old value anyway.  */

                      nareas = imagechunker (best, 0 /* dont visualize result */,
                          &minY, &maxY); /* uses pixelspace as input and output */

                      if (is_oneline) {				/* single line */
                          if (imagemargin > 0) {		/* image on top */
                              lines_reserved = SINGLE_LINE +	/* THAT line: */
                                  ((maxY+fontheight+imagemargin-1) / fontheight);
                          } else {				/* image at bottom */
                              lines_reserved = SINGLE_LINE +
                                  ( (minY-(fontheight+(-imagemargin)-1)) / fontheight );
                          } /* this assumes text needs fontheight pixels / line */
                          /* *** no range check, but imagemargin could be evil! *** */
                      } else {
                          if (imagemargin > 0) {		/* image on top */
                              lines_reserved = (maxY+fontheight-1) / fontheight;
                          } else {				/* image at bottom */
                              lines_reserved = - ( rows - (minY / fontheight) );
                          } /* this assumes text needs fontheight pixels / line */
                      } /* centered in free space */
                      /* keep this in sync with screen.c! */

                      firsttime = timestamp;	/* clamp timestamp to 0 (4/2005) */
                      sprintf (oneline, "IMAGETRIAL %d %d %d %d %.75s",
#if GRAPHICS	/* new 4/2005: FONT_ZOOM processing */
#if 0		/* complex way to get simple result - disabled */
!                         (fontzoom * minY * rows * 16) / YGFX, /* convert to virt pixels */
!                         (fontzoom * maxY * rows * 16) / YGFX,
#else
                          minY,			/* use real pixels, same effect as */
                          maxY,			/* real -> virt -[fontzoom]-> real */
#endif
#else
                          (minY * rows * 16) / YGFX, /* convert to virt pixels */
                          (maxY * rows * 16) / YGFX,
#endif
                          lines_reserved, nareas, pcxname);
                      LOG_STRING (oneline);	/* log image properties */

                  } /* pcxshow worked */
                  /* image not yet rendered to user screen, only to pixelspace */

              } else {

                  sprintf (oneline, "TRIALID %s", thelabel);
                  LOG_STRING (oneline);

                  if (lfbSel > 0) {
                      LOG_STRING ("TRIAL ERROR unknowntrialtype");
                  } else {
                      LOG_STRING ("TRIAL ERROR notingraphicsmode");
                  }

                  do { } while (get_word (trial, oneword, &trial, 0));
                  /* ^- added 4/2005: skip rest of invalid trial line */
                  continue;

              } /* no known and enabled keyword */

#else /* GRAPHICS or not GRAPHICS ... */

              sprintf (oneline, "TRIALID %s", thelabel);
              LOG_STRING (oneline);
              LOG_STRING ("TRIAL ERROR nographicssupport");
              /* only allowed trial type is "inline" if compiled w/o VESA */
              do { } while (get_word (trial, oneword, &trial, 0));
              /* ^- added 4/2005: skip rest of invalid trial line */
              continue;

#endif /* not GRAPHICS */
              /* -- end 10/2004 change area -- */

          } else {	/* trial type was "inline[left]", continue as usual */

              /* "inline" is mostly a subset of "image" */
              alignment = (reading) ? TOPLEFT : CENTERED;
              /* Default is CENTERED in NEWTRACK, but TOPLEFT in READING mode! */
              /* Note that alignment is (yet) always CENTERED for image trials */
              /* but that READING script image trials do not use inline text.  */

              if (!strcmp (oneword, "inlineleft"))
                 alignment = TOPLEFT;

          }
          /* no other trial types except inline text supported yet! */
	          /* UPDATE: image  type added 10/2004 (text centered in free area) */
	          /* UPDATE: image2 type added 10/2004 (text close to objects) */


          ptr = trial;		/* remember where stimulus text begins */


          restart_trial:			/* *** trial restart label *** */


          firsttime = timestamp;		/* clamp timestamp to 0 (4/2005) */

          trial = ptr;			/* "jump" to stimulus text start */

          sprintf (oneline, "TRIALID %s", thelabel);
          LOG_STRING (oneline);

          lines_used = layout (trial, lines_reserved, alignment);
          	/* prepare layouted version of text: n text lines reserved */
          	/* area, or put at fixed line with SINGLE_LINE flag... The */
          	/* alignment (new 4/2005) can be TOPLEFT or CENTERED.      */

          describe_stimulus (lines_used);	/* initialize word area list */
              /* ... and log the contents of the list */

          if (!lines_used) {
              char * dummy;			/* empty text support added 4/2005 */
              if (!get_word (trial, oneword, &dummy, 0)) {
                  LOG_STRING ("INFO WORD 0 0 0 0 0 EmptyText");
              } else {
                  LOG_STRING ("TRIAL ERROR invalidlayout"); /* (e.g. too long) */
                  do { } while (get_word (trial, oneword, &trial, 0));
                  /* ^-- skip over stimulus text anyway! (added 4/2005) */
                  sprintf (oneline, " Cannot display trial - impossible layout ");
                  FLASH_MSG_OPERATOR (1000);
                  buttons = 0;
                  goto trial_aborted;		/* jump out of here */
              }
          }

          do {
              wordlen = get_word (trial, oneword, &trial, 0);
          } while (wordlen);	/* skip over stimulus text */

          clear_screen (0, -1, -1, -1);	/* clear subject text + VESA screen */
          clear_screen (1, -1, -1, -1); /* clear operator text screen */

          firsttime = get_ytime ();	/* updated later if auto activate */
          if ( (trial_types[t].start_type == AUTO_ACTIVATE) ||
               (trial_types[t].start_type == MANUAL_ACTIVATE) ) {
              /* MANUAL_ACTIVATE added 4/2005. This ifthenelse THEN branch */
              /* handles all activation modes which are not gaze triggered */
              int starx, wholex;

              if (trial_types[t].start_type == AUTO_ACTIVATE) { /* new 4/2005 */
                  firsttime = debounce (-1, 50); /* need at least some time */
                  goto activate_now;		/* bypass any waiting stuff */
                  /* pre-4/2005 versions always did the "show grid / wait"! */
              }

              sprintf (oneline,
                  "[%s] Press NEXT to show text or CAL to calibrate.", thelabel);
              (void) put_string (0, 0, 1, 7, 15, -1, -1, oneline);
              					/* create a test pattern */
              wholex = cols - (10+10+1);	/* some margin */
              strcpy (oneline, emptyline);
              for (starx = 0; starx <= wholex; starx += wholex/4)
                  oneline[starx+10] = '*';	/* 5 stars evenly distributed */

              do {
                  int center5 = ((cols - (10+10+1)) - ((wholex / 4) * 4)) / 2;

                  (void) get_xy (&eyex, &eyey);	/* get eye coordinates */
                  (void) put_string (center5, 2, 0, 7, 12, eyex, eyey, oneline);
                  (void) put_string (center5, 2, 1, 7, 12, eyex, eyey, oneline);
                  (void) put_string (center5, rows-(2+1), 0, 7, 12, eyex, eyey, oneline);
                  (void) put_string (center5, rows-(2+1), 1, 7, 12, eyex, eyey, oneline);
                  center5 += ((wholex / 4) * 2);	/* align to middle star */
                  (void) put_string (center5+10, (rows-1)/2, 0, 7, 12, eyex, eyey, "*");
                  (void) put_string (center5+10, (rows-1)/2, 1, 7, 12, eyex, eyey, "*");
                  /* (will not be exactly centered unless rows is an odd number) */
                  (void) get_buttons (&buttons);
              } while (!(buttons & (NEXTBUTTON | CALBUTTON |
                  ABORTBUTTON | ESCBUTTON) ));	/* test display loop */

              if (buttons & CALBUTTON) {
                  int it_bak;

                  LOG_STRING ("TRIAL REPEATED");
                  LOG_STRING ("TRIAL_RESULT 0");	/* fixed 4/2005 */
                  it_bak = inversetext;
                  inversetext = 0;	/* white on black is nicer for the eye */
                  clear_screen (0, -1, -1, -1);	/* clear subject text + VESA screen */
                  clear_screen (1, -1, -1, -1); /* clear operator text screen */

                  calibrate ();		/* calibrate again */

                  inversetext = it_bak;
                  clear_screen (0, -1, -1, -1);	/* clear subject text + VESA screen */
                  clear_screen (1, -1, -1, -1); /* clear operator text screen */

                  goto restart_trial;	/* do this trial again */
              }

              do {
                  if (buttons & (ABORTBUTTON | ESCBUTTON))
                     goto trial_aborted;	/* jump out of here */
                  (void) get_buttons(&buttons);
              } while (buttons & NEXTBUTTON);	/* next and abort overlap */
              					/* (both use ctrl) */

              (void) put_string (0, 2, 0, 7, 15, -1, -1, emptyline);
              (void) put_string (0, 2, 1, 7, 15, -1, -1, emptyline);
              (void) put_string (0, (rows-1)/2, 0, 7, 15, -1, -1, emptyline);
              (void) put_string (0, (rows-1)/2, 1, 7, 15, -1, -1, emptyline);
              (void) put_string (0, rows-(2+1), 0, 7, 15, -1, -1, emptyline);
              (void) put_string (0, rows-(2+1), 1, 7, 15, -1, -1, emptyline);

              /* firsttime = debounce (NEXTBUTTON, DEBOUNCE); */
              firsttime = debounce (-1, DEBOUNCE); /* changed 4/2005 */
              
              activate_now:	/* no frills - just activate at once! */

              firsttime = get_ytime ();
              timestamp = lasttime = firsttime;


          } /* no gaze activation */ else {	/* gaze act. or drift corr. */


              int markx, marky;	/* drift correct / gaze act. mark coords */

              if (trial_types[t].start_type != GAZE_ACTIVATE) {
                  markx = (cols-1)/2;		/* fixed position: 5 or center */
                  marky = (rows-1)/2;		/* fixed position: 2 or center */
              } else {
                  if (lines_used < 1) { 	/* no text present? (4/2005) */
                      markx = (cols-1)/2;	/* fixed position: center */
                      marky = (rows-1)/2;	/* fixed position: center */
                  } else {
                      int whichline;		/* scan for nonempty (4/2005) */

                      markx = (cols-1)/2;	/* default: center */
                      marky = (rows-1)/2;
                      for (whichline = 0; whichline < lines_used; whichline++) {
                          if (get_line (whichline) != NULL) {
                              marky = get_line_ypos (whichline, lines_used, &markx);
                              break;		/* use only FIRST nonempty line... */
                          }
                      } /* Y -> first nonempty line, X -> first word */
                  }
              }

              /* pseudo added 4/2005: ignores correction result */
              /* simulates pre-4/2005 "always ignore" behaviour */
              sprintf (oneline, "[%s] Awaiting %stion gaze. NEXT %s.",
                  thelabel, (trial_types[t].start_type == GAZE_ACTIVATE)
                      ? "gaze activa" : ( (trial_types[t].start_type == DRIFT_PSEUDO)
                      ? "no-drift confirma" : "drift correc" ),
                      (trial_types[t].start_type == GAZE_ACTIVATE)
                      ? "skips" : "samples" );
                      /* shorter 7/2004, 3rd type added 4/2005 */
              oneline[cols] = '\0';
              (void) put_string (0, 0, 1, 7, 15, -1, -1, oneline);

              /* Auto-activation fails if there is drift: The operator */
              /* has to press NEXT manually to trigger a coord. origin */
              /* update (drift correction) for "driftcorrect" trials,  */
              /* or to just bypass the wait for "gazeactivation" ones. */
              /* *** Could work with less operator interaction...? *** */
              /* Pre-4/2005 did "drift..." like "gaze...", no real DC. */

              (void) select_screen (0, -1);		/* DISable screen */
              (void) put_string (markx, marky, 0, 7, 12, -1, -1, "*");
              (void) put_string (markx, marky, 1, 7, 12, eyex, eyey, "+");
              timestamp = select_screen (0, 1);		/* ENable screen  */
                  /* (show gaze activation mark, with exact timestamp) */

              sprintf (oneline, "TARGET ON %u", (timestamp-firsttime)/1000);
              LOG_STRING (oneline);

              (void) debounce (NEXTBUTTON, DEBOUNCE);	/* just in case */

              firsttime = lasttime = get_ytime ();	/* timeout starts */
              lefttime = 0xffffffff;	/* start in "out" state */
              dwelltime = 0;		/* zero gaze time yet   */
              entertime = 0;		/* nothing entered yet  */

              do {

                  timestamp = get_xy (&eyex, &eyey);

                  (void) put_string (markx, marky, 0, 7, 15, -1, -1,
                      ((timestamp - firsttime) < GAZE_PAUSE) ? "-" : "*");
                      /* gaze highlighting on, but eye cursor off */
                      /* "-" means "you cannot enter yet" */

                  (void) put_string (markx, marky, 1, 7, 15, eyex, eyey,
                      (entertime == 0xffffffff) ? "+"
                          : ((lefttime == 0xffffffff) ? "-" : "*") );

                  if ((eyex == markx) && (eyey == marky)) {	/* in area? */

                      if ((timestamp - firsttime) < GAZE_PAUSE)	/* too early? */
                          entertime = 0;		/* spoil fixation */

                      if (entertime > ENTER_THRESHOLD) {
                          dwelltime += (entertime != 0xffffffff)
                              ? (entertime + timestamp - lasttime)
                              : (timestamp - lasttime);
                          entertime = 0xffffffff; 	/* we are "in" */
                          lefttime = 0;			/* reset "out" time */
                      } else {
                          entertime += timestamp - lasttime;
                      } /* waiting to enter */
                  } else {
                      if (lefttime > LEAVE_THRESHOLD) {
                          lefttime = 0xffffffff;	/* we are "out" */
                          entertime = 0;		/* reset "in" time */
                          dwelltime = 0;		/* even dwell time */
                      } else {
                          lefttime += timestamp - lasttime;
                      } /* waiting to leave */
                  } /* not at right coordinates */

                  lasttime = timestamp;
                  timestamp = get_buttons (&buttons);

                  if (buttons & CALBUTTON) {
                      int it_bak;

                      LOG_STRING ("TRIAL REPEATED");
                      LOG_STRING ("TRIAL_RESULT 0");	/* fixed 4/2005 */

                      it_bak = inversetext;
                      inversetext = 0;	/* white on black is nicer for the eye */
                      clear_screen (0, -1, -1, -1);	/* clear subject text + VESA screen */
                      clear_screen (1, -1, -1, -1); /* clear operator text screen */

                      calibrate ();	/* calibrate again */

                      inversetext = it_bak;
                      clear_screen (0, -1, -1, -1);	/* clear subject text + VESA screen */
                      clear_screen (1, -1, -1, -1); /* clear operator text screen */

                      goto restart_trial;	/* do this trial again */
                  }

                  if (buttons & (ABORTBUTTON | ESCBUTTON))
                      goto trial_aborted;

              } while ( (dwelltime < GAZE_ACT_THRESHOLD) &&
                        ((lasttime-firsttime) < (600 * 1000000)) &&
                        !(buttons & NEXTBUTTON) );
       			/* end of gaze activation / drift correction loop */

#if 0		/* obvious from dwelltime in TRIGGER MAIN anyway */
!             if (buttons & NEXTBUTTON) {
!                 LOG_STRING ("TRIGGER BYPASS nextbutton pressed");
!                 /* no need to debounce - NEXT is unused during trials */
!             }
#endif
              /* make sure to remove gaze targets - added 4/2005: */
              (void) put_string (markx, marky, 0, 7, 12, -1, -1, " ");
              (void) put_string (markx, marky, 1, 7, 12, eyex, eyey, " ");

              if ( !(buttons & NEXTBUTTON) &&
                   (dwelltime < GAZE_ACT_THRESHOLD) ) {
                  sprintf (oneline, " Gaze activation timeout after %d seconds. ",
                      timeout / 1000);	/* milliseconds -> seconds */
                  FLASH_MSG_OPERATOR (2000);
                  LOG_STRING ("DISPLAY STILL OFF BUT TIMEOUT");
                  LOG_STRING ("TRIAL ERROR");
                  continue;
              }

              if ( (buttons & NEXTBUTTON) && 		/* new 4/2005 */
                  (trial_types[t].start_type == DRIFT_CORRECT) ) {
                  int dc_x = (markx *  8) + 4;	/* virtual coordinates! */
                  int dc_y = (marky * 16) + 8;
                  /* no not use real "pixel" average coordinates HERE! */
                  /* drift_update compares "gaze now" to given coordinates */

                  if (drift_update (&dc_x, &dc_y)) {
                      sprintf (oneline, "DRIFTCORRECT CHANGED %d %d",
#if GRAPHICS	/* new 4/2005: FONT_ZOOM processing */
                          fontzoom * dc_x, fontzoom * dc_y); /* signed int delta */
                          /* values, unit is REAL (!) screen pixels. */
#else
                          dc_x, dc_y); /* signed, rounded delta pixel */
                          /* values, unit is VIRTUAL (!) screen pixels. */
#endif
                  } else {
#if GRAPHICS	/* new 4/2005: FONT_ZOOM processing */
                      sprintf (oneline, "DRIFTCORRECT FAILED %d %d",
                          fontzoom * dc_x, fontzoom * dc_y); /* delta ignored */
#else
                      sprintf (oneline, "DRIFTCORRECT FAILED %d %d",
                          dc_x, dc_y); /* delta values got ignored */
#endif
                  }
                  LOG_STRING (oneline);
              } /* gaze activation / drift confirmation failed, the */
                /* operator triggered sample, use for DRIFT_CORRECT */

              sprintf (oneline, "TRIGGER MAIN 0 %d %d %d %d %u",
#if GRAPHICS	/* new 4/2005: FONT_ZOOM processing */
                  ((markx *  8) + 4) * fontzoom,
                  ((marky * 16) + 8) * fontzoom,
                  ((markx *  8) + 4) * fontzoom,
                  ((marky * 16) + 8) * fontzoom,
#else
                  (markx * 8) + 4, (marky * 16) + 8,
                  (markx * 8) + 4, (marky * 16) + 8,
#endif
                  dwelltime/1000);	/* convert ysec -> msec */
                  /* *** this log line uses virtual pixel coordinates *** */
                  /* should log mark- and actual average coordinates */
                  /* (get_xy needs to return additional "pixel" coords)  */
                  /* (those coords will assume an 8*16 font in ANY case) */
              LOG_STRING (oneline);


          } /* either drift correction or gaze activation mode */
          /* (as opposed to "at once" / "show test grid, wait for key" modes) */


          firsttime = get_ytime ();	/* timeout starts again now! */
          timestamp = 0;		/* remember that we have to set it */
          lasttime = 0;			/* (when display gets visible) */
          tlb_start = 0;		/* not in a blink */

          (void) put_string (0, 0, 1, 7, 15, -1, -1, emptyline);
          sprintf (oneline, "[%s] trial running.", thelabel);
          (void) put_string (0, 0, 1, 7, 15, -1, -1, oneline);

/* -- */
          for (i = 0; i < MAX_AREAS; i++) {	/* zap all dwelltimes */
              areas[i].dwelltime = 0;
              areas[i].avgxsum = 0;
              areas[i].avgysum = 0;
          } /* initialize area time counters */
          thisarea = -1;		/* ... */
          lastarea = -1;	/* region which was looked at most recently */
          in_area = -1;		/* region which we have ENTERed */
/* -- */

          do {					/* *** main trial loop +++ */
              int yy;
              char * stline;
              double pix_eyex, pix_eyey;	/* pixel precision coords */

              timestamp = get_xy (&eyex, &eyey);	/* fetch eye position */
              yy = 0;

              if (!lasttime)			/* stimulus just coming in? */
/* -- */         (void) select_screen(0, -1);		/* screen off */

          /* -- start 10/2004 change area -- */
#if GRAPHICS
              if ((!lasttime) && (pcxsize > 0)) { /* have to reveal image now! */
                  (void) select_screen(0, 0); /* access subject VESA screen! */
                  if (pcxshow (pcxsize, pcxcontents, -1 /* x centered */,
                      imagemargin /* neg.: from bottom */,
                      NULL /* no pixelspace */, histogram, 1 /* show */)) {
                      (void) select_screen (0, 1);	/* error, so enable screen */
                      LOG_STRING ("TRIAL ERROR invalidimage");
                      /* (unlikely: image went invalid after load-to-analyze) */
                      continue;
                  } else {
                      /* could call showpalette(-1,-10) here ... */
                  } /* pcxshow worked */
                  /* (screen not yet unblanked again) */
              } /* trial with an image */
#endif /* GRAPHICS */
          /* -- end 10/2004 change area -- */



#if GRAPHICS /* -- start 10/2004 change area -- */
              if (lfbSel > 0) { /* in graphics mode */
                  for (yy = 0; yy < rows; yy++) {
                      int pcx_x, pcx_area, nfilled;
                      int fontx, fonty;

                      if ((!cols) || (!rows)) {	/* you never know */
                          fontx = FONT_ZOOM * 8;
                          fonty = FONT_ZOOM * 16;
                      } else {
                          fontx = XGFX / cols;
                          fonty = YGFX / rows;
                      }
                      nfilled = 0;	/* used to skip empty lines */

                      for (pcx_x = 0; pcx_x < cols; pcx_x++) {
                          pcx_area = spacePIX( ((pcx_x * fontx) + (fontx/2)),
                              ((yy * fonty) + (fonty/2)) );
                          /* sample middle pixel of char cell */
                          if ((pcx_area > 0) && (pcx_area < 27)) {
                              nfilled = pcx_x+1;	/* something found */
                              oneline[pcx_x] = 'A' + pcx_area - 1;
                              /* convert to a char */
                          } else {
                              oneline[pcx_x] = ' ';
                          }
                      } /* for cols */
                      oneline[cols] = 0;	/* terminate string */
                      if (nfilled) {
                          oneline[nfilled] = 0;	/* terminate earlier */
                          (void) put_string (0, yy,
                          1, 2, 10, eyex, eyey, oneline);
                          /* area encoding visible for operator (in green) */
                      }
                  } /* for rows */
              } /* in graphics mode */
#endif /* GRAPHICS */ /* -- end 10/2004 change area -- */

              for (yy = 0; yy < lines_used; yy++) {	/* stimulus lines */
                  int line_y, line_x;

                  stline = get_line (yy);	/* fetch layouted text  */
                  if (stline == NULL) continue;	/* no text in THAT line */
                  line_y = get_line_ypos (yy, lines_used, &line_x);
                  				/* fetch layouted position */
                  (void) put_string (line_x, line_y,
                      0, 7, 7 /* no highlighting! */, -1, -1, stline);
                      /* neither highlighting nor cursor visible for subject */
                  (void) put_string (line_x, line_y,
                      1, 7, 15, eyex, eyey, stline);
                      /* both highlighting and cursor visible for operator */
              } /* loop over stimulus lines */
              /* (text is printed "on top of" image if they "collide") */

              if (!lasttime) {			/* stimulus just coming in? */
/* -- */          timestamp = select_screen(0, 1);	/* screen ON */
                  /* (reveal stimulus to user, with exact timestamp) */
                  /* *** screen gets unblanked with complete stimulus here *** */

                  lasttime = timestamp;
                  check_fixations (0);			/* new 11/2004 */
                  LOG_STRING ("DISPLAY ON");		/* here we go! */
                  LOG_STRING ("SYNCTIME");		/* synctime now!? */
              }

/* -- *** -- */
              get_pixel_xy (&pix_eyex, &pix_eyey);	/* must use get_xy() before */

              if (track_lost ()) {			/* new 4/2005 */
                if (!tlb_start)				/* blink starts now */
                    tlb_start = (get_ytime () - firsttime) / 1000UL;
                /* else: ongoing blink / track loss */
              } else {
		if (tlb_start) {			/* end of a blink */
		    uint32 now = (get_ytime () - firsttime) / 1000UL;
		    sprintf (oneline, "BLINK %d %d", tlb_start, now-tlb_start);
		    LOG_STRING (oneline);
		}
		tlb_start = 0;
              } /* tlb logging */

              if ((eyex < 0) || (eyey < 0)) {	/* outside screen? */
                  thisarea = -1;			/* track loss / error */
              } else {

                  thisarea = analyze_focus (lines_used,
                      (int)(pix_eyex+0.5), (int)(pix_eyey+0.5));

                  if (trial_types[t].streaming & STREAMFIX)
                      check_fixations (firsttime);	/* new 11/2004 */
                      /* new 4/2005: use STREAMFIX flag, not streaming as bool */

              } /* analyze "eye cursor" position */

#if 1
              sprintf (oneline, "% -4d", thisarea);	/* nervous display... */
              (void) put_string (cols-5, 0, 1, 7, 7, -1, -1, oneline);
#endif 

              if (thisarea < 0)
                  thisarea = MAX_AREAS-1;	/* we store "nowhere" here */

              areas[thisarea].dwelltime += timestamp - lasttime;
              if (thisarea != MAX_AREAS-1) {
                  areas[thisarea].avgxsum += 1.0 * pix_eyex
                      * (timestamp - lasttime);
                  areas[thisarea].avgysum += 1.0 * pix_eyey
                      * (timestamp - lasttime);
              } /* (pix_eyex and pix_eyey are nonsense for area "nowhere") */

              if ( (in_area != thisarea) &&		/* really a CHANGE ? */
                   (areas[thisarea].dwelltime > ( (thisarea == MAX_AREAS-1)
                  ? LEAVE_THRESHOLD : ENTER_THRESHOLD)) ) {	/* threshold reached? */

                  if (in_area < 0) in_area = MAX_AREAS - 1;
                  if ( (in_area != thisarea) &&		/* any real change??? */
                       (in_area != MAX_AREAS-1) ) {	/* leaving real word? */
                      if (!(areas[in_area].dwelltime)) areas[in_area].dwelltime++;
                      sprintf (oneline, "LEAVE WORD %d %d %d %d %d %u 0", in_area,
#if GRAPHICS	/* new 4/2005: FONT_ZOOM processing */
                          (int)(fontzoom * areas[in_area].avgxsum / areas[in_area].dwelltime),
                          (int)(fontzoom * areas[in_area].avgysum / areas[in_area].dwelltime),
                          (int)((fontzoom * pix_eyex) + 0.5),
                          (int)((fontzoom * pix_eyey) + 0.5),
#else
                          (int)(areas[in_area].avgxsum / areas[in_area].dwelltime),
                          (int)(areas[in_area].avgysum / areas[in_area].dwelltime),
                          (int)(pix_eyex+0.5), (int)(pix_eyey+0.5),
#endif
                          (areas[in_area].dwelltime + 500) / 1000);
                          /* dwelltime is logged in millisecond units! */
                          /* the 0 is the "time index in sound file" (unused) */
                      if (trial_types[t].streaming & STREAMWORD) /* if: 4/2005 */
                          LOG_STRING (oneline);
                      (void) put_string (0, rows-1, 1, 7, 7, -1, -1, emptyline);
                      (void) put_string (0, rows-1, 1, 7, 7, -1, -1, oneline);
                  } /* leaving real word by entering new word */

                  areas[in_area].dwelltime = 0;
                  areas[in_area].avgxsum = 0;
                  areas[in_area].avgysum = 0;

                  in_area = thisarea;	/* We are in a NEW AREA now! */

                  /* should we reset the dwelltimes / avg... of all the      */
                  /* other areas here? Else scattered dwellings might reach  */
                  /* the threshold eventually - but we might even want that. */

                  if (in_area != MAX_AREAS-1) {		/* entering real word? */
                      if (!(areas[in_area].dwelltime)) areas[in_area].dwelltime++;
                      sprintf (oneline, "ENTER WORD %d %d %d %d %d %.70s", in_area,
#if GRAPHICS	/* new 4/2005: FONT_ZOOM processing */
                          (int)(fontzoom * areas[in_area].avgxsum / areas[in_area].dwelltime),
                          (int)(fontzoom * areas[in_area].avgysum / areas[in_area].dwelltime),
                          (int)((fontzoom * pix_eyex) + 0.5),
                          (int)((fontzoom * pix_eyey) + 0.5),
#else
                          (int)(areas[in_area].avgxsum / areas[in_area].dwelltime),
                          (int)(areas[in_area].avgysum / areas[in_area].dwelltime),
                          (int)(pix_eyex+0.5), (int)(pix_eyey+0.5),
#endif
                          word_for_area (in_area));
                      if (trial_types[t].streaming & STREAMWORD) /* if: 4/2005 */
                          LOG_STRING (oneline);
                      (void) put_string (0, rows-1, 1, 7, 7, -1, -1, emptyline);
                      (void) put_string (0, rows-1, 1, 7, 7, -1, -1, oneline);
                  } /* entering real word */

              } /* threshold reached for changing to new area */
/* -- *** -- */

              lasttime = timestamp;		/* store last eye sample time */
              					/*  (for delta calculations)  */
              timestamp = get_buttons (&buttons);
              sprintf (oneline, "[%s] Buttons: %s%s%s Time: %d/%d",
                  thelabel, (trial_types[t].buttons & YESBUTTON) ? "YES " : "",
                  (trial_types[t].buttons & NOBUTTON) ? "NO " : "",
                  trial_types[t].keybuttons,	/* <- a possibly empty string */
                  (timestamp - firsttime) / 1000000, timeout / 1000 );
                  					/* shorter 7/2004 */
                  /* Other buttons are not interesting. It is possible that */
                  /* no buttons are enabled (e.g. for a "pause" stimulus).  */
              if (timestamp - lasttime > 1000) {
                  sprintf (oneline + strlen(oneline),	/* shorter 7/2004 */
                      " LAG: %4u ysec", timestamp - lasttime);
              } else {
                  sprintf (oneline + strlen(oneline),
                      "                ");		/* shorter 7/2004 */
              }
              (void) put_string (0, 0, 1, 7, 15, -1, -1, oneline);

          } while ( ( (lasttime - firsttime) < (1000 * timeout) ) &&
              !( buttons &
                 (trial_types[t].buttons | ESCBUTTON | ABORTBUTTON) ) &&
              ( !(buttons & 0xff00) ||
                !strchr (trial_types[t].keybuttons, (buttons & 0xff00) >> 8)
              ) ); /* no active button or accepted keyboard key pressed */
          					/* *** main trial loop end +++ */

          /* *** returns last valid timestamp for logging...!    *** */

          if ((lasttime - firsttime) > (1000 * timeout)) {
#if 0		/* timeout can be intended, e.g. for priming experiments */
//            sprintf (oneline, " Trial aborted: timeout after %d seconds. ",
//                timeout / 1000);	/* milliseconds -> seconds */
//            FLASH_MSG_OPERATOR (2000);
#endif
              LOG_STRING ("TIMEOUT");
              LOG_STRING ("TRIAL ERROR");
              buttons = 0;
              goto trial_aborted;
          }

          if (buttons & 0xff00) {	/* button came in from keyboard */
              int i, key, ch;

              ch = (buttons & 0xff00) >> 8;
              key = 10;
              for (i = 0; trial_types[t].keybuttons[i]; i++)
                  if (trial_types[t].keybuttons[i] == ch)
                      key = i;
              sprintf (oneline, "ANSWERBUTTON %d KEY %d", 128 + key, ch);
              if ( (key > 10) &&
                   ( ( (toupper (ch) == 'N') &&
                       !(trial_types[t].buttons & NOBUTTON) ) ||
                     ( (toupper (ch) == 'Y') &&
                       !(trial_types[t].buttons & YESBUTTON) )
                 ) ) {
                  LOG_STRING ("TRIAL ERROR wrongbutton");
                      /* Y and N can be produced by buttonbox */
                      /* emulation for YESBUTTON and NOBUTTON */
               } else {
                   LOG_STRING ("TRIAL OK");
                   sprintf (oneline, "TRIAL_RESULT %d", 128 + key);
                   LOG_STRING (oneline);
                   continue;		/* next trial */
               } /* valid keyboard button */
          } /* button came in from keyboard */

          sprintf (oneline, "ENDBUTTON %d", buttons & 0xff);
          LOG_STRING (oneline);
          if (!( buttons & (ABORTBUTTON | ESCBUTTON) )) {
              LOG_STRING ("TRIAL OK");
              sprintf (oneline, "TRIAL_RESULT %d", buttons & 0xff);
              LOG_STRING (oneline);
              continue;			/* next trial */
          }

          trial_aborted:		/* we jumped straight out of it */

          if (buttons & ABORTBUTTON) {
              sprintf (oneline, " Experiment aborted (ABORT button). ");
              FLASH_MSG (3000);
              LOG_STRING ("TRIAL ABORTED");
              LOG_STRING ("TRIAL_RESULT 0");
              LOG_STRING ("EXPERIMENT ABORTED");
              (void) debounce (ABORTBUTTON, DEBOUNCE);
#if GRAPHICS
              if (pcxcontents)
                  free (pcxcontents);
              free (pixelspace);
#endif
              return;
          } /* experiment aborted */

          if (buttons & ESCBUTTON) {
              sprintf (oneline, " Trial aborted (ESC button). ");
              FLASH_MSG (2000);
              LOG_STRING ("TRIAL ABORTED");
              LOG_STRING ("TRIAL_RESULT 0");
              (void) debounce (ESCBUTTON, DEBOUNCE);
              continue;
          } /* trial aborted */

          /* if we are still here: error was invalid keyboard button press */
          /* or the stimulus text could not be layouted in available space */
          LOG_STRING ("TRIAL_RESULT 0");
      } /* stimulus line (an actual trial) */



  } /* while *trial */

#if GRAPHICS
  if (pcxcontents)
      free (pcxcontents);
  free (pixelspace);
#endif

  return;
} /* do_script_trials */

