/* This is part of the NEWTRACK eyetracking software, (c) 2005 by  */
/* Eric Auer. NEWTRACK is free software; you can redistribute it   */
/* and modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2  */
/* of the License, or (at your option) any later version.          */
/*     NEWTRACK is distributed in the hope that it will be useful, */
/*     but WITHOUT ANY WARRANTY; without even the implied warranty */
/*     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.     */
/*     See the GNU General Public License for more details.        */
/* You should have received a copy of the GNU General Public       */
/* License (license.txt) along with this program; if not, check    */
/* www.gnu.org or write to the Free Software Foundation, Inc., 59  */
/* Temple Place, Suite 330, Boston, MA  02111-1307 USA.            */

/* Functions, data and defines to use VESA LFB graphics modes */
/* Version to compile "headless" Linux programs which process */
/* a VESA style canvas. Used for the PCX2TPL program. Future  */
/* versions might support actual graphical display output...  */

#ifndef VESA_UNIX_H
#define VESA_UNIX_H 1

#include "tracker.h"	/* includes arch.h etc. */

#ifdef __DJGPP__
#error Do not include this file directly, use vesa.h instead.
#endif

/* only core values, no real VESA yet, so vesadata.h is not used! */

#include "arch.h"	/* sint8 uint8 ... 32 */

typedef struct vesaMode {
  uint16 bytes_line, width, height;
  uint8  redBits, redShift, greenBits, greenShift, blueBits, blueShift;
} VESA_MODE;

			/* If we would INIT "... lfbSel = 0", then we would  */
			/* get a SEPARATE lfbSel variable for EACH .o! Yikes */
VESA_MODE vesamode;	/* globally used current VESA video mode description */
int lfbSel;	  	/* globally used selector for LFB memory access      */
uint16 palette[256];	/* palette for 8 bit color data interpretation       */
uint8 * pixelspace;	/* pointer for general purpose 8 bit "second page"   */
#define spacePIX(a,b) pixelspace[(a) + ((b) * vesamode.width)]


#define RGB2c(r,g,b) ( (((r)>>(8-vesamode.redBits)) << vesamode.redShift) | \
 (((g)>>(8-vesamode.greenBits)) << vesamode.greenShift) | \
  (((b)>>(8-vesamode.blueBits)) << vesamode.blueShift) )
  
  /* no "putpixel" for text and EGA (4 plane) memory modes provided here... */
#define putpixel8(x,y,c) ((uint8 *)lfbSel)[(x) + \
  (vesamode.bytes_line*(y))] = (c)
#define putpixel16(x,y,c) ((uint16 *)lfbSel)[(x) + \
  (vesamode.bytes_line*(y)/2)] = (c)
#define putpixel24(x,y,c) ((uint32 *)lfbSel)[(x) + \
  (vesamode.bytes_line*(y)/4)] = (c) /* not optimal... */
#define putpixel32(x,y,c) ((uint32 *)lfbSel)[(x) + \
  (vesamode.bytes_line*(y)/4)] = (c)

/* not yet available: */
/* int vesainit(int width, int height, int bits, int khz); */

/* not yet available: */
/* int vbe3refresh(int khz, uint16 modenumber); */

#endif
